/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.gallery;

import android.content.Context;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import io.getstream.chat.android.ui.feature.gallery.AttachmentGalleryActivity;
import io.getstream.chat.android.ui.feature.gallery.AttachmentGalleryItem;
import io.getstream.chat.android.ui.feature.gallery.AttachmentGalleryResultContract;
import io.getstream.chat.android.ui.feature.gallery.internal.AttachmentGalleryRepository;
import io.getstream.chat.android.ui.navigation.destinations.ChatDestination;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u001a\u001a\u00020\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryDestination;", "Lio/getstream/chat/android/ui/navigation/destinations/ChatDestination;", "context", "Landroid/content/Context;", "attachmentReplyOptionHandler", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentReplyOptionHandler;", "attachmentShowInChatOptionHandler", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentShowInChatOptionHandler;", "attachmentDownloadOptionHandler", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentDownloadOptionHandler;", "attachmentDeleteOptionClickHandler", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentDeleteOptionHandler;", "(Landroid/content/Context;Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentReplyOptionHandler;Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentShowInChatOptionHandler;Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentDownloadOptionHandler;Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentDeleteOptionHandler;)V", "attachmentGalleryItems", "", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryItem;", "attachmentIndex", "", "launcher", "Landroidx/activity/result/ActivityResultLauncher;", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultContract$Input;", "navigate", "", "register", "activityResultRegistry", "Landroidx/activity/result/ActivityResultRegistry;", "setData", "unregister", "stream-chat-android-ui-components_release"})
public final class AttachmentGalleryDestination
extends ChatDestination {
    @NotNull
    private final AttachmentGalleryActivity.AttachmentReplyOptionHandler attachmentReplyOptionHandler;
    @NotNull
    private final AttachmentGalleryActivity.AttachmentShowInChatOptionHandler attachmentShowInChatOptionHandler;
    @NotNull
    private final AttachmentGalleryActivity.AttachmentDownloadOptionHandler attachmentDownloadOptionHandler;
    @NotNull
    private final AttachmentGalleryActivity.AttachmentDeleteOptionHandler attachmentDeleteOptionClickHandler;
    @Nullable
    private ActivityResultLauncher<AttachmentGalleryResultContract.Input> launcher;
    private List<AttachmentGalleryItem> attachmentGalleryItems;
    private int attachmentIndex;

    public AttachmentGalleryDestination(@NotNull Context context, @NotNull AttachmentGalleryActivity.AttachmentReplyOptionHandler attachmentReplyOptionHandler, @NotNull AttachmentGalleryActivity.AttachmentShowInChatOptionHandler attachmentShowInChatOptionHandler, @NotNull AttachmentGalleryActivity.AttachmentDownloadOptionHandler attachmentDownloadOptionHandler, @NotNull AttachmentGalleryActivity.AttachmentDeleteOptionHandler attachmentDeleteOptionClickHandler) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attachmentReplyOptionHandler, (String)"attachmentReplyOptionHandler");
        Intrinsics.checkNotNullParameter((Object)attachmentShowInChatOptionHandler, (String)"attachmentShowInChatOptionHandler");
        Intrinsics.checkNotNullParameter((Object)attachmentDownloadOptionHandler, (String)"attachmentDownloadOptionHandler");
        Intrinsics.checkNotNullParameter((Object)attachmentDeleteOptionClickHandler, (String)"attachmentDeleteOptionClickHandler");
        super(context);
        this.attachmentReplyOptionHandler = attachmentReplyOptionHandler;
        this.attachmentShowInChatOptionHandler = attachmentShowInChatOptionHandler;
        this.attachmentDownloadOptionHandler = attachmentDownloadOptionHandler;
        this.attachmentDeleteOptionClickHandler = attachmentDeleteOptionClickHandler;
    }

    public final void setData(@NotNull List<AttachmentGalleryItem> attachmentGalleryItems, int attachmentIndex) {
        Intrinsics.checkNotNullParameter(attachmentGalleryItems, (String)"attachmentGalleryItems");
        this.attachmentGalleryItems = attachmentGalleryItems;
        this.attachmentIndex = attachmentIndex;
    }

    @Override
    public void navigate() {
        block3: {
            List<AttachmentGalleryItem> list = this.attachmentGalleryItems;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachmentGalleryItems");
                list = null;
            }
            if (list.isEmpty()) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"Invalid image(s)!", (int)0).show();
                return;
            }
            List<AttachmentGalleryItem> list2 = this.attachmentGalleryItems;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachmentGalleryItems");
                list2 = null;
            }
            AttachmentGalleryRepository.INSTANCE.setAttachmentGalleryItems(list2);
            ActivityResultLauncher<AttachmentGalleryResultContract.Input> activityResultLauncher = this.launcher;
            if (activityResultLauncher == null) break block3;
            activityResultLauncher.launch((Object)new AttachmentGalleryResultContract.Input(this.attachmentIndex));
        }
    }

    public final void register(@NotNull ActivityResultRegistry activityResultRegistry) {
        Intrinsics.checkNotNullParameter((Object)activityResultRegistry, (String)"activityResultRegistry");
        this.launcher = activityResultRegistry.register("attachment_gallery_launcher#" + this.hashCode(), (ActivityResultContract)new AttachmentGalleryResultContract(), arg_0 -> AttachmentGalleryDestination.register$lambda$0(this, arg_0));
    }

    public final void unregister() {
        ActivityResultLauncher<AttachmentGalleryResultContract.Input> activityResultLauncher = this.launcher;
        if (activityResultLauncher != null) {
            activityResultLauncher.unregister();
        }
        this.launcher = null;
    }

    private static final void register$lambda$0(AttachmentGalleryDestination this$0, AttachmentGalleryActivity.AttachmentOptionResult result2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AttachmentGalleryActivity.AttachmentOptionResult attachmentOptionResult = result2;
        if (attachmentOptionResult instanceof AttachmentGalleryActivity.AttachmentOptionResult.Reply) {
            this$0.attachmentReplyOptionHandler.onClick(((AttachmentGalleryActivity.AttachmentOptionResult.Reply)result2).getResult());
        } else if (attachmentOptionResult instanceof AttachmentGalleryActivity.AttachmentOptionResult.ShowInChat) {
            this$0.attachmentShowInChatOptionHandler.onClick(((AttachmentGalleryActivity.AttachmentOptionResult.ShowInChat)result2).getResult());
        } else if (attachmentOptionResult instanceof AttachmentGalleryActivity.AttachmentOptionResult.Delete) {
            this$0.attachmentDeleteOptionClickHandler.onClick(((AttachmentGalleryActivity.AttachmentOptionResult.Delete)result2).getResult());
        } else if (attachmentOptionResult instanceof AttachmentGalleryActivity.AttachmentOptionResult.Download) {
            this$0.attachmentDownloadOptionHandler.onClick(((AttachmentGalleryActivity.AttachmentOptionResult.Download)result2).getResult());
        } else if (attachmentOptionResult == null) {
            // empty if block
        }
    }
}

