/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.gallery.internal;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.feature.gallery.internal.AttachmentGalleryImagePageFragment;
import io.getstream.chat.android.ui.feature.gallery.internal.AttachmentGalleryVideoPageFragment;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/internal/AttachmentGalleryPagerAdapter;", "Landroidx/viewpager2/adapter/FragmentStateAdapter;", "fragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "mediaList", "", "Lio/getstream/chat/android/models/Attachment;", "mediaClickListener", "Lkotlin/Function0;", "", "(Landroidx/fragment/app/FragmentActivity;Ljava/util/List;Lkotlin/jvm/functions/Function0;)V", "createFragment", "Landroidx/fragment/app/Fragment;", "position", "", "getItem", "getItemCount", "stream-chat-android-ui-components_release"})
public final class AttachmentGalleryPagerAdapter
extends FragmentStateAdapter {
    @NotNull
    private final List<Attachment> mediaList;
    @NotNull
    private final Function0<Unit> mediaClickListener;

    public AttachmentGalleryPagerAdapter(@NotNull FragmentActivity fragmentActivity, @NotNull List<Attachment> mediaList, @NotNull Function0<Unit> mediaClickListener2) {
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"fragmentActivity");
        Intrinsics.checkNotNullParameter(mediaList, (String)"mediaList");
        Intrinsics.checkNotNullParameter(mediaClickListener2, (String)"mediaClickListener");
        super(fragmentActivity);
        this.mediaList = mediaList;
        this.mediaClickListener = mediaClickListener2;
    }

    public int getItemCount() {
        return this.mediaList.size();
    }

    @NotNull
    public Fragment createFragment(int position) {
        Fragment fragment;
        Attachment attachment = this.getItem(position);
        String string2 = attachment.getType();
        if (Intrinsics.areEqual((Object)string2, (Object)"image")) {
            fragment = AttachmentGalleryImagePageFragment.Companion.create(attachment, this.mediaClickListener);
        } else if (Intrinsics.areEqual((Object)string2, (Object)"video")) {
            fragment = AttachmentGalleryVideoPageFragment.Companion.create(attachment, this.mediaClickListener);
        } else {
            throw new Throwable("Unsupported attachment type");
        }
        return fragment;
    }

    @NotNull
    public final Attachment getItem(int position) {
        return this.mediaList.get(position);
    }
}

