/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.gallery.overview.internal;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import io.getstream.chat.android.client.utils.attachment.AttachmentUtilsKt;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.ui.ChatUI;
import io.getstream.chat.android.ui.common.images.resizing.StreamCdnImageResizing;
import io.getstream.chat.android.ui.common.images.resizing.StringExtensionsKt;
import io.getstream.chat.android.ui.common.utils.extensions.AttachmentKt;
import io.getstream.chat.android.ui.databinding.StreamUiItemMediaAttachmentBinding;
import io.getstream.chat.android.ui.feature.gallery.AttachmentGalleryItem;
import io.getstream.chat.android.ui.feature.gallery.MediaAttachmentGridViewStyle;
import io.getstream.chat.android.ui.utils.ImageUtilsKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import io.getstream.chat.android.ui.widgets.avatar.UserAvatarView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\u0012\u0013\u0014B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryItem;", "Lio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter$MediaAttachmentViewHolder;", "style", "Lio/getstream/chat/android/ui/feature/gallery/MediaAttachmentGridViewStyle;", "mediaAttachmentClickListener", "Lio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter$MediaAttachmentClickListener;", "(Lio/getstream/chat/android/ui/feature/gallery/MediaAttachmentGridViewStyle;Lio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter$MediaAttachmentClickListener;)V", "onBindViewHolder", "", "holder", "position", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "AttachmentGalleryItemDiffCallback", "MediaAttachmentClickListener", "MediaAttachmentViewHolder", "stream-chat-android-ui-components_release"})
public final class MediaAttachmentAdapter
extends ListAdapter<AttachmentGalleryItem, MediaAttachmentViewHolder> {
    @NotNull
    private final MediaAttachmentGridViewStyle style;
    @NotNull
    private final MediaAttachmentClickListener mediaAttachmentClickListener;

    public MediaAttachmentAdapter(@NotNull MediaAttachmentGridViewStyle style2, @NotNull MediaAttachmentClickListener mediaAttachmentClickListener) {
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        Intrinsics.checkNotNullParameter((Object)mediaAttachmentClickListener, (String)"mediaAttachmentClickListener");
        super((DiffUtil.ItemCallback)AttachmentGalleryItemDiffCallback.INSTANCE);
        this.style = style2;
        this.mediaAttachmentClickListener = mediaAttachmentClickListener;
    }

    @NotNull
    public MediaAttachmentViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        StreamUiItemMediaAttachmentBinding it = StreamUiItemMediaAttachmentBinding.inflate(ViewGroupKt.getStreamThemeInflater(parent), parent, false);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return new MediaAttachmentViewHolder(it, this.mediaAttachmentClickListener, this.style);
    }

    public void onBindViewHolder(@NotNull MediaAttachmentViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Object object = this.getItem(position);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        holder.bind((AttachmentGalleryItem)object);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter$AttachmentGalleryItemDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryItem;", "()V", "areContentsTheSame", "", "oldItem", "newItem", "areItemsTheSame", "stream-chat-android-ui-components_release"})
    private static final class AttachmentGalleryItemDiffCallback
    extends DiffUtil.ItemCallback<AttachmentGalleryItem> {
        @NotNull
        public static final AttachmentGalleryItemDiffCallback INSTANCE = new AttachmentGalleryItemDiffCallback();

        private AttachmentGalleryItemDiffCallback() {
        }

        public boolean areItemsTheSame(@NotNull AttachmentGalleryItem oldItem, @NotNull AttachmentGalleryItem newItem) {
            Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
            Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
            return Intrinsics.areEqual((Object)AttachmentKt.getImagePreviewUrl((Attachment)oldItem.getAttachment()), (Object)AttachmentKt.getImagePreviewUrl((Attachment)newItem.getAttachment())) && Intrinsics.areEqual((Object)oldItem.getCreatedAt(), (Object)newItem.getCreatedAt());
        }

        public boolean areContentsTheSame(@NotNull AttachmentGalleryItem oldItem, @NotNull AttachmentGalleryItem newItem) {
            Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
            Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
            return Intrinsics.areEqual((Object)oldItem, (Object)newItem);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter$MediaAttachmentClickListener;", "", "onMediaAttachmentClick", "", "position", "", "stream-chat-android-ui-components_release"})
    public static interface MediaAttachmentClickListener {
        public void onMediaAttachmentClick(int var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter$MediaAttachmentViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiItemMediaAttachmentBinding;", "mediaAttachmentClickListener", "Lio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter$MediaAttachmentClickListener;", "style", "Lio/getstream/chat/android/ui/feature/gallery/MediaAttachmentGridViewStyle;", "(Lio/getstream/chat/android/ui/databinding/StreamUiItemMediaAttachmentBinding;Lio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter$MediaAttachmentClickListener;Lio/getstream/chat/android/ui/feature/gallery/MediaAttachmentGridViewStyle;)V", "bind", "", "attachmentGalleryItem", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryItem;", "loadImage", "setupPlayButton", "attachmentType", "", "setupPlayButtonCard", "setupPlayButtonIcon", "setupUserAvatar", "stream-chat-android-ui-components_release"})
    @SourceDebugExtension(value={"SMAP\nMediaAttachmentAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaAttachmentAdapter.kt\nio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter$MediaAttachmentViewHolder\n+ 2 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,198:1\n262#2,2:199\n262#2,2:201\n*S KotlinDebug\n*F\n+ 1 MediaAttachmentAdapter.kt\nio/getstream/chat/android/ui/feature/gallery/overview/internal/MediaAttachmentAdapter$MediaAttachmentViewHolder\n*L\n129#1:199,2\n132#1:201,2\n*E\n"})
    public static final class MediaAttachmentViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final StreamUiItemMediaAttachmentBinding binding;
        @NotNull
        private final MediaAttachmentClickListener mediaAttachmentClickListener;
        @NotNull
        private final MediaAttachmentGridViewStyle style;

        public MediaAttachmentViewHolder(@NotNull StreamUiItemMediaAttachmentBinding binding2, @NotNull MediaAttachmentClickListener mediaAttachmentClickListener, @NotNull MediaAttachmentGridViewStyle style2) {
            Intrinsics.checkNotNullParameter((Object)binding2, (String)"binding");
            Intrinsics.checkNotNullParameter((Object)mediaAttachmentClickListener, (String)"mediaAttachmentClickListener");
            Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
            super((View)binding2.getRoot());
            this.binding = binding2;
            this.mediaAttachmentClickListener = mediaAttachmentClickListener;
            this.style = style2;
            this.binding.mediaContainer.setOnClickListener(arg_0 -> MediaAttachmentViewHolder._init_$lambda$0(this, arg_0));
        }

        public final void bind(@NotNull AttachmentGalleryItem attachmentGalleryItem) {
            Intrinsics.checkNotNullParameter((Object)attachmentGalleryItem, (String)"attachmentGalleryItem");
            this.setupUserAvatar(attachmentGalleryItem);
            this.setupPlayButton(attachmentGalleryItem.getAttachment().getType());
            this.loadImage(attachmentGalleryItem);
        }

        private final void loadImage(AttachmentGalleryItem attachmentGalleryItem) {
            String string2;
            boolean isVideoAttachment = AttachmentUtilsKt.isVideo((Attachment)attachmentGalleryItem.getAttachment());
            boolean shouldLoadImage = AttachmentUtilsKt.isImage((Attachment)attachmentGalleryItem.getAttachment()) || AttachmentUtilsKt.isVideo((Attachment)attachmentGalleryItem.getAttachment()) && ChatUI.getVideoThumbnailsEnabled();
            ImageView imageView = this.binding.mediaImageView;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"mediaImageView");
            if (shouldLoadImage) {
                String string3 = AttachmentKt.getImagePreviewUrl((Attachment)attachmentGalleryItem.getAttachment());
                string2 = string3 != null ? StringExtensionsKt.applyStreamCdnImageResizingIfEnabled((String)string3, (StreamCdnImageResizing)ChatUI.getStreamCdnImageResizing()) : null;
            } else {
                string2 = null;
            }
            ImageUtilsKt.load$default(imageView, (Object)string2, !isVideoAttachment ? this.style.getImagePlaceholder() : null, null, (Function0)new Function0<Unit>(this){
                final /* synthetic */ MediaAttachmentViewHolder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    MediaAttachmentViewHolder.access$getBinding$p((MediaAttachmentViewHolder)this.this$0).progressBar.setVisibility(0);
                }
            }, (Function0)new Function0<Unit>(this, attachmentGalleryItem){
                final /* synthetic */ MediaAttachmentViewHolder this$0;
                final /* synthetic */ AttachmentGalleryItem $attachmentGalleryItem;
                {
                    this.this$0 = $receiver;
                    this.$attachmentGalleryItem = $attachmentGalleryItem;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$isVisible$iv;
                    CardView cardView = MediaAttachmentViewHolder.access$getBinding$p((MediaAttachmentViewHolder)this.this$0).playButtonCardView;
                    Intrinsics.checkNotNullExpressionValue((Object)cardView, (String)"playButtonCardView");
                    View view = (View)cardView;
                    boolean value$iv = AttachmentUtilsKt.isVideo((Attachment)this.$attachmentGalleryItem.getAttachment());
                    boolean $i$f$setVisible = false;
                    $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
                    MediaAttachmentViewHolder.access$getBinding$p((MediaAttachmentViewHolder)this.this$0).progressBar.setVisibility(8);
                }
            }, 4, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void setupUserAvatar(AttachmentGalleryItem attachmentGalleryItem) {
            User user = attachmentGalleryItem.getUser();
            if (this.style.getShowUserAvatars()) {
                void $this$isVisible$iv;
                CardView cardView = this.binding.userAvatarCardView;
                Intrinsics.checkNotNullExpressionValue((Object)cardView, (String)"userAvatarCardView");
                View view = (View)cardView;
                boolean value$iv = true;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                UserAvatarView userAvatarView = this.binding.userAvatarView;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)userAvatarView), (String)"userAvatarView");
                UserAvatarView.setUser$default(userAvatarView, user, false, 2, null);
            } else {
                CardView cardView = this.binding.userAvatarCardView;
                Intrinsics.checkNotNullExpressionValue((Object)cardView, (String)"userAvatarCardView");
                View $this$isVisible$iv = (View)cardView;
                boolean value$iv = false;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
            }
        }

        private final void setupPlayButton(String attachmentType) {
            if (Intrinsics.areEqual((Object)attachmentType, (Object)"video")) {
                this.setupPlayButtonIcon();
                this.setupPlayButtonCard();
            }
        }

        private final void setupPlayButtonIcon() {
            Drawable drawable2;
            ImageView $this$setupPlayButtonIcon_u24lambda_u242 = this.binding.playButtonImageView;
            boolean bl = false;
            Drawable drawable3 = this.style.getPlayVideoButtonIcon();
            if (drawable3 != null && (drawable3 = drawable3.mutate()) != null) {
                Drawable drawable4;
                Drawable $this$setupPlayButtonIcon_u24lambda_u242_u24lambda_u241 = drawable4 = drawable3;
                boolean bl2 = false;
                Integer tintColor = this.style.getPlayVideoIconTint();
                if (tintColor != null) {
                    $this$setupPlayButtonIcon_u24lambda_u242_u24lambda_u241.setTint(tintColor.intValue());
                }
                drawable2 = drawable4;
            } else {
                drawable2 = null;
            }
            Drawable playVideoDrawable = drawable2;
            $this$setupPlayButtonIcon_u24lambda_u242.setImageDrawable(playVideoDrawable);
            $this$setupPlayButtonIcon_u24lambda_u242.setPaddingRelative(this.style.getPlayVideoIconPaddingStart(), this.style.getPlayVideoIconPaddingTop(), this.style.getPlayVideoIconPaddingEnd(), this.style.getPlayVideoIconPaddingBottom());
        }

        private final void setupPlayButtonCard() {
            CardView $this$setupPlayButtonCard_u24lambda_u243 = this.binding.playButtonCardView;
            boolean bl = false;
            $this$setupPlayButtonCard_u24lambda_u243.setElevation(this.style.getPlayVideoIconElevation());
            $this$setupPlayButtonCard_u24lambda_u243.setCardBackgroundColor(this.style.getPlayVideoIconBackgroundColor());
            $this$setupPlayButtonCard_u24lambda_u243.setRadius(this.style.getPlayVideoIconCornerRadius());
        }

        private static final void _init_$lambda$0(MediaAttachmentViewHolder this$0, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.mediaAttachmentClickListener.onMediaAttachmentClick(this$0.getBindingAdapterPosition());
        }

        public static final /* synthetic */ StreamUiItemMediaAttachmentBinding access$getBinding$p(MediaAttachmentViewHolder $this) {
            return $this.binding;
        }
    }
}

