/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.composer.attachment.picker.factory.camera.internal;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import io.getstream.chat.android.ui.common.contract.internal.CaptureMediaContract;
import io.getstream.chat.android.ui.common.state.messages.composer.AttachmentMetaData;
import io.getstream.chat.android.ui.databinding.StreamUiAttachmentPermissionViewBinding;
import io.getstream.chat.android.ui.databinding.StreamUiFragmentAttachmentCameraBinding;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.picker.AttachmentsPickerDialogStyle;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.picker.PickerMediaMode;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.picker.factory.AttachmentsPickerTabListener;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.utils.PermissionChecker;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0002J\u001a\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010!\u001a\u00020\u0007H\u0002J\b\u0010\"\u001a\u00020\u0007H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/camera/internal/CameraAttachmentFragment;", "Landroidx/fragment/app/Fragment;", "()V", "_binding", "Lio/getstream/chat/android/ui/databinding/StreamUiFragmentAttachmentCameraBinding;", "activityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "", "attachmentsPickerTabListener", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/AttachmentsPickerTabListener;", "binding", "getBinding", "()Lio/getstream/chat/android/ui/databinding/StreamUiFragmentAttachmentCameraBinding;", "permissionChecker", "Lio/getstream/chat/android/ui/utils/PermissionChecker;", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/AttachmentsPickerDialogStyle;", "checkPermissions", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onDestroyView", "onPermissionDenied", "onPermissionGranted", "onViewCreated", "view", "setAttachmentsPickerTabListener", "setStyle", "setupResultListener", "setupViews", "Companion", "LauncherRequestsKeys", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nCameraAttachmentFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraAttachmentFragment.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/camera/internal/CameraAttachmentFragment\n+ 2 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,176:1\n262#2,2:177\n262#2,2:179\n*S KotlinDebug\n*F\n+ 1 CameraAttachmentFragment.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/camera/internal/CameraAttachmentFragment\n*L\n134#1:177,2\n139#1:179,2\n*E\n"})
public final class CameraAttachmentFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private StreamUiFragmentAttachmentCameraBinding _binding;
    @NotNull
    private final PermissionChecker permissionChecker = new PermissionChecker();
    @Nullable
    private ActivityResultLauncher<Unit> activityResultLauncher;
    private AttachmentsPickerDialogStyle style;
    @Nullable
    private AttachmentsPickerTabListener attachmentsPickerTabListener;

    private final StreamUiFragmentAttachmentCameraBinding getBinding() {
        StreamUiFragmentAttachmentCameraBinding streamUiFragmentAttachmentCameraBinding = this._binding;
        Intrinsics.checkNotNull((Object)streamUiFragmentAttachmentCameraBinding);
        return streamUiFragmentAttachmentCameraBinding;
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext(...)");
        this._binding = StreamUiFragmentAttachmentCameraBinding.inflate(ContextKt.getStreamThemeInflater(context), container, false);
        ConstraintLayout constraintLayout = this.getBinding().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
        return (View)constraintLayout;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        if (this.style != null) {
            this.setupViews();
            this.setupResultListener();
            this.checkPermissions();
        }
    }

    public final void setStyle(@NotNull AttachmentsPickerDialogStyle style2) {
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        this.style = style2;
    }

    public final void setAttachmentsPickerTabListener(@NotNull AttachmentsPickerTabListener attachmentsPickerTabListener2) {
        Intrinsics.checkNotNullParameter((Object)attachmentsPickerTabListener2, (String)"attachmentsPickerTabListener");
        this.attachmentsPickerTabListener = attachmentsPickerTabListener2;
    }

    private final void setupViews() {
        StreamUiAttachmentPermissionViewBinding streamUiAttachmentPermissionViewBinding;
        StreamUiAttachmentPermissionViewBinding $this$setupViews_u24lambda_u241 = streamUiAttachmentPermissionViewBinding = this.getBinding().grantPermissionsInclude;
        boolean bl = false;
        ImageView imageView = $this$setupViews_u24lambda_u241.grantPermissionsImageView;
        AttachmentsPickerDialogStyle attachmentsPickerDialogStyle = this.style;
        if (attachmentsPickerDialogStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            attachmentsPickerDialogStyle = null;
        }
        imageView.setImageDrawable(attachmentsPickerDialogStyle.getAllowAccessToCameraIconDrawable());
        TextView textView = $this$setupViews_u24lambda_u241.grantPermissionsTextView;
        AttachmentsPickerDialogStyle attachmentsPickerDialogStyle2 = this.style;
        if (attachmentsPickerDialogStyle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            attachmentsPickerDialogStyle2 = null;
        }
        textView.setText((CharSequence)attachmentsPickerDialogStyle2.getAllowAccessToCameraButtonText());
        TextView textView2 = $this$setupViews_u24lambda_u241.grantPermissionsTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"grantPermissionsTextView");
        AttachmentsPickerDialogStyle attachmentsPickerDialogStyle3 = this.style;
        if (attachmentsPickerDialogStyle3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            attachmentsPickerDialogStyle3 = null;
        }
        TextStyleKt.setTextStyle(textView2, attachmentsPickerDialogStyle3.getAllowAccessButtonTextStyle());
        $this$setupViews_u24lambda_u241.grantPermissionsTextView.setOnClickListener(arg_0 -> CameraAttachmentFragment.setupViews$lambda$1$lambda$0(this, arg_0));
    }

    private final void setupResultListener() {
        ActivityResultLauncher activityResultLauncher;
        ActivityResultRegistry activityResultRegistry;
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity != null && (activityResultRegistry = fragmentActivity.getActivityResultRegistry()) != null) {
            AttachmentsPickerDialogStyle attachmentsPickerDialogStyle = this.style;
            if (attachmentsPickerDialogStyle == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"style");
                attachmentsPickerDialogStyle = null;
            }
            activityResultLauncher = activityResultRegistry.register("capture_media_request_key", (ActivityResultContract)new CaptureMediaContract(CameraAttachmentFragment.Companion.getMode(attachmentsPickerDialogStyle.getPickerMediaMode())), arg_0 -> CameraAttachmentFragment.setupResultListener$lambda$2(this, arg_0));
        } else {
            activityResultLauncher = null;
        }
        this.activityResultLauncher = activityResultLauncher;
    }

    private final void checkPermissions() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext(...)");
        if (this.permissionChecker.isNeededToRequestForCameraPermissions(context)) {
            ConstraintLayout constraintLayout = this.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
            this.permissionChecker.checkCameraPermissions((View)constraintLayout, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    CameraAttachmentFragment.access$onPermissionDenied((CameraAttachmentFragment)((Object)this.receiver));
                }
            }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    CameraAttachmentFragment.access$onPermissionGranted((CameraAttachmentFragment)((Object)this.receiver));
                }
            }));
            return;
        }
        this.onPermissionGranted();
    }

    /*
     * WARNING - void declaration
     */
    private final void onPermissionGranted() {
        block0: {
            void $this$isVisible$iv;
            LinearLayout linearLayout = this.getBinding().grantPermissionsInclude.grantPermissionsContainer;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"grantPermissionsContainer");
            View view = (View)linearLayout;
            boolean value$iv = false;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
            ActivityResultLauncher<Unit> activityResultLauncher = this.activityResultLauncher;
            if (activityResultLauncher == null) break block0;
            activityResultLauncher.launch((Object)Unit.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onPermissionDenied() {
        void $this$isVisible$iv;
        LinearLayout linearLayout = this.getBinding().grantPermissionsInclude.grantPermissionsContainer;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"grantPermissionsContainer");
        View view = (View)linearLayout;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
    }

    public void onDestroyView() {
        super.onDestroyView();
        ActivityResultLauncher<Unit> activityResultLauncher = this.activityResultLauncher;
        if (activityResultLauncher != null) {
            activityResultLauncher.unregister();
        }
        this._binding = null;
    }

    private static final void setupViews$lambda$1$lambda$0(CameraAttachmentFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.checkPermissions();
    }

    private static final void setupResultListener$lambda$2(CameraAttachmentFragment this$0, File file) {
        block3: {
            List list;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            if (file == null) {
                list = CollectionsKt.emptyList();
            } else {
                Context context = this$0.requireContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext(...)");
                list = CollectionsKt.listOf((Object)new AttachmentMetaData(context, file));
            }
            List result2 = list;
            AttachmentsPickerTabListener attachmentsPickerTabListener2 = this$0.attachmentsPickerTabListener;
            if (attachmentsPickerTabListener2 != null) {
                attachmentsPickerTabListener2.onSelectedAttachmentsChanged(result2);
            }
            AttachmentsPickerTabListener attachmentsPickerTabListener3 = this$0.attachmentsPickerTabListener;
            if (attachmentsPickerTabListener3 == null) break block3;
            attachmentsPickerTabListener3.onSelectedAttachmentsSubmitted();
        }
    }

    public static final /* synthetic */ void access$onPermissionDenied(CameraAttachmentFragment $this) {
        $this.onPermissionDenied();
    }

    public static final /* synthetic */ void access$onPermissionGranted(CameraAttachmentFragment $this) {
        $this.onPermissionGranted();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/camera/internal/CameraAttachmentFragment$Companion;", "", "()V", "mode", "Lio/getstream/chat/android/ui/common/contract/internal/CaptureMediaContract$Mode;", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/PickerMediaMode;", "getMode", "(Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/PickerMediaMode;)Lio/getstream/chat/android/ui/common/contract/internal/CaptureMediaContract$Mode;", "newInstance", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/camera/internal/CameraAttachmentFragment;", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/AttachmentsPickerDialogStyle;", "stream-chat-android-ui-components_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CameraAttachmentFragment newInstance(@NotNull AttachmentsPickerDialogStyle style2) {
            CameraAttachmentFragment cameraAttachmentFragment;
            Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
            CameraAttachmentFragment $this$newInstance_u24lambda_u240 = cameraAttachmentFragment = new CameraAttachmentFragment();
            boolean bl = false;
            $this$newInstance_u24lambda_u240.setStyle(style2);
            return cameraAttachmentFragment;
        }

        private final CaptureMediaContract.Mode getMode(PickerMediaMode $this$mode) {
            CaptureMediaContract.Mode mode;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$mode.ordinal()]) {
                case 1: {
                    mode = CaptureMediaContract.Mode.PHOTO;
                    break;
                }
                case 2: {
                    mode = CaptureMediaContract.Mode.VIDEO;
                    break;
                }
                case 3: {
                    mode = CaptureMediaContract.Mode.PHOTO_AND_VIDEO;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return mode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PickerMediaMode.values().length];
                try {
                    nArray[PickerMediaMode.PHOTO.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PickerMediaMode.VIDEO.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PickerMediaMode.PHOTO_AND_VIDEO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/camera/internal/CameraAttachmentFragment$LauncherRequestsKeys;", "", "()V", "CAPTURE_MEDIA", "", "stream-chat-android-ui-components_release"})
    private static final class LauncherRequestsKeys {
        @NotNull
        public static final LauncherRequestsKeys INSTANCE = new LauncherRequestsKeys();
        @NotNull
        public static final String CAPTURE_MEDIA = "capture_media_request_key";

        private LauncherRequestsKeys() {
        }
    }
}

