/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.composer.attachment.picker.factory.file.internal;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import io.getstream.chat.android.ui.common.state.messages.composer.AttachmentMetaData;
import io.getstream.chat.android.ui.common.utils.MediaStringUtil;
import io.getstream.chat.android.ui.databinding.StreamUiItemAttachmentFileBinding;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.picker.AttachmentsPickerDialogStyle;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.utils.AttachmentUtilsKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007J\u0014\u0010\u0018\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/file/internal/FileAttachmentAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/file/internal/FileAttachmentAdapter$FileAttachmentViewHolder;", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/AttachmentsPickerDialogStyle;", "onAttachmentSelected", "Lkotlin/Function1;", "Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;", "", "(Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/AttachmentsPickerDialogStyle;Lkotlin/jvm/functions/Function1;)V", "attachments", "", "deselectAttachment", "attachment", "getItemCount", "", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "selectAttachment", "setAttachments", "toggleSelection", "isSelected", "", "FileAttachmentViewHolder", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nFileAttachmentAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileAttachmentAdapter.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/file/internal/FileAttachmentAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1#2:118\n1774#3,4:119\n766#3:123\n857#3,2:124\n1855#3,2:126\n*S KotlinDebug\n*F\n+ 1 FileAttachmentAdapter.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/file/internal/FileAttachmentAdapter\n*L\n64#1:119,4\n69#1:123\n69#1:124,2\n69#1:126,2\n*E\n"})
public final class FileAttachmentAdapter
extends RecyclerView.Adapter<FileAttachmentViewHolder> {
    @NotNull
    private final AttachmentsPickerDialogStyle style;
    @NotNull
    private final Function1<AttachmentMetaData, Unit> onAttachmentSelected;
    @NotNull
    private List<AttachmentMetaData> attachments;

    public FileAttachmentAdapter(@NotNull AttachmentsPickerDialogStyle style2, @NotNull Function1<? super AttachmentMetaData, Unit> onAttachmentSelected) {
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        Intrinsics.checkNotNullParameter(onAttachmentSelected, (String)"onAttachmentSelected");
        this.style = style2;
        this.onAttachmentSelected = onAttachmentSelected;
        this.attachments = CollectionsKt.emptyList();
    }

    public void onBindViewHolder(@NotNull FileAttachmentViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bind(this.attachments.get(position));
    }

    public int getItemCount() {
        return this.attachments.size();
    }

    public final void selectAttachment(@NotNull AttachmentMetaData attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        this.toggleSelection(attachment, true);
    }

    public final void deselectAttachment(@NotNull AttachmentMetaData attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        this.toggleSelection(attachment, false);
    }

    public final void setAttachments(@NotNull List<AttachmentMetaData> attachments2) {
        Intrinsics.checkNotNullParameter(attachments2, (String)"attachments");
        this.attachments = attachments2;
        this.notifyDataSetChanged();
    }

    @NotNull
    public FileAttachmentViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        StreamUiItemAttachmentFileBinding it = StreamUiItemAttachmentFileBinding.inflate(ViewGroupKt.getStreamThemeInflater(parent), parent, false);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return new FileAttachmentViewHolder(it, this.onAttachmentSelected, this.style);
    }

    /*
     * WARNING - void declaration
     */
    private final void toggleSelection(AttachmentMetaData attachment, boolean isSelected) {
        int index = this.attachments.indexOf(attachment);
        if (index != -1) {
            this.attachments.get(index).setSelected(isSelected);
            if (isSelected) {
                int n;
                void $this$count$iv;
                Iterable iterable = this.attachments;
                AttachmentMetaData attachmentMetaData = this.attachments.get(index);
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        AttachmentMetaData it = (AttachmentMetaData)element$iv;
                        boolean bl = false;
                        if (!it.isSelected() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int n2 = n;
                attachmentMetaData.setSelectedPosition(n2);
                this.notifyItemChanged(index);
            } else {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                int prevSelectedPosition = this.attachments.get(index).getSelectedPosition();
                this.attachments.get(index).setSelectedPosition(0);
                Iterable $this$filter$iv = this.attachments;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    AttachmentMetaData it = (AttachmentMetaData)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getSelectedPosition() > prevSelectedPosition)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AttachmentMetaData it = (AttachmentMetaData)element$iv;
                    boolean bl = false;
                    it.setSelectedPosition(it.getSelectedPosition() - 1);
                }
                this.notifyDataSetChanged();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/file/internal/FileAttachmentAdapter$FileAttachmentViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiItemAttachmentFileBinding;", "onAttachmentClick", "Lkotlin/Function1;", "Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;", "", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/AttachmentsPickerDialogStyle;", "(Lio/getstream/chat/android/ui/databinding/StreamUiItemAttachmentFileBinding;Lkotlin/jvm/functions/Function1;Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/AttachmentsPickerDialogStyle;)V", "attachment", "getAttachment", "()Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;", "setAttachment", "(Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;)V", "bind", "getSelectionIndicatorBackground", "Landroid/graphics/drawable/Drawable;", "selected", "", "stream-chat-android-ui-components_release"})
    @SourceDebugExtension(value={"SMAP\nFileAttachmentAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileAttachmentAdapter.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/file/internal/FileAttachmentAdapter$FileAttachmentViewHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
    public static final class FileAttachmentViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final StreamUiItemAttachmentFileBinding binding;
        @NotNull
        private final Function1<AttachmentMetaData, Unit> onAttachmentClick;
        @NotNull
        private final AttachmentsPickerDialogStyle style;
        public AttachmentMetaData attachment;

        public FileAttachmentViewHolder(@NotNull StreamUiItemAttachmentFileBinding binding2, @NotNull Function1<? super AttachmentMetaData, Unit> onAttachmentClick, @NotNull AttachmentsPickerDialogStyle style2) {
            Intrinsics.checkNotNullParameter((Object)binding2, (String)"binding");
            Intrinsics.checkNotNullParameter(onAttachmentClick, (String)"onAttachmentClick");
            Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
            super((View)binding2.getRoot());
            this.binding = binding2;
            this.onAttachmentClick = onAttachmentClick;
            this.style = style2;
            this.binding.getRoot().setOnClickListener(arg_0 -> FileAttachmentViewHolder._init_$lambda$0(this, arg_0));
            this.binding.selectionIndicator.setTextColor(this.style.getFileAttachmentItemCheckboxTextColor());
            TextView textView = this.binding.fileNameTextView;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"fileNameTextView");
            TextStyleKt.setTextStyle(textView, this.style.getFileAttachmentItemNameTextStyle());
            TextView textView2 = this.binding.fileSizeTextView;
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"fileSizeTextView");
            TextStyleKt.setTextStyle(textView2, this.style.getFileAttachmentItemSizeTextStyle());
        }

        @NotNull
        public final AttachmentMetaData getAttachment() {
            AttachmentMetaData attachmentMetaData = this.attachment;
            if (attachmentMetaData != null) {
                return attachmentMetaData;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            return null;
        }

        public final void setAttachment(@NotNull AttachmentMetaData attachmentMetaData) {
            Intrinsics.checkNotNullParameter((Object)attachmentMetaData, (String)"<set-?>");
            this.attachment = attachmentMetaData;
        }

        /*
         * WARNING - void declaration
         */
        public final void bind(@NotNull AttachmentMetaData attachment) {
            void it;
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            this.setAttachment(attachment);
            ImageView imageView = this.binding.fileTypeImageView;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"fileTypeImageView");
            AttachmentUtilsKt.loadAttachmentThumb(imageView, attachment);
            this.binding.fileNameTextView.setText((CharSequence)attachment.getTitle());
            this.binding.fileSizeTextView.setText((CharSequence)MediaStringUtil.convertFileSizeByteCount((long)attachment.getSize()));
            this.binding.selectionIndicator.setBackground(this.getSelectionIndicatorBackground(attachment.isSelected(), this.style));
            this.binding.selectionIndicator.setChecked(attachment.isSelected());
            Integer n = attachment.getSelectedPosition();
            int n2 = ((Number)n).intValue();
            CheckedTextView checkedTextView = this.binding.selectionIndicator;
            boolean bl = false;
            boolean bl2 = it > 0;
            Object object = bl2 ? n : null;
            checkedTextView.setText(object != null && (object = ((Integer)object).toString()) != null ? (CharSequence)object : (CharSequence)"");
        }

        private final Drawable getSelectionIndicatorBackground(boolean selected, AttachmentsPickerDialogStyle style2) {
            return selected ? style2.getFileAttachmentItemCheckboxSelectedDrawable() : style2.getFileAttachmentItemCheckboxDeselectedDrawable();
        }

        private static final void _init_$lambda$0(FileAttachmentViewHolder this$0, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.onAttachmentClick.invoke((Object)this$0.getAttachment());
        }
    }
}

