/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.composer.attachment.picker.factory.media.internal;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.common.state.messages.composer.AttachmentMetaData;
import io.getstream.chat.android.ui.common.utils.MediaStringUtil;
import io.getstream.chat.android.ui.databinding.StreamUiItemAttachmentMediaBinding;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.picker.AttachmentsPickerDialogStyle;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.utils.ImageUtilsKt;
import io.getstream.chat.android.ui.utils.extensions.DrawableKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B0\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012!\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007J\u0014\u0010\u001c\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dJ\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/media/internal/MediaAttachmentAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/media/internal/MediaAttachmentAdapter$MediaAttachmentViewHolder;", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/AttachmentsPickerDialogStyle;", "onAttachmentSelected", "Lkotlin/Function1;", "Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;", "Lkotlin/ParameterName;", "name", "attachmentMetaData", "", "(Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/AttachmentsPickerDialogStyle;Lkotlin/jvm/functions/Function1;)V", "attachments", "", "clearAttachments", "deselectAttachment", "attachment", "getItemCount", "", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "selectAttachment", "setAttachments", "", "toggleAttachmentSelection", "isSelected", "", "MediaAttachmentViewHolder", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nMediaAttachmentAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaAttachmentAdapter.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/media/internal/MediaAttachmentAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class MediaAttachmentAdapter
extends RecyclerView.Adapter<MediaAttachmentViewHolder> {
    @NotNull
    private final AttachmentsPickerDialogStyle style;
    @NotNull
    private final Function1<AttachmentMetaData, Unit> onAttachmentSelected;
    @NotNull
    private final List<AttachmentMetaData> attachments;

    public MediaAttachmentAdapter(@NotNull AttachmentsPickerDialogStyle style2, @NotNull Function1<? super AttachmentMetaData, Unit> onAttachmentSelected) {
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        Intrinsics.checkNotNullParameter(onAttachmentSelected, (String)"onAttachmentSelected");
        this.style = style2;
        this.onAttachmentSelected = onAttachmentSelected;
        this.attachments = new ArrayList();
    }

    @NotNull
    public MediaAttachmentViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        StreamUiItemAttachmentMediaBinding it = StreamUiItemAttachmentMediaBinding.inflate(ViewGroupKt.getStreamThemeInflater(parent), parent, false);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return new MediaAttachmentViewHolder(it, this.onAttachmentSelected, this.style);
    }

    public void onBindViewHolder(@NotNull MediaAttachmentViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bind(this.attachments.get(position));
    }

    public int getItemCount() {
        return this.attachments.size();
    }

    public final void setAttachments(@NotNull List<AttachmentMetaData> attachments2) {
        Intrinsics.checkNotNullParameter(attachments2, (String)"attachments");
        this.attachments.clear();
        this.attachments.addAll((Collection<AttachmentMetaData>)attachments2);
        this.notifyDataSetChanged();
    }

    public final void selectAttachment(@NotNull AttachmentMetaData attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        this.toggleAttachmentSelection(attachment, true);
    }

    public final void deselectAttachment(@NotNull AttachmentMetaData attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        this.toggleAttachmentSelection(attachment, false);
    }

    public final void clearAttachments() {
        this.attachments.clear();
        this.notifyDataSetChanged();
    }

    private final void toggleAttachmentSelection(AttachmentMetaData attachment, boolean isSelected) {
        int index = this.attachments.indexOf(attachment);
        if (index != -1) {
            this.attachments.get(index).setSelected(isSelected);
            this.notifyItemChanged(index);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B8\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002R\u001a\u0010\u000e\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/media/internal/MediaAttachmentAdapter$MediaAttachmentViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiItemAttachmentMediaBinding;", "onAttachmentSelected", "Lkotlin/Function1;", "Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;", "Lkotlin/ParameterName;", "name", "attachmentMetaData", "", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/AttachmentsPickerDialogStyle;", "(Lio/getstream/chat/android/ui/databinding/StreamUiItemAttachmentMediaBinding;Lkotlin/jvm/functions/Function1;Lio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/AttachmentsPickerDialogStyle;)V", "attachment", "getAttachment", "()Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;", "setAttachment", "(Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;)V", "bind", "bindAttachmentType", "bindMediaImage", "bindSelectionMark", "bindSelectionOverlay", "stream-chat-android-ui-components_release"})
    @SourceDebugExtension(value={"SMAP\nMediaAttachmentAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaAttachmentAdapter.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/media/internal/MediaAttachmentAdapter$MediaAttachmentViewHolder\n+ 2 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,139:1\n262#2,2:140\n262#2,2:142\n262#2,2:144\n262#2,2:146\n262#2,2:148\n262#2,2:150\n*S KotlinDebug\n*F\n+ 1 MediaAttachmentAdapter.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/picker/factory/media/internal/MediaAttachmentAdapter$MediaAttachmentViewHolder\n*L\n114#1:140,2\n118#1:142,2\n123#1:144,2\n125#1:146,2\n126#1:148,2\n133#1:150,2\n*E\n"})
    public static final class MediaAttachmentViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final StreamUiItemAttachmentMediaBinding binding;
        @NotNull
        private final Function1<AttachmentMetaData, Unit> onAttachmentSelected;
        @NotNull
        private final AttachmentsPickerDialogStyle style;
        public AttachmentMetaData attachment;

        public MediaAttachmentViewHolder(@NotNull StreamUiItemAttachmentMediaBinding binding2, @NotNull Function1<? super AttachmentMetaData, Unit> onAttachmentSelected, @NotNull AttachmentsPickerDialogStyle style2) {
            Intrinsics.checkNotNullParameter((Object)binding2, (String)"binding");
            Intrinsics.checkNotNullParameter(onAttachmentSelected, (String)"onAttachmentSelected");
            Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
            super((View)binding2.getRoot());
            this.binding = binding2;
            this.onAttachmentSelected = onAttachmentSelected;
            this.style = style2;
            this.binding.getRoot().setOnClickListener(arg_0 -> MediaAttachmentViewHolder._init_$lambda$0(this, arg_0));
        }

        @NotNull
        public final AttachmentMetaData getAttachment() {
            AttachmentMetaData attachmentMetaData = this.attachment;
            if (attachmentMetaData != null) {
                return attachmentMetaData;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            return null;
        }

        public final void setAttachment(@NotNull AttachmentMetaData attachmentMetaData) {
            Intrinsics.checkNotNullParameter((Object)attachmentMetaData, (String)"<set-?>");
            this.attachment = attachmentMetaData;
        }

        public final void bind(@NotNull AttachmentMetaData attachment) {
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            this.setAttachment(attachment);
            this.bindMediaImage(attachment);
            this.bindSelectionMark(attachment);
            this.bindSelectionOverlay(attachment);
            this.bindAttachmentType(attachment);
        }

        private final void bindMediaImage(AttachmentMetaData attachment) {
            if (Intrinsics.areEqual((Object)attachment.getType(), (Object)"video")) {
                ImageView imageView = this.binding.mediaThumbnailImageView;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"mediaThumbnailImageView");
                ImageUtilsKt.loadVideoThumbnail$default(imageView, attachment.getUri(), R.drawable.stream_ui_placeholder, null, null, null, 28, null);
                int color2 = ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.stream_ui_white_smoke);
                this.binding.mediaThumbnailImageView.setBackgroundColor(color2);
            } else {
                ImageView imageView = this.binding.mediaThumbnailImageView;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"mediaThumbnailImageView");
                ImageUtilsKt.load$default(imageView, (Object)attachment.getUri(), null, null, null, null, 30, null);
                this.binding.mediaThumbnailImageView.setBackgroundColor(0);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void bindSelectionMark(AttachmentMetaData attachment) {
            void $this$isVisible$iv;
            ImageView imageView = this.binding.selectionMarkImageView;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"selectionMarkImageView");
            View view = (View)imageView;
            boolean value$iv = attachment.isSelected();
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        }

        /*
         * WARNING - void declaration
         */
        private final void bindSelectionOverlay(AttachmentMetaData attachment) {
            void $this$isVisible$iv;
            View view = this.binding.selectionOverlayView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"selectionOverlayView");
            View view2 = view;
            boolean value$iv = attachment.isSelected();
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        }

        private final void bindAttachmentType(AttachmentMetaData attachment) {
            if (Intrinsics.areEqual((Object)attachment.getType(), (Object)"video")) {
                View $this$isVisible$iv;
                ConstraintLayout constraintLayout = this.binding.videoInformationConstraintLayout;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"videoInformationConstraintLayout");
                View view = (View)constraintLayout;
                boolean value$iv = this.style.getVideoLengthTextVisible() || this.style.getVideoIconVisible();
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
                TextView textView = this.binding.videoLengthTextView;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"videoLengthTextView");
                $this$isVisible$iv = (View)textView;
                value$iv = this.style.getVideoLengthTextVisible();
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
                ImageView imageView = this.binding.videoLogoImageView;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"videoLogoImageView");
                $this$isVisible$iv = (View)imageView;
                value$iv = this.style.getVideoIconVisible();
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
                this.binding.videoLogoImageView.setImageDrawable(DrawableKt.applyTint(this.style.getVideoIconDrawable(), this.style.getVideoIconDrawableTint()));
                TextView textView2 = this.binding.videoLengthTextView;
                Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"videoLengthTextView");
                TextStyleKt.setTextStyle(textView2, this.style.getVideoLengthTextStyle());
                this.binding.videoLengthTextView.setText((CharSequence)MediaStringUtil.convertVideoLength$default((long)attachment.getVideoLength(), null, (int)2, null));
            } else {
                ConstraintLayout constraintLayout = this.binding.videoInformationConstraintLayout;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"videoInformationConstraintLayout");
                View $this$isVisible$iv = (View)constraintLayout;
                boolean value$iv = false;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
                this.binding.videoLengthTextView.setText((CharSequence)"");
            }
        }

        private static final void _init_$lambda$0(MediaAttachmentViewHolder this$0, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.onAttachmentSelected.invoke((Object)this$0.getAttachment());
        }
    }
}

