/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.composer.attachment.preview;

import android.view.ViewGroup;
import androidx.collection.SparseArrayCompat;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.feature.messages.composer.MessageComposerViewStyle;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.AttachmentPreviewViewHolder;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory.AttachmentPreviewFactory;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory.AudioRecordAttachmentPreviewFactory;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory.FallbackAttachmentPreviewFactory;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory.FileAttachmentPreviewFactory;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory.MediaAttachmentPreviewFactory;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB!\b\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J6\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001b0\u001a2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewFactoryManager;", "", "attachmentPreviewFactories", "", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/AttachmentPreviewFactory;", "fallbackAttachmentPreviewFactory", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/FallbackAttachmentPreviewFactory;", "(Ljava/util/List;Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/FallbackAttachmentPreviewFactory;)V", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "viewTypeToFactoryMapping", "Landroidx/collection/SparseArrayCompat;", "getItemViewType", "", "attachment", "Lio/getstream/chat/android/models/Attachment;", "onCreateViewHolder", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewViewHolder;", "parentView", "Landroid/view/ViewGroup;", "viewType", "attachmentRemovalListener", "Lkotlin/Function1;", "", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/MessageComposerViewStyle;", "Companion", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nAttachmentPreviewFactoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentPreviewFactoryManager.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewFactoryManager\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n*L\n1#1,104:1\n281#2,4:105\n*S KotlinDebug\n*F\n+ 1 AttachmentPreviewFactoryManager.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewFactoryManager\n*L\n89#1:105,4\n*E\n"})
public final class AttachmentPreviewFactoryManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FallbackAttachmentPreviewFactory fallbackAttachmentPreviewFactory;
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final SparseArrayCompat<AttachmentPreviewFactory> viewTypeToFactoryMapping;
    private static final int FALLBACK_FACTORY_VIEW_TYPE = 100;

    @JvmOverloads
    public AttachmentPreviewFactoryManager(@NotNull List<? extends AttachmentPreviewFactory> attachmentPreviewFactories, @NotNull FallbackAttachmentPreviewFactory fallbackAttachmentPreviewFactory) {
        Intrinsics.checkNotNullParameter(attachmentPreviewFactories, (String)"attachmentPreviewFactories");
        Intrinsics.checkNotNullParameter((Object)fallbackAttachmentPreviewFactory, (String)"fallbackAttachmentPreviewFactory");
        this.fallbackAttachmentPreviewFactory = fallbackAttachmentPreviewFactory;
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)this, (String)"AttachPreviewFM");
        this.viewTypeToFactoryMapping = new SparseArrayCompat(0, 1, null);
        int n = attachmentPreviewFactories.size();
        for (int i = 0; i < n; ++i) {
            this.viewTypeToFactoryMapping.put(i, (Object)attachmentPreviewFactories.get(i));
        }
    }

    public /* synthetic */ AttachmentPreviewFactoryManager(List list, FallbackAttachmentPreviewFactory fallbackAttachmentPreviewFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Object[] objectArray = new AttachmentPreviewFactory[]{new MediaAttachmentPreviewFactory(), new AudioRecordAttachmentPreviewFactory(), new FileAttachmentPreviewFactory()};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        if ((n & 2) != 0) {
            fallbackAttachmentPreviewFactory = new FallbackAttachmentPreviewFactory();
        }
        this(list, fallbackAttachmentPreviewFactory);
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @NotNull
    public final AttachmentPreviewViewHolder onCreateViewHolder(@NotNull ViewGroup parentView, int viewType, @NotNull Function1<? super Attachment, Unit> attachmentRemovalListener2, @Nullable MessageComposerViewStyle style2) {
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        Intrinsics.checkNotNullParameter(attachmentRemovalListener2, (String)"attachmentRemovalListener");
        return ((AttachmentPreviewFactory)this.viewTypeToFactoryMapping.get(viewType, (Object)this.fallbackAttachmentPreviewFactory)).onCreateViewHolder(parentView, attachmentRemovalListener2, style2);
    }

    public static /* synthetic */ AttachmentPreviewViewHolder onCreateViewHolder$default(AttachmentPreviewFactoryManager attachmentPreviewFactoryManager2, ViewGroup viewGroup, int n, Function1 function1, MessageComposerViewStyle messageComposerViewStyle, int n2, Object object) {
        if ((n2 & 8) != 0) {
            messageComposerViewStyle = null;
        }
        return attachmentPreviewFactoryManager2.onCreateViewHolder(viewGroup, n, (Function1<? super Attachment, Unit>)function1, messageComposerViewStyle);
    }

    public final int getItemViewType(@NotNull Attachment attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        int n = this.viewTypeToFactoryMapping.size();
        for (int i = 0; i < n; ++i) {
            AttachmentPreviewFactory factory2 = (AttachmentPreviewFactory)this.viewTypeToFactoryMapping.valueAt(i);
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[getItemViewType] i: " + i + ", factory: " + factory2;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            if (!factory2.canHandle(attachment)) continue;
            return this.viewTypeToFactoryMapping.keyAt(i);
        }
        return 100;
    }

    @JvmOverloads
    public AttachmentPreviewFactoryManager(@NotNull List<? extends AttachmentPreviewFactory> attachmentPreviewFactories) {
        Intrinsics.checkNotNullParameter(attachmentPreviewFactories, (String)"attachmentPreviewFactories");
        this(attachmentPreviewFactories, null, 2, null);
    }

    @JvmOverloads
    public AttachmentPreviewFactoryManager() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewFactoryManager$Companion;", "", "()V", "FALLBACK_FACTORY_VIEW_TYPE", "", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

