/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory;

import android.content.Context;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.audio.AudioPlayer;
import io.getstream.chat.android.client.audio.AudioState;
import io.getstream.chat.android.client.audio.ProgressData;
import io.getstream.chat.android.client.extensions.AttachmentExtensionsKt;
import io.getstream.chat.android.client.utils.attachment.AttachmentUtilsKt;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.common.utils.DurationFormatter;
import io.getstream.chat.android.ui.databinding.StreamUiAudioRecordPlayerPreviewBinding;
import io.getstream.chat.android.ui.feature.messages.common.AudioRecordPlayerViewStyle;
import io.getstream.chat.android.ui.feature.messages.composer.MessageComposerViewStyle;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.AttachmentPreviewViewHolder;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory.AttachmentPreviewFactory;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory.AudioRecordAttachmentPreviewFactory;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory.AudioRecordAttachmentPreviewFactoryKt;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.AudioRecordPlayerView;
import io.getstream.chat.android.ui.helper.ViewStyle;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/AudioRecordAttachmentPreviewFactory;", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/AttachmentPreviewFactory;", "()V", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "canHandle", "", "attachment", "Lio/getstream/chat/android/models/Attachment;", "onCreateViewHolder", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewViewHolder;", "parentView", "Landroid/view/ViewGroup;", "attachmentRemovalListener", "Lkotlin/Function1;", "", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/MessageComposerViewStyle;", "AudioRecordAttachmentPreviewViewHolder", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nAudioRecordAttachmentPreviewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioRecordAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/AudioRecordAttachmentPreviewFactory\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n292#2,4:178\n1#3:182\n*S KotlinDebug\n*F\n+ 1 AudioRecordAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/AudioRecordAttachmentPreviewFactory\n*L\n52#1:178,4\n*E\n"})
public final class AudioRecordAttachmentPreviewFactory
implements AttachmentPreviewFactory {
    @NotNull
    private final Lazy logger$delegate = StreamLogExtensionKt.taggedLogger((Object)this, (String)"AttachRecordPreviewFactory");

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @Override
    public boolean canHandle(@NotNull Attachment attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        TaggedLogger this_$iv = this.getLogger();
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[canHandle] isAudioRecording: " + AttachmentUtilsKt.isAudioRecording((Attachment)attachment) + "; " + attachment;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        return AttachmentUtilsKt.isAudioRecording((Attachment)attachment);
    }

    @Override
    @NotNull
    public AttachmentPreviewViewHolder onCreateViewHolder(@NotNull ViewGroup parentView, @NotNull Function1<? super Attachment, Unit> attachmentRemovalListener2, @Nullable MessageComposerViewStyle style2) {
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        Intrinsics.checkNotNullParameter(attachmentRemovalListener2, (String)"attachmentRemovalListener");
        Context context = parentView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        StreamUiAudioRecordPlayerPreviewBinding it = StreamUiAudioRecordPlayerPreviewBinding.inflate(ContextKt.getStreamThemeInflater(context), parentView, false);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return new AudioRecordAttachmentPreviewViewHolder(it, attachmentRemovalListener2, style2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J$\u0010\u0014\u001a\u00020\u0007*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u0007*\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/AudioRecordAttachmentPreviewFactory$AudioRecordAttachmentPreviewViewHolder;", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewViewHolder;", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiAudioRecordPlayerPreviewBinding;", "attachmentRemovalListener", "Lkotlin/Function1;", "Lio/getstream/chat/android/models/Attachment;", "", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/MessageComposerViewStyle;", "(Lio/getstream/chat/android/ui/databinding/StreamUiAudioRecordPlayerPreviewBinding;Lkotlin/jvm/functions/Function1;Lio/getstream/chat/android/ui/feature/messages/composer/MessageComposerViewStyle;)V", "attachment", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "bind", "unbind", "registerButtonsListeners", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AudioRecordPlayerView;", "audioPlayer", "Lio/getstream/chat/android/client/audio/AudioPlayer;", "hashCode", "", "registerStateChange", "playerView", "stream-chat-android-ui-components_release"})
    @SourceDebugExtension(value={"SMAP\nAudioRecordAttachmentPreviewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioRecordAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/AudioRecordAttachmentPreviewFactory$AudioRecordAttachmentPreviewViewHolder\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n303#2,4:178\n314#2,4:183\n1#3:182\n*S KotlinDebug\n*F\n+ 1 AudioRecordAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/AudioRecordAttachmentPreviewFactory$AudioRecordAttachmentPreviewViewHolder\n*L\n102#1:178,4\n111#1:183,4\n*E\n"})
    private static final class AudioRecordAttachmentPreviewViewHolder
    extends AttachmentPreviewViewHolder {
        @NotNull
        private final StreamUiAudioRecordPlayerPreviewBinding binding;
        @Nullable
        private final MessageComposerViewStyle style;
        @NotNull
        private final Lazy logger$delegate;
        @Nullable
        private Attachment attachment;

        public AudioRecordAttachmentPreviewViewHolder(@NotNull StreamUiAudioRecordPlayerPreviewBinding binding2, @NotNull Function1<? super Attachment, Unit> attachmentRemovalListener2, @Nullable MessageComposerViewStyle style2) {
            block0: {
                ViewStyle viewStyle;
                Intrinsics.checkNotNullParameter((Object)binding2, (String)"binding");
                Intrinsics.checkNotNullParameter(attachmentRemovalListener2, (String)"attachmentRemovalListener");
                FrameLayout frameLayout = binding2.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"getRoot(...)");
                super((View)frameLayout);
                this.binding = binding2;
                this.style = style2;
                this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"AttachRecordPreviewHolder");
                this.binding.removeButton.setOnClickListener(arg_0 -> AudioRecordAttachmentPreviewViewHolder._init_$lambda$1(this, attachmentRemovalListener2, arg_0));
                ViewStyle viewStyle2 = this.style;
                if (viewStyle2 == null || (viewStyle2 = viewStyle2.getAudioRecordPlayerViewStyle()) == null) break block0;
                ViewStyle it = viewStyle = viewStyle2;
                boolean bl = false;
                this.binding.playerView.setStyle((AudioRecordPlayerViewStyle)it);
            }
        }

        private final TaggedLogger getLogger() {
            Lazy lazy = this.logger$delegate;
            return (TaggedLogger)lazy.getValue();
        }

        @Override
        public void bind(@NotNull Attachment attachment) {
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            if (attachment.getUpload() == null) {
                return;
            }
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$d = false;
            if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.DEBUG;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[bind] attachment: " + attachment;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            AudioPlayer audioPlayer = ChatClient.Companion.instance().getAudioPlayer();
            AudioRecordPlayerView audioRecordPlayerView = this.binding.playerView;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)audioRecordPlayerView), (String)"playerView");
            AudioRecordPlayerView playerView = audioRecordPlayerView;
            this.attachment = attachment;
            Float f = AttachmentExtensionsKt.getDuration((Attachment)attachment);
            if (f != null) {
                Float f2 = f;
                DurationFormatter durationFormatter = DurationFormatter.INSTANCE;
                float p0 = ((Number)f2).floatValue();
                boolean bl = false;
                String string4 = durationFormatter.formatDurationInSeconds(p0);
                if (string4 != null) {
                    String duration = string4;
                    boolean bl2 = false;
                    TaggedLogger this_$iv2 = this.getLogger();
                    boolean $i$f$v = false;
                    if (this_$iv2.getValidator().isLoggable(Priority.VERBOSE, this_$iv2.getTag())) {
                        String string5 = this_$iv2.getTag();
                        Priority priority = Priority.VERBOSE;
                        StreamLogger streamLogger = this_$iv2.getDelegate();
                        boolean bl3 = false;
                        String string6 = "[bind] duration: " + duration;
                        StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string5, (String)string6, null, (int)8, null);
                    }
                    playerView.setDuration(duration);
                }
            }
            List list = AttachmentExtensionsKt.getWaveformData((Attachment)attachment);
            if (list != null) {
                List waveBars = list;
                boolean bl = false;
                playerView.setWaveBars(waveBars);
            }
            this.registerStateChange(audioPlayer, playerView, attachment.hashCode());
            this.registerButtonsListeners(playerView, audioPlayer, attachment, attachment.hashCode());
        }

        @Override
        public void unbind() {
            Attachment attachment = this.attachment;
            if (attachment == null) {
                return;
            }
            Attachment attachment2 = attachment;
            ChatClient.Companion.instance().getAudioPlayer().removeAudios(CollectionsKt.listOf((Object)attachment2.hashCode()));
        }

        private final void registerStateChange(AudioPlayer $this$registerStateChange, AudioRecordPlayerView playerView, int hashCode) {
            $this$registerStateChange.registerOnAudioStateChange(hashCode, (Function1)new Function1<AudioState, Unit>(playerView){
                final /* synthetic */ AudioRecordPlayerView $playerView;
                {
                    this.$playerView = $playerView;
                    super(1);
                }

                public final void invoke(@NotNull AudioState audioState) {
                    Intrinsics.checkNotNullParameter((Object)audioState, (String)"audioState");
                    switch (registerStateChange.WhenMappings.$EnumSwitchMapping$0[audioState.ordinal()]) {
                        case 1: {
                            this.$playerView.setLoading();
                            break;
                        }
                        case 2: {
                            this.$playerView.setPaused();
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.$playerView.setIdle();
                            break;
                        }
                        case 5: {
                            this.$playerView.setPlaying();
                        }
                    }
                }
            });
            $this$registerStateChange.registerOnProgressStateChange(hashCode, (Function1)new Function1<ProgressData, Unit>(playerView){
                final /* synthetic */ AudioRecordPlayerView $playerView;
                {
                    this.$playerView = $playerView;
                    super(1);
                }

                public final void invoke(@NotNull ProgressData progressData) {
                    Intrinsics.checkNotNullParameter((Object)progressData, (String)"<name for destructuring parameter 0>");
                    int duration = progressData.component1();
                    float progress = progressData.component2();
                    this.$playerView.setDuration(DurationFormatter.INSTANCE.formatDurationInMillis(duration));
                    this.$playerView.setProgress(progress);
                }
            });
            $this$registerStateChange.registerOnSpeedChange(hashCode, (Function1)new Function1<Float, Unit>((Object)playerView){

                public final void invoke(float p0) {
                    ((AudioRecordPlayerView)((Object)this.receiver)).setSpeedText(p0);
                }
            });
        }

        private final void registerButtonsListeners(AudioRecordPlayerView $this$registerButtonsListeners, AudioPlayer audioPlayer, Attachment attachment, int hashCode) {
            $this$registerButtonsListeners.setOnPlayButtonClickListener((Function0<Unit>)((Function0)new Function0<Unit>(attachment, $this$registerButtonsListeners, audioPlayer, hashCode, this){
                final /* synthetic */ Attachment $attachment;
                final /* synthetic */ AudioRecordPlayerView $this_registerButtonsListeners;
                final /* synthetic */ AudioPlayer $audioPlayer;
                final /* synthetic */ int $hashCode;
                final /* synthetic */ AudioRecordAttachmentPreviewViewHolder this$0;
                {
                    this.$attachment = $attachment;
                    this.$this_registerButtonsListeners = $receiver;
                    this.$audioPlayer = $audioPlayer;
                    this.$hashCode = $hashCode;
                    this.this$0 = $receiver2;
                    super(0);
                }

                public final void invoke() {
                    File audioFile;
                    File file = this.$attachment.getUpload();
                    if (file == null) {
                        AudioRecordPlayerView audioRecordPlayerView = this.$this_registerButtonsListeners;
                        AudioRecordAttachmentPreviewViewHolder audioRecordAttachmentPreviewViewHolder = this.this$0;
                        AudioRecordPlayerView $this$invoke_u24lambda_u241 = audioRecordPlayerView;
                        boolean bl = false;
                        TaggedLogger this_$iv = AudioRecordAttachmentPreviewViewHolder.access$getLogger(audioRecordAttachmentPreviewViewHolder);
                        boolean $i$f$w = false;
                        if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                            String string2 = this_$iv.getTag();
                            Priority priority = Priority.WARN;
                            StreamLogger streamLogger = this_$iv.getDelegate();
                            boolean bl2 = false;
                            String string3 = "[toggleRecordingPlayback] rejected (audioFile is null)";
                            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                        }
                        return;
                    }
                    File $this$toUri$iv = audioFile = file;
                    boolean $i$f$toUri = false;
                    String string4 = Uri.fromFile((File)$this$toUri$iv).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                    String fileUri = string4;
                    this.$audioPlayer.play(fileUri, this.$hashCode);
                }
            }));
            $this$registerButtonsListeners.setOnSpeedButtonClickListener((Function0<Unit>)((Function0)new Function0<Unit>(audioPlayer){
                final /* synthetic */ AudioPlayer $audioPlayer;
                {
                    this.$audioPlayer = $audioPlayer;
                    super(0);
                }

                public final void invoke() {
                    this.$audioPlayer.changeSpeed();
                }
            }));
            $this$registerButtonsListeners.setOnSeekbarMoveListeners((Function0<Unit>)((Function0)new Function0<Unit>(audioPlayer, attachment){
                final /* synthetic */ AudioPlayer $audioPlayer;
                final /* synthetic */ Attachment $attachment;
                {
                    this.$audioPlayer = $audioPlayer;
                    this.$attachment = $attachment;
                    super(0);
                }

                public final void invoke() {
                    this.$audioPlayer.startSeek(this.$attachment.hashCode());
                }
            }), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(audioPlayer, attachment){
                final /* synthetic */ AudioPlayer $audioPlayer;
                final /* synthetic */ Attachment $attachment;
                {
                    this.$audioPlayer = $audioPlayer;
                    this.$attachment = $attachment;
                    super(1);
                }

                public final void invoke(int progress) {
                    this.$audioPlayer.seekTo(AudioRecordAttachmentPreviewFactoryKt.access$progressToDecimal(progress, AttachmentExtensionsKt.getDuration((Attachment)this.$attachment)), this.$attachment.hashCode());
                }
            }));
        }

        private static final void _init_$lambda$1(AudioRecordAttachmentPreviewViewHolder this$0, Function1 $attachmentRemovalListener, View it) {
            block0: {
                Attachment attachment;
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$attachmentRemovalListener, (String)"$attachmentRemovalListener");
                Attachment attachment2 = this$0.attachment;
                if (attachment2 == null) break block0;
                Attachment it2 = attachment = attachment2;
                boolean bl = false;
                $attachmentRemovalListener.invoke((Object)it2);
            }
        }

        public static final /* synthetic */ TaggedLogger access$getLogger(AudioRecordAttachmentPreviewViewHolder $this) {
            return $this.getLogger();
        }
    }
}

