/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.common.utils.MediaStringUtil;
import io.getstream.chat.android.ui.databinding.StreamUiFileAttachmentPreviewBinding;
import io.getstream.chat.android.ui.feature.messages.composer.MessageComposerViewStyle;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.AttachmentPreviewViewHolder;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory.AttachmentPreviewFactory;
import io.getstream.chat.android.ui.utils.AttachmentUtilsKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.uiutils.extension.AttachmentKt;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/FileAttachmentPreviewFactory;", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/AttachmentPreviewFactory;", "()V", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "canHandle", "", "attachment", "Lio/getstream/chat/android/models/Attachment;", "onCreateViewHolder", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewViewHolder;", "parentView", "Landroid/view/ViewGroup;", "attachmentRemovalListener", "Lkotlin/Function1;", "", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/MessageComposerViewStyle;", "FileAttachmentPreviewHandler", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nFileAttachmentPreviewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/FileAttachmentPreviewFactory\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n292#2,4:98\n1#3:102\n*S KotlinDebug\n*F\n+ 1 FileAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/FileAttachmentPreviewFactory\n*L\n44#1:98,4\n*E\n"})
public final class FileAttachmentPreviewFactory
implements AttachmentPreviewFactory {
    @NotNull
    private final Lazy logger$delegate = StreamLogExtensionKt.taggedLogger((Object)this, (String)"AttachFilePreviewFactory");

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @Override
    public boolean canHandle(@NotNull Attachment attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        TaggedLogger this_$iv = this.getLogger();
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[canHandle] isAnyFileType: " + AttachmentKt.isAnyFileType((Attachment)attachment) + "; " + attachment;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        return AttachmentKt.isAnyFileType((Attachment)attachment);
    }

    @Override
    @NotNull
    public AttachmentPreviewViewHolder onCreateViewHolder(@NotNull ViewGroup parentView, @NotNull Function1<? super Attachment, Unit> attachmentRemovalListener2, @Nullable MessageComposerViewStyle style2) {
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        Intrinsics.checkNotNullParameter(attachmentRemovalListener2, (String)"attachmentRemovalListener");
        Context context = parentView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        StreamUiFileAttachmentPreviewBinding it = StreamUiFileAttachmentPreviewBinding.inflate(ContextKt.getStreamThemeInflater(context), parentView, false);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return new FileAttachmentPreviewHandler(it, attachmentRemovalListener2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\t\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/FileAttachmentPreviewFactory$FileAttachmentPreviewHandler;", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewViewHolder;", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiFileAttachmentPreviewBinding;", "attachmentRemovalListener", "Lkotlin/Function1;", "Lio/getstream/chat/android/models/Attachment;", "", "(Lio/getstream/chat/android/ui/databinding/StreamUiFileAttachmentPreviewBinding;Lkotlin/jvm/functions/Function1;)V", "attachment", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "bind", "stream-chat-android-ui-components_release"})
    @SourceDebugExtension(value={"SMAP\nFileAttachmentPreviewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/FileAttachmentPreviewFactory$FileAttachmentPreviewHandler\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n*L\n1#1,97:1\n314#2,4:98\n*S KotlinDebug\n*F\n+ 1 FileAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/FileAttachmentPreviewFactory$FileAttachmentPreviewHandler\n*L\n88#1:98,4\n*E\n"})
    private static final class FileAttachmentPreviewHandler
    extends AttachmentPreviewViewHolder {
        @NotNull
        private final StreamUiFileAttachmentPreviewBinding binding;
        @NotNull
        private final Lazy logger$delegate;
        private Attachment attachment;

        public FileAttachmentPreviewHandler(@NotNull StreamUiFileAttachmentPreviewBinding binding2, @NotNull Function1<? super Attachment, Unit> attachmentRemovalListener2) {
            Intrinsics.checkNotNullParameter((Object)binding2, (String)"binding");
            Intrinsics.checkNotNullParameter(attachmentRemovalListener2, (String)"attachmentRemovalListener");
            ConstraintLayout constraintLayout = binding2.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
            super((View)constraintLayout);
            this.binding = binding2;
            this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"AttachFilePreviewHolder");
            this.binding.removeButton.setOnClickListener(arg_0 -> FileAttachmentPreviewHandler._init_$lambda$0(attachmentRemovalListener2, this, arg_0));
        }

        private final TaggedLogger getLogger() {
            Lazy lazy = this.logger$delegate;
            return (TaggedLogger)lazy.getValue();
        }

        @Override
        public void bind(@NotNull Attachment attachment) {
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$v = false;
            if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.VERBOSE;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[bind] isAnyFileType: " + AttachmentKt.isAnyFileType((Attachment)attachment) + "; " + attachment;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            this.attachment = attachment;
            this.binding.fileNameTextView.setText((CharSequence)attachment.getTitle());
            ImageView imageView = this.binding.fileThumbImageView;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"fileThumbImageView");
            AttachmentUtilsKt.loadAttachmentThumb(imageView, attachment);
            this.binding.fileSizeTextView.setText((CharSequence)MediaStringUtil.convertFileSizeByteCount((long)attachment.getFileSize()));
        }

        private static final void _init_$lambda$0(Function1 $attachmentRemovalListener, FileAttachmentPreviewHandler this$0, View it) {
            Intrinsics.checkNotNullParameter((Object)$attachmentRemovalListener, (String)"$attachmentRemovalListener");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Attachment attachment = this$0.attachment;
            if (attachment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                attachment = null;
            }
            $attachmentRemovalListener.invoke((Object)attachment);
        }
    }
}

