/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.google.android.material.imageview.ShapeableImageView;
import com.google.android.material.shape.ShapeAppearanceModel;
import io.getstream.chat.android.client.utils.attachment.AttachmentUtilsKt;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.databinding.StreamUiMediaAttachmentPreviewBinding;
import io.getstream.chat.android.ui.feature.messages.composer.MessageComposerViewStyle;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.AttachmentPreviewViewHolder;
import io.getstream.chat.android.ui.feature.messages.composer.attachment.preview.factory.AttachmentPreviewFactory;
import io.getstream.chat.android.ui.utils.ImageUtilsKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.DrawableKt;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.io.File;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/MediaAttachmentPreviewFactory;", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/AttachmentPreviewFactory;", "()V", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "canHandle", "", "attachment", "Lio/getstream/chat/android/models/Attachment;", "onCreateViewHolder", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewViewHolder;", "parentView", "Landroid/view/ViewGroup;", "attachmentRemovalListener", "Lkotlin/Function1;", "", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/MessageComposerViewStyle;", "MediaAttachmentPreviewViewHolder", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nMediaAttachmentPreviewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/MediaAttachmentPreviewFactory\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n*L\n1#1,163:1\n292#2,4:164\n*S KotlinDebug\n*F\n+ 1 MediaAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/MediaAttachmentPreviewFactory\n*L\n50#1:164,4\n*E\n"})
public final class MediaAttachmentPreviewFactory
implements AttachmentPreviewFactory {
    @NotNull
    private final Lazy logger$delegate = StreamLogExtensionKt.taggedLogger((Object)this, (String)"AttachMediaPreviewFactory");

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @Override
    public boolean canHandle(@NotNull Attachment attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        TaggedLogger this_$iv = this.getLogger();
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[canHandle] isImage: " + AttachmentUtilsKt.isImage((Attachment)attachment) + ", isVideo: " + AttachmentUtilsKt.isVideo((Attachment)attachment) + "; " + attachment;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        return AttachmentUtilsKt.isImage((Attachment)attachment) || AttachmentUtilsKt.isVideo((Attachment)attachment);
    }

    @Override
    @NotNull
    public AttachmentPreviewViewHolder onCreateViewHolder(@NotNull ViewGroup parentView, @NotNull Function1<? super Attachment, Unit> attachmentRemovalListener2, @Nullable MessageComposerViewStyle style2) {
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        Intrinsics.checkNotNullParameter(attachmentRemovalListener2, (String)"attachmentRemovalListener");
        Context context = parentView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        StreamUiMediaAttachmentPreviewBinding binding2 = StreamUiMediaAttachmentPreviewBinding.inflate(ContextKt.getStreamThemeInflater(context), parentView, false);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)binding2);
        return new MediaAttachmentPreviewViewHolder(binding2, attachmentRemovalListener2, style2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0002J\b\u0010\u0014\u001a\u00020\u0007H\u0002R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/MediaAttachmentPreviewFactory$MediaAttachmentPreviewViewHolder;", "Lio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/AttachmentPreviewViewHolder;", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiMediaAttachmentPreviewBinding;", "attachmentRemovalListener", "Lkotlin/Function1;", "Lio/getstream/chat/android/models/Attachment;", "", "style", "Lio/getstream/chat/android/ui/feature/messages/composer/MessageComposerViewStyle;", "(Lio/getstream/chat/android/ui/databinding/StreamUiMediaAttachmentPreviewBinding;Lkotlin/jvm/functions/Function1;Lio/getstream/chat/android/ui/feature/messages/composer/MessageComposerViewStyle;)V", "attachment", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "bind", "setupIconCard", "setupIconImageView", "stream-chat-android-ui-components_release"})
    @SourceDebugExtension(value={"SMAP\nMediaAttachmentPreviewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/MediaAttachmentPreviewFactory$MediaAttachmentPreviewViewHolder\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 3 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,163:1\n314#2,4:164\n262#3,2:168\n*S KotlinDebug\n*F\n+ 1 MediaAttachmentPreviewFactory.kt\nio/getstream/chat/android/ui/feature/messages/composer/attachment/preview/factory/MediaAttachmentPreviewFactory$MediaAttachmentPreviewViewHolder\n*L\n149#1:164,4\n153#1:168,2\n*E\n"})
    private static final class MediaAttachmentPreviewViewHolder
    extends AttachmentPreviewViewHolder {
        @NotNull
        private final StreamUiMediaAttachmentPreviewBinding binding;
        @Nullable
        private final MessageComposerViewStyle style;
        @NotNull
        private final Lazy logger$delegate;
        private Attachment attachment;

        public MediaAttachmentPreviewViewHolder(@NotNull StreamUiMediaAttachmentPreviewBinding binding2, @NotNull Function1<? super Attachment, Unit> attachmentRemovalListener2, @Nullable MessageComposerViewStyle style2) {
            Intrinsics.checkNotNullParameter((Object)binding2, (String)"binding");
            Intrinsics.checkNotNullParameter(attachmentRemovalListener2, (String)"attachmentRemovalListener");
            ConstraintLayout constraintLayout = binding2.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
            super((View)constraintLayout);
            this.binding = binding2;
            this.style = style2;
            this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"AttachMediaPreviewHolder");
            float cornerRadius = ContextKt.getDimension(this.getContext(), R.dimen.stream_ui_selected_attachment_corner_radius);
            this.binding.thumbImageView.setShapeAppearanceModel(ShapeAppearanceModel.builder().setAllCornerSizes(cornerRadius).build());
            this.binding.removeButton.setOnClickListener(arg_0 -> MediaAttachmentPreviewViewHolder._init_$lambda$0(attachmentRemovalListener2, this, arg_0));
            this.setupIconImageView();
            this.setupIconCard();
        }

        private final TaggedLogger getLogger() {
            Lazy lazy = this.logger$delegate;
            return (TaggedLogger)lazy.getValue();
        }

        private final void setupIconImageView() {
            if (this.style != null) {
                ImageView $this$setupIconImageView_u24lambda_u241 = this.binding.playIconImageView;
                boolean bl = false;
                Drawable iconDrawable = DrawableKt.applyTint(this.style.getMessageInputVideoAttachmentIconDrawable(), this.style.getMessageInputVideoAttachmentIconDrawableTint());
                $this$setupIconImageView_u24lambda_u241.setImageDrawable(iconDrawable);
                $this$setupIconImageView_u24lambda_u241.setPaddingRelative(this.style.getMessageInputVideoAttachmentIconDrawablePaddingStart(), this.style.getMessageInputVideoAttachmentIconDrawablePaddingTop(), this.style.getMessageInputVideoAttachmentIconDrawablePaddingEnd(), this.style.getMessageInputVideoAttachmentIconDrawablePaddingBottom());
            }
        }

        private final void setupIconCard() {
            if (this.style != null) {
                CardView $this$setupIconCard_u24lambda_u243 = this.binding.playIconCardView;
                boolean bl = false;
                Integer n = this.style.getMessageInputVideoAttachmentIconBackgroundColor();
                if (n != null) {
                    Integer n2 = n;
                    int backgroundColor = ((Number)n2).intValue();
                    boolean bl2 = false;
                    $this$setupIconCard_u24lambda_u243.setCardBackgroundColor(backgroundColor);
                }
                $this$setupIconCard_u24lambda_u243.setElevation(this.style.getMessageInputVideoAttachmentIconElevation());
                $this$setupIconCard_u24lambda_u243.setRadius(this.style.getMessageInputVideoAttachmentIconCornerRadius());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void bind(@NotNull Attachment attachment) {
            void $this$isVisible$iv;
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$v22 = false;
            if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.VERBOSE;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[bind] isImage: " + AttachmentUtilsKt.isImage((Attachment)attachment) + ", isVideo: " + AttachmentUtilsKt.isVideo((Attachment)attachment) + "; " + attachment;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            this.attachment = attachment;
            File upload = attachment.getUpload();
            CardView cardView = this.binding.playIconCardView;
            Intrinsics.checkNotNullExpressionValue((Object)cardView, (String)"playIconCardView");
            View $i$f$v22 = (View)cardView;
            boolean value$iv = AttachmentUtilsKt.isVideo((Attachment)attachment);
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
            if (upload != null) {
                ShapeableImageView shapeableImageView = this.binding.thumbImageView;
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView, (String)"thumbImageView");
                ImageUtilsKt.load$default((ImageView)shapeableImageView, (Object)upload, null, null, null, null, 30, null);
            } else {
                ShapeableImageView shapeableImageView = this.binding.thumbImageView;
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView, (String)"thumbImageView");
                io.getstream.chat.android.ui.utils.AttachmentUtilsKt.loadAttachmentThumb((ImageView)shapeableImageView, attachment);
            }
        }

        private static final void _init_$lambda$0(Function1 $attachmentRemovalListener, MediaAttachmentPreviewViewHolder this$0, View it) {
            Intrinsics.checkNotNullParameter((Object)$attachmentRemovalListener, (String)"$attachmentRemovalListener");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Attachment attachment = this$0.attachment;
            if (attachment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                attachment = null;
            }
            $attachmentRemovalListener.invoke((Object)attachment);
        }
    }
}

