/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.composer.internal;

import android.content.Context;
import android.view.View;
import com.google.android.material.snackbar.BaseTransientBottomBar;
import com.google.android.material.snackbar.Snackbar;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.common.state.messages.composer.ValidationError;
import io.getstream.chat.android.ui.common.utils.MediaStringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/getstream/chat/android/ui/feature/messages/composer/internal/ValidationErrorRenderer;", "Lcom/google/android/material/snackbar/BaseTransientBottomBar$BaseCallback;", "Lcom/google/android/material/snackbar/Snackbar;", "context", "Landroid/content/Context;", "view", "Landroid/view/View;", "(Landroid/content/Context;Landroid/view/View;)V", "currentlyVisibleSnackbar", "previousValidationError", "Lio/getstream/chat/android/ui/common/state/messages/composer/ValidationError;", "dismissValidationErrors", "", "onDismissed", "snackbar", "event", "", "onShown", "renderValidationErrors", "validationErrors", "", "stream-chat-android-ui-components_release"})
public final class ValidationErrorRenderer
extends BaseTransientBottomBar.BaseCallback<Snackbar> {
    @NotNull
    private final Context context;
    @NotNull
    private final View view;
    @Nullable
    private ValidationError previousValidationError;
    @Nullable
    private Snackbar currentlyVisibleSnackbar;

    public ValidationErrorRenderer(@NotNull Context context, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.context = context;
        this.view = view;
    }

    public final void renderValidationErrors(@NotNull List<? extends ValidationError> validationErrors) {
        Intrinsics.checkNotNullParameter(validationErrors, (String)"validationErrors");
        if (validationErrors.isEmpty()) {
            this.dismissValidationErrors();
            return;
        }
        ValidationError currentValidationError = (ValidationError)CollectionsKt.firstOrNull(validationErrors);
        if (this.currentlyVisibleSnackbar == null && currentValidationError != null && !Intrinsics.areEqual((Object)currentValidationError, (Object)this.previousValidationError)) {
            String string2;
            Object[] objectArray;
            ValidationError validationError = currentValidationError;
            if (validationError instanceof ValidationError.MessageLengthExceeded) {
                objectArray = new Object[]{((ValidationError.MessageLengthExceeded)currentValidationError).getMaxMessageLength()};
                string2 = this.context.getString(R.string.stream_ui_message_composer_error_message_length, objectArray);
            } else if (validationError instanceof ValidationError.AttachmentCountExceeded) {
                objectArray = new Object[]{((ValidationError.AttachmentCountExceeded)currentValidationError).getMaxAttachmentCount()};
                string2 = this.context.getString(R.string.stream_ui_message_composer_error_attachment_count, objectArray);
            } else if (validationError instanceof ValidationError.AttachmentSizeExceeded) {
                objectArray = new Object[]{MediaStringUtil.convertFileSizeByteCount((long)((ValidationError.AttachmentSizeExceeded)currentValidationError).getMaxAttachmentSize())};
                string2 = this.context.getString(R.string.stream_ui_message_composer_error_file_size, objectArray);
            } else if (validationError instanceof ValidationError.ContainsLinksWhenNotAllowed) {
                string2 = this.context.getString(R.string.stream_ui_message_composer_sending_links_not_allowed);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String string3 = string2;
            Intrinsics.checkNotNull((Object)string3);
            String errorMessage = string3;
            String $this$renderValidationErrors_u24lambda_u241 = string3 = Snackbar.make((View)this.view, (CharSequence)errorMessage, (int)-2);
            boolean bl = false;
            $this$renderValidationErrors_u24lambda_u241.setAnchorView(this.view);
            $this$renderValidationErrors_u24lambda_u241.addCallback((BaseTransientBottomBar.BaseCallback)this);
            $this$renderValidationErrors_u24lambda_u241.setAction(R.string.stream_ui_ok, arg_0 -> ValidationErrorRenderer.renderValidationErrors$lambda$1$lambda$0((Snackbar)$this$renderValidationErrors_u24lambda_u241, arg_0));
            string3.show();
        }
        this.previousValidationError = currentValidationError;
    }

    public final void dismissValidationErrors() {
        block0: {
            Snackbar snackbar = this.currentlyVisibleSnackbar;
            if (snackbar == null) break block0;
            snackbar.dismiss();
        }
    }

    public void onShown(@Nullable Snackbar snackbar) {
        super.onShown((Object)snackbar);
        this.currentlyVisibleSnackbar = snackbar;
    }

    public void onDismissed(@Nullable Snackbar snackbar, int event) {
        super.onDismissed((Object)snackbar, event);
        this.currentlyVisibleSnackbar = null;
    }

    private static final void renderValidationErrors$lambda$1$lambda$0(Snackbar $this_apply, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        $this_apply.dismiss();
    }
}

