/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\nJ \u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J \u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/EndlessMessageListScrollListener;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "loadMoreThreshold", "", "loadMoreAtTopListener", "Lkotlin/Function0;", "", "loadMoreAtBottomListener", "(ILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "paginationEnabled", "", "scrollStateReset", "shouldFetchBottomMessages", "disablePagination", "enablePagination", "fetchAtBottom", "shouldFetch", "handleScroll", "dy", "layoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "handleScrollDown", "handleScrollUp", "onScrollStateChanged", "newState", "onScrolled", "dx", "Companion", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nEndlessMessageListScrollListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndlessMessageListScrollListener.kt\nio/getstream/chat/android/ui/feature/messages/list/EndlessMessageListScrollListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class EndlessMessageListScrollListener
extends RecyclerView.OnScrollListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int loadMoreThreshold;
    @NotNull
    private final Function0<Unit> loadMoreAtTopListener;
    @NotNull
    private final Function0<Unit> loadMoreAtBottomListener;
    private boolean paginationEnabled;
    private boolean shouldFetchBottomMessages;
    private boolean scrollStateReset;
    @NotNull
    private static final String TAG = "Chat:EndlessMessageScroll";
    private static final boolean DEBUG = false;

    public EndlessMessageListScrollListener(int loadMoreThreshold, @NotNull Function0<Unit> loadMoreAtTopListener, @NotNull Function0<Unit> loadMoreAtBottomListener) {
        Intrinsics.checkNotNullParameter(loadMoreAtTopListener, (String)"loadMoreAtTopListener");
        Intrinsics.checkNotNullParameter(loadMoreAtBottomListener, (String)"loadMoreAtBottomListener");
        this.loadMoreThreshold = loadMoreThreshold;
        this.loadMoreAtTopListener = loadMoreAtTopListener;
        this.loadMoreAtBottomListener = loadMoreAtBottomListener;
        if (!(this.loadMoreThreshold >= 0)) {
            boolean bl = false;
            String string2 = "Load more threshold must not be negative";
            throw new IllegalArgumentException(string2.toString());
        }
        this.scrollStateReset = true;
    }

    public final void fetchAtBottom(boolean shouldFetch) {
        this.shouldFetchBottomMessages = shouldFetch;
    }

    public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        if (!this.paginationEnabled) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (!(layoutManager instanceof LinearLayoutManager)) {
            throw new IllegalStateException("EndlessScrollListener supports only LinearLayoutManager");
        }
        this.handleScroll(dy, (LinearLayoutManager)layoutManager, recyclerView);
    }

    private final void handleScroll(int dy, LinearLayoutManager layoutManager, RecyclerView recyclerView) {
        if (!this.paginationEnabled) {
            return;
        }
        if (dy >= 0 && this.shouldFetchBottomMessages) {
            this.handleScrollDown(layoutManager, recyclerView);
        } else if (dy < 0) {
            this.handleScrollUp(layoutManager, recyclerView);
        }
    }

    private final void handleScrollDown(LinearLayoutManager layoutManager, RecyclerView recyclerView) {
        int lastVisiblePosition = layoutManager.findLastVisibleItemPosition();
        RecyclerView.Adapter adapter2 = recyclerView.getAdapter();
        int total = adapter2 != null ? adapter2.getItemCount() : 0;
        if (this.scrollStateReset && lastVisiblePosition > total - this.loadMoreThreshold) {
            this.scrollStateReset = false;
            recyclerView.post(() -> EndlessMessageListScrollListener.handleScrollDown$lambda$2(this.loadMoreAtBottomListener));
        }
    }

    private final void handleScrollUp(LinearLayoutManager layoutManager, RecyclerView recyclerView) {
        int firstVisiblePosition = layoutManager.findFirstVisibleItemPosition();
        if (this.scrollStateReset && firstVisiblePosition <= this.loadMoreThreshold) {
            this.scrollStateReset = false;
            recyclerView.post(() -> EndlessMessageListScrollListener.handleScrollUp$lambda$3(this.loadMoreAtTopListener));
        }
    }

    public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        switch (newState) {
            case 0: 
            case 1: {
                this.scrollStateReset = true;
            }
        }
    }

    public final void enablePagination() {
        this.paginationEnabled = true;
    }

    public final void disablePagination() {
        this.paginationEnabled = false;
    }

    private static final void handleScrollDown$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void handleScrollUp$lambda$3(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/EndlessMessageListScrollListener$Companion;", "", "()V", "DEBUG", "", "TAG", "", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

