/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.adapter.internal;

import io.getstream.chat.android.client.utils.attachment.AttachmentUtilsKt;
import io.getstream.chat.android.client.utils.message.MessageUtils;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.ui.feature.messages.list.adapter.MessageListItem;
import io.getstream.chat.android.ui.feature.messages.list.adapter.viewholder.attachment.AttachmentFactoryManager;
import io.getstream.chat.android.uiutils.extension.AttachmentKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/internal/MessageListItemViewTypeMapper;", "", "()V", "getViewTypeValue", "", "messageListItem", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/MessageListItem;", "attachmentFactoryManager", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/viewholder/attachment/AttachmentFactoryManager;", "messageItemToViewType", "messageItem", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/MessageListItem$MessageItem;", "containsOnlyLinkAttachments", "", "Lio/getstream/chat/android/models/Message;", "isMediaAttachment", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nMessageListItemViewTypeMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageListItemViewTypeMapper.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/internal/MessageListItemViewTypeMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n3190#2,10:122\n1747#2,3:132\n1726#2,3:135\n2624#2,3:138\n1726#2,3:141\n*S KotlinDebug\n*F\n+ 1 MessageListItemViewTypeMapper.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/internal/MessageListItemViewTypeMapper\n*L\n81#1:122,10\n82#1:132,3\n108#1:135,3\n109#1:138,3\n118#1:141,3\n*E\n"})
public final class MessageListItemViewTypeMapper {
    @NotNull
    public static final MessageListItemViewTypeMapper INSTANCE = new MessageListItemViewTypeMapper();

    private MessageListItemViewTypeMapper() {
    }

    public final int getViewTypeValue(@NotNull MessageListItem messageListItem, @NotNull AttachmentFactoryManager attachmentFactoryManager2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)messageListItem, (String)"messageListItem");
        Intrinsics.checkNotNullParameter((Object)attachmentFactoryManager2, (String)"attachmentFactoryManager");
        MessageListItem messageListItem2 = messageListItem;
        if (messageListItem2 instanceof MessageListItem.DateSeparatorItem) {
            n = 1001;
        } else if (messageListItem2 instanceof MessageListItem.LoadingMoreIndicatorItem) {
            n = 1005;
        } else if (messageListItem2 instanceof MessageListItem.ThreadSeparatorItem) {
            n = 1006;
        } else if (messageListItem2 instanceof MessageListItem.MessageItem) {
            n = this.messageItemToViewType((MessageListItem.MessageItem)messageListItem, attachmentFactoryManager2);
        } else if (messageListItem2 instanceof MessageListItem.TypingItem) {
            n = 1007;
        } else if (messageListItem2 instanceof MessageListItem.ThreadPlaceholderItem) {
            n = 1011;
        } else if (messageListItem2 instanceof MessageListItem.UnreadSeparatorItem) {
            n = 1016;
        } else if (messageListItem2 instanceof MessageListItem.StartOfTheChannelItem) {
            n = 1017;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final int messageItemToViewType(MessageListItem.MessageItem messageItem2, AttachmentFactoryManager attachmentFactoryManager2) {
        boolean bl;
        Message message;
        block5: {
            message = messageItem2.getMessage();
            Iterable $this$partition$iv = message.getAttachments();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                Attachment attachment = (Attachment)element$iv;
                boolean bl2 = false;
                if (AttachmentKt.hasLink((Attachment)attachment)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            List linksAndGiphy = (List)new Pair(first$iv, second$iv).component1();
            Iterable $this$any$iv = linksAndGiphy;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Attachment p0 = (Attachment)element$iv;
                    boolean bl3 = false;
                    if (!AttachmentUtilsKt.isGiphy((Attachment)p0)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean containsGiphy = bl;
        boolean hasAttachments = !((Collection)message.getAttachments()).isEmpty();
        boolean containsOnlyLinks = this.containsOnlyLinkAttachments(message);
        return MessageUtils.isDeleted((Message)message) ? 1002 : (MessageUtils.isError((Message)message) && !MessageUtils.isModerationBounce((Message)message) ? 1010 : (MessageUtils.isSystem((Message)message) ? 1009 : (MessageUtils.isGiphyEphemeral((Message)message) ? 1008 : (hasAttachments ? (attachmentFactoryManager2.canHandle(message) ? 1004 : (containsGiphy ? 1012 : (containsOnlyLinks ? 1015 : (this.isMediaAttachment(message) ? 1013 : 1014)))) : 1003))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMediaAttachment(Message $this$isMediaAttachment) {
        boolean bl;
        Attachment it;
        boolean bl2;
        if (((Collection)$this$isMediaAttachment.getAttachments()).isEmpty()) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        Iterable $this$all$iv = $this$isMediaAttachment.getAttachments();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                it = (Attachment)element$iv;
                boolean bl4 = false;
                if (!(AttachmentUtilsKt.isImage((Attachment)it) || AttachmentUtilsKt.isVideo((Attachment)it) || AttachmentKt.hasLink((Attachment)it))) {
                    if (!AttachmentUtilsKt.isAudioRecording((Attachment)it)) return false;
                }
                boolean bl5 = true;
                if (bl5) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        Iterable $this$none$iv = $this$isMediaAttachment.getAttachments();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (Attachment)element$iv;
            boolean bl6 = false;
            if (AttachmentKt.isUploading((Attachment)it)) return false;
            if (AttachmentKt.isFailed((Attachment)it)) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    private final boolean containsOnlyLinkAttachments(Message $this$containsOnlyLinkAttachments) {
        boolean bl;
        block4: {
            if ($this$containsOnlyLinkAttachments.getAttachments().isEmpty()) {
                return false;
            }
            Iterable $this$all$iv = $this$containsOnlyLinkAttachments.getAttachments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Attachment attachment = (Attachment)element$iv;
                    boolean bl2 = false;
                    if (AttachmentKt.hasLink((Attachment)attachment)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }
}

