/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.adapter.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.extensions.AttachmentExtensionsKt;
import io.getstream.chat.android.client.utils.attachment.AttachmentUtilsKt;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.ui.ChatUI;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.common.utils.DurationFormatter;
import io.getstream.chat.android.ui.common.utils.extensions.MessageKt;
import io.getstream.chat.android.ui.databinding.StreamUiMessageReplyViewBinding;
import io.getstream.chat.android.ui.feature.messages.list.MessageReplyStyle;
import io.getstream.chat.android.ui.feature.messages.list.adapter.viewholder.attachment.QuotedAttachmentFactoryManager;
import io.getstream.chat.android.ui.feature.messages.list.background.ShapeAppearanceModelFactory;
import io.getstream.chat.android.ui.font.TextStyle;
import io.getstream.chat.android.ui.utils.MessageEllipsizeKt;
import io.getstream.chat.android.ui.utils.extensions.ConstraintLayoutKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.IntKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import io.getstream.chat.android.ui.widgets.avatar.UserAvatarView;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\r\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J \u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\"\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\"\u0010 \u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/MessageReplyView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiMessageReplyViewBinding;", "ellipsize", "", "configureLinkTextStyle", "", "isMine", "style", "Lio/getstream/chat/android/ui/feature/messages/list/MessageReplyStyle;", "", "text", "init", "isLink", "message", "Lio/getstream/chat/android/models/Message;", "setAdditionalInfo", "setAttachmentImage", "setAvatarPosition", "setMessage", "setReplyBackground", "quotedMessage", "setReplyText", "setUserAvatar", "Companion", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nMessageReplyView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageReplyView.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/view/MessageReplyView\n+ 2 TypedArray.kt\nio/getstream/chat/android/ui/utils/extensions/TypedArrayKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n65#2,6:266\n262#3,2:272\n329#3,4:274\n329#3,4:278\n262#3,2:283\n262#3,2:285\n262#3,2:290\n262#3,2:294\n1#4:282\n1747#5,3:287\n223#5,2:292\n*S KotlinDebug\n*F\n+ 1 MessageReplyView.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/view/MessageReplyView\n*L\n72#1:266,6\n93#1:272,2\n104#1:274,4\n115#1:278,4\n188#1:283,2\n191#1:285,2\n197#1:290,2\n207#1:294,2\n196#1:287,3\n202#1:292,2\n*E\n"})
public final class MessageReplyView
extends FrameLayout {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final StreamUiMessageReplyViewBinding binding;
    private boolean ellipsize;
    private static final float DEFAULT_STROKE_WIDTH = IntKt.dpToPxPrecise(1);
    private static final float REPLY_CORNER_RADIUS = IntKt.dpToPxPrecise(12);
    private static final int CONTENT_MARGIN = IntKt.dpToPx(4);
    private static final int MAX_ELLIPSIZE_CHAR_COUNT = 170;

    public MessageReplyView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context));
        StreamUiMessageReplyViewBinding streamUiMessageReplyViewBinding = StreamUiMessageReplyViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiMessageReplyViewBinding, (String)"inflate(...)");
        this.binding = streamUiMessageReplyViewBinding;
        this.init(context, null);
    }

    public MessageReplyView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs);
        StreamUiMessageReplyViewBinding streamUiMessageReplyViewBinding = StreamUiMessageReplyViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiMessageReplyViewBinding, (String)"inflate(...)");
        this.binding = streamUiMessageReplyViewBinding;
        this.init(context, attrs);
    }

    public MessageReplyView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr);
        StreamUiMessageReplyViewBinding streamUiMessageReplyViewBinding = StreamUiMessageReplyViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiMessageReplyViewBinding, (String)"inflate(...)");
        this.binding = streamUiMessageReplyViewBinding;
        this.init(context, attrs);
    }

    private final void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MessageReplyView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray it = $this$use$iv;
        boolean bl = false;
        this.ellipsize = it.getBoolean(R.styleable.MessageReplyView_streamUiEllipsize, true);
        $this$use$iv.recycle();
    }

    public final void setMessage(@NotNull Message message, boolean isMine, @Nullable MessageReplyStyle style2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.setUserAvatar(message);
        this.setAvatarPosition(MessageKt.isMine((Message)message, (User)ChatClient.Companion.instance().getCurrentUser()));
        this.setReplyBackground(message, isMine, style2);
        this.setAttachmentImage(message);
        this.setAdditionalInfo(message);
        this.setReplyText(message, isMine, style2);
    }

    /*
     * WARNING - void declaration
     */
    private final void setUserAvatar(Message message) {
        void $this$isVisible$iv;
        UserAvatarView userAvatarView = this.binding.replyAvatarView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)userAvatarView), (String)"replyAvatarView");
        UserAvatarView.setUser$default(userAvatarView, message.getUser(), false, 2, null);
        UserAvatarView userAvatarView2 = this.binding.replyAvatarView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)userAvatarView2), (String)"replyAvatarView");
        View view = (View)userAvatarView2;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
    }

    private final void setAvatarPosition(boolean isMine) {
        StreamUiMessageReplyViewBinding $this$setAvatarPosition_u24lambda_u243 = this.binding;
        boolean bl = false;
        ConstraintLayout constraintLayout = $this$setAvatarPosition_u24lambda_u243.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
        ConstraintLayoutKt.updateConstraints(constraintLayout, (Function1<? super ConstraintSet, Unit>)((Function1)new Function1<ConstraintSet, Unit>($this$setAvatarPosition_u24lambda_u243){
            final /* synthetic */ StreamUiMessageReplyViewBinding $this_with;
            {
                this.$this_with = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ConstraintSet $this$updateConstraints) {
                Intrinsics.checkNotNullParameter((Object)$this$updateConstraints, (String)"$this$updateConstraints");
                $this$updateConstraints.clear(this.$this_with.replyAvatarView.getId(), 6);
                $this$updateConstraints.clear(this.$this_with.replyAvatarView.getId(), 7);
                $this$updateConstraints.clear(this.$this_with.replyContainer.getId(), 6);
                $this$updateConstraints.clear(this.$this_with.replyContainer.getId(), 7);
            }
        }));
        UserAvatarView userAvatarView = $this$setAvatarPosition_u24lambda_u243.replyAvatarView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)userAvatarView), (String)"replyAvatarView");
        View $this$updateLayoutParams$iv = (View)userAvatarView;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
        ConstraintLayout.LayoutParams $this$setAvatarPosition_u24lambda_u243_u24lambda_u241 = (ConstraintLayout.LayoutParams)params$iv;
        boolean bl2 = false;
        if (isMine) {
            $this$setAvatarPosition_u24lambda_u243_u24lambda_u241.endToEnd = 0;
            $this$setAvatarPosition_u24lambda_u243_u24lambda_u241.startToEnd = $this$setAvatarPosition_u24lambda_u243.replyContainer.getId();
        } else {
            $this$setAvatarPosition_u24lambda_u243_u24lambda_u241.startToStart = 0;
            $this$setAvatarPosition_u24lambda_u243_u24lambda_u241.endToStart = $this$setAvatarPosition_u24lambda_u243.replyContainer.getId();
        }
        $this$setAvatarPosition_u24lambda_u243_u24lambda_u241.setMarginStart(CONTENT_MARGIN);
        $this$setAvatarPosition_u24lambda_u243_u24lambda_u241.setMarginEnd(CONTENT_MARGIN);
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        ConstraintLayout constraintLayout2 = $this$setAvatarPosition_u24lambda_u243.replyContainer;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"replyContainer");
        $this$updateLayoutParams$iv = (View)constraintLayout2;
        $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams2 = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams2);
        ConstraintLayout.LayoutParams $this$setAvatarPosition_u24lambda_u243_u24lambda_u242 = (ConstraintLayout.LayoutParams)params$iv;
        boolean bl3 = false;
        if (isMine) {
            $this$setAvatarPosition_u24lambda_u243_u24lambda_u242.startToStart = 0;
            $this$setAvatarPosition_u24lambda_u243_u24lambda_u242.endToStart = $this$setAvatarPosition_u24lambda_u243.replyAvatarView.getId();
        } else {
            $this$setAvatarPosition_u24lambda_u243_u24lambda_u242.startToEnd = $this$setAvatarPosition_u24lambda_u243.replyAvatarView.getId();
            $this$setAvatarPosition_u24lambda_u243_u24lambda_u242.endToEnd = 0;
        }
        $this$setAvatarPosition_u24lambda_u243_u24lambda_u242.setMarginStart(CONTENT_MARGIN);
        $this$setAvatarPosition_u24lambda_u243_u24lambda_u242.setMarginEnd(CONTENT_MARGIN);
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void setReplyBackground(Message quotedMessage, boolean isMine, MessageReplyStyle style2) {
        void $this$setReplyBackground_u24lambda_u244;
        MaterialShapeDrawable materialShapeDrawable;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModelFactory.INSTANCE.create(context, REPLY_CORNER_RADIUS, 0.0f, MessageKt.isMine((Message)quotedMessage, (User)ChatClient.Companion.instance().getCurrentUser()), true);
        MaterialShapeDrawable materialShapeDrawable2 = materialShapeDrawable = new MaterialShapeDrawable(shapeAppearanceModel);
        ConstraintLayout constraintLayout = this.binding.replyContainer;
        boolean bl = false;
        if (this.isLink(quotedMessage)) {
            int n;
            $this$setReplyBackground_u24lambda_u244.setPaintStyle(Paint.Style.FILL);
            if (isMine) {
                MessageReplyStyle messageReplyStyle = style2;
                if (messageReplyStyle != null) {
                    n = messageReplyStyle.getLinkBackgroundColorMine();
                } else {
                    Context context2 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
                    n = ContextKt.getColorCompat(context2, R.color.stream_ui_blue_alice);
                }
            } else {
                MessageReplyStyle messageReplyStyle = style2;
                if (messageReplyStyle != null) {
                    n = messageReplyStyle.getLinkBackgroundColorTheirs();
                } else {
                    Context context3 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
                    n = ContextKt.getColorCompat(context3, R.color.stream_ui_blue_alice);
                }
            }
            int color2 = n;
            $this$setReplyBackground_u24lambda_u244.setTint(color2);
        } else if (MessageKt.isMine((Message)quotedMessage, (User)ChatClient.Companion.instance().getCurrentUser())) {
            int n;
            $this$setReplyBackground_u24lambda_u244.setPaintStyle(Paint.Style.FILL_AND_STROKE);
            if (isMine) {
                MessageReplyStyle messageReplyStyle = style2;
                if (messageReplyStyle != null) {
                    n = messageReplyStyle.getMessageBackgroundColorTheirs();
                } else {
                    Context context4 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"getContext(...)");
                    n = ContextKt.getColorCompat(context4, R.color.stream_ui_white);
                }
            } else {
                MessageReplyStyle messageReplyStyle = style2;
                if (messageReplyStyle != null) {
                    n = messageReplyStyle.getMessageBackgroundColorMine();
                } else {
                    Context context5 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context5, (String)"getContext(...)");
                    n = ContextKt.getColorCompat(context5, R.color.stream_ui_grey_whisper);
                }
            }
            int color3 = n;
            $this$setReplyBackground_u24lambda_u244.setTint(color3);
            MessageReplyStyle messageReplyStyle = style2;
            if (messageReplyStyle != null) {
                int p0 = messageReplyStyle.getMessageStrokeColorMine();
                boolean bl2 = false;
                $this$setReplyBackground_u24lambda_u244.setStrokeTint(p0);
            }
            MessageReplyStyle messageReplyStyle2 = style2;
            $this$setReplyBackground_u24lambda_u244.setStrokeWidth(messageReplyStyle2 != null ? messageReplyStyle2.getMessageStrokeWidthMine() : DEFAULT_STROKE_WIDTH);
        } else {
            int n;
            int n2;
            $this$setReplyBackground_u24lambda_u244.setPaintStyle(Paint.Style.FILL_AND_STROKE);
            MessageReplyStyle messageReplyStyle = style2;
            if (messageReplyStyle != null) {
                n2 = messageReplyStyle.getMessageStrokeColorTheirs();
            } else {
                Context context6 = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context6, (String)"getContext(...)");
                n2 = ContextKt.getColorCompat(context6, R.color.stream_ui_grey_whisper);
            }
            $this$setReplyBackground_u24lambda_u244.setStrokeTint(n2);
            MessageReplyStyle messageReplyStyle3 = style2;
            $this$setReplyBackground_u24lambda_u244.setStrokeWidth(messageReplyStyle3 != null ? messageReplyStyle3.getMessageStrokeWidthTheirs() : DEFAULT_STROKE_WIDTH);
            MessageReplyStyle messageReplyStyle4 = style2;
            if (messageReplyStyle4 != null) {
                n = messageReplyStyle4.getMessageBackgroundColorTheirs();
            } else {
                Context context7 = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context7, (String)"getContext(...)");
                n = ContextKt.getColorCompat(context7, R.color.stream_ui_white);
            }
            int tintColor = n;
            $this$setReplyBackground_u24lambda_u244.setTint(tintColor);
        }
        constraintLayout.setBackground((Drawable)materialShapeDrawable);
    }

    private final boolean isLink(Message message) {
        List $this$isLink_u24lambda_u245 = message.getAttachments();
        boolean bl = false;
        return $this$isLink_u24lambda_u245.size() == 1 && AttachmentUtilsKt.isLink((Attachment)((Attachment)CollectionsKt.last((List)$this$isLink_u24lambda_u245)));
    }

    /*
     * WARNING - void declaration
     */
    private final void setAttachmentImage(Message message) {
        if (ChatUI.getQuotedAttachmentFactoryManager().canHandle(message)) {
            void $this$isVisible$iv;
            FrameLayout frameLayout = this.binding.attachmentContainer;
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"attachmentContainer");
            View view = (View)frameLayout;
            boolean value$iv = true;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(0);
            QuotedAttachmentFactoryManager quotedAttachmentFactoryManager2 = ChatUI.getQuotedAttachmentFactoryManager();
            FrameLayout frameLayout2 = this.binding.attachmentContainer;
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout2, (String)"attachmentContainer");
            quotedAttachmentFactoryManager2.createAndAddQuotedView(message, (ViewGroup)frameLayout2);
        } else {
            FrameLayout frameLayout = this.binding.attachmentContainer;
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"attachmentContainer");
            View $this$isVisible$iv = (View)frameLayout;
            boolean value$iv = false;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setAdditionalInfo(Message message) {
        View $this$isVisible$iv;
        boolean value$iv22;
        boolean bl;
        Iterable $this$any$iv;
        block6: {
            $this$any$iv = message.getAttachments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Attachment it = (Attachment)element$iv;
                    boolean bl2 = false;
                    if (!AttachmentUtilsKt.isAudioRecording((Attachment)it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            Object element$iv2;
            TextView textView;
            DurationFormatter durationFormatter;
            block7: {
                void $this$first$iv;
                TextView textView2 = this.binding.additionalInfo;
                Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"additionalInfo");
                $this$any$iv = (View)textView2;
                value$iv22 = true;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                Iterable value$iv22 = message.getAttachments();
                durationFormatter = DurationFormatter.INSTANCE;
                textView = this.binding.additionalInfo;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Attachment it = (Attachment)element$iv2;
                    boolean bl3 = false;
                    if (!AttachmentUtilsKt.isAudioRecording((Attachment)it)) continue;
                    break block7;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv2;
            Float f = AttachmentExtensionsKt.getDuration((Attachment)((Attachment)t));
            textView.setText((CharSequence)durationFormatter.formatDurationInSeconds(f != null ? f.floatValue() : 0.0f));
        } else {
            TextView textView = this.binding.additionalInfo;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"additionalInfo");
            $this$isVisible$iv = (View)textView;
            value$iv22 = false;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
        }
    }

    private final void setReplyText(Message message, boolean isMine, MessageReplyStyle style2) {
        block9: {
            block10: {
                block8: {
                    CharSequence charSequence;
                    Attachment attachment = (Attachment)CollectionsKt.lastOrNull((List)message.getAttachments());
                    String displayedText = io.getstream.chat.android.ui.utils.extensions.MessageKt.getTranslatedText$default(message, null, 1, null);
                    TextView textView = this.binding.replyText;
                    if (attachment == null || !StringsKt.isBlank((CharSequence)displayedText)) {
                        charSequence = this.ellipsize ? this.ellipsize(displayedText) : displayedText;
                    } else {
                        String string2;
                        if (AttachmentUtilsKt.isLink((Attachment)attachment)) {
                            string2 = attachment.getTitleLink();
                            if (string2 == null) {
                                string2 = attachment.getOgUrl();
                            }
                        } else if (AttachmentUtilsKt.isAudioRecording((Attachment)attachment)) {
                            string2 = this.getContext().getString(R.string.stream_ui_message_audio_reply_info);
                        } else {
                            string2 = attachment.getTitle();
                            if (string2 == null) {
                                string2 = attachment.getName();
                            }
                        }
                        charSequence = string2;
                    }
                    textView.setText(charSequence);
                    if (!this.isLink(message)) break block8;
                    this.configureLinkTextStyle(isMine, style2);
                    break block9;
                }
                if (!isMine) break block10;
                Object object = style2;
                if (object == null || (object = ((MessageReplyStyle)object).getTextStyleMine()) == null) break block9;
                TextView textView = this.binding.replyText;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"replyText");
                ((TextStyle)object).apply(textView);
                break block9;
            }
            Object object = style2;
            if (object == null || (object = ((MessageReplyStyle)object).getTextStyleTheirs()) == null) break block9;
            TextView textView = this.binding.replyText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"replyText");
            ((TextStyle)object).apply(textView);
        }
    }

    private final void configureLinkTextStyle(boolean isMine, MessageReplyStyle style2) {
        block1: {
            block0: {
                if (!isMine) break block0;
                Object object = style2;
                if (object == null || (object = ((MessageReplyStyle)object).getLinkStyleMine()) == null) break block1;
                TextView textView = this.binding.replyText;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"replyText");
                ((TextStyle)object).apply(textView);
                break block1;
            }
            Object object = style2;
            if (object == null || (object = ((MessageReplyStyle)object).getLinkStyleTheirs()) == null) break block1;
            TextView textView = this.binding.replyText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"replyText");
            ((TextStyle)object).apply(textView);
        }
    }

    private final String ellipsize(String text) {
        return MessageEllipsizeKt.ellipsizeText$default(text, 170, 0, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/MessageReplyView$Companion;", "", "()V", "CONTENT_MARGIN", "", "DEFAULT_STROKE_WIDTH", "", "MAX_ELLIPSIZE_CHAR_COUNT", "REPLY_CORNER_RADIUS", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

