/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal;

import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.common.utils.MediaStringUtil;
import io.getstream.chat.android.ui.common.utils.extensions.AttachmentKt;
import io.getstream.chat.android.ui.databinding.StreamUiItemFileAttachmentBinding;
import io.getstream.chat.android.ui.feature.messages.list.FileAttachmentViewStyle;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.AttachmentClickListener;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.AttachmentDownloadClickListener;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.AttachmentLongClickListener;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.FileAttachmentViewHolder;
import io.getstream.chat.android.ui.feature.messages.list.background.ShapeAppearanceModelFactory;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.utils.AttachmentUtilsKt;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.io.File;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J \u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u0018H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010$\u001a\u00020\u0018H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/GeneralFileAttachmentViewHolder;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/FileAttachmentViewHolder;", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiItemFileAttachmentBinding;", "attachmentClickListener", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentClickListener;", "attachmentLongClickListener", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentLongClickListener;", "attachmentDownloadClickListener", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentDownloadClickListener;", "style", "Lio/getstream/chat/android/ui/feature/messages/list/FileAttachmentViewStyle;", "(Lio/getstream/chat/android/ui/databinding/StreamUiItemFileAttachmentBinding;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentClickListener;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentLongClickListener;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentDownloadClickListener;Lio/getstream/chat/android/ui/feature/messages/list/FileAttachmentViewStyle;)V", "attachment", "Lio/getstream/chat/android/models/Attachment;", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "bind", "", "item", "clearScope", "handleInProgressAttachment", "fileSizeView", "Landroid/widget/TextView;", "bytesRead", "", "totalBytes", "restartJob", "setupBackground", "subscribeForProgressIfNeeded", "unbind", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nFileAttachmentsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileAttachmentsView.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/GeneralFileAttachmentViewHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 4 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,535:1\n1#2:536\n303#3,4:537\n262#4,2:541\n*S KotlinDebug\n*F\n+ 1 FileAttachmentsView.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/GeneralFileAttachmentViewHolder\n*L\n285#1:537,4\n312#1:541,2\n*E\n"})
final class GeneralFileAttachmentViewHolder
extends FileAttachmentViewHolder {
    @NotNull
    private final StreamUiItemFileAttachmentBinding binding;
    @NotNull
    private final FileAttachmentViewStyle style;
    @NotNull
    private final Lazy logger$delegate;
    @Nullable
    private Attachment attachment;
    @Nullable
    private CoroutineScope scope;

    public GeneralFileAttachmentViewHolder(@NotNull StreamUiItemFileAttachmentBinding binding2, @Nullable AttachmentClickListener attachmentClickListener2, @Nullable AttachmentLongClickListener attachmentLongClickListener, @Nullable AttachmentDownloadClickListener attachmentDownloadClickListener2, @NotNull FileAttachmentViewStyle style2) {
        Object listener;
        Intrinsics.checkNotNullParameter((Object)binding2, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        ConstraintLayout constraintLayout = binding2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
        super((View)constraintLayout, null);
        this.binding = binding2;
        this.style = style2;
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"FileAttachmentVH");
        AttachmentClickListener attachmentClickListener3 = attachmentClickListener2;
        if (attachmentClickListener3 != null) {
            listener = attachmentClickListener3;
            boolean bl = false;
            this.binding.getRoot().setOnClickListener(arg_0 -> GeneralFileAttachmentViewHolder.lambda$1$lambda$0(this, (AttachmentClickListener)listener, arg_0));
        }
        AttachmentLongClickListener attachmentLongClickListener2 = attachmentLongClickListener;
        if (attachmentLongClickListener2 != null) {
            listener = attachmentLongClickListener2;
            boolean bl = false;
            this.binding.getRoot().setOnLongClickListener(arg_0 -> GeneralFileAttachmentViewHolder.lambda$3$lambda$2((AttachmentLongClickListener)listener, arg_0));
        }
        AttachmentDownloadClickListener attachmentDownloadClickListener3 = attachmentDownloadClickListener2;
        if (attachmentDownloadClickListener3 != null) {
            listener = attachmentDownloadClickListener3;
            boolean bl = false;
            this.binding.actionButton.setOnClickListener(arg_0 -> GeneralFileAttachmentViewHolder.lambda$6$lambda$5(this, (AttachmentDownloadClickListener)listener, arg_0));
        }
        this.binding.getRoot().setBackground((Drawable)ShapeAppearanceModelFactory.INSTANCE.fileBackground(this.getContext()));
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @Override
    public void clearScope() {
        CoroutineScope coroutineScope = this.scope;
        if (coroutineScope != null) {
            CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope, null, (int)1, null);
        }
        this.scope = null;
    }

    private final void setupBackground() {
        MaterialShapeDrawable bgShapeDrawable;
        MaterialShapeDrawable materialShapeDrawable;
        ShapeAppearanceModel shapeAppearanceModel = new ShapeAppearanceModel.Builder().setAllCorners(0, (float)this.style.getCornerRadius()).build();
        Intrinsics.checkNotNullExpressionValue((Object)shapeAppearanceModel, (String)"build(...)");
        ShapeAppearanceModel shapeAppearanceModel2 = shapeAppearanceModel;
        MaterialShapeDrawable $this$setupBackground_u24lambda_u247 = materialShapeDrawable = (bgShapeDrawable = new MaterialShapeDrawable(shapeAppearanceModel2));
        boolean bl = false;
        $this$setupBackground_u24lambda_u247.setFillColor(ColorStateList.valueOf((int)this.style.getBackgroundColor()));
        $this$setupBackground_u24lambda_u247.setStrokeColor(ColorStateList.valueOf((int)this.style.getStrokeColor()));
        $this$setupBackground_u24lambda_u247.setStrokeWidth((float)this.style.getStrokeWidth());
        this.binding.getRoot().setBackground((Drawable)bgShapeDrawable);
    }

    @Override
    public void restartJob() {
        block0: {
            Attachment attachment = this.attachment;
            if (attachment == null) break block0;
            Attachment p0 = attachment;
            boolean bl = false;
            this.subscribeForProgressIfNeeded(p0);
        }
    }

    private final void subscribeForProgressIfNeeded(Attachment attachment) {
        Attachment.UploadState uploadState = attachment.getUploadState();
        if (uploadState instanceof Attachment.UploadState.Idle) {
            TextView textView = this.binding.fileSize;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"fileSize");
            File file = attachment.getUpload();
            this.handleInProgressAttachment(textView, 0L, file != null ? file.length() : 0L);
        } else if (uploadState instanceof Attachment.UploadState.InProgress) {
            TextView textView = this.binding.fileSize;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"fileSize");
            this.handleInProgressAttachment(textView, ((Attachment.UploadState.InProgress)uploadState).getBytesUploaded(), ((Attachment.UploadState.InProgress)uploadState).getTotalBytes());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bind(@NotNull Attachment item) {
        void $this$isVisible$iv;
        StreamUiItemFileAttachmentBinding streamUiItemFileAttachmentBinding;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        TaggedLogger this_$iv = this.getLogger();
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[bind] item: " + item;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.attachment = item;
        StreamUiItemFileAttachmentBinding $this$bind_u24lambda_u2410 = streamUiItemFileAttachmentBinding = this.binding;
        boolean bl = false;
        TextView textView = $this$bind_u24lambda_u2410.fileTitle;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"fileTitle");
        TextStyleKt.setTextStyle(textView, this.style.getTitleTextStyle());
        TextView textView2 = $this$bind_u24lambda_u2410.fileSize;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"fileSize");
        TextStyleKt.setTextStyle(textView2, this.style.getFileSizeTextStyle());
        ImageView imageView = $this$bind_u24lambda_u2410.fileTypeIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"fileTypeIcon");
        AttachmentUtilsKt.loadAttachmentThumb(imageView, item);
        $this$bind_u24lambda_u2410.fileTitle.setText((CharSequence)AttachmentKt.getDisplayableName((Attachment)item));
        if (item.getUploadState() instanceof Attachment.UploadState.Idle || item.getUploadState() instanceof Attachment.UploadState.InProgress || item.getUploadState() instanceof Attachment.UploadState.Success && item.getFileSize() == 0) {
            $this$bind_u24lambda_u2410.actionButton.setVisibility(8);
            File file = item.getUpload();
            $this$bind_u24lambda_u2410.fileSize.setText((CharSequence)MediaStringUtil.convertFileSizeByteCount((long)(file != null ? file.length() : 0L)));
        } else if (item.getUploadState() instanceof Attachment.UploadState.Failed || item.getFileSize() == 0) {
            $this$bind_u24lambda_u2410.actionButton.setVisibility(0);
            $this$bind_u24lambda_u2410.actionButton.setImageDrawable(this.style.getFailedAttachmentIcon());
            File file = item.getUpload();
            $this$bind_u24lambda_u2410.fileSize.setText((CharSequence)MediaStringUtil.convertFileSizeByteCount((long)(file != null ? file.length() : 0L)));
        } else {
            $this$bind_u24lambda_u2410.actionButton.setVisibility(0);
            $this$bind_u24lambda_u2410.actionButton.setImageDrawable(this.style.getActionButtonIcon());
            $this$bind_u24lambda_u2410.fileSize.setText((CharSequence)MediaStringUtil.convertFileSizeByteCount((long)item.getFileSize()));
        }
        this.binding.progressBar.setIndeterminateDrawable(this.style.getProgressBarDrawable());
        ProgressBar progressBar = this.binding.progressBar;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"progressBar");
        View view = (View)progressBar;
        boolean value$iv = item.getUploadState() instanceof Attachment.UploadState.InProgress;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        this.subscribeForProgressIfNeeded(item);
        this.setupBackground();
    }

    private final void handleInProgressAttachment(TextView fileSizeView, long bytesRead, long totalBytes) {
        String totalValue = MediaStringUtil.convertFileSizeByteCount((long)totalBytes);
        Object[] objectArray = new Object[]{MediaStringUtil.convertFileSizeByteCount((long)bytesRead), totalValue};
        fileSizeView.setText((CharSequence)this.getContext().getString(R.string.stream_ui_message_list_attachment_upload_progress, objectArray));
    }

    @Override
    public void unbind() {
        this.clearScope();
        super.unbind();
    }

    private static final void lambda$1$lambda$0(GeneralFileAttachmentViewHolder this$0, AttachmentClickListener $listener, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
            Attachment attachment = this$0.attachment;
            if (attachment == null) break block0;
            Attachment p0 = attachment;
            boolean bl = false;
            $listener.onAttachmentClick(p0);
        }
    }

    private static final boolean lambda$3$lambda$2(AttachmentLongClickListener $listener, View it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.onAttachmentLongClick();
        return true;
    }

    private static final void lambda$6$lambda$5(GeneralFileAttachmentViewHolder this$0, AttachmentDownloadClickListener $listener, View it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
            Attachment attachment = this$0.attachment;
            boolean bl = attachment != null ? io.getstream.chat.android.uiutils.extension.AttachmentKt.isFailed((Attachment)attachment) : false;
            if (bl) {
                return;
            }
            Attachment attachment2 = this$0.attachment;
            if (attachment2 == null) break block1;
            Attachment p0 = attachment2;
            boolean bl2 = false;
            $listener.onAttachmentDownloadClick(p0);
        }
    }
}

