/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import com.google.android.material.shape.AbsoluteCornerSize;
import com.google.android.material.shape.CornerSize;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import io.getstream.chat.android.client.utils.attachment.AttachmentUtilsKt;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.common.extensions.internal.AnyKt;
import io.getstream.chat.android.ui.feature.messages.list.adapter.MessageListItem;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.AttachmentClickListener;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.AttachmentLongClickListener;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.MediaAttachmentView;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.MediaAttachmentsGroupView;
import io.getstream.chat.android.ui.feature.messages.list.adapter.viewholder.decorator.internal.BackgroundDecorator;
import io.getstream.chat.android.ui.feature.messages.list.background.ShapeAppearanceModelFactory;
import io.getstream.chat.android.ui.utils.extensions.ConstraintLayoutKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.IntKt;
import io.getstream.chat.android.ui.utils.extensions.MessageItemKt;
import io.getstream.chat.android.uiutils.extension.AttachmentKt;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 C2\u00020\u0001:\u0002CDB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u000200J\u0014\u00101\u001a\u00020&2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403J2\u00105\u001a\u00020&2\u0006\u00106\u001a\u0002042\u0006\u00107\u001a\u0002042\u0006\u00108\u001a\u0002042\u0006\u00109\u001a\u0002042\b\b\u0002\u0010:\u001a\u00020\tH\u0002J\u0010\u0010;\u001a\u00020&2\u0006\u00106\u001a\u000204H\u0002J \u0010<\u001a\u00020&2\u0006\u00106\u001a\u0002042\u0006\u00107\u001a\u0002042\u0006\u00108\u001a\u000204H\u0002J\u0018\u0010=\u001a\u00020&2\u0006\u00106\u001a\u0002042\u0006\u00107\u001a\u000204H\u0002J \u0010>\u001a\u00020?*\u00020(2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020B0AH\u0002R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001f\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001e\u001a\u0004\b \u0010!R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "attachmentClickListener", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentClickListener;", "getAttachmentClickListener", "()Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentClickListener;", "setAttachmentClickListener", "(Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentClickListener;)V", "attachmentLongClickListener", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentLongClickListener;", "getAttachmentLongClickListener", "()Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentLongClickListener;", "setAttachmentLongClickListener", "(Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentLongClickListener;)V", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "maxMediaAttachmentHeight", "getMaxMediaAttachmentHeight", "()I", "maxMediaAttachmentHeight$delegate", "state", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State;", "applyToMediaPreviews", "", "shapeAppearanceModel", "Lcom/google/android/material/shape/ShapeAppearanceModel;", "createMediaAttachmentView", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;", "setBackground", "background", "Landroid/graphics/drawable/Drawable;", "setupBackground", "data", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/MessageListItem$MessageItem;", "showAttachments", "attachments", "", "Lio/getstream/chat/android/models/Attachment;", "showFour", "first", "second", "third", "fourth", "andMoreCount", "showOne", "showThree", "showTwo", "getCornerSize", "", "selector", "Lkotlin/Function1;", "Lcom/google/android/material/shape/CornerSize;", "Companion", "State", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nMediaAttachmentsGroupView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaAttachmentsGroupView.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n766#2:301\n857#2,2:302\n303#3,4:304\n1#4:308\n*S KotlinDebug\n*F\n+ 1 MediaAttachmentsGroupView.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView\n*L\n79#1:301\n79#1:302,2\n83#1:304,4\n*E\n"})
public final class MediaAttachmentsGroupView
extends ConstraintLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy logger$delegate;
    @Nullable
    private AttachmentClickListener attachmentClickListener;
    @Nullable
    private AttachmentLongClickListener attachmentLongClickListener;
    @NotNull
    private final Lazy maxMediaAttachmentHeight$delegate;
    @NotNull
    private State state;
    private static final double MAX_HEIGHT_PERCENTAGE = 0.75;
    private static final int MAX_PREVIEW_COUNT = 4;
    private static final int MIN_HEIGHT_PX = IntKt.dpToPx(95);
    private static final float STROKE_WIDTH = IntKt.dpToPxPrecise(2);

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @Nullable
    public final AttachmentClickListener getAttachmentClickListener() {
        return this.attachmentClickListener;
    }

    public final void setAttachmentClickListener(@Nullable AttachmentClickListener attachmentClickListener2) {
        this.attachmentClickListener = attachmentClickListener2;
    }

    @Nullable
    public final AttachmentLongClickListener getAttachmentLongClickListener() {
        return this.attachmentLongClickListener;
    }

    public final void setAttachmentLongClickListener(@Nullable AttachmentLongClickListener attachmentLongClickListener) {
        this.attachmentLongClickListener = attachmentLongClickListener;
    }

    private final int getMaxMediaAttachmentHeight() {
        Lazy lazy = this.maxMediaAttachmentHeight$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public MediaAttachmentsGroupView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context));
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"MediaAttachGroupView");
        this.maxMediaAttachmentHeight$delegate = LazyKt.lazy((Function0)maxMediaAttachmentHeight.2.INSTANCE);
        this.state = State.Empty.INSTANCE;
    }

    public MediaAttachmentsGroupView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs);
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"MediaAttachGroupView");
        this.maxMediaAttachmentHeight$delegate = LazyKt.lazy((Function0)maxMediaAttachmentHeight.2.INSTANCE);
        this.state = State.Empty.INSTANCE;
    }

    public MediaAttachmentsGroupView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr);
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"MediaAttachGroupView");
        this.maxMediaAttachmentHeight$delegate = LazyKt.lazy((Function0)maxMediaAttachmentHeight.2.INSTANCE);
        this.state = State.Empty.INSTANCE;
    }

    public MediaAttachmentsGroupView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr, defStyleRes);
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"MediaAttachGroupView");
        this.maxMediaAttachmentHeight$delegate = LazyKt.lazy((Function0)maxMediaAttachmentHeight.2.INSTANCE);
        this.state = State.Empty.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final void showAttachments(@NotNull List<Attachment> attachments2) {
        block8: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(attachments2, (String)"attachments");
            Iterable $this$filter$iv = attachments2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Attachment attachment = (Attachment)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !AttachmentKt.hasLink((Attachment)attachment) && (AttachmentUtilsKt.isImage((Attachment)attachment) || AttachmentUtilsKt.isVideo((Attachment)attachment));
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List media = (List)destination$iv$iv;
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$d = false;
            if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.DEBUG;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[showAttachments] attachments.size: " + media.size();
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            switch (media.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.showOne((Attachment)CollectionsKt.first((List)media));
                    break;
                }
                case 2: {
                    this.showTwo((Attachment)CollectionsKt.first((List)media), (Attachment)media.get(1));
                    break;
                }
                case 3: {
                    this.showThree((Attachment)CollectionsKt.first((List)media), (Attachment)media.get(1), (Attachment)media.get(2));
                    break;
                }
                default: {
                    this.showFour((Attachment)CollectionsKt.first((List)media), (Attachment)media.get(1), (Attachment)media.get(2), (Attachment)media.get(3), media.size() - 4);
                }
            }
            Drawable drawable2 = this.getBackground();
            MaterialShapeDrawable materialShapeDrawable = drawable2 instanceof MaterialShapeDrawable ? (MaterialShapeDrawable)drawable2 : null;
            if (materialShapeDrawable == null || (materialShapeDrawable = materialShapeDrawable.getShapeAppearanceModel()) == null) break block8;
            MaterialShapeDrawable p0 = materialShapeDrawable;
            boolean bl = false;
            this.applyToMediaPreviews((ShapeAppearanceModel)p0);
        }
    }

    private final void showOne(Attachment first) {
        Float mediaHeight;
        ConstraintSet constraintSet;
        this.removeAllViews();
        MediaAttachmentView mediaAttachmentView = this.createMediaAttachmentView();
        this.addView((View)mediaAttachmentView);
        this.state = new State.OneView(mediaAttachmentView);
        ConstraintSet $this$showOne_u24lambda_u242 = constraintSet = new ConstraintSet();
        boolean bl = false;
        $this$showOne_u24lambda_u242.constrainMaxHeight(mediaAttachmentView.getId(), this.getMaxMediaAttachmentHeight());
        $this$showOne_u24lambda_u242.constrainWidth(mediaAttachmentView.getId(), -1);
        ConstraintLayoutKt.constrainViewToParentBySide($this$showOne_u24lambda_u242, (View)mediaAttachmentView, 1);
        ConstraintLayoutKt.constrainViewToParentBySide($this$showOne_u24lambda_u242, (View)mediaAttachmentView, 2);
        ConstraintLayoutKt.constrainViewToParentBySide($this$showOne_u24lambda_u242, (View)mediaAttachmentView, 3);
        ConstraintLayoutKt.constrainViewToParentBySide($this$showOne_u24lambda_u242, (View)mediaAttachmentView, 4);
        Integer n = first.getOriginalWidth();
        Float mediaWidth = n != null ? Float.valueOf(n.intValue()) : null;
        Integer n2 = first.getOriginalHeight();
        Float f = mediaHeight = n2 != null ? Float.valueOf(n2.intValue()) : null;
        if (mediaWidth != null && mediaHeight != null) {
            String ratio = String.valueOf(mediaWidth.floatValue() / mediaHeight.floatValue());
            $this$showOne_u24lambda_u242.setDimensionRatio(mediaAttachmentView.getId(), ratio);
        } else {
            $this$showOne_u24lambda_u242.setDimensionRatio(mediaAttachmentView.getId(), "1");
        }
        $this$showOne_u24lambda_u242.applyTo((ConstraintLayout)this);
        MediaAttachmentView.showAttachment$default(mediaAttachmentView, first, 0, 2, null);
    }

    private final void showTwo(Attachment first, Attachment second) {
        MediaAttachmentView mediaAttachmentView;
        MediaAttachmentView mediaAttachmentView2;
        this.removeAllViews();
        MediaAttachmentView it = mediaAttachmentView2 = this.createMediaAttachmentView();
        boolean bl = false;
        this.addView((View)it);
        MediaAttachmentView viewOne = mediaAttachmentView2;
        MediaAttachmentView it2 = mediaAttachmentView = this.createMediaAttachmentView();
        boolean bl2 = false;
        this.addView((View)it2);
        MediaAttachmentView viewTwo = mediaAttachmentView;
        this.state = new State.TwoViews(viewOne, viewTwo);
        MediaAttachmentView $this$showTwo_u24lambda_u245 = mediaAttachmentView = new ConstraintSet();
        boolean bl3 = false;
        MediaAttachmentsGroupView.Companion.setupMinHeight((ConstraintSet)$this$showTwo_u24lambda_u245, (View)viewOne, false);
        MediaAttachmentsGroupView.Companion.setupMinHeight((ConstraintSet)$this$showTwo_u24lambda_u245, (View)viewTwo, false);
        ConstraintLayoutKt.constrainViewToParentBySide((ConstraintSet)$this$showTwo_u24lambda_u245, (View)viewOne, 3);
        ConstraintLayoutKt.constrainViewToParentBySide((ConstraintSet)$this$showTwo_u24lambda_u245, (View)viewTwo, 3);
        ConstraintLayoutKt.constrainViewToParentBySide((ConstraintSet)$this$showTwo_u24lambda_u245, (View)viewOne, 4);
        ConstraintLayoutKt.constrainViewToParentBySide((ConstraintSet)$this$showTwo_u24lambda_u245, (View)viewTwo, 4);
        View[] viewArray = new View[]{viewOne, viewTwo};
        ConstraintLayoutKt.horizontalChainInParent((ConstraintSet)$this$showTwo_u24lambda_u245, viewArray);
        $this$showTwo_u24lambda_u245.applyTo(this);
        MediaAttachmentView.showAttachment$default(viewOne, first, 0, 2, null);
        MediaAttachmentView.showAttachment$default(viewTwo, second, 0, 2, null);
    }

    private final void showThree(Attachment first, Attachment second, Attachment third) {
        MediaAttachmentView mediaAttachmentView;
        MediaAttachmentView mediaAttachmentView2;
        this.removeAllViews();
        MediaAttachmentView it = mediaAttachmentView2 = this.createMediaAttachmentView();
        boolean bl = false;
        this.addView((View)it);
        MediaAttachmentView viewOne = mediaAttachmentView2;
        MediaAttachmentView it2 = it = this.createMediaAttachmentView();
        boolean bl2 = false;
        this.addView((View)it2);
        MediaAttachmentView viewTwo = it;
        MediaAttachmentView it3 = mediaAttachmentView = this.createMediaAttachmentView();
        boolean bl3 = false;
        this.addView((View)it3);
        MediaAttachmentView viewThree = mediaAttachmentView;
        this.state = new State.ThreeViews(viewOne, viewTwo, viewThree);
        MediaAttachmentView $this$showThree_u24lambda_u249 = mediaAttachmentView = new ConstraintSet();
        boolean bl4 = false;
        MediaAttachmentsGroupView.Companion.setupMinHeight((ConstraintSet)$this$showThree_u24lambda_u249, (View)viewTwo, true);
        MediaAttachmentsGroupView.Companion.setupMinHeight((ConstraintSet)$this$showThree_u24lambda_u249, (View)viewThree, true);
        View[] viewArray = new View[]{viewOne, viewTwo};
        ConstraintLayoutKt.horizontalChainInParent((ConstraintSet)$this$showThree_u24lambda_u249, viewArray);
        viewArray = new View[]{viewOne, viewThree};
        ConstraintLayoutKt.horizontalChainInParent((ConstraintSet)$this$showThree_u24lambda_u249, viewArray);
        viewArray = new View[]{viewTwo, viewThree};
        ConstraintLayoutKt.verticalChainInParent((ConstraintSet)$this$showThree_u24lambda_u249, viewArray);
        $this$showThree_u24lambda_u249.connect(viewOne.getId(), 3, viewTwo.getId(), 3);
        $this$showThree_u24lambda_u249.connect(viewOne.getId(), 4, viewThree.getId(), 4);
        $this$showThree_u24lambda_u249.applyTo(this);
        MediaAttachmentView.showAttachment$default(viewOne, first, 0, 2, null);
        MediaAttachmentView.showAttachment$default(viewTwo, second, 0, 2, null);
        MediaAttachmentView.showAttachment$default(viewThree, third, 0, 2, null);
    }

    private final void showFour(Attachment first, Attachment second, Attachment third, Attachment fourth, int andMoreCount) {
        MediaAttachmentView mediaAttachmentView;
        MediaAttachmentView mediaAttachmentView2;
        this.removeAllViews();
        MediaAttachmentView it = mediaAttachmentView2 = this.createMediaAttachmentView();
        boolean bl = false;
        this.addView((View)it);
        MediaAttachmentView viewOne = mediaAttachmentView2;
        MediaAttachmentView it2 = it = this.createMediaAttachmentView();
        boolean bl2 = false;
        this.addView((View)it2);
        MediaAttachmentView viewTwo = it;
        MediaAttachmentView it3 = it2 = this.createMediaAttachmentView();
        boolean bl3 = false;
        this.addView((View)it3);
        MediaAttachmentView viewThree = it2;
        MediaAttachmentView it4 = mediaAttachmentView = this.createMediaAttachmentView();
        boolean bl4 = false;
        this.addView((View)it4);
        MediaAttachmentView viewFour = mediaAttachmentView;
        this.state = new State.FourViews(viewOne, viewTwo, viewThree, viewFour);
        MediaAttachmentView $this$showFour_u24lambda_u2414 = mediaAttachmentView = new ConstraintSet();
        boolean bl5 = false;
        MediaAttachmentsGroupView.Companion.setupMinHeight((ConstraintSet)$this$showFour_u24lambda_u2414, (View)viewOne, true);
        MediaAttachmentsGroupView.Companion.setupMinHeight((ConstraintSet)$this$showFour_u24lambda_u2414, (View)viewTwo, true);
        MediaAttachmentsGroupView.Companion.setupMinHeight((ConstraintSet)$this$showFour_u24lambda_u2414, (View)viewThree, true);
        MediaAttachmentsGroupView.Companion.setupMinHeight((ConstraintSet)$this$showFour_u24lambda_u2414, (View)viewFour, true);
        View[] viewArray = new View[]{viewOne, viewTwo};
        ConstraintLayoutKt.horizontalChainInParent((ConstraintSet)$this$showFour_u24lambda_u2414, viewArray);
        viewArray = new View[]{viewThree, viewFour};
        ConstraintLayoutKt.horizontalChainInParent((ConstraintSet)$this$showFour_u24lambda_u2414, viewArray);
        viewArray = new View[]{viewOne, viewThree};
        ConstraintLayoutKt.verticalChainInParent((ConstraintSet)$this$showFour_u24lambda_u2414, viewArray);
        viewArray = new View[]{viewTwo, viewFour};
        ConstraintLayoutKt.verticalChainInParent((ConstraintSet)$this$showFour_u24lambda_u2414, viewArray);
        $this$showFour_u24lambda_u2414.applyTo(this);
        MediaAttachmentView.showAttachment$default(viewOne, first, 0, 2, null);
        MediaAttachmentView.showAttachment$default(viewTwo, second, 0, 2, null);
        MediaAttachmentView.showAttachment$default(viewThree, third, 0, 2, null);
        viewFour.showAttachment(fourth, andMoreCount);
    }

    static /* synthetic */ void showFour$default(MediaAttachmentsGroupView mediaAttachmentsGroupView, Attachment attachment, Attachment attachment2, Attachment attachment3, Attachment attachment4, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        mediaAttachmentsGroupView.showFour(attachment, attachment2, attachment3, attachment4, n);
    }

    public void setBackground(@NotNull Drawable background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        super.setBackground(background);
        if (background instanceof MaterialShapeDrawable) {
            ShapeAppearanceModel shapeAppearanceModel = ((MaterialShapeDrawable)background).getShapeAppearanceModel();
            Intrinsics.checkNotNullExpressionValue((Object)shapeAppearanceModel, (String)"getShapeAppearanceModel(...)");
            this.applyToMediaPreviews(shapeAppearanceModel);
        }
    }

    private final void applyToMediaPreviews(ShapeAppearanceModel shapeAppearanceModel) {
        block1: {
            State stateCopy;
            float bottomLeftCorner2;
            float bottomRightCorner2;
            float topRightCorner2;
            float topLeftCorner2;
            block3: {
                block2: {
                    block0: {
                        topLeftCorner2 = this.getCornerSize(shapeAppearanceModel, (Function1<? super ShapeAppearanceModel, ? extends CornerSize>)((Function1)applyToMediaPreviews.topLeftCorner.1.INSTANCE));
                        topRightCorner2 = this.getCornerSize(shapeAppearanceModel, (Function1<? super ShapeAppearanceModel, ? extends CornerSize>)((Function1)applyToMediaPreviews.topRightCorner.1.INSTANCE));
                        bottomRightCorner2 = this.getCornerSize(shapeAppearanceModel, (Function1<? super ShapeAppearanceModel, ? extends CornerSize>)((Function1)applyToMediaPreviews.bottomRightCorner.1.INSTANCE));
                        bottomLeftCorner2 = this.getCornerSize(shapeAppearanceModel, (Function1<? super ShapeAppearanceModel, ? extends CornerSize>)((Function1)applyToMediaPreviews.bottomLeftCorner.1.INSTANCE));
                        stateCopy = this.state;
                        if (!(stateCopy instanceof State.OneView)) break block0;
                        ((State.OneView)stateCopy).getView().setMediaPreviewShapeByCorners(topLeftCorner2, topRightCorner2, bottomRightCorner2, bottomLeftCorner2);
                        break block1;
                    }
                    if (!(stateCopy instanceof State.TwoViews)) break block2;
                    ((State.TwoViews)stateCopy).getViewOne().setMediaPreviewShapeByCorners(topLeftCorner2, 0.0f, 0.0f, bottomLeftCorner2);
                    ((State.TwoViews)stateCopy).getViewTwo().setMediaPreviewShapeByCorners(0.0f, topRightCorner2, bottomRightCorner2, 0.0f);
                    break block1;
                }
                if (!(stateCopy instanceof State.ThreeViews)) break block3;
                ((State.ThreeViews)stateCopy).getViewOne().setMediaPreviewShapeByCorners(topLeftCorner2, 0.0f, 0.0f, bottomLeftCorner2);
                ((State.ThreeViews)stateCopy).getViewTwo().setMediaPreviewShapeByCorners(0.0f, topRightCorner2, 0.0f, 0.0f);
                ((State.ThreeViews)stateCopy).getViewThree().setMediaPreviewShapeByCorners(0.0f, 0.0f, bottomRightCorner2, 0.0f);
                break block1;
            }
            if (!(stateCopy instanceof State.FourViews)) break block1;
            ((State.FourViews)stateCopy).getViewOne().setMediaPreviewShapeByCorners(topLeftCorner2, 0.0f, 0.0f, 0.0f);
            ((State.FourViews)stateCopy).getViewTwo().setMediaPreviewShapeByCorners(0.0f, topRightCorner2, 0.0f, 0.0f);
            ((State.FourViews)stateCopy).getViewThree().setMediaPreviewShapeByCorners(0.0f, 0.0f, 0.0f, bottomLeftCorner2);
            ((State.FourViews)stateCopy).getViewFour().setMediaPreviewShapeByCorners(0.0f, 0.0f, bottomRightCorner2, 0.0f);
        }
    }

    private final float getCornerSize(ShapeAppearanceModel $this$getCornerSize, Function1<? super ShapeAppearanceModel, ? extends CornerSize> selector) {
        Object object = selector.invoke((Object)$this$getCornerSize);
        AbsoluteCornerSize absoluteCornerSize = object instanceof AbsoluteCornerSize ? (AbsoluteCornerSize)object : null;
        Float f = Float.valueOf((absoluteCornerSize != null ? absoluteCornerSize.getCornerSize() : 0.0f) - STROKE_WIDTH);
        float it = ((Number)f).floatValue();
        boolean bl = false;
        return ((Number)AnyKt.getOrDefault(it >= 0.0f ? f : null, Float.valueOf(0.0f))).floatValue();
    }

    private final MediaAttachmentView createMediaAttachmentView() {
        MediaAttachmentView mediaAttachmentView;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        MediaAttachmentView it = mediaAttachmentView = new MediaAttachmentView(context);
        boolean bl = false;
        it.setId(ConstraintLayout.generateViewId());
        it.setAttachmentClickListener(this.attachmentClickListener);
        it.setAttachmentLongClickListener(this.attachmentLongClickListener);
        return mediaAttachmentView;
    }

    /*
     * WARNING - void declaration
     */
    public final void setupBackground(@NotNull MessageListItem.MessageItem data) {
        void $this$setupBackground_u24lambda_u2418;
        MaterialShapeDrawable p0;
        MaterialShapeDrawable materialShapeDrawable;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModelFactory.INSTANCE.create(context, BackgroundDecorator.Companion.getDEFAULT_CORNER_RADIUS$stream_chat_android_ui_components_release(), 0.0f, data.isMine(), MessageItemKt.isBottomPosition(data));
        MediaAttachmentsGroupView mediaAttachmentsGroupView = this;
        boolean bl = false;
        p0 = materialShapeDrawable = new MaterialShapeDrawable((ShapeAppearanceModel)p0);
        boolean bl2 = false;
        $this$setupBackground_u24lambda_u2418.setTint(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stream_ui_literal_transparent));
        mediaAttachmentsGroupView.setBackground((Drawable)materialShapeDrawable);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$Companion;", "", "()V", "MAX_HEIGHT_PERCENTAGE", "", "MAX_PREVIEW_COUNT", "", "MIN_HEIGHT_PX", "STROKE_WIDTH", "", "setupMinHeight", "", "Landroidx/constraintlayout/widget/ConstraintSet;", "view", "Landroid/view/View;", "isQuarter", "", "stream-chat-android-ui-components_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupMinHeight(ConstraintSet $this$setupMinHeight, View view, boolean isQuarter) {
            $this$setupMinHeight.constrainMinHeight(view.getId(), isQuarter ? MIN_HEIGHT_PX : 2 * MIN_HEIGHT_PX);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0005\b\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State;", "", "()V", "Empty", "FourViews", "OneView", "ThreeViews", "TwoViews", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State$Empty;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State$FourViews;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State$OneView;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State$ThreeViews;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State$TwoViews;", "stream-chat-android-ui-components_release"})
    private static abstract class State {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State$Empty;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State;", "()V", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class Empty
        extends State {
            @NotNull
            public static final Empty INSTANCE = new Empty();

            private Empty() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Empty";
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001a"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State$FourViews;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State;", "viewOne", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;", "viewTwo", "viewThree", "viewFour", "(Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;)V", "getViewFour", "()Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;", "getViewOne", "getViewThree", "getViewTwo", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class FourViews
        extends State {
            @NotNull
            private final MediaAttachmentView viewOne;
            @NotNull
            private final MediaAttachmentView viewTwo;
            @NotNull
            private final MediaAttachmentView viewThree;
            @NotNull
            private final MediaAttachmentView viewFour;

            public FourViews(@NotNull MediaAttachmentView viewOne, @NotNull MediaAttachmentView viewTwo, @NotNull MediaAttachmentView viewThree, @NotNull MediaAttachmentView viewFour) {
                Intrinsics.checkNotNullParameter((Object)((Object)viewOne), (String)"viewOne");
                Intrinsics.checkNotNullParameter((Object)((Object)viewTwo), (String)"viewTwo");
                Intrinsics.checkNotNullParameter((Object)((Object)viewThree), (String)"viewThree");
                Intrinsics.checkNotNullParameter((Object)((Object)viewFour), (String)"viewFour");
                super(null);
                this.viewOne = viewOne;
                this.viewTwo = viewTwo;
                this.viewThree = viewThree;
                this.viewFour = viewFour;
            }

            @NotNull
            public final MediaAttachmentView getViewOne() {
                return this.viewOne;
            }

            @NotNull
            public final MediaAttachmentView getViewTwo() {
                return this.viewTwo;
            }

            @NotNull
            public final MediaAttachmentView getViewThree() {
                return this.viewThree;
            }

            @NotNull
            public final MediaAttachmentView getViewFour() {
                return this.viewFour;
            }

            @NotNull
            public final MediaAttachmentView component1() {
                return this.viewOne;
            }

            @NotNull
            public final MediaAttachmentView component2() {
                return this.viewTwo;
            }

            @NotNull
            public final MediaAttachmentView component3() {
                return this.viewThree;
            }

            @NotNull
            public final MediaAttachmentView component4() {
                return this.viewFour;
            }

            @NotNull
            public final FourViews copy(@NotNull MediaAttachmentView viewOne, @NotNull MediaAttachmentView viewTwo, @NotNull MediaAttachmentView viewThree, @NotNull MediaAttachmentView viewFour) {
                Intrinsics.checkNotNullParameter((Object)((Object)viewOne), (String)"viewOne");
                Intrinsics.checkNotNullParameter((Object)((Object)viewTwo), (String)"viewTwo");
                Intrinsics.checkNotNullParameter((Object)((Object)viewThree), (String)"viewThree");
                Intrinsics.checkNotNullParameter((Object)((Object)viewFour), (String)"viewFour");
                return new FourViews(viewOne, viewTwo, viewThree, viewFour);
            }

            public static /* synthetic */ FourViews copy$default(FourViews fourViews, MediaAttachmentView mediaAttachmentView, MediaAttachmentView mediaAttachmentView2, MediaAttachmentView mediaAttachmentView3, MediaAttachmentView mediaAttachmentView4, int n, Object object) {
                if ((n & 1) != 0) {
                    mediaAttachmentView = fourViews.viewOne;
                }
                if ((n & 2) != 0) {
                    mediaAttachmentView2 = fourViews.viewTwo;
                }
                if ((n & 4) != 0) {
                    mediaAttachmentView3 = fourViews.viewThree;
                }
                if ((n & 8) != 0) {
                    mediaAttachmentView4 = fourViews.viewFour;
                }
                return fourViews.copy(mediaAttachmentView, mediaAttachmentView2, mediaAttachmentView3, mediaAttachmentView4);
            }

            @NotNull
            public String toString() {
                return "FourViews(viewOne=" + this.viewOne + ", viewTwo=" + this.viewTwo + ", viewThree=" + this.viewThree + ", viewFour=" + this.viewFour + ")";
            }

            public int hashCode() {
                int result2 = this.viewOne.hashCode();
                result2 = result2 * 31 + this.viewTwo.hashCode();
                result2 = result2 * 31 + this.viewThree.hashCode();
                result2 = result2 * 31 + this.viewFour.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FourViews)) {
                    return false;
                }
                FourViews fourViews = (FourViews)other;
                if (!Intrinsics.areEqual((Object)((Object)this.viewOne), (Object)((Object)fourViews.viewOne))) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)((Object)this.viewTwo), (Object)((Object)fourViews.viewTwo))) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)((Object)this.viewThree), (Object)((Object)fourViews.viewThree))) {
                    return false;
                }
                return Intrinsics.areEqual((Object)((Object)this.viewFour), (Object)((Object)fourViews.viewFour));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State$OneView;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State;", "view", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;", "(Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;)V", "getView", "()Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class OneView
        extends State {
            @NotNull
            private final MediaAttachmentView view;

            public OneView(@NotNull MediaAttachmentView view) {
                Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
                super(null);
                this.view = view;
            }

            @NotNull
            public final MediaAttachmentView getView() {
                return this.view;
            }

            @NotNull
            public final MediaAttachmentView component1() {
                return this.view;
            }

            @NotNull
            public final OneView copy(@NotNull MediaAttachmentView view) {
                Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
                return new OneView(view);
            }

            public static /* synthetic */ OneView copy$default(OneView oneView, MediaAttachmentView mediaAttachmentView, int n, Object object) {
                if ((n & 1) != 0) {
                    mediaAttachmentView = oneView.view;
                }
                return oneView.copy(mediaAttachmentView);
            }

            @NotNull
            public String toString() {
                return "OneView(view=" + this.view + ")";
            }

            public int hashCode() {
                return this.view.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OneView)) {
                    return false;
                }
                OneView oneView = (OneView)other;
                return Intrinsics.areEqual((Object)((Object)this.view), (Object)((Object)oneView.view));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State$ThreeViews;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State;", "viewOne", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;", "viewTwo", "viewThree", "(Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;)V", "getViewOne", "()Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;", "getViewThree", "getViewTwo", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class ThreeViews
        extends State {
            @NotNull
            private final MediaAttachmentView viewOne;
            @NotNull
            private final MediaAttachmentView viewTwo;
            @NotNull
            private final MediaAttachmentView viewThree;

            public ThreeViews(@NotNull MediaAttachmentView viewOne, @NotNull MediaAttachmentView viewTwo, @NotNull MediaAttachmentView viewThree) {
                Intrinsics.checkNotNullParameter((Object)((Object)viewOne), (String)"viewOne");
                Intrinsics.checkNotNullParameter((Object)((Object)viewTwo), (String)"viewTwo");
                Intrinsics.checkNotNullParameter((Object)((Object)viewThree), (String)"viewThree");
                super(null);
                this.viewOne = viewOne;
                this.viewTwo = viewTwo;
                this.viewThree = viewThree;
            }

            @NotNull
            public final MediaAttachmentView getViewOne() {
                return this.viewOne;
            }

            @NotNull
            public final MediaAttachmentView getViewTwo() {
                return this.viewTwo;
            }

            @NotNull
            public final MediaAttachmentView getViewThree() {
                return this.viewThree;
            }

            @NotNull
            public final MediaAttachmentView component1() {
                return this.viewOne;
            }

            @NotNull
            public final MediaAttachmentView component2() {
                return this.viewTwo;
            }

            @NotNull
            public final MediaAttachmentView component3() {
                return this.viewThree;
            }

            @NotNull
            public final ThreeViews copy(@NotNull MediaAttachmentView viewOne, @NotNull MediaAttachmentView viewTwo, @NotNull MediaAttachmentView viewThree) {
                Intrinsics.checkNotNullParameter((Object)((Object)viewOne), (String)"viewOne");
                Intrinsics.checkNotNullParameter((Object)((Object)viewTwo), (String)"viewTwo");
                Intrinsics.checkNotNullParameter((Object)((Object)viewThree), (String)"viewThree");
                return new ThreeViews(viewOne, viewTwo, viewThree);
            }

            public static /* synthetic */ ThreeViews copy$default(ThreeViews threeViews, MediaAttachmentView mediaAttachmentView, MediaAttachmentView mediaAttachmentView2, MediaAttachmentView mediaAttachmentView3, int n, Object object) {
                if ((n & 1) != 0) {
                    mediaAttachmentView = threeViews.viewOne;
                }
                if ((n & 2) != 0) {
                    mediaAttachmentView2 = threeViews.viewTwo;
                }
                if ((n & 4) != 0) {
                    mediaAttachmentView3 = threeViews.viewThree;
                }
                return threeViews.copy(mediaAttachmentView, mediaAttachmentView2, mediaAttachmentView3);
            }

            @NotNull
            public String toString() {
                return "ThreeViews(viewOne=" + this.viewOne + ", viewTwo=" + this.viewTwo + ", viewThree=" + this.viewThree + ")";
            }

            public int hashCode() {
                int result2 = this.viewOne.hashCode();
                result2 = result2 * 31 + this.viewTwo.hashCode();
                result2 = result2 * 31 + this.viewThree.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ThreeViews)) {
                    return false;
                }
                ThreeViews threeViews = (ThreeViews)other;
                if (!Intrinsics.areEqual((Object)((Object)this.viewOne), (Object)((Object)threeViews.viewOne))) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)((Object)this.viewTwo), (Object)((Object)threeViews.viewTwo))) {
                    return false;
                }
                return Intrinsics.areEqual((Object)((Object)this.viewThree), (Object)((Object)threeViews.viewThree));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State$TwoViews;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentsGroupView$State;", "viewOne", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;", "viewTwo", "(Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;)V", "getViewOne", "()Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/MediaAttachmentView;", "getViewTwo", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class TwoViews
        extends State {
            @NotNull
            private final MediaAttachmentView viewOne;
            @NotNull
            private final MediaAttachmentView viewTwo;

            public TwoViews(@NotNull MediaAttachmentView viewOne, @NotNull MediaAttachmentView viewTwo) {
                Intrinsics.checkNotNullParameter((Object)((Object)viewOne), (String)"viewOne");
                Intrinsics.checkNotNullParameter((Object)((Object)viewTwo), (String)"viewTwo");
                super(null);
                this.viewOne = viewOne;
                this.viewTwo = viewTwo;
            }

            @NotNull
            public final MediaAttachmentView getViewOne() {
                return this.viewOne;
            }

            @NotNull
            public final MediaAttachmentView getViewTwo() {
                return this.viewTwo;
            }

            @NotNull
            public final MediaAttachmentView component1() {
                return this.viewOne;
            }

            @NotNull
            public final MediaAttachmentView component2() {
                return this.viewTwo;
            }

            @NotNull
            public final TwoViews copy(@NotNull MediaAttachmentView viewOne, @NotNull MediaAttachmentView viewTwo) {
                Intrinsics.checkNotNullParameter((Object)((Object)viewOne), (String)"viewOne");
                Intrinsics.checkNotNullParameter((Object)((Object)viewTwo), (String)"viewTwo");
                return new TwoViews(viewOne, viewTwo);
            }

            public static /* synthetic */ TwoViews copy$default(TwoViews twoViews, MediaAttachmentView mediaAttachmentView, MediaAttachmentView mediaAttachmentView2, int n, Object object) {
                if ((n & 1) != 0) {
                    mediaAttachmentView = twoViews.viewOne;
                }
                if ((n & 2) != 0) {
                    mediaAttachmentView2 = twoViews.viewTwo;
                }
                return twoViews.copy(mediaAttachmentView, mediaAttachmentView2);
            }

            @NotNull
            public String toString() {
                return "TwoViews(viewOne=" + this.viewOne + ", viewTwo=" + this.viewTwo + ")";
            }

            public int hashCode() {
                int result2 = this.viewOne.hashCode();
                result2 = result2 * 31 + this.viewTwo.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TwoViews)) {
                    return false;
                }
                TwoViews twoViews = (TwoViews)other;
                if (!Intrinsics.areEqual((Object)((Object)this.viewOne), (Object)((Object)twoViews.viewOne))) {
                    return false;
                }
                return Intrinsics.areEqual((Object)((Object)this.viewTwo), (Object)((Object)twoViews.viewTwo));
            }
        }
    }
}

