/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal;

import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.audio.AudioPlayer;
import io.getstream.chat.android.client.audio.AudioState;
import io.getstream.chat.android.client.audio.ProgressData;
import io.getstream.chat.android.client.extensions.AttachmentExtensionsKt;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.common.utils.DurationFormatter;
import io.getstream.chat.android.ui.common.utils.MediaStringUtil;
import io.getstream.chat.android.ui.databinding.StreamUiItemRecordingAttachmentBinding;
import io.getstream.chat.android.ui.feature.messages.list.FileAttachmentViewStyle;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.AttachmentClickListener;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.AttachmentDownloadClickListener;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.AttachmentLongClickListener;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.AudioRecordPlayerView;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.FileAttachmentViewHolder;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.RecordingFileAttachmentViewHolder;
import io.getstream.chat.android.ui.feature.messages.list.background.ShapeAppearanceModelFactory;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.utils.AttachmentUtilsKt;
import io.getstream.chat.android.uiutils.extension.AttachmentKt;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J \u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u001f\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u0018H\u0002J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010*\u001a\u00020\u0018H\u0016J\u0014\u0010+\u001a\u00020\u0018*\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u001c\u0010/\u001a\u00020\u0018*\u00020.2\u0006\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020\"H\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/RecordingFileAttachmentViewHolder;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/FileAttachmentViewHolder;", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiItemRecordingAttachmentBinding;", "attachmentClickListener", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentClickListener;", "attachmentLongClickListener", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentLongClickListener;", "attachmentDownloadClickListener", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentDownloadClickListener;", "style", "Lio/getstream/chat/android/ui/feature/messages/list/FileAttachmentViewStyle;", "(Lio/getstream/chat/android/ui/databinding/StreamUiItemRecordingAttachmentBinding;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentClickListener;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentLongClickListener;Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AttachmentDownloadClickListener;Lio/getstream/chat/android/ui/feature/messages/list/FileAttachmentViewStyle;)V", "attachment", "Lio/getstream/chat/android/models/Attachment;", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "bind", "", "item", "clearScope", "handleInProgressAttachment", "fileSizeView", "Landroid/widget/TextView;", "bytesRead", "", "totalBytes", "progressToDecimal", "", "progress", "totalDuration", "", "(ILjava/lang/Float;)I", "restartJob", "setupBackground", "subscribeForProgressIfNeeded", "unbind", "registerButtonsListeners", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/AudioRecordPlayerView;", "audioPlayer", "Lio/getstream/chat/android/client/audio/AudioPlayer;", "registerStateChange", "playerView", "hashCode", "Companion", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nFileAttachmentsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileAttachmentsView.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/RecordingFileAttachmentViewHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 4 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,535:1\n1#2:536\n303#3,4:537\n262#4,2:541\n262#4,2:543\n262#4,2:545\n*S KotlinDebug\n*F\n+ 1 FileAttachmentsView.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/RecordingFileAttachmentViewHolder\n*L\n466#1:537,4\n477#1:541,2\n478#1:543,2\n505#1:545,2\n*E\n"})
final class RecordingFileAttachmentViewHolder
extends FileAttachmentViewHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StreamUiItemRecordingAttachmentBinding binding;
    @NotNull
    private final FileAttachmentViewStyle style;
    @NotNull
    private final Lazy logger$delegate;
    @Nullable
    private Attachment attachment;
    @Nullable
    private CoroutineScope scope;
    private static final float NULL_DURATION = 0.0f;

    public RecordingFileAttachmentViewHolder(@NotNull StreamUiItemRecordingAttachmentBinding binding2, @Nullable AttachmentClickListener attachmentClickListener2, @Nullable AttachmentLongClickListener attachmentLongClickListener, @Nullable AttachmentDownloadClickListener attachmentDownloadClickListener2, @NotNull FileAttachmentViewStyle style2) {
        Object listener;
        Intrinsics.checkNotNullParameter((Object)binding2, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        FrameLayout frameLayout = binding2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"getRoot(...)");
        super((View)frameLayout, null);
        this.binding = binding2;
        this.style = style2;
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"RecordingAttachmentVH");
        AttachmentClickListener attachmentClickListener3 = attachmentClickListener2;
        if (attachmentClickListener3 != null) {
            listener = attachmentClickListener3;
            boolean bl = false;
            this.binding.getRoot().setOnClickListener(arg_0 -> RecordingFileAttachmentViewHolder.lambda$1$lambda$0(this, (AttachmentClickListener)listener, arg_0));
        }
        AttachmentLongClickListener attachmentLongClickListener2 = attachmentLongClickListener;
        if (attachmentLongClickListener2 != null) {
            listener = attachmentLongClickListener2;
            boolean bl = false;
            this.binding.getRoot().setOnLongClickListener(arg_0 -> RecordingFileAttachmentViewHolder.lambda$3$lambda$2((AttachmentLongClickListener)listener, arg_0));
        }
        AttachmentDownloadClickListener attachmentDownloadClickListener3 = attachmentDownloadClickListener2;
        if (attachmentDownloadClickListener3 != null) {
            listener = attachmentDownloadClickListener3;
            boolean bl = false;
            this.binding.actionButton.setOnClickListener(arg_0 -> RecordingFileAttachmentViewHolder.lambda$6$lambda$5(this, (AttachmentDownloadClickListener)listener, arg_0));
        }
        AudioPlayer audioPlayer = ChatClient.Companion.instance().getAudioPlayer();
        AudioRecordPlayerView audioRecordPlayerView = this.binding.playerView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)audioRecordPlayerView), (String)"playerView");
        this.registerButtonsListeners(audioRecordPlayerView, audioPlayer);
        this.binding.getRoot().setBackground((Drawable)ShapeAppearanceModelFactory.INSTANCE.fileBackground(this.getContext()));
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @Override
    public void clearScope() {
        CoroutineScope coroutineScope = this.scope;
        if (coroutineScope != null) {
            CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope, null, (int)1, null);
        }
        this.scope = null;
    }

    private final void registerStateChange(AudioPlayer $this$registerStateChange, AudioRecordPlayerView playerView, int hashCode) {
        $this$registerStateChange.registerOnAudioStateChange(hashCode, (Function1)new Function1<AudioState, Unit>(this, playerView){
            final /* synthetic */ RecordingFileAttachmentViewHolder this$0;
            final /* synthetic */ AudioRecordPlayerView $playerView;
            {
                this.this$0 = $receiver;
                this.$playerView = $playerView;
                super(1);
            }

            public final void invoke(@NotNull AudioState audioState) {
                Intrinsics.checkNotNullParameter((Object)audioState, (String)"audioState");
                TaggedLogger this_$iv = RecordingFileAttachmentViewHolder.access$getLogger(this.this$0);
                boolean $i$f$d = false;
                if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                    String string2 = this_$iv.getTag();
                    Priority priority = Priority.DEBUG;
                    StreamLogger streamLogger = this_$iv.getDelegate();
                    boolean bl = false;
                    String string3 = "[onAudioStateChange] audioState: " + audioState;
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                }
                switch (registerStateChange.WhenMappings.$EnumSwitchMapping$0[audioState.ordinal()]) {
                    case 1: {
                        this.$playerView.setLoading();
                        break;
                    }
                    case 2: {
                        this.$playerView.setPaused();
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.$playerView.setIdle();
                        break;
                    }
                    case 5: {
                        this.$playerView.setPlaying();
                    }
                }
            }
        });
        $this$registerStateChange.registerOnProgressStateChange(hashCode, (Function1)new Function1<ProgressData, Unit>(playerView){
            final /* synthetic */ AudioRecordPlayerView $playerView;
            {
                this.$playerView = $playerView;
                super(1);
            }

            public final void invoke(@NotNull ProgressData progressData) {
                Intrinsics.checkNotNullParameter((Object)progressData, (String)"<name for destructuring parameter 0>");
                int duration = progressData.component1();
                float progress = progressData.component2();
                this.$playerView.setDuration(DurationFormatter.INSTANCE.formatDurationInMillis(duration));
                this.$playerView.setProgress(progress);
            }
        });
        $this$registerStateChange.registerOnSpeedChange(hashCode, (Function1)new Function1<Float, Unit>((Object)playerView){

            public final void invoke(float p0) {
                ((AudioRecordPlayerView)((Object)this.receiver)).setSpeedText(p0);
            }
        });
    }

    private final void registerButtonsListeners(AudioRecordPlayerView $this$registerButtonsListeners, AudioPlayer audioPlayer) {
        $this$registerButtonsListeners.setOnPlayButtonClickListener((Function0<Unit>)((Function0)new Function0<Unit>(this, audioPlayer, $this$registerButtonsListeners){
            final /* synthetic */ RecordingFileAttachmentViewHolder this$0;
            final /* synthetic */ AudioPlayer $audioPlayer;
            final /* synthetic */ AudioRecordPlayerView $this_registerButtonsListeners;
            {
                this.this$0 = $receiver;
                this.$audioPlayer = $audioPlayer;
                this.$this_registerButtonsListeners = $receiver2;
                super(0);
            }

            public final void invoke() {
                Attachment attachment = RecordingFileAttachmentViewHolder.access$getAttachment$p(this.this$0);
                String assetUrl2 = attachment != null ? attachment.getAssetUrl() : null;
                Attachment attachment2 = RecordingFileAttachmentViewHolder.access$getAttachment$p(this.this$0);
                int audioHash = attachment2 != null ? attachment2.hashCode() : 0;
                TaggedLogger this_$iv = RecordingFileAttachmentViewHolder.access$getLogger(this.this$0);
                boolean $i$f$d = false;
                if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                    String string2 = this_$iv.getTag();
                    Priority priority = Priority.DEBUG;
                    StreamLogger streamLogger = this_$iv.getDelegate();
                    boolean bl = false;
                    String string3 = "[onPlayButtonClick] audioHash: " + audioHash + ", assetUrl: " + assetUrl2;
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                }
                if (assetUrl2 != null) {
                    this.$audioPlayer.play(assetUrl2, audioHash);
                } else {
                    this.$this_registerButtonsListeners.setLoading();
                }
            }
        }));
        $this$registerButtonsListeners.setOnSpeedButtonClickListener((Function0<Unit>)((Function0)new Function0<Unit>(audioPlayer){
            final /* synthetic */ AudioPlayer $audioPlayer;
            {
                this.$audioPlayer = $audioPlayer;
                super(0);
            }

            public final void invoke() {
                this.$audioPlayer.changeSpeed();
            }
        }));
        $this$registerButtonsListeners.setOnSeekbarMoveListeners((Function0<Unit>)((Function0)new Function0<Unit>(this, audioPlayer){
            final /* synthetic */ RecordingFileAttachmentViewHolder this$0;
            final /* synthetic */ AudioPlayer $audioPlayer;
            {
                this.this$0 = $receiver;
                this.$audioPlayer = $audioPlayer;
                super(0);
            }

            public final void invoke() {
                Attachment attachment = RecordingFileAttachmentViewHolder.access$getAttachment$p(this.this$0);
                int hash = attachment != null ? attachment.hashCode() : 0;
                this.$audioPlayer.startSeek(hash);
            }
        }), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, audioPlayer){
            final /* synthetic */ RecordingFileAttachmentViewHolder this$0;
            final /* synthetic */ AudioPlayer $audioPlayer;
            {
                this.this$0 = $receiver;
                this.$audioPlayer = $audioPlayer;
                super(1);
            }

            public final void invoke(int progress) {
                Attachment attachment = RecordingFileAttachmentViewHolder.access$getAttachment$p(this.this$0);
                int hash = attachment != null ? attachment.hashCode() : 0;
                Attachment attachment2 = RecordingFileAttachmentViewHolder.access$getAttachment$p(this.this$0);
                this.$audioPlayer.seekTo(RecordingFileAttachmentViewHolder.access$progressToDecimal(this.this$0, progress, attachment2 != null ? AttachmentExtensionsKt.getDuration((Attachment)attachment2) : null), hash);
            }
        }));
    }

    private final int progressToDecimal(int progress, Float totalDuration) {
        Float f = totalDuration;
        return progress * (int)(f != null ? f.floatValue() : 0.0f) / 100;
    }

    private final void setupBackground() {
        MaterialShapeDrawable bgShapeDrawable;
        MaterialShapeDrawable materialShapeDrawable;
        ShapeAppearanceModel shapeAppearanceModel = new ShapeAppearanceModel.Builder().setAllCorners(0, (float)this.style.getCornerRadius()).build();
        Intrinsics.checkNotNullExpressionValue((Object)shapeAppearanceModel, (String)"build(...)");
        ShapeAppearanceModel shapeAppearanceModel2 = shapeAppearanceModel;
        MaterialShapeDrawable $this$setupBackground_u24lambda_u247 = materialShapeDrawable = (bgShapeDrawable = new MaterialShapeDrawable(shapeAppearanceModel2));
        boolean bl = false;
        $this$setupBackground_u24lambda_u247.setFillColor(ColorStateList.valueOf((int)this.style.getBackgroundColor()));
        $this$setupBackground_u24lambda_u247.setStrokeColor(ColorStateList.valueOf((int)this.style.getStrokeColor()));
        $this$setupBackground_u24lambda_u247.setStrokeWidth((float)this.style.getStrokeWidth());
        this.binding.getRoot().setBackground((Drawable)bgShapeDrawable);
    }

    @Override
    public void restartJob() {
        block0: {
            Attachment attachment = this.attachment;
            if (attachment == null) break block0;
            Attachment p0 = attachment;
            boolean bl = false;
            this.subscribeForProgressIfNeeded(p0);
        }
    }

    private final void subscribeForProgressIfNeeded(Attachment attachment) {
        Attachment.UploadState uploadState = attachment.getUploadState();
        if (uploadState instanceof Attachment.UploadState.Idle) {
            TextView textView = this.binding.fileSize;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"fileSize");
            File file = attachment.getUpload();
            this.handleInProgressAttachment(textView, 0L, file != null ? file.length() : 0L);
        } else if (uploadState instanceof Attachment.UploadState.InProgress) {
            TextView textView = this.binding.fileSize;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"fileSize");
            this.handleInProgressAttachment(textView, ((Attachment.UploadState.InProgress)uploadState).getBytesUploaded(), ((Attachment.UploadState.InProgress)uploadState).getTotalBytes());
        }
    }

    @Override
    public void bind(@NotNull Attachment item) {
        Object $this$isVisible$iv;
        boolean bl;
        Object it;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Object this_$iv = this.getLogger();
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl2 = false;
            String string3 = "[bind] item: " + item;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.attachment = item;
        Object $this$bind_u24lambda_u2414 = this_$iv = this.binding;
        boolean bl3 = false;
        TextView textView = $this$bind_u24lambda_u2414.fileTitle;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"fileTitle");
        TextStyleKt.setTextStyle(textView, this.style.getTitleTextStyle());
        TextView textView2 = $this$bind_u24lambda_u2414.fileSize;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"fileSize");
        TextStyleKt.setTextStyle(textView2, this.style.getFileSizeTextStyle());
        ImageView imageView = $this$bind_u24lambda_u2414.fileTypeIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"fileTypeIcon");
        AttachmentUtilsKt.loadAttachmentThumb(imageView, item);
        $this$bind_u24lambda_u2414.fileTitle.setText((CharSequence)this.getContext().getString(R.string.stream_ui_attachment_list_recording));
        Attachment.UploadState uploadState = item.getUploadState();
        if (uploadState != null) {
            it = uploadState;
            boolean bl4 = false;
            bl = it instanceof Attachment.UploadState.Success;
        } else {
            bl = true;
        }
        boolean isSuccess = bl;
        ConstraintLayout constraintLayout = $this$bind_u24lambda_u2414.uploadingContainer;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"uploadingContainer");
        View view = (View)constraintLayout;
        boolean value$iv = !isSuccess;
        boolean $i$f$setVisible3 = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        AudioRecordPlayerView audioRecordPlayerView = $this$bind_u24lambda_u2414.playerView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)audioRecordPlayerView), (String)"playerView");
        $this$isVisible$iv = (View)audioRecordPlayerView;
        boolean $i$f$setVisible22 = false;
        $this$isVisible$iv.setVisibility(isSuccess ? 0 : 8);
        $this$isVisible$iv = AttachmentExtensionsKt.getDuration((Attachment)item);
        if ($this$isVisible$iv != null) {
            Object $i$f$setVisible3 = $this$isVisible$iv;
            it = DurationFormatter.INSTANCE;
            float p0 = ((Number)$i$f$setVisible3).floatValue();
            boolean bl5 = false;
            String $i$f$setVisible22 = it.formatDurationInSeconds(p0);
            if ($i$f$setVisible22 != null) {
                $i$f$setVisible3 = $i$f$setVisible22;
                AudioRecordPlayerView audioRecordPlayerView2 = $this$bind_u24lambda_u2414.playerView;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)audioRecordPlayerView2), (String)"playerView");
                it = audioRecordPlayerView2;
                Object p02 = $i$f$setVisible3;
                boolean bl6 = false;
                ((AudioRecordPlayerView)((Object)it)).setDuration((String)p02);
            }
        }
        List list = AttachmentExtensionsKt.getWaveformData((Attachment)item);
        if (list != null) {
            List $i$f$setVisible22;
            List it2 = $i$f$setVisible22 = list;
            boolean bl7 = false;
            $this$bind_u24lambda_u2414.playerView.setWaveBars(it2);
        }
        if (item.getUploadState() instanceof Attachment.UploadState.Idle || item.getUploadState() instanceof Attachment.UploadState.InProgress || item.getUploadState() instanceof Attachment.UploadState.Success && item.getFileSize() == 0) {
            $this$bind_u24lambda_u2414.actionButton.setVisibility(8);
            File file = item.getUpload();
            $this$bind_u24lambda_u2414.fileSize.setText((CharSequence)MediaStringUtil.convertFileSizeByteCount((long)(file != null ? file.length() : 0L)));
        } else if (item.getUploadState() instanceof Attachment.UploadState.Failed || item.getFileSize() == 0) {
            $this$bind_u24lambda_u2414.actionButton.setVisibility(0);
            $this$bind_u24lambda_u2414.actionButton.setImageDrawable(this.style.getFailedAttachmentIcon());
            Float f = AttachmentExtensionsKt.getDuration((Attachment)item);
            $this$bind_u24lambda_u2414.fileSize.setText((CharSequence)DurationFormatter.INSTANCE.formatDurationInSeconds(f != null ? f.floatValue() : 0.0f));
        } else {
            $this$bind_u24lambda_u2414.actionButton.setVisibility(8);
            $this$bind_u24lambda_u2414.actionButton.setImageDrawable(this.style.getActionButtonIcon());
            Float f = AttachmentExtensionsKt.getDuration((Attachment)item);
            $this$bind_u24lambda_u2414.fileSize.setText((CharSequence)DurationFormatter.INSTANCE.formatDurationInSeconds(f != null ? f.floatValue() : 0.0f));
        }
        this.binding.progressBar.setIndeterminateDrawable(this.style.getProgressBarDrawable());
        ProgressBar progressBar = this.binding.progressBar;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"progressBar");
        $this$isVisible$iv = (View)progressBar;
        value$iv = item.getUploadState() instanceof Attachment.UploadState.InProgress;
        boolean $i$f$setVisible4 = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        this.subscribeForProgressIfNeeded(item);
        this.setupBackground();
        AudioPlayer audioPlayer = ChatClient.Companion.instance().getAudioPlayer();
        AudioRecordPlayerView audioRecordPlayerView3 = this.binding.playerView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)audioRecordPlayerView3), (String)"playerView");
        this.registerStateChange(audioPlayer, audioRecordPlayerView3, item.hashCode());
    }

    private final void handleInProgressAttachment(TextView fileSizeView, long bytesRead, long totalBytes) {
        String totalValue = MediaStringUtil.convertFileSizeByteCount((long)totalBytes);
        Object[] objectArray = new Object[]{MediaStringUtil.convertFileSizeByteCount((long)bytesRead), totalValue};
        fileSizeView.setText((CharSequence)this.getContext().getString(R.string.stream_ui_message_list_attachment_upload_progress, objectArray));
    }

    @Override
    public void unbind() {
        this.clearScope();
        super.unbind();
    }

    private static final void lambda$1$lambda$0(RecordingFileAttachmentViewHolder this$0, AttachmentClickListener $listener, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
            Attachment attachment = this$0.attachment;
            if (attachment == null) break block0;
            Attachment p0 = attachment;
            boolean bl = false;
            $listener.onAttachmentClick(p0);
        }
    }

    private static final boolean lambda$3$lambda$2(AttachmentLongClickListener $listener, View it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.onAttachmentLongClick();
        return true;
    }

    private static final void lambda$6$lambda$5(RecordingFileAttachmentViewHolder this$0, AttachmentDownloadClickListener $listener, View it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
            Attachment attachment = this$0.attachment;
            boolean bl = attachment != null ? AttachmentKt.isFailed((Attachment)attachment) : false;
            if (bl) {
                return;
            }
            Attachment attachment2 = this$0.attachment;
            if (attachment2 == null) break block1;
            Attachment p0 = attachment2;
            boolean bl2 = false;
            $listener.onAttachmentDownloadClick(p0);
        }
    }

    public static final /* synthetic */ TaggedLogger access$getLogger(RecordingFileAttachmentViewHolder $this) {
        return $this.getLogger();
    }

    public static final /* synthetic */ Attachment access$getAttachment$p(RecordingFileAttachmentViewHolder $this) {
        return $this.attachment;
    }

    public static final /* synthetic */ int access$progressToDecimal(RecordingFileAttachmentViewHolder $this, int progress, Float totalDuration) {
        return $this.progressToDecimal(progress, totalDuration);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/RecordingFileAttachmentViewHolder$Companion;", "", "()V", "NULL_DURATION", "", "stream-chat-android-ui-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

