/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.core.content.ContextCompat;
import io.getstream.chat.android.extensions.FloatExtensionsKt;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.feature.messages.list.adapter.view.internal.WaveformView;
import io.getstream.chat.android.ui.utils.extensions.IntKt;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010E\u001a\u00020(2\u0006\u0010F\u001a\u00020\rJ\u0006\u0010G\u001a\u00020(J\u0010\u0010H\u001a\u00020(2\u0006\u00106\u001a\u00020\rH\u0002J\u0010\u0010I\u001a\u00020(2\u0006\u0010J\u001a\u00020KH\u0014J\u0012\u0010L\u001a\u00020\u00182\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\u0018\u0010O\u001a\u00020(2\u0006\u0010P\u001a\u00020\t2\u0006\u0010Q\u001a\u00020\tH\u0014J\u0010\u0010R\u001a\u00020\u00182\u0006\u0010S\u001a\u00020NH\u0016J!\u0010T\u001a\u00020(2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020(0'H\u0000\u00a2\u0006\u0002\bVJ\u001b\u0010W\u001a\u00020(2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020(02H\u0000\u00a2\u0006\u0002\bXJ\u0010\u0010Y\u001a\u00020(2\b\b\u0001\u0010Z\u001a\u00020\tJ\u0015\u0010[\u001a\u00020(2\u0006\u00106\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\\R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u0012\u0010$\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010%R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020(0'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020(0'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R&\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020(0'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020(02X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00106\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010=\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010>\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010@\u001a\b\u0012\u0004\u0012\u00020\r0?2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0?8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006]"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/WaveformView;", "Landroidx/appcompat/widget/LinearLayoutCompat;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "_waveform", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "barHeightRatio", "barLimit", "barRect", "Landroid/graphics/RectF;", "barSpacing", "", "barWidth", "Ljava/lang/Float;", "isDragging", "", "value", "isSliderVisible", "()Z", "setSliderVisible", "(Z)V", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "maxHeight", "Ljava/lang/Integer;", "onEndDrag", "Lkotlin/Function1;", "", "onSliderDragStart", "getOnSliderDragStart", "()Lkotlin/jvm/functions/Function1;", "setOnSliderDragStart", "(Lkotlin/jvm/functions/Function1;)V", "onSliderDragStop", "getOnSliderDragStop", "setOnSliderDragStop", "onStartDrag", "Lkotlin/Function0;", "paintPassed", "Landroid/graphics/Paint;", "paintUpcoming", "progress", "getProgress", "()F", "setProgress", "(F)V", "slider", "Landroid/widget/ImageView;", "spaceWidth", "viewportRect", "", "waveform", "getWaveform", "()Ljava/util/List;", "setWaveform", "(Ljava/util/List;)V", "addValue", "normalized", "clearData", "forceProgress", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "event", "setOnEndDrag", "func", "setOnEndDrag$stream_chat_android_ui_components_release", "setOnStartDrag", "setOnStartDrag$stream_chat_android_ui_components_release", "setWaveformColor", "color", "updateProgress", "updateProgress$stream_chat_android_ui_components_release", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nWaveformView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaveformView.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/WaveformView\n+ 2 View.kt\nandroidx/core/view/ViewKt\n+ 3 StreamLog.kt\nio/getstream/log/TaggedLogger\n*L\n1#1,307:1\n262#2,2:308\n262#2,2:314\n315#2:320\n329#2,4:321\n316#2:325\n315#2:326\n329#2,4:327\n316#2:331\n314#3,4:310\n281#3,4:316\n*S KotlinDebug\n*F\n+ 1 WaveformView.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/view/internal/WaveformView\n*L\n75#1:308,2\n127#1:314,2\n208#1:320\n208#1:321,4\n208#1:325\n225#1:326\n225#1:327,4\n225#1:331\n119#1:310,4\n145#1:316,4\n*E\n"})
public final class WaveformView
extends LinearLayoutCompat {
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final ImageView slider;
    private int barLimit;
    @Nullable
    private Float barWidth;
    @Nullable
    private Float spaceWidth;
    @Nullable
    private Integer maxHeight;
    private final double barSpacing;
    private float barHeightRatio;
    @NotNull
    private Function0<Unit> onStartDrag;
    @NotNull
    private Function1<? super Integer, Unit> onEndDrag;
    private boolean isDragging;
    @NotNull
    private Function1<? super Float, Unit> onSliderDragStart;
    @NotNull
    private Function1<? super Float, Unit> onSliderDragStop;
    @NotNull
    private final Paint paintPassed;
    @NotNull
    private final Paint paintUpcoming;
    @NotNull
    private final ArrayList<Float> _waveform;
    private float progress;
    @NotNull
    private final RectF viewportRect;
    @NotNull
    private final RectF barRect;

    /*
     * WARNING - void declaration
     */
    public WaveformView(@NotNull Context context) {
        void $this$paintUpcoming_u24lambda_u242;
        ImageView $this$paintPassed_u24lambda_u241;
        void $this$isVisible$iv;
        ImageView $this$_init__u24lambda_u240;
        ImageView imageView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"WaveformView");
        this.setOrientation(0);
        ImageView imageView2 = imageView = new ImageView(this.getContext());
        WaveformView waveformView = this;
        boolean bl = false;
        $i$a$-apply-WaveformView$1 = false;
        $i$a$-apply-WaveformView$1 = false;
        $this$_init__u24lambda_u240.setBackgroundResource(R.drawable.stream_ui_share_rectangle);
        View view = (View)$this$_init__u24lambda_u240;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        waveformView.slider = imageView;
        LinearLayoutCompat.LayoutParams layoutParamsButton = new LinearLayoutCompat.LayoutParams(-2, -1);
        this.addView((View)this.slider, (ViewGroup.LayoutParams)layoutParamsButton);
        this.setWillNotDraw(false);
        this.barLimit = 100;
        this.barSpacing = 0.4;
        this.barHeightRatio = 0.9f;
        this.onStartDrag = onStartDrag.1.INSTANCE;
        this.onEndDrag = onEndDrag.1.INSTANCE;
        this.onSliderDragStart = onSliderDragStart.1.INSTANCE;
        this.onSliderDragStop = onSliderDragStop.1.INSTANCE;
        $this$_init__u24lambda_u240 = imageView = new Paint();
        waveformView = this;
        boolean bl2 = false;
        $i$a$-apply-WaveformView$paintPassed$1 = false;
        $i$a$-apply-WaveformView$paintPassed$1 = false;
        $this$paintPassed_u24lambda_u241.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stream_ui_accent_blue));
        $this$paintPassed_u24lambda_u241.setStyle(Paint.Style.FILL);
        waveformView.paintPassed = imageView;
        $this$paintPassed_u24lambda_u241 = imageView = new Paint();
        waveformView = this;
        boolean bl3 = false;
        $i$a$-apply-WaveformView$paintUpcoming$1 = false;
        $i$a$-apply-WaveformView$paintUpcoming$1 = false;
        $this$paintUpcoming_u24lambda_u242.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stream_ui_grey));
        $this$paintUpcoming_u24lambda_u242.setStyle(Paint.Style.FILL);
        waveformView.paintUpcoming = imageView;
        this._waveform = new ArrayList();
        this.viewportRect = new RectF();
        this.barRect = new RectF();
    }

    /*
     * WARNING - void declaration
     */
    public WaveformView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void $this$paintUpcoming_u24lambda_u242;
        ImageView $this$paintPassed_u24lambda_u241;
        void $this$isVisible$iv;
        ImageView $this$_init__u24lambda_u240;
        ImageView imageView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"WaveformView");
        this.setOrientation(0);
        ImageView imageView2 = imageView = new ImageView(this.getContext());
        WaveformView waveformView = this;
        boolean bl = false;
        $i$a$-apply-WaveformView$1 = false;
        $i$a$-apply-WaveformView$1 = false;
        $this$_init__u24lambda_u240.setBackgroundResource(R.drawable.stream_ui_share_rectangle);
        View view = (View)$this$_init__u24lambda_u240;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        waveformView.slider = imageView;
        LinearLayoutCompat.LayoutParams layoutParamsButton = new LinearLayoutCompat.LayoutParams(-2, -1);
        this.addView((View)this.slider, (ViewGroup.LayoutParams)layoutParamsButton);
        this.setWillNotDraw(false);
        this.barLimit = 100;
        this.barSpacing = 0.4;
        this.barHeightRatio = 0.9f;
        this.onStartDrag = onStartDrag.1.INSTANCE;
        this.onEndDrag = onEndDrag.1.INSTANCE;
        this.onSliderDragStart = onSliderDragStart.1.INSTANCE;
        this.onSliderDragStop = onSliderDragStop.1.INSTANCE;
        $this$_init__u24lambda_u240 = imageView = new Paint();
        waveformView = this;
        boolean bl2 = false;
        $i$a$-apply-WaveformView$paintPassed$1 = false;
        $i$a$-apply-WaveformView$paintPassed$1 = false;
        $this$paintPassed_u24lambda_u241.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stream_ui_accent_blue));
        $this$paintPassed_u24lambda_u241.setStyle(Paint.Style.FILL);
        waveformView.paintPassed = imageView;
        $this$paintPassed_u24lambda_u241 = imageView = new Paint();
        waveformView = this;
        boolean bl3 = false;
        $i$a$-apply-WaveformView$paintUpcoming$1 = false;
        $i$a$-apply-WaveformView$paintUpcoming$1 = false;
        $this$paintUpcoming_u24lambda_u242.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stream_ui_grey));
        $this$paintUpcoming_u24lambda_u242.setStyle(Paint.Style.FILL);
        waveformView.paintUpcoming = imageView;
        this._waveform = new ArrayList();
        this.viewportRect = new RectF();
        this.barRect = new RectF();
    }

    /*
     * WARNING - void declaration
     */
    public WaveformView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$paintUpcoming_u24lambda_u242;
        ImageView $this$paintPassed_u24lambda_u241;
        void $this$isVisible$iv;
        ImageView $this$_init__u24lambda_u240;
        ImageView imageView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"WaveformView");
        this.setOrientation(0);
        ImageView imageView2 = imageView = new ImageView(this.getContext());
        WaveformView waveformView = this;
        boolean bl = false;
        $i$a$-apply-WaveformView$1 = false;
        $i$a$-apply-WaveformView$1 = false;
        $this$_init__u24lambda_u240.setBackgroundResource(R.drawable.stream_ui_share_rectangle);
        View view = (View)$this$_init__u24lambda_u240;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        waveformView.slider = imageView;
        LinearLayoutCompat.LayoutParams layoutParamsButton = new LinearLayoutCompat.LayoutParams(-2, -1);
        this.addView((View)this.slider, (ViewGroup.LayoutParams)layoutParamsButton);
        this.setWillNotDraw(false);
        this.barLimit = 100;
        this.barSpacing = 0.4;
        this.barHeightRatio = 0.9f;
        this.onStartDrag = onStartDrag.1.INSTANCE;
        this.onEndDrag = onEndDrag.1.INSTANCE;
        this.onSliderDragStart = onSliderDragStart.1.INSTANCE;
        this.onSliderDragStop = onSliderDragStop.1.INSTANCE;
        $this$_init__u24lambda_u240 = imageView = new Paint();
        waveformView = this;
        boolean bl2 = false;
        $i$a$-apply-WaveformView$paintPassed$1 = false;
        $i$a$-apply-WaveformView$paintPassed$1 = false;
        $this$paintPassed_u24lambda_u241.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stream_ui_accent_blue));
        $this$paintPassed_u24lambda_u241.setStyle(Paint.Style.FILL);
        waveformView.paintPassed = imageView;
        $this$paintPassed_u24lambda_u241 = imageView = new Paint();
        waveformView = this;
        boolean bl3 = false;
        $i$a$-apply-WaveformView$paintUpcoming$1 = false;
        $i$a$-apply-WaveformView$paintUpcoming$1 = false;
        $this$paintUpcoming_u24lambda_u242.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stream_ui_grey));
        $this$paintUpcoming_u24lambda_u242.setStyle(Paint.Style.FILL);
        waveformView.paintUpcoming = imageView;
        this._waveform = new ArrayList();
        this.viewportRect = new RectF();
        this.barRect = new RectF();
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @NotNull
    public final Function1<Float, Unit> getOnSliderDragStart() {
        return this.onSliderDragStart;
    }

    public final void setOnSliderDragStart(@NotNull Function1<? super Float, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onSliderDragStart = function1;
    }

    @NotNull
    public final Function1<Float, Unit> getOnSliderDragStop() {
        return this.onSliderDragStop;
    }

    public final void setOnSliderDragStop(@NotNull Function1<? super Float, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onSliderDragStop = function1;
    }

    public final void setWaveformColor(@ColorInt int color2) {
        this.paintPassed.setColor(color2);
    }

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float value) {
        TaggedLogger this_$iv = this.getLogger();
        boolean $i$f$v = false;
        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.VERBOSE;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[setProgress] progress: " + value;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.progress = value;
        this.invalidate();
    }

    public final boolean isSliderVisible() {
        return this.slider.getVisibility() == 0;
    }

    public final void setSliderVisible(boolean value) {
        View $this$isVisible$iv = (View)this.slider;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value ? 0 : 8);
    }

    @NotNull
    public final List<Float> getWaveform() {
        return this._waveform;
    }

    public final void setWaveform(@NotNull List<Float> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this._waveform.clear();
        this._waveform.addAll((Collection<Float>)value);
        this.invalidate();
    }

    public final void clearData() {
        this._waveform.clear();
        this.invalidate();
    }

    public final void addValue(float normalized) {
        if (normalized > 1.0f || normalized < 0.0f) {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[addValue] rejected (Normalized value must be between 0 and 1): " + normalized;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            return;
        }
        this._waveform.add(Float.valueOf(normalized));
        this.invalidate();
    }

    public final void updateProgress$stream_chat_android_ui_components_release(float progress) {
        if (!this.isDragging) {
            this.setProgress(progress);
            this.invalidate();
        }
    }

    private final void forceProgress(float progress) {
        this.setProgress(progress);
        this.invalidate();
    }

    public final void setOnStartDrag$stream_chat_android_ui_components_release(@NotNull Function0<Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        this.onStartDrag = func;
    }

    public final void setOnEndDrag$stream_chat_android_ui_components_release(@NotNull Function1<? super Integer, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        this.onEndDrag = func;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        RectF rectF;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int viewportWidth = this.getMeasuredWidth() - this.getPaddingStart() - this.getPaddingEnd();
        double totalBarWidth = (double)viewportWidth * (1.0 - this.barSpacing);
        double totalSpaceWidth = (double)viewportWidth * this.barSpacing;
        int barCount = this._waveform.size();
        this.barWidth = Float.valueOf((float)totalBarWidth / (float)barCount);
        this.spaceWidth = Float.valueOf((float)totalSpaceWidth / (float)barCount);
        this.maxHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        RectF $this$onMeasure_u24lambda_u245 = rectF = this.viewportRect;
        boolean bl = false;
        $this$onMeasure_u24lambda_u245.left = this.getPaddingStart();
        $this$onMeasure_u24lambda_u245.right = this.getMeasuredWidth() - this.getPaddingEnd();
        $this$onMeasure_u24lambda_u245.top = this.getPaddingTop();
        $this$onMeasure_u24lambda_u245.bottom = this.getMeasuredHeight() - this.getPaddingBottom();
    }

    public boolean onInterceptTouchEvent(@Nullable MotionEvent ev) {
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        switch (event.getAction()) {
            case 0: {
                ViewGroup.LayoutParams params$iv$iv;
                this.isDragging = true;
                View $this$updateLayoutParams$iv = (View)this.slider;
                boolean $i$f$updateLayoutParams = false;
                View $this$updateLayoutParams$iv$iv = $this$updateLayoutParams$iv;
                boolean $i$f$updateLayoutParamsTyped = false;
                ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv$iv.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
                }
                ViewGroup.LayoutParams $this$onTouchEvent_u24lambda_u246 = params$iv$iv = layoutParams;
                boolean bl2 = false;
                $this$onTouchEvent_u24lambda_u246.width += IntKt.dpToPx(10);
                $this$updateLayoutParams$iv$iv.setLayoutParams(params$iv$iv);
                this.setProgress(event.getX() / this.viewportRect.width());
                this.onSliderDragStart.invoke((Object)Float.valueOf(this.progress));
                bl = true;
                break;
            }
            case 2: {
                this.setProgress(event.getX() / this.viewportRect.width());
                bl = true;
                break;
            }
            case 1: 
            case 3: {
                ViewGroup.LayoutParams params$iv$iv;
                this.setProgress(event.getX() / this.viewportRect.width());
                this.onSliderDragStop.invoke((Object)Float.valueOf(this.progress));
                this.isDragging = false;
                View $this$updateLayoutParams$iv = (View)this.slider;
                boolean $i$f$updateLayoutParams = false;
                View $this$updateLayoutParams$iv$iv = $this$updateLayoutParams$iv;
                boolean $i$f$updateLayoutParamsTyped = false;
                ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv$iv.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
                }
                ViewGroup.LayoutParams $this$onTouchEvent_u24lambda_u247 = params$iv$iv = layoutParams;
                boolean bl3 = false;
                $this$onTouchEvent_u24lambda_u247.width -= IntKt.dpToPx(10);
                $this$updateLayoutParams$iv$iv.setLayoutParams(params$iv$iv);
                bl = true;
                break;
            }
            default: {
                bl = super.onTouchEvent(event);
            }
        }
        return bl;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        float viewportW = this.viewportRect.width();
        float perBarW = viewportW / (float)this.barLimit;
        float spacerW = perBarW * 0.3f;
        float barW = perBarW - spacerW;
        float maxBarHeight = this.viewportRect.height();
        float centerY = (float)this.getHeight() / 2.0f;
        int maxEnd = this.getWidth() - this.getPaddingEnd();
        int minStart = this.getPaddingStart();
        int minVisibleIndex = Math.max(this._waveform.size() - this.barLimit, 0);
        float progressX = viewportW * this.progress;
        float deltaX = 0.0f;
        int index = CollectionsKt.getLastIndex((List)this._waveform);
        if (minVisibleIndex <= index) {
            while (true) {
                float rx;
                Float f = this._waveform.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)f, (String)"get(...)");
                float value = ((Number)f).floatValue();
                float barHeight = Math.max(maxBarHeight * value, barW);
                int relativeIndex = index - minVisibleIndex;
                float top = centerY - barHeight / (float)2;
                float bottom = centerY + barHeight / (float)2;
                float start = (float)minStart + perBarW * (float)relativeIndex;
                float end = start + barW;
                float ry = rx = barW / 2.0f;
                this.barRect.set(start, top, end, bottom);
                if (this.barRect.left < (float)minStart) {
                    this.barRect.left = minStart;
                } else if (this.barRect.right > (float)maxEnd) {
                    this.barRect.right = maxEnd;
                }
                boolean passed = !this.isSliderVisible() || this.barRect.centerX() < progressX;
                canvas.drawRoundRect(this.barRect, rx, ry, passed ? this.paintPassed : this.paintUpcoming);
                if (index == minVisibleIndex) break;
                --index;
            }
        }
        float sliderX = progressX - (float)this.slider.getWidth() / 2.0f;
        float finalSliderX = FloatExtensionsKt.limitTo((float)sliderX, (float)this.viewportRect.left, (float)(this.viewportRect.right - (float)this.slider.getWidth()));
        this.slider.setTranslationX(finalSliderX);
    }
}

