/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.adapter.viewholder.attachment;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.ui.databinding.StreamUiUnsupportedAttachmentViewBinding;
import io.getstream.chat.android.ui.feature.messages.list.UnsupportedAttachmentViewStyle;
import io.getstream.chat.android.ui.feature.messages.list.adapter.MessageListListenerContainer;
import io.getstream.chat.android.ui.feature.messages.list.adapter.MessageListListeners;
import io.getstream.chat.android.ui.feature.messages.list.adapter.viewholder.attachment.AttachmentFactory;
import io.getstream.chat.android.ui.feature.messages.list.adapter.viewholder.attachment.InnerAttachmentViewHolder;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.uiutils.extension.AttachmentKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u0004*\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/viewholder/attachment/UnsupportedAttachmentFactory;", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/viewholder/attachment/AttachmentFactory;", "()V", "canHandle", "", "message", "Lio/getstream/chat/android/models/Message;", "createViewHolder", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/viewholder/attachment/InnerAttachmentViewHolder;", "listeners", "Lio/getstream/chat/android/ui/feature/messages/list/adapter/MessageListListeners;", "parent", "Landroid/view/ViewGroup;", "isSupported", "Lio/getstream/chat/android/models/Attachment;", "Companion", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nUnsupportedAttachmentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsupportedAttachmentFactory.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/viewholder/attachment/UnsupportedAttachmentFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1726#2,3:107\n*S KotlinDebug\n*F\n+ 1 UnsupportedAttachmentFactory.kt\nio/getstream/chat/android/ui/feature/messages/list/adapter/viewholder/attachment/UnsupportedAttachmentFactory\n*L\n48#1:107,3\n*E\n"})
public final class UnsupportedAttachmentFactory
implements AttachmentFactory {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> SUPPORTED_ATTACHMENT_TYPES;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canHandle(@NotNull Message message) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (((Collection)message.getAttachments()).isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = message.getAttachments();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            Attachment it = (Attachment)element$iv;
            boolean bl3 = false;
            if (AttachmentKt.hasLink((Attachment)it)) return false;
            if (this.isSupported(it)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InnerAttachmentViewHolder createViewHolder(@NotNull Message message, @Nullable MessageListListeners listeners, @NotNull ViewGroup parent) {
        void $this$createViewHolder_u24lambda_u241;
        MaterialShapeDrawable materialShapeDrawable;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        StreamUiUnsupportedAttachmentViewBinding streamUiUnsupportedAttachmentViewBinding = StreamUiUnsupportedAttachmentViewBinding.inflate(ContextKt.getStreamThemeInflater(context), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiUnsupportedAttachmentViewBinding, (String)"inflate(...)");
        StreamUiUnsupportedAttachmentViewBinding binding2 = streamUiUnsupportedAttachmentViewBinding;
        Context context2 = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        UnsupportedAttachmentViewStyle style2 = UnsupportedAttachmentViewStyle.Companion.invoke(context2, null);
        ShapeAppearanceModel shapeAppearanceModel = new ShapeAppearanceModel.Builder().setAllCorners(0, (float)style2.getCornerRadius()).build();
        Intrinsics.checkNotNullExpressionValue((Object)shapeAppearanceModel, (String)"build(...)");
        ShapeAppearanceModel shapeAppearanceModel2 = shapeAppearanceModel;
        MaterialShapeDrawable materialShapeDrawable2 = materialShapeDrawable = new MaterialShapeDrawable(shapeAppearanceModel2);
        ConstraintLayout constraintLayout = binding2.attachmentContainer;
        boolean bl = false;
        $this$createViewHolder_u24lambda_u241.setFillColor(ColorStateList.valueOf((int)style2.getBackgroundColor()));
        $this$createViewHolder_u24lambda_u241.setStrokeColor(ColorStateList.valueOf((int)style2.getStrokeColor()));
        $this$createViewHolder_u24lambda_u241.setStrokeWidth((float)style2.getStrokeWidth());
        constraintLayout.setBackground((Drawable)materialShapeDrawable);
        TextView textView = binding2.titleImageView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"titleImageView");
        TextStyleKt.setTextStyle(textView, style2.getTitleTextStyle());
        materialShapeDrawable = binding2.getRoot();
        return new InnerAttachmentViewHolder((ConstraintLayout)materialShapeDrawable){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super((View)$super_call_param$1);
            }
        };
    }

    private final boolean isSupported(Attachment $this$isSupported) {
        return CollectionsKt.contains((Iterable)SUPPORTED_ATTACHMENT_TYPES, (Object)$this$isSupported.getType());
    }

    @Override
    @Deprecated(message="Use createViewHolder(message: Message, listeners: MessageListListeners?, parent: ViewGroup) instead", replaceWith=@ReplaceWith(expression="createViewHolder(message, listeners, parent)", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public InnerAttachmentViewHolder createViewHolder(@NotNull Message message, @Nullable MessageListListenerContainer listeners, @NotNull ViewGroup parent) {
        return AttachmentFactory.DefaultImpls.createViewHolder((AttachmentFactory)this, message, listeners, parent);
    }

    static {
        Object[] objectArray = new String[]{"image", "giphy", "video", "audio", "file", "link", "voiceRecording"};
        SUPPORTED_ATTACHMENT_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/adapter/viewholder/attachment/UnsupportedAttachmentFactory$Companion;", "", "()V", "SUPPORTED_ATTACHMENT_TYPES", "", "", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

