/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.options.message;

import android.content.Context;
import android.graphics.drawable.Drawable;
import io.getstream.chat.android.client.utils.attachment.AttachmentUtilsKt;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.models.SyncStatus;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.common.state.messages.Copy;
import io.getstream.chat.android.ui.common.state.messages.Delete;
import io.getstream.chat.android.ui.common.state.messages.Edit;
import io.getstream.chat.android.ui.common.state.messages.Flag;
import io.getstream.chat.android.ui.common.state.messages.MarkAsUnread;
import io.getstream.chat.android.ui.common.state.messages.MessageAction;
import io.getstream.chat.android.ui.common.state.messages.Pin;
import io.getstream.chat.android.ui.common.state.messages.Reply;
import io.getstream.chat.android.ui.common.state.messages.Resend;
import io.getstream.chat.android.ui.common.state.messages.ThreadReply;
import io.getstream.chat.android.ui.feature.messages.list.MessageListViewStyle;
import io.getstream.chat.android.ui.feature.messages.list.options.message.MessageOptionItem;
import io.getstream.chat.android.ui.feature.messages.list.options.message.MessageOptionItemsFactory;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.uiutils.extension.AttachmentKt;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/options/message/DefaultMessageOptionItemsFactory;", "Lio/getstream/chat/android/ui/feature/messages/list/options/message/MessageOptionItemsFactory;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "createMessageOptionItems", "", "Lio/getstream/chat/android/ui/feature/messages/list/options/message/MessageOptionItem;", "selectedMessage", "Lio/getstream/chat/android/models/Message;", "currentUser", "Lio/getstream/chat/android/models/User;", "isInThread", "", "ownCapabilities", "", "", "style", "Lio/getstream/chat/android/ui/feature/messages/list/MessageListViewStyle;", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nMessageOptionItemsFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageOptionItemsFactory.kt\nio/getstream/chat/android/ui/feature/messages/list/options/message/DefaultMessageOptionItemsFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1747#2,3:219\n*S KotlinDebug\n*F\n+ 1 MessageOptionItemsFactory.kt\nio/getstream/chat/android/ui/feature/messages/list/options/message/DefaultMessageOptionItemsFactory\n*L\n108#1:219,3\n*E\n"})
public class DefaultMessageOptionItemsFactory
implements MessageOptionItemsFactory {
    @NotNull
    private final Context context;

    public DefaultMessageOptionItemsFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @NotNull
    public List<MessageOptionItem> createMessageOptionItems(@NotNull Message selectedMessage, @Nullable User currentUser, boolean isInThread, @NotNull Set<String> ownCapabilities, @NotNull MessageListViewStyle style2) {
        MessageOptionItem messageOptionItem;
        MessageOptionItem messageOptionItem2;
        MessageOptionItem messageOptionItem3;
        MessageOptionItem messageOptionItem4;
        MessageOptionItem messageOptionItem5;
        MessageOptionItem messageOptionItem6;
        MessageOptionItem messageOptionItem7;
        MessageOptionItem messageOptionItem8;
        MessageOptionItem messageOptionItem9;
        boolean bl;
        boolean isTextOnlyMessage;
        String selectedMessageUserId;
        block22: {
            Intrinsics.checkNotNullParameter((Object)selectedMessage, (String)"selectedMessage");
            Intrinsics.checkNotNullParameter(ownCapabilities, (String)"ownCapabilities");
            Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
            if (((CharSequence)selectedMessage.getId()).length() == 0) {
                return CollectionsKt.emptyList();
            }
            selectedMessageUserId = selectedMessage.getUser().getId();
            isTextOnlyMessage = ((CharSequence)selectedMessage.getText()).length() > 0 && selectedMessage.getAttachments().isEmpty();
            Iterable $this$any$iv = selectedMessage.getAttachments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Attachment it = (Attachment)element$iv;
                    boolean bl2 = false;
                    if (!(AttachmentKt.hasLink((Attachment)it) && !AttachmentUtilsKt.isGiphy((Attachment)it))) continue;
                    bl = true;
                    break block22;
                }
                bl = false;
            }
        }
        boolean hasLinks = bl;
        User user = currentUser;
        boolean isOwnMessage = Intrinsics.areEqual((Object)selectedMessageUserId, (Object)(user != null ? user.getId() : null));
        boolean isMessageSynced = selectedMessage.getSyncStatus() == SyncStatus.COMPLETED;
        boolean isMessageFailed = selectedMessage.getSyncStatus() == SyncStatus.FAILED_PERMANENTLY;
        boolean canQuoteMessage = ownCapabilities.contains("quote-message");
        boolean canThreadReply = ownCapabilities.contains("send-reply");
        boolean canPinMessage = ownCapabilities.contains("pin-message");
        boolean canDeleteOwnMessage = ownCapabilities.contains("delete-own-message");
        boolean canDeleteAnyMessage = ownCapabilities.contains("delete-any-message");
        boolean canEditOwnMessage = ownCapabilities.contains("update-own-message");
        boolean canEditAnyMessage = ownCapabilities.contains("update-any-message");
        boolean canMarkAsUnread = ownCapabilities.contains("read-events");
        boolean canFlagMessage = ownCapabilities.contains("flag-message");
        Object[] objectArray = new MessageOptionItem[9];
        if (style2.getRetryMessageEnabled() && isOwnMessage && isMessageFailed) {
            String string2 = this.context.getString(R.string.stream_ui_message_list_resend_message);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            Drawable drawable2 = ContextKt.getDrawableCompat(this.context, style2.getRetryIcon());
            Intrinsics.checkNotNull((Object)drawable2);
            messageOptionItem9 = new MessageOptionItem(string2, drawable2, (MessageAction)new Resend(selectedMessage), false, 8, null);
        } else {
            messageOptionItem9 = objectArray[0] = null;
        }
        if (style2.getReplyEnabled() && isMessageSynced && canQuoteMessage) {
            String string3 = this.context.getString(R.string.stream_ui_message_list_reply);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            Drawable drawable3 = ContextKt.getDrawableCompat(this.context, style2.getReplyIcon());
            Intrinsics.checkNotNull((Object)drawable3);
            messageOptionItem8 = new MessageOptionItem(string3, drawable3, (MessageAction)new Reply(selectedMessage), false, 8, null);
        } else {
            messageOptionItem8 = objectArray[1] = null;
        }
        if (style2.getThreadsEnabled() && !isInThread && isMessageSynced && canThreadReply) {
            String string4 = this.context.getString(R.string.stream_ui_message_list_thread_reply);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            Drawable drawable4 = ContextKt.getDrawableCompat(this.context, style2.getThreadReplyIcon());
            Intrinsics.checkNotNull((Object)drawable4);
            messageOptionItem7 = new MessageOptionItem(string4, drawable4, (MessageAction)new ThreadReply(selectedMessage), false, 8, null);
        } else {
            messageOptionItem7 = objectArray[2] = null;
        }
        if (style2.getMarkAsUnreadEnabled() && canMarkAsUnread) {
            String string5 = this.context.getString(R.string.stream_ui_message_list_mark_as_unread);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
            Drawable drawable5 = ContextKt.getDrawableCompat(this.context, style2.getMarkAsUnreadIcon());
            Intrinsics.checkNotNull((Object)drawable5);
            messageOptionItem6 = new MessageOptionItem(string5, drawable5, (MessageAction)new MarkAsUnread(selectedMessage), false, 8, null);
        } else {
            messageOptionItem6 = objectArray[3] = null;
        }
        if (style2.getCopyTextEnabled() && (isTextOnlyMessage || hasLinks)) {
            String string6 = this.context.getString(R.string.stream_ui_message_list_copy_message);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(...)");
            Drawable drawable6 = ContextKt.getDrawableCompat(this.context, style2.getCopyIcon());
            Intrinsics.checkNotNull((Object)drawable6);
            messageOptionItem5 = new MessageOptionItem(string6, drawable6, (MessageAction)new Copy(selectedMessage), false, 8, null);
        } else {
            messageOptionItem5 = objectArray[4] = null;
        }
        if (style2.getEditMessageEnabled() && (isOwnMessage && canEditOwnMessage || canEditAnyMessage) && !Intrinsics.areEqual((Object)selectedMessage.getCommand(), (Object)"giphy")) {
            String string7 = this.context.getString(R.string.stream_ui_message_list_edit_message);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getString(...)");
            Drawable drawable7 = ContextKt.getDrawableCompat(this.context, style2.getEditIcon());
            Intrinsics.checkNotNull((Object)drawable7);
            messageOptionItem4 = new MessageOptionItem(string7, drawable7, (MessageAction)new Edit(selectedMessage), false, 8, null);
        } else {
            messageOptionItem4 = objectArray[5] = null;
        }
        if (style2.getFlagEnabled() && canFlagMessage && !isOwnMessage) {
            String string8 = this.context.getString(R.string.stream_ui_message_list_flag_message);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getString(...)");
            Drawable drawable8 = ContextKt.getDrawableCompat(this.context, style2.getFlagIcon());
            Intrinsics.checkNotNull((Object)drawable8);
            messageOptionItem3 = new MessageOptionItem(string8, drawable8, (MessageAction)new Flag(selectedMessage), false, 8, null);
        } else {
            messageOptionItem3 = objectArray[6] = null;
        }
        if (style2.getPinMessageEnabled() && isMessageSynced && canPinMessage) {
            Pair pair = selectedMessage.getPinned() ? TuplesKt.to((Object)R.string.stream_ui_message_list_unpin_message, (Object)style2.getUnpinIcon()) : TuplesKt.to((Object)R.string.stream_ui_message_list_pin_message, (Object)style2.getPinIcon());
            int pinText = ((Number)pair.component1()).intValue();
            int pinIcon = ((Number)pair.component2()).intValue();
            String string9 = this.context.getString(pinText);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getString(...)");
            Drawable drawable9 = ContextKt.getDrawableCompat(this.context, pinIcon);
            Intrinsics.checkNotNull((Object)drawable9);
            messageOptionItem2 = new MessageOptionItem(string9, drawable9, (MessageAction)new Pin(selectedMessage), false, 8, null);
        } else {
            messageOptionItem2 = objectArray[7] = null;
        }
        if (style2.getDeleteMessageEnabled() && (canDeleteAnyMessage || isOwnMessage && canDeleteOwnMessage)) {
            String string10 = this.context.getString(R.string.stream_ui_message_list_delete_message);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getString(...)");
            Drawable drawable10 = ContextKt.getDrawableCompat(this.context, style2.getDeleteIcon());
            Intrinsics.checkNotNull((Object)drawable10);
            messageOptionItem = new MessageOptionItem(string10, drawable10, (MessageAction)new Delete(selectedMessage), true);
        } else {
            messageOptionItem = null;
        }
        objectArray[8] = messageOptionItem;
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }
}

