/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.reactions.edit.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.models.Reaction;
import io.getstream.chat.android.ui.ChatUI;
import io.getstream.chat.android.ui.feature.messages.list.reactions.ReactionClickListener;
import io.getstream.chat.android.ui.feature.messages.list.reactions.edit.EditReactionsViewStyle;
import io.getstream.chat.android.ui.feature.messages.list.reactions.edit.internal.EditReactionsBubbleDrawer;
import io.getstream.chat.android.ui.feature.messages.list.reactions.internal.ReactionItem;
import io.getstream.chat.android.ui.feature.messages.list.reactions.internal.ReactionsAdapter;
import io.getstream.chat.android.ui.helper.SupportedReactions;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.IntKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalStreamChatApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001cJ\u001a\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0015\u0010!\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\"J\u0016\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010&\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/reactions/edit/internal/EditReactionsView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "bubbleDrawer", "Lio/getstream/chat/android/ui/feature/messages/list/reactions/edit/internal/EditReactionsBubbleDrawer;", "bubbleHeight", "isMyMessage", "", "messageAnchorPosition", "", "reactionClickListener", "Lio/getstream/chat/android/ui/feature/messages/list/reactions/ReactionClickListener;", "reactionsAdapter", "Lio/getstream/chat/android/ui/feature/messages/list/reactions/internal/ReactionsAdapter;", "reactionsColumns", "reactionsViewStyle", "Lio/getstream/chat/android/ui/feature/messages/list/reactions/edit/EditReactionsViewStyle;", "applyStyle", "", "editReactionsViewStyle", "applyStyle$stream_chat_android_ui_components_release", "init", "onDraw", "canvas", "Landroid/graphics/Canvas;", "positionBubbleTail", "positionBubbleTail$stream_chat_android_ui_components_release", "setMessage", "message", "Lio/getstream/chat/android/models/Message;", "setReactionClickListener", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nEditReactionsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditReactionsView.kt\nio/getstream/chat/android/ui/feature/messages/list/reactions/edit/internal/EditReactionsView\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n125#2:150\n152#2,2:151\n154#2:156\n1747#3,3:153\n1#4:157\n*S KotlinDebug\n*F\n+ 1 EditReactionsView.kt\nio/getstream/chat/android/ui/feature/messages/list/reactions/edit/internal/EditReactionsView\n*L\n71#1:150\n71#1:151,2\n71#1:156\n74#1:153,3\n*E\n"})
public final class EditReactionsView
extends RecyclerView {
    private EditReactionsViewStyle reactionsViewStyle;
    private ReactionsAdapter reactionsAdapter;
    private EditReactionsBubbleDrawer bubbleDrawer;
    @Nullable
    private ReactionClickListener reactionClickListener;
    private boolean isMyMessage;
    private float messageAnchorPosition;
    private int bubbleHeight;
    private int reactionsColumns;

    public EditReactionsView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context));
        this.reactionsColumns = 5;
        this.init(context, null);
    }

    public EditReactionsView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs);
        this.reactionsColumns = 5;
        this.init(context, attrs);
    }

    public EditReactionsView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr);
        this.reactionsColumns = 5;
        this.init(context, attrs);
    }

    /*
     * WARNING - void declaration
     */
    public final void setMessage(@NotNull Message message, boolean isMyMessage) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.isMyMessage = isMyMessage;
        Map<String, SupportedReactions.ReactionDrawable> $this$map$iv = ChatUI.getSupportedReactions().getReactions();
        boolean $i$f$map = false;
        Map<String, SupportedReactions.ReactionDrawable> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            String string2;
            SupportedReactions.ReactionDrawable reactionDrawable;
            Collection collection;
            block6: {
                void $this$any$iv;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                String type2 = (String)entry.getKey();
                reactionDrawable = (SupportedReactions.ReactionDrawable)entry.getValue();
                Iterable iterable = message.getOwnReactions();
                string2 = type2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Reaction it = (Reaction)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)type2)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean bl4 = bl;
            SupportedReactions.ReactionDrawable reactionDrawable2 = reactionDrawable;
            boolean bl5 = bl4;
            String string3 = string2;
            collection.add(new ReactionItem(string3, bl5, reactionDrawable2));
        }
        List reactionItems = (List)destination$iv$iv;
        if (reactionItems.size() > this.reactionsColumns) {
            int timesBigger = (int)Math.ceil((float)reactionItems.size() / (float)this.reactionsColumns);
            this.bubbleHeight *= timesBigger;
        }
        this.setMinimumHeight(this.bubbleHeight + IntKt.dpToPx(16));
        ReactionsAdapter reactionsAdapter = this.reactionsAdapter;
        if (reactionsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reactionsAdapter");
            reactionsAdapter = null;
        }
        reactionsAdapter.submitList(reactionItems);
    }

    public final void setReactionClickListener(@NotNull ReactionClickListener reactionClickListener) {
        Intrinsics.checkNotNullParameter((Object)reactionClickListener, (String)"reactionClickListener");
        this.reactionClickListener = reactionClickListener;
    }

    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        int canvasWidth = this.getWidth();
        int bubbleDrawOffset = IntKt.dpToPx(12);
        int boundsEnd = canvasWidth - bubbleDrawOffset;
        IntRange canvasBounds = new IntRange(bubbleDrawOffset, boundsEnd);
        EditReactionsBubbleDrawer editReactionsBubbleDrawer = this.bubbleDrawer;
        if (editReactionsBubbleDrawer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bubbleDrawer");
            editReactionsBubbleDrawer = null;
        }
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        editReactionsBubbleDrawer.drawReactionsBubble(context, canvas, this.getWidth(), this.bubbleHeight, this.isMyMessage, true, this.messageAnchorPosition, canvasBounds);
    }

    private final void init(Context context, AttributeSet attrs) {
        EditReactionsViewStyle style2 = EditReactionsViewStyle.Companion.invoke$stream_chat_android_ui_components_release(context, attrs);
        this.applyStyle$stream_chat_android_ui_components_release(style2);
        this.bubbleHeight = style2.getBubbleHeight();
        this.setItemAnimator(null);
        this.setOverScrollMode(2);
        this.setWillNotDraw(false);
    }

    /*
     * WARNING - void declaration
     */
    public final void applyStyle$stream_chat_android_ui_components_release(@NotNull EditReactionsViewStyle editReactionsViewStyle) {
        void it;
        ReactionsAdapter reactionsAdapter;
        Intrinsics.checkNotNullParameter((Object)editReactionsViewStyle, (String)"editReactionsViewStyle");
        this.reactionsViewStyle = editReactionsViewStyle;
        EditReactionsViewStyle editReactionsViewStyle2 = this.reactionsViewStyle;
        if (editReactionsViewStyle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reactionsViewStyle");
            editReactionsViewStyle2 = null;
        }
        this.bubbleDrawer = new EditReactionsBubbleDrawer(editReactionsViewStyle2);
        this.reactionsColumns = Math.min(ChatUI.getSupportedReactions().getReactions().size(), editReactionsViewStyle.getReactionsColumn());
        EditReactionsViewStyle editReactionsViewStyle3 = this.reactionsViewStyle;
        if (editReactionsViewStyle3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reactionsViewStyle");
            editReactionsViewStyle3 = null;
        }
        int n = editReactionsViewStyle3.getHorizontalPadding();
        EditReactionsViewStyle editReactionsViewStyle4 = this.reactionsViewStyle;
        if (editReactionsViewStyle4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reactionsViewStyle");
            editReactionsViewStyle4 = null;
        }
        int n2 = editReactionsViewStyle4.getVerticalPadding();
        EditReactionsViewStyle editReactionsViewStyle5 = this.reactionsViewStyle;
        if (editReactionsViewStyle5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reactionsViewStyle");
            editReactionsViewStyle5 = null;
        }
        int n3 = editReactionsViewStyle5.getHorizontalPadding();
        EditReactionsViewStyle editReactionsViewStyle6 = this.reactionsViewStyle;
        if (editReactionsViewStyle6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reactionsViewStyle");
            editReactionsViewStyle6 = null;
        }
        this.setPadding(n, n2, n3, editReactionsViewStyle6.getVerticalPadding());
        this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), this.reactionsColumns));
        EditReactionsViewStyle editReactionsViewStyle7 = this.reactionsViewStyle;
        if (editReactionsViewStyle7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reactionsViewStyle");
            editReactionsViewStyle7 = null;
        }
        ReactionsAdapter reactionsAdapter2 = reactionsAdapter = new ReactionsAdapter(editReactionsViewStyle7.getItemSize(), arg_0 -> EditReactionsView.applyStyle$lambda$2(this, arg_0));
        EditReactionsView editReactionsView = this;
        boolean bl = false;
        this.reactionsAdapter = it;
        editReactionsView.setAdapter((RecyclerView.Adapter)reactionsAdapter);
    }

    public final void positionBubbleTail$stream_chat_android_ui_components_release(float messageAnchorPosition) {
        this.messageAnchorPosition = messageAnchorPosition;
        this.requestLayout();
    }

    private static final void applyStyle$lambda$2(EditReactionsView this$0, String it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ReactionClickListener reactionClickListener = this$0.reactionClickListener;
            if (reactionClickListener == null) break block0;
            reactionClickListener.onReactionClick(it);
        }
    }
}

