/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.reactions.user.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.getstream.chat.android.ui.databinding.StreamUiItemMessageReactionBinding;
import io.getstream.chat.android.ui.feature.messages.list.reactions.user.SingleReactionViewStyle;
import io.getstream.chat.android.ui.feature.messages.list.reactions.user.internal.SingleReactionViewBubbleDrawer;
import io.getstream.chat.android.ui.feature.messages.list.reactions.user.internal.UserReactionItem;
import io.getstream.chat.android.ui.feature.messages.list.reactions.view.MessageOptionsUserReactionOrientation;
import io.getstream.chat.android.ui.feature.messages.list.reactions.view.MessageOptionsUserReactionOrientationKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/reactions/user/internal/SingleReactionView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiItemMessageReactionBinding;", "bubbleDrawer", "Lio/getstream/chat/android/ui/feature/messages/list/reactions/user/internal/SingleReactionViewBubbleDrawer;", "isMyMessage", "", "messageOrientation", "Lio/getstream/chat/android/ui/feature/messages/list/reactions/view/MessageOptionsUserReactionOrientation;", "getMessageOrientation", "()Lio/getstream/chat/android/ui/feature/messages/list/reactions/view/MessageOptionsUserReactionOrientation;", "reactionsViewStyle", "Lio/getstream/chat/android/ui/feature/messages/list/reactions/user/SingleReactionViewStyle;", "init", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "setReaction", "userReactionItem", "Lio/getstream/chat/android/ui/feature/messages/list/reactions/user/internal/UserReactionItem;", "stream-chat-android-ui-components_release"})
public final class SingleReactionView
extends FrameLayout {
    @NotNull
    private final StreamUiItemMessageReactionBinding binding;
    private SingleReactionViewStyle reactionsViewStyle;
    private SingleReactionViewBubbleDrawer bubbleDrawer;
    private boolean isMyMessage;

    private final MessageOptionsUserReactionOrientation getMessageOrientation() {
        SingleReactionViewStyle singleReactionViewStyle = this.reactionsViewStyle;
        if (singleReactionViewStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reactionsViewStyle");
            singleReactionViewStyle = null;
        }
        return MessageOptionsUserReactionOrientationKt.getUserReactionOrientation(singleReactionViewStyle.getReactionOrientation());
    }

    public SingleReactionView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context));
        StreamUiItemMessageReactionBinding streamUiItemMessageReactionBinding = StreamUiItemMessageReactionBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiItemMessageReactionBinding, (String)"inflate(...)");
        this.binding = streamUiItemMessageReactionBinding;
        this.init(context, null);
    }

    public SingleReactionView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs);
        StreamUiItemMessageReactionBinding streamUiItemMessageReactionBinding = StreamUiItemMessageReactionBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiItemMessageReactionBinding, (String)"inflate(...)");
        this.binding = streamUiItemMessageReactionBinding;
        this.init(context, attrs);
    }

    public SingleReactionView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr);
        StreamUiItemMessageReactionBinding streamUiItemMessageReactionBinding = StreamUiItemMessageReactionBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiItemMessageReactionBinding, (String)"inflate(...)");
        this.binding = streamUiItemMessageReactionBinding;
        this.init(context, attrs);
    }

    public final void setReaction(@NotNull UserReactionItem userReactionItem) {
        Intrinsics.checkNotNullParameter((Object)userReactionItem, (String)"userReactionItem");
        this.isMyMessage = userReactionItem.isMine();
        this.binding.reactionIcon.setImageDrawable(userReactionItem.getDrawable());
        this.invalidate();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        boolean isOrientedTowardsStart = MessageOptionsUserReactionOrientationKt.isOrientedTowardsStart(this.getMessageOrientation(), this.isMyMessage);
        SingleReactionViewBubbleDrawer singleReactionViewBubbleDrawer = this.bubbleDrawer;
        if (singleReactionViewBubbleDrawer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bubbleDrawer");
            singleReactionViewBubbleDrawer = null;
        }
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        singleReactionViewBubbleDrawer.drawReactionsBubble(context, canvas, this.getWidth(), this.isMyMessage, isOrientedTowardsStart);
    }

    private final void init(Context context, AttributeSet attrs) {
        this.reactionsViewStyle = SingleReactionViewStyle.Companion.invoke(context, attrs);
        SingleReactionViewStyle singleReactionViewStyle = this.reactionsViewStyle;
        if (singleReactionViewStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reactionsViewStyle");
            singleReactionViewStyle = null;
        }
        this.bubbleDrawer = new SingleReactionViewBubbleDrawer(singleReactionViewStyle);
        this.setWillNotDraw(false);
        SingleReactionViewStyle singleReactionViewStyle2 = this.reactionsViewStyle;
        if (singleReactionViewStyle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reactionsViewStyle");
            singleReactionViewStyle2 = null;
        }
        this.setMinimumHeight(singleReactionViewStyle2.getTotalHeight());
    }
}

