/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.list.reactions.user.internal;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.models.Reaction;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.ui.ChatUI;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.common.state.messages.list.MessageOptionsUserReactionAlignmentKt;
import io.getstream.chat.android.ui.databinding.StreamUiUserReactionsViewBinding;
import io.getstream.chat.android.ui.feature.messages.list.MessageListViewStyle;
import io.getstream.chat.android.ui.feature.messages.list.reactions.user.internal.UserReactionAdapter;
import io.getstream.chat.android.ui.feature.messages.list.reactions.user.internal.UserReactionItem;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.helper.SupportedReactions;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.MessageKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalStreamChatApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0015\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0016\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0015\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/reactions/user/internal/UserReactionsView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiUserReactionsViewBinding;", "gridLayoutManager", "Landroidx/recyclerview/widget/GridLayoutManager;", "userReactionClickListener", "Lio/getstream/chat/android/ui/feature/messages/list/reactions/user/internal/UserReactionsView$UserReactionClickListener;", "userReactionsAdapter", "Lio/getstream/chat/android/ui/feature/messages/list/reactions/user/internal/UserReactionAdapter;", "bindReactionList", "", "message", "Lio/getstream/chat/android/models/Message;", "currentUser", "Lio/getstream/chat/android/models/User;", "bindTitle", "configure", "messageListViewStyle", "Lio/getstream/chat/android/ui/feature/messages/list/MessageListViewStyle;", "configure$stream_chat_android_ui_components_release", "setMessage", "setOnUserReactionClickListener", "setOnUserReactionClickListener$stream_chat_android_ui_components_release", "Companion", "UserReactionClickListener", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nUserReactionsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserReactionsView.kt\nio/getstream/chat/android/ui/feature/messages/list/reactions/user/internal/UserReactionsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1603#2,9:116\n1855#2:125\n1856#2:127\n1612#2:128\n1#3:126\n*S KotlinDebug\n*F\n+ 1 UserReactionsView.kt\nio/getstream/chat/android/ui/feature/messages/list/reactions/user/internal/UserReactionsView\n*L\n88#1:116,9\n88#1:125\n88#1:127\n88#1:128\n88#1:126\n*E\n"})
public final class UserReactionsView
extends FrameLayout {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final StreamUiUserReactionsViewBinding binding;
    @NotNull
    private final UserReactionAdapter userReactionsAdapter;
    @NotNull
    private final GridLayoutManager gridLayoutManager;
    @Nullable
    private UserReactionClickListener userReactionClickListener;
    private static final int MAX_COLUMNS_COUNT = 4;

    public UserReactionsView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0);
    }

    public UserReactionsView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public UserReactionsView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr);
        StreamUiUserReactionsViewBinding streamUiUserReactionsViewBinding = StreamUiUserReactionsViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiUserReactionsViewBinding, (String)"inflate(...)");
        this.binding = streamUiUserReactionsViewBinding;
        this.userReactionsAdapter = new UserReactionAdapter(arg_0 -> UserReactionsView.userReactionsAdapter$lambda$0(this, arg_0));
        this.binding.recyclerView.setAdapter((RecyclerView.Adapter)this.userReactionsAdapter);
        RecyclerView.LayoutManager layoutManager = this.binding.recyclerView.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.GridLayoutManager");
        this.gridLayoutManager = (GridLayoutManager)layoutManager;
    }

    public final void setMessage(@NotNull Message message, @NotNull User currentUser) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        this.bindTitle(message);
        this.bindReactionList(message, currentUser);
    }

    public final void setOnUserReactionClickListener$stream_chat_android_ui_components_release(@NotNull UserReactionClickListener userReactionClickListener) {
        Intrinsics.checkNotNullParameter((Object)userReactionClickListener, (String)"userReactionClickListener");
        this.userReactionClickListener = userReactionClickListener;
    }

    public final void configure$stream_chat_android_ui_components_release(@NotNull MessageListViewStyle messageListViewStyle) {
        Intrinsics.checkNotNullParameter((Object)messageListViewStyle, (String)"messageListViewStyle");
        this.binding.userReactionsContainer.setCardBackgroundColor(messageListViewStyle.getUserReactionsBackgroundColor());
        TextView textView = this.binding.userReactionsTitleTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"userReactionsTitleTextView");
        TextStyleKt.setTextStyle(textView, messageListViewStyle.getUserReactionsTitleText());
        this.userReactionsAdapter.setMessageOptionsUserReactionAlignment(MessageOptionsUserReactionAlignmentKt.getUserReactionAlignment((int)messageListViewStyle.getMessageOptionsUserReactionAlignment()));
    }

    private final void bindTitle(Message message) {
        int reactionCount = MessageKt.getSupportedLatestReactions(message).size();
        Object[] objectArray = new Object[]{reactionCount};
        this.binding.userReactionsTitleTextView.setText((CharSequence)this.getContext().getResources().getQuantityString(R.plurals.stream_ui_message_list_message_reactions, reactionCount, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final void bindReactionList(Message message, User currentUser) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = MessageKt.getSupportedLatestReactions(message);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            UserReactionItem it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Reaction it = (Reaction)element$iv$iv;
            boolean bl2 = false;
            User user = it.getUser();
            SupportedReactions.ReactionDrawable reactionDrawable = ChatUI.getSupportedReactions().getReactionDrawable(it.getType());
            if ((user != null && reactionDrawable != null ? new UserReactionItem(user, it, Intrinsics.areEqual((Object)user.getId(), (Object)currentUser.getId()), reactionDrawable) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List userReactionItems = (List)destination$iv$iv;
        this.gridLayoutManager.setSpanCount(RangesKt.coerceAtMost((int)userReactionItems.size(), (int)4));
        this.userReactionsAdapter.submitList(userReactionItems);
    }

    private static final void userReactionsAdapter$lambda$0(UserReactionsView this$0, UserReactionItem it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            UserReactionClickListener userReactionClickListener = this$0.userReactionClickListener;
            if (userReactionClickListener == null) break block0;
            userReactionClickListener.onUserReactionClick(it.getUser(), it.getReaction());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/reactions/user/internal/UserReactionsView$Companion;", "", "()V", "MAX_COLUMNS_COUNT", "", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lio/getstream/chat/android/ui/feature/messages/list/reactions/user/internal/UserReactionsView$UserReactionClickListener;", "", "onUserReactionClick", "", "user", "Lio/getstream/chat/android/models/User;", "reaction", "Lio/getstream/chat/android/models/Reaction;", "stream-chat-android-ui-components_release"})
    public static interface UserReactionClickListener {
        public void onUserReactionClick(@NotNull User var1, @NotNull Reaction var2);
    }
}

