/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.messages.preview.internal;

import android.content.Context;
import android.text.Html;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import io.getstream.chat.android.models.ChannelInfo;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.ui.ChatUI;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.common.extensions.internal.AnyKt;
import io.getstream.chat.android.ui.common.helper.DateFormatter;
import io.getstream.chat.android.ui.databinding.StreamUiMessagePreviewItemBinding;
import io.getstream.chat.android.ui.feature.messages.preview.MessagePreviewStyle;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.MessageKt;
import io.getstream.chat.android.ui.utils.extensions.StringKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import io.getstream.chat.android.ui.widgets.avatar.UserAvatarView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u0016\u001a\u00020\u00152\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/getstream/chat/android/ui/feature/messages/preview/internal/MessagePreviewView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiMessagePreviewItemBinding;", "formatChannelName", "", "message", "Lio/getstream/chat/android/models/Message;", "formatMessagePreview", "currentUserMention", "", "init", "", "parseAttrs", "setMessage", "styleView", "messagePreviewStyle", "Lio/getstream/chat/android/ui/feature/messages/preview/MessagePreviewStyle;", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nMessagePreviewView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessagePreviewView.kt\nio/getstream/chat/android/ui/feature/messages/preview/internal/MessagePreviewView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n819#2:113\n847#2,2:114\n*S KotlinDebug\n*F\n+ 1 MessagePreviewView.kt\nio/getstream/chat/android/ui/feature/messages/preview/internal/MessagePreviewView\n*L\n108#1:113\n108#1:114,2\n*E\n"})
public final class MessagePreviewView
extends FrameLayout {
    @NotNull
    private final StreamUiMessagePreviewItemBinding binding;

    public MessagePreviewView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context));
        StreamUiMessagePreviewItemBinding streamUiMessagePreviewItemBinding = StreamUiMessagePreviewItemBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiMessagePreviewItemBinding, (String)"inflate(...)");
        this.binding = streamUiMessagePreviewItemBinding;
        this.init(null);
    }

    public MessagePreviewView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs);
        StreamUiMessagePreviewItemBinding streamUiMessagePreviewItemBinding = StreamUiMessagePreviewItemBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiMessagePreviewItemBinding, (String)"inflate(...)");
        this.binding = streamUiMessagePreviewItemBinding;
        this.init(attrs);
    }

    public MessagePreviewView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr);
        StreamUiMessagePreviewItemBinding streamUiMessagePreviewItemBinding = StreamUiMessagePreviewItemBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiMessagePreviewItemBinding, (String)"inflate(...)");
        this.binding = streamUiMessagePreviewItemBinding;
        this.init(attrs);
    }

    private final void init(AttributeSet attrs) {
        this.parseAttrs(attrs);
    }

    private final void parseAttrs(AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
    }

    public final void styleView(@NotNull MessagePreviewStyle messagePreviewStyle) {
        Intrinsics.checkNotNullParameter((Object)messagePreviewStyle, (String)"messagePreviewStyle");
        MessagePreviewStyle $this$styleView_u24lambda_u240 = messagePreviewStyle;
        boolean bl = false;
        TextView textView = this.binding.senderNameLabel;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"senderNameLabel");
        TextStyleKt.setTextStyle(textView, $this$styleView_u24lambda_u240.getMessageSenderTextStyle());
        TextView textView2 = this.binding.messageLabel;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"messageLabel");
        TextStyleKt.setTextStyle(textView2, $this$styleView_u24lambda_u240.getMessageTextStyle());
        TextView textView3 = this.binding.messageTimeLabel;
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"messageTimeLabel");
        TextStyleKt.setTextStyle(textView3, $this$styleView_u24lambda_u240.getMessageTimeTextStyle());
    }

    public final void setMessage(@NotNull Message message, @Nullable String currentUserMention) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        UserAvatarView userAvatarView = this.binding.userAvatarView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)userAvatarView), (String)"userAvatarView");
        UserAvatarView.setUser$default(userAvatarView, message.getUser(), false, 2, null);
        this.binding.senderNameLabel.setText(this.formatChannelName(message));
        this.binding.messageLabel.setText(this.formatMessagePreview(message, currentUserMention));
        TextView textView = this.binding.messageTimeLabel;
        DateFormatter dateFormatter2 = ChatUI.getDateFormatter();
        Date date = message.getCreatedAt();
        if (date == null) {
            date = message.getCreatedLocallyAt();
        }
        textView.setText((CharSequence)dateFormatter2.formatDate(date));
    }

    public static /* synthetic */ void setMessage$default(MessagePreviewView messagePreviewView, Message message, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        messagePreviewView.setMessage(message, string2);
    }

    private final CharSequence formatChannelName(Message message) {
        CharSequence charSequence;
        ChannelInfo channel2;
        ChannelInfo channelInfo = channel2 = message.getChannelInfo();
        if ((channelInfo != null ? channelInfo.getName() : null) != null && channel2.getMemberCount() > 2) {
            Object[] objectArray = new Object[]{message.getUser().getName(), channel2.getName()};
            Spanned spanned = Html.fromHtml((String)this.getContext().getString(R.string.stream_ui_message_preview_sender, objectArray));
            Intrinsics.checkNotNull((Object)spanned);
            charSequence = (CharSequence)spanned;
        } else {
            charSequence = (CharSequence)StringKt.bold$default(message.getUser().getName(), null, false, 3, null);
        }
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence formatMessagePreview(Message message, String currentUserMention) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        SpannableString attachmentsText = MessageKt.getAttachmentsText(message);
        String displayedText = MessageKt.getTranslatedText$default(message, null, 1, null);
        String it = ((Object)StringsKt.trim((CharSequence)displayedText)).toString();
        boolean $i$a$-let-MessagePreviewView$formatMessagePreview$previewText$22 = false;
        CharSequence previewText = currentUserMention != null ? (CharSequence)StringKt.bold(it, AnyKt.singletonList(currentUserMention), true) : (CharSequence)it;
        Object object = new CharSequence[]{previewText, attachmentsText};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$filterNot = false;
        void $i$a$-let-MessagePreviewView$formatMessagePreview$previewText$22 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            CharSequence it2 = (CharSequence)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it2;
            if (charSequence == null || charSequence.length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (CharSequence)((Object)CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)((Appendable)new SpannableStringBuilder()), (CharSequence)" ", null, null, (int)0, null, null, (int)124, null));
    }
}

