/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.search;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.transition.Fade;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import io.getstream.chat.android.ui.databinding.StreamUiSearchViewBinding;
import io.getstream.chat.android.ui.feature.search.SearchInputViewStyle;
import io.getstream.chat.android.ui.utils.Debouncer;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.EditTextKt;
import io.getstream.chat.android.ui.utils.extensions.TextViewKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0003+,-B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001c\u001a\u00020\u0011J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\u0010\u0010 \u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\"\u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010#\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010$\u001a\u00020\u001e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0012\u0010%\u001a\u00020\u001e2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0017\u0010(\u001a\u00020\u001e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0*H\u0082\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/getstream/chat/android/ui/feature/search/SearchInputView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiSearchViewBinding;", "continuousInputChangedListener", "Lio/getstream/chat/android/ui/feature/search/SearchInputView$InputChangedListener;", "debouncedInputChangedListener", "disableListeners", "", "inputDebouncer", "Lio/getstream/chat/android/ui/utils/Debouncer;", "query", "", "getQuery", "()Ljava/lang/String;", "searchStartedListener", "Lio/getstream/chat/android/ui/feature/search/SearchInputView$SearchStartedListener;", "style", "Lio/getstream/chat/android/ui/feature/search/SearchInputViewStyle;", "clear", "init", "", "onDetachedFromWindow", "setContinuousInputChangedListener", "inputChangedListener", "setDebouncedInputChangedListener", "setQuery", "setSearchStartedListener", "updateClearButtonVisibility", "text", "", "withoutListenerNotifications", "actions", "Lkotlin/Function0;", "Companion", "InputChangedListener", "SearchStartedListener", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nSearchInputView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchInputView.kt\nio/getstream/chat/android/ui/feature/search/SearchInputView\n+ 2 View.kt\nandroidx/core/view/ViewKt\n+ 3 TextView.kt\nandroidx/core/widget/TextViewKt\n*L\n1#1,245:1\n192#1,4:293\n315#2:246\n329#2,4:247\n316#2:251\n329#2,4:252\n329#2,4:256\n329#2,4:260\n260#2:290\n262#2,2:291\n58#3,23:264\n93#3,3:287\n*S KotlinDebug\n*F\n+ 1 SearchInputView.kt\nio/getstream/chat/android/ui/feature/search/SearchInputView\n*L\n176#1:293,4\n80#1:246\n80#1:247,4\n80#1:251\n86#1:252,4\n91#1:256,4\n107#1:260,4\n143#1:290\n146#1:291,2\n112#1:264,23\n112#1:287,3\n*E\n"})
public final class SearchInputView
extends FrameLayout {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final StreamUiSearchViewBinding binding;
    @Nullable
    private InputChangedListener debouncedInputChangedListener;
    @Nullable
    private InputChangedListener continuousInputChangedListener;
    @Nullable
    private SearchStartedListener searchStartedListener;
    @NotNull
    private final Debouncer inputDebouncer;
    private SearchInputViewStyle style;
    private boolean disableListeners;
    private static final long TYPING_DEBOUNCE_MS = 300L;
    private static final long FADE_DURATION = 300L;

    private final String getQuery() {
        Editable editable = this.binding.inputField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"getText(...)");
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)editable))).toString();
    }

    public SearchInputView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context));
        StreamUiSearchViewBinding streamUiSearchViewBinding = StreamUiSearchViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiSearchViewBinding, (String)"inflate(...)");
        this.binding = streamUiSearchViewBinding;
        this.inputDebouncer = new Debouncer(300L);
        this.init(null);
    }

    public SearchInputView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs);
        StreamUiSearchViewBinding streamUiSearchViewBinding = StreamUiSearchViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiSearchViewBinding, (String)"inflate(...)");
        this.binding = streamUiSearchViewBinding;
        this.inputDebouncer = new Debouncer(300L);
        this.init(attrs);
    }

    public SearchInputView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr);
        StreamUiSearchViewBinding streamUiSearchViewBinding = StreamUiSearchViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiSearchViewBinding, (String)"inflate(...)");
        this.binding = streamUiSearchViewBinding;
        this.inputDebouncer = new Debouncer(300L);
        this.init(attrs);
    }

    private final void init(AttributeSet attrs) {
        ViewGroup.LayoutParams params$iv$iv;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.style = SearchInputViewStyle.Companion.invoke(context, attrs);
        this.binding.getRoot().setOnClickListener(arg_0 -> SearchInputView.init$lambda$0(this, arg_0));
        ConstraintLayout constraintLayout = this.binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
        View $this$updateLayoutParams$iv = (View)constraintLayout;
        boolean $i$f$updateLayoutParams = false;
        View $this$updateLayoutParams$iv$iv = $this$updateLayoutParams$iv;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }
        ViewGroup.LayoutParams $this$init_u24lambda_u241 = params$iv$iv = layoutParams;
        boolean bl = false;
        SearchInputViewStyle searchInputViewStyle = this.style;
        if (searchInputViewStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle = null;
        }
        $this$init_u24lambda_u241.height = searchInputViewStyle.getSearchInputHeight();
        $this$updateLayoutParams$iv$iv.setLayoutParams(params$iv$iv);
        ImageView imageView = this.binding.clearInputButton;
        SearchInputViewStyle searchInputViewStyle2 = this.style;
        if (searchInputViewStyle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle2 = null;
        }
        imageView.setImageDrawable(searchInputViewStyle2.getClearInputDrawable());
        ImageView imageView2 = this.binding.searchIcon;
        SearchInputViewStyle searchInputViewStyle3 = this.style;
        if (searchInputViewStyle3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle3 = null;
        }
        imageView2.setImageDrawable(searchInputViewStyle3.getSearchIconDrawable());
        ImageView imageView3 = this.binding.searchIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"searchIcon");
        $this$updateLayoutParams$iv = (View)imageView3;
        boolean $i$f$updateLayoutParamsTyped2 = false;
        ViewGroup.LayoutParams layoutParams2 = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams2);
        ViewGroup.MarginLayoutParams $this$init_u24lambda_u242 = (ViewGroup.MarginLayoutParams)params$iv;
        boolean bl2 = false;
        SearchInputViewStyle searchInputViewStyle4 = this.style;
        if (searchInputViewStyle4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle4 = null;
        }
        $this$init_u24lambda_u242.width = searchInputViewStyle4.getSearchIconWidth();
        SearchInputViewStyle searchInputViewStyle5 = this.style;
        if (searchInputViewStyle5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle5 = null;
        }
        $this$init_u24lambda_u242.height = searchInputViewStyle5.getSearchIconHeight();
        SearchInputViewStyle searchInputViewStyle6 = this.style;
        if (searchInputViewStyle6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle6 = null;
        }
        $this$init_u24lambda_u242.setMarginStart(searchInputViewStyle6.getSearchIconMarginStart());
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        ImageView imageView4 = this.binding.clearInputButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageView4, (String)"clearInputButton");
        $this$updateLayoutParams$iv = (View)imageView4;
        $i$f$updateLayoutParamsTyped2 = false;
        ViewGroup.LayoutParams layoutParams3 = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        params$iv = (ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams3);
        ViewGroup.MarginLayoutParams $this$init_u24lambda_u243 = (ViewGroup.MarginLayoutParams)params$iv;
        boolean bl3 = false;
        SearchInputViewStyle searchInputViewStyle7 = this.style;
        if (searchInputViewStyle7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle7 = null;
        }
        $this$init_u24lambda_u243.width = searchInputViewStyle7.getClearIconWidth();
        SearchInputViewStyle searchInputViewStyle8 = this.style;
        if (searchInputViewStyle8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle8 = null;
        }
        $this$init_u24lambda_u243.height = searchInputViewStyle8.getClearIconHeight();
        SearchInputViewStyle searchInputViewStyle9 = this.style;
        if (searchInputViewStyle9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle9 = null;
        }
        $this$init_u24lambda_u243.setMarginEnd(searchInputViewStyle9.getClearIconMarginEnd());
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        EditText editText = this.binding.inputField;
        SearchInputViewStyle searchInputViewStyle10 = this.style;
        if (searchInputViewStyle10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle10 = null;
        }
        editText.setHint((CharSequence)searchInputViewStyle10.getHintText());
        EditText editText2 = this.binding.inputField;
        SearchInputViewStyle searchInputViewStyle11 = this.style;
        if (searchInputViewStyle11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle11 = null;
        }
        editText2.setHintTextColor(searchInputViewStyle11.getHintColor());
        EditText editText3 = this.binding.inputField;
        SearchInputViewStyle searchInputViewStyle12 = this.style;
        if (searchInputViewStyle12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle12 = null;
        }
        editText3.setTextColor(searchInputViewStyle12.getTextColor());
        SearchInputViewStyle searchInputViewStyle13 = this.style;
        if (searchInputViewStyle13 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle13 = null;
        }
        View it = $this$updateLayoutParams$iv = searchInputViewStyle13.getBackgroundDrawable();
        boolean bl4 = false;
        SearchInputViewStyle searchInputViewStyle14 = this.style;
        if (searchInputViewStyle14 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle14 = null;
        }
        SearchInputViewStyle.DrawableOutline outline = searchInputViewStyle14.getBackgroundDrawableOutline();
        if (it instanceof GradientDrawable && outline != null) {
            ((GradientDrawable)it).setStroke(outline.getWidth(), outline.getColor());
        }
        ConstraintLayout constraintLayout2 = this.binding.getRoot();
        SearchInputViewStyle searchInputViewStyle15 = this.style;
        if (searchInputViewStyle15 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle15 = null;
        }
        constraintLayout2.setBackground(searchInputViewStyle15.getBackgroundDrawable());
        EditText editText4 = this.binding.inputField;
        Intrinsics.checkNotNullExpressionValue((Object)editText4, (String)"inputField");
        TextView textView = (TextView)editText4;
        SearchInputViewStyle searchInputViewStyle16 = this.style;
        if (searchInputViewStyle16 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle16 = null;
        }
        TextViewKt.setTextSizePx(textView, searchInputViewStyle16.getTextSize());
        EditText editText5 = this.binding.inputField;
        Intrinsics.checkNotNullExpressionValue((Object)editText5, (String)"inputField");
        $this$updateLayoutParams$iv = (View)editText5;
        $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams4 = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        params$iv = (ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams4);
        ViewGroup.MarginLayoutParams $this$init_u24lambda_u245 = (ViewGroup.MarginLayoutParams)params$iv;
        boolean bl5 = false;
        SearchInputViewStyle searchInputViewStyle17 = this.style;
        if (searchInputViewStyle17 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle17 = null;
        }
        $this$init_u24lambda_u245.setMarginStart(searchInputViewStyle17.getTextMarginStart());
        SearchInputViewStyle searchInputViewStyle18 = this.style;
        if (searchInputViewStyle18 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            searchInputViewStyle18 = null;
        }
        $this$init_u24lambda_u245.setMarginEnd(searchInputViewStyle18.getTextMarginEnd());
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        EditText editText6 = this.binding.inputField;
        Intrinsics.checkNotNullExpressionValue((Object)editText6, (String)"inputField");
        TextView $this$doAfterTextChanged$iv = (TextView)editText6;
        boolean $i$f$doAfterTextChanged = false;
        TextView $this$addTextChangedListener_u24default$iv$iv = $this$doAfterTextChanged$iv;
        boolean $i$f$addTextChangedListener = false;
        TextWatcher textWatcher$iv$iv = new TextWatcher(this){
            final /* synthetic */ SearchInputView this$0;
            {
                this.this$0 = searchInputView;
            }

            public void afterTextChanged(@Nullable Editable s) {
                Editable newText = s;
                boolean bl = false;
                SearchInputView.access$updateClearButtonVisibility(this.this$0, (CharSequence)newText);
                if (!SearchInputView.access$getDisableListeners$p(this.this$0)) {
                    String newQuery = SearchInputView.access$getQuery(this.this$0);
                    InputChangedListener inputChangedListener = SearchInputView.access$getContinuousInputChangedListener$p(this.this$0);
                    if (inputChangedListener != null) {
                        inputChangedListener.onInputChanged(newQuery);
                    }
                    SearchInputView.access$getInputDebouncer$p(this.this$0).submit((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, newQuery){
                        final /* synthetic */ SearchInputView this$0;
                        final /* synthetic */ String $newQuery;
                        {
                            this.this$0 = $receiver;
                            this.$newQuery = $newQuery;
                            super(0);
                        }

                        public final void invoke() {
                            block0: {
                                InputChangedListener inputChangedListener = SearchInputView.access$getDebouncedInputChangedListener$p(this.this$0);
                                if (inputChangedListener == null) break block0;
                                inputChangedListener.onInputChanged(this.$newQuery);
                            }
                        }
                    }));
                }
            }

            public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                boolean bl = false;
            }

            public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                boolean bl = false;
            }
        };
        $this$addTextChangedListener_u24default$iv$iv.addTextChangedListener(textWatcher$iv$iv);
        this.binding.inputField.setOnEditorActionListener((arg_0, arg_1, arg_2) -> SearchInputView.init$lambda$7(this, arg_0, arg_1, arg_2));
        this.binding.clearInputButton.setOnClickListener(arg_0 -> SearchInputView.init$lambda$8(this, arg_0));
        this.updateClearButtonVisibility(this.getQuery());
    }

    private final void updateClearButtonVisibility(CharSequence text) {
        View $this$isVisible$iv;
        boolean isClearButtonVisible;
        CharSequence charSequence = text;
        boolean bl = isClearButtonVisible = !(charSequence == null || charSequence.length() == 0);
        if (isClearButtonVisible) {
            ImageView imageView = this.binding.clearInputButton;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"clearInputButton");
            $this$isVisible$iv = (View)imageView;
            boolean $i$f$isVisible = false;
            if (!($this$isVisible$iv.getVisibility() == 0)) {
                TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)this.binding.getRoot()), (Transition)new Fade().setDuration(300L));
            }
        }
        ImageView imageView = this.binding.clearInputButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"clearInputButton");
        $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(isClearButtonVisible ? 0 : 8);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.inputDebouncer.shutdown();
    }

    public final void setQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.binding.inputField.setText((CharSequence)((Object)StringsKt.trim((CharSequence)query)).toString());
    }

    public final boolean clear() {
        if (((CharSequence)this.getQuery()).length() == 0) {
            return false;
        }
        SearchInputView this_$iv = this;
        boolean $i$f$withoutListenerNotifications = false;
        this_$iv.disableListeners = true;
        boolean bl = false;
        this.binding.inputField.setText((CharSequence)"");
        InputChangedListener inputChangedListener = this.continuousInputChangedListener;
        if (inputChangedListener != null) {
            inputChangedListener.onInputChanged("");
        }
        InputChangedListener inputChangedListener2 = this.debouncedInputChangedListener;
        if (inputChangedListener2 != null) {
            inputChangedListener2.onInputChanged("");
        }
        this_$iv.disableListeners = false;
        return true;
    }

    private final void withoutListenerNotifications(Function0<Unit> actions) {
        boolean $i$f$withoutListenerNotifications = false;
        this.disableListeners = true;
        actions.invoke();
        this.disableListeners = false;
    }

    public final void setContinuousInputChangedListener(@Nullable InputChangedListener inputChangedListener) {
        this.continuousInputChangedListener = inputChangedListener;
    }

    public final void setDebouncedInputChangedListener(@Nullable InputChangedListener inputChangedListener) {
        this.debouncedInputChangedListener = inputChangedListener;
    }

    public final void setSearchStartedListener(@Nullable SearchStartedListener searchStartedListener) {
        this.searchStartedListener = searchStartedListener;
    }

    private static final void init$lambda$0(SearchInputView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        EditText editText = this$0.binding.inputField;
        Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"inputField");
        EditTextKt.focusAndShowKeyboard(editText);
    }

    private static final boolean init$lambda$7(SearchInputView this$0, TextView textView, int actionId, KeyEvent keyEvent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (actionId == 3) {
            SearchStartedListener searchStartedListener = this$0.searchStartedListener;
            if (searchStartedListener != null) {
                searchStartedListener.onSearchStarted(this$0.getQuery());
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void init$lambda$8(SearchInputView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.clear();
    }

    public static final /* synthetic */ void access$updateClearButtonVisibility(SearchInputView $this, CharSequence text) {
        $this.updateClearButtonVisibility(text);
    }

    public static final /* synthetic */ boolean access$getDisableListeners$p(SearchInputView $this) {
        return $this.disableListeners;
    }

    public static final /* synthetic */ String access$getQuery(SearchInputView $this) {
        return $this.getQuery();
    }

    public static final /* synthetic */ InputChangedListener access$getContinuousInputChangedListener$p(SearchInputView $this) {
        return $this.continuousInputChangedListener;
    }

    public static final /* synthetic */ Debouncer access$getInputDebouncer$p(SearchInputView $this) {
        return $this.inputDebouncer;
    }

    public static final /* synthetic */ InputChangedListener access$getDebouncedInputChangedListener$p(SearchInputView $this) {
        return $this.debouncedInputChangedListener;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/feature/search/SearchInputView$Companion;", "", "()V", "FADE_DURATION", "", "TYPING_DEBOUNCE_MS", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/feature/search/SearchInputView$InputChangedListener;", "", "onInputChanged", "", "query", "", "stream-chat-android-ui-components_release"})
    public static interface InputChangedListener {
        public void onInputChanged(@NotNull String var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/feature/search/SearchInputView$SearchStartedListener;", "", "onSearchStarted", "", "query", "", "stream-chat-android-ui-components_release"})
    public static interface SearchStartedListener {
        public void onSearchStarted(@NotNull String var1);
    }
}

