/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.search.list;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ViewFlipper;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.RecyclerView;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.databinding.StreamUiSearchResultListViewBinding;
import io.getstream.chat.android.ui.feature.search.internal.SearchResultListAdapter;
import io.getstream.chat.android.ui.feature.search.list.SearchResultListViewStyle;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import io.getstream.chat.android.ui.widgets.EndlessScrollListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0004\"#$%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0012\u0010\u0019\u001a\u00020\u00112\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u0011J\u001c\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/getstream/chat/android/ui/feature/search/list/SearchResultListView;", "Landroid/widget/ViewFlipper;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "adapter", "Lio/getstream/chat/android/ui/feature/search/internal/SearchResultListAdapter;", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiSearchResultListViewBinding;", "loadMoreListener", "Lio/getstream/chat/android/ui/feature/search/list/SearchResultListView$LoadMoreListener;", "scrollListener", "Lio/getstream/chat/android/ui/widgets/EndlessScrollListener;", "setLoadMoreListener", "", "setPaginationEnabled", "isEnabled", "", "setSearchResultSelectedListener", "searchResultSelectedListener", "Lio/getstream/chat/android/ui/feature/search/list/SearchResultListView$SearchResultSelectedListener;", "setupView", "setupViewStyle", "showError", "showLoading", "showMessages", "query", "", "messages", "", "Lio/getstream/chat/android/models/Message;", "Companion", "Flipper", "LoadMoreListener", "SearchResultSelectedListener", "stream-chat-android-ui-components_release"})
public final class SearchResultListView
extends ViewFlipper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final StreamUiSearchResultListViewBinding binding;
    @Nullable
    private LoadMoreListener loadMoreListener;
    @NotNull
    private final SearchResultListAdapter adapter;
    @NotNull
    private final EndlessScrollListener scrollListener;
    @Deprecated
    public static final int LOAD_MORE_THRESHOLD = 10;

    public SearchResultListView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public SearchResultListView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs);
        StreamUiSearchResultListViewBinding streamUiSearchResultListViewBinding = StreamUiSearchResultListViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiSearchResultListViewBinding, (String)"inflate(...)");
        this.binding = streamUiSearchResultListViewBinding;
        this.adapter = new SearchResultListAdapter();
        this.scrollListener = new EndlessScrollListener(10, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SearchResultListView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    LoadMoreListener loadMoreListener = SearchResultListView.access$getLoadMoreListener$p(this.this$0);
                    if (loadMoreListener == null) break block0;
                    loadMoreListener.onLoadMoreRequested();
                }
            }
        }));
        this.setupViewStyle(attrs);
        this.setupView();
    }

    private final void setupViewStyle(AttributeSet attrs) {
        SearchResultListViewStyle searchResultListViewStyle;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        SearchResultListViewStyle style2 = searchResultListViewStyle = SearchResultListViewStyle.Companion.invoke(context, attrs);
        boolean bl = false;
        this.setBackgroundColor(style2.getBackgroundColor());
        this.binding.searchInfoBar.setBackground(style2.getSearchInfoBarBackground());
        TextView textView = this.binding.searchInfoBar;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"searchInfoBar");
        TextStyleKt.setTextStyle(textView, style2.getSearchInfoBarTextStyle());
        this.binding.emptyImage.setImageDrawable(style2.getEmptyStateIcon());
        TextView textView2 = this.binding.emptyLabel;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"emptyLabel");
        TextStyleKt.setTextStyle(textView2, style2.getEmptyStateTextStyle());
        this.binding.progressBar.setIndeterminateDrawable(style2.getProgressBarIcon());
        this.adapter.setMessagePreviewStyle(style2.getMessagePreviewStyle());
    }

    /*
     * WARNING - void declaration
     */
    private final void setupView() {
        void $this$setupView_u24lambda_u242_u24lambda_u241;
        DividerItemDecoration dividerItemDecoration;
        RecyclerView recyclerView;
        RecyclerView $this$setupView_u24lambda_u242 = recyclerView = this.binding.searchListView;
        boolean bl = false;
        $this$setupView_u24lambda_u242.setHasFixedSize(true);
        $this$setupView_u24lambda_u242.setAdapter((RecyclerView.Adapter)this.adapter);
        DividerItemDecoration dividerItemDecoration2 = dividerItemDecoration = new DividerItemDecoration($this$setupView_u24lambda_u242.getContext(), 1);
        RecyclerView recyclerView2 = $this$setupView_u24lambda_u242;
        boolean bl2 = false;
        Drawable drawable2 = AppCompatResources.getDrawable((Context)$this$setupView_u24lambda_u242.getContext(), (int)R.drawable.stream_ui_divider);
        Intrinsics.checkNotNull((Object)drawable2);
        $this$setupView_u24lambda_u242_u24lambda_u241.setDrawable(drawable2);
        recyclerView2.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecoration);
        $this$setupView_u24lambda_u242.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
    }

    public final void showMessages(@NotNull String query, @NotNull List<Message> messages) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        boolean isEmpty = messages.isEmpty();
        this.setDisplayedChild(isEmpty ? 1 : 0);
        if (!isEmpty) {
            Object[] objectArray = new Object[]{messages.size()};
            this.binding.searchInfoBar.setText((CharSequence)this.getResources().getQuantityString(R.plurals.stream_ui_search_results_count, messages.size(), objectArray));
        } else {
            Object[] objectArray = new Object[]{query};
            this.binding.emptyLabel.setText((CharSequence)this.getContext().getString(R.string.stream_ui_search_results_empty, objectArray));
        }
        this.adapter.submitList(messages);
    }

    public final void showLoading() {
        this.setDisplayedChild(2);
        this.adapter.submitList(CollectionsKt.emptyList());
        this.scrollListener.disablePagination();
    }

    public final void showError() {
        Toast.makeText((Context)this.getContext(), (int)R.string.stream_ui_search_results_error, (int)0).show();
    }

    public final void setPaginationEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.scrollListener.enablePagination();
        } else {
            this.scrollListener.disablePagination();
        }
    }

    public final void setSearchResultSelectedListener(@Nullable SearchResultSelectedListener searchResultSelectedListener) {
        this.adapter.setSearchResultSelectedListener(searchResultSelectedListener);
    }

    public final void setLoadMoreListener(@Nullable LoadMoreListener loadMoreListener) {
        this.loadMoreListener = loadMoreListener;
    }

    public static final /* synthetic */ LoadMoreListener access$getLoadMoreListener$p(SearchResultListView $this) {
        return $this.loadMoreListener;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/feature/search/list/SearchResultListView$Companion;", "", "()V", "LOAD_MORE_THRESHOLD", "", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/ui/feature/search/list/SearchResultListView$Flipper;", "", "()V", "EMPTY", "", "LOADING", "RESULTS", "stream-chat-android-ui-components_release"})
    private static final class Flipper {
        @NotNull
        public static final Flipper INSTANCE = new Flipper();
        public static final int RESULTS = 0;
        public static final int EMPTY = 1;
        public static final int LOADING = 2;

        private Flipper() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/getstream/chat/android/ui/feature/search/list/SearchResultListView$LoadMoreListener;", "", "onLoadMoreRequested", "", "stream-chat-android-ui-components_release"})
    public static interface LoadMoreListener {
        public void onLoadMoreRequested();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/feature/search/list/SearchResultListView$SearchResultSelectedListener;", "", "onSearchResultSelected", "", "message", "Lio/getstream/chat/android/models/Message;", "stream-chat-android-ui-components_release"})
    public static interface SearchResultSelectedListener {
        public void onSearchResultSelected(@NotNull Message var1);
    }
}

