/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.font;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.widget.TextView;
import androidx.annotation.FontRes;
import androidx.core.content.res.ResourcesCompat;
import io.getstream.chat.android.ui.font.ChatFonts;
import io.getstream.chat.android.ui.font.ChatStyle;
import io.getstream.chat.android.ui.font.TextStyle;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0016\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0016\u001a\u00020\u0012H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/getstream/chat/android/ui/font/ChatFontsImpl;", "Lio/getstream/chat/android/ui/font/ChatFonts;", "style", "Lio/getstream/chat/android/ui/font/ChatStyle;", "context", "Landroid/content/Context;", "(Lio/getstream/chat/android/ui/font/ChatStyle;Landroid/content/Context;)V", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "pathMap", "", "", "Landroid/graphics/Typeface;", "resourceMap", "", "getFont", "textStyle", "Lio/getstream/chat/android/ui/font/TextStyle;", "fontRes", "fontPath", "safeLoadTypeface", "setDefaultFont", "", "textView", "Landroid/widget/TextView;", "defaultTypeface", "setFont", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nChatFontsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatFontsImpl.kt\nio/getstream/chat/android/ui/font/ChatFontsImpl\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n*L\n1#1,111:1\n259#2,4:112\n259#2,4:116\n*S KotlinDebug\n*F\n+ 1 ChatFontsImpl.kt\nio/getstream/chat/android/ui/font/ChatFontsImpl\n*L\n97#1:112,4\n106#1:116,4\n*E\n"})
public final class ChatFontsImpl
implements ChatFonts {
    @NotNull
    private final ChatStyle style;
    @NotNull
    private final Context context;
    @NotNull
    private final Map<Integer, Typeface> resourceMap;
    @NotNull
    private final Map<String, Typeface> pathMap;
    @NotNull
    private final Lazy logger$delegate;

    public ChatFontsImpl(@NotNull ChatStyle style2, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.style = style2;
        this.context = context;
        this.resourceMap = new HashMap();
        this.pathMap = new HashMap();
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)this, (String)ChatFonts.class.getSimpleName());
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @Override
    public void setFont(@NotNull TextStyle textStyle, @NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        if (textStyle.getFont() != null) {
            textView.setTypeface(textStyle.getFont(), textStyle.getStyle());
        } else {
            this.setDefaultFont(textView, textStyle.getStyle(), null);
        }
    }

    @Override
    public void setFont(@NotNull TextStyle textStyle, @NotNull TextView textView, @NotNull Typeface defaultTypeface) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        Intrinsics.checkNotNullParameter((Object)defaultTypeface, (String)"defaultTypeface");
        if (textStyle.getFont() != null) {
            textView.setTypeface(textStyle.getFont(), textStyle.getStyle());
        } else {
            this.setDefaultFont(textView, textStyle.getStyle(), defaultTypeface);
        }
    }

    @Override
    @Nullable
    public Typeface getFont(@NotNull TextStyle textStyle) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        return textStyle.getFontResource() != -1 ? this.getFont(textStyle.getFontResource()) : (!((charSequence = (CharSequence)textStyle.getFontAssetsPath()) == null || charSequence.length() == 0) ? this.getFont(textStyle.getFontAssetsPath()) : null);
    }

    private final Typeface getFont(String fontPath) {
        if (this.pathMap.containsKey(fontPath)) {
            return this.pathMap.get(fontPath);
        }
        Typeface typeface = this.safeLoadTypeface(fontPath);
        if (typeface == null) {
            return null;
        }
        Typeface typeface2 = typeface;
        this.pathMap.put(fontPath, typeface2);
        return typeface2;
    }

    private final Typeface getFont(@FontRes int fontRes) {
        Integer n = fontRes;
        if (this.resourceMap.containsKey(n)) {
            return this.resourceMap.get(fontRes);
        }
        Typeface typeface = this.safeLoadTypeface(fontRes);
        if (typeface == null) {
            return null;
        }
        Typeface typeface2 = typeface;
        this.resourceMap.put(fontRes, typeface2);
        return typeface2;
    }

    private final void setDefaultFont(TextView textView, int textStyle, Typeface defaultTypeface) {
        if (this.style.hasDefaultFont()) {
            TextStyle textStyle2 = this.style.getDefaultTextStyle();
            if (textStyle2 != null) {
                TextStyle it = textStyle2;
                boolean bl = false;
                textView.setTypeface(this.getFont(it), textStyle);
            }
        } else {
            Typeface typeface = defaultTypeface;
            if (typeface == null) {
                typeface = Typeface.DEFAULT;
            }
            textView.setTypeface(typeface, textStyle);
        }
    }

    private final Typeface safeLoadTypeface(@FontRes int fontRes) {
        Typeface typeface;
        try {
            typeface = ResourcesCompat.getFont((Context)this.context, (int)fontRes);
        }
        catch (Throwable t) {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[safeLoadTypeface] failed: " + t;
                streamLogger.log(priority, string2, string3, t);
            }
            typeface = null;
        }
        return typeface;
    }

    private final Typeface safeLoadTypeface(String fontPath) {
        Typeface typeface;
        try {
            typeface = Typeface.createFromAsset((AssetManager)this.context.getAssets(), (String)fontPath);
        }
        catch (Throwable t) {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[safeLoadTypeface] failed: " + t;
                streamLogger.log(priority, string2, string3, t);
            }
            typeface = null;
        }
        return typeface;
    }
}

