/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.font;

import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.widget.TextView;
import androidx.annotation.AnyRes;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import androidx.annotation.StyleableRes;
import io.getstream.chat.android.ui.ChatUI;
import io.getstream.chat.android.ui.font.ChatFonts;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0086\b\u0018\u0000 22\u00020\u0001:\u000212BW\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0003\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0003\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\r\u0010\u001f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010 J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\fH\u00c6\u0003J[\u0010)\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0003\u0010\u0007\u001a\u00020\u00032\b\b\u0003\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0003\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\u0006\u0010.\u001a\u00020+J\t\u0010/\u001a\u00020\u0003H\u00d6\u0001J\t\u00100\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000f\u00a8\u00063"}, d2={"Lio/getstream/chat/android/ui/font/TextStyle;", "Ljava/io/Serializable;", "fontResource", "", "fontAssetsPath", "", "style", "size", "color", "hint", "hintColor", "defaultFont", "Landroid/graphics/Typeface;", "(ILjava/lang/String;IIILjava/lang/String;ILandroid/graphics/Typeface;)V", "getColor", "()I", "getDefaultFont", "()Landroid/graphics/Typeface;", "font", "getFont", "getFontAssetsPath", "()Ljava/lang/String;", "getFontResource", "getHint", "getHintColor", "getSize", "getStyle", "apply", "", "textView", "Landroid/widget/TextView;", "colorOrNull", "()Ljava/lang/Integer;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "hasFont", "hashCode", "toString", "Builder", "Companion", "stream-chat-android-ui-components_release"})
public final class TextStyle
implements Serializable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int fontResource;
    @Nullable
    private final String fontAssetsPath;
    private final int style;
    private final int size;
    private final int color;
    @NotNull
    private final String hint;
    private final int hintColor;
    @NotNull
    private final Typeface defaultFont;
    @Deprecated
    public static final int UNSET_SIZE = -1;
    @Deprecated
    public static final int UNSET_COLOR = Integer.MAX_VALUE;
    @Deprecated
    public static final int UNSET_HINT_COLOR = Integer.MAX_VALUE;
    @Deprecated
    public static final int UNSET_FONT_RESOURCE = -1;
    @Deprecated
    @NotNull
    public static final String UNSET_HINT = "";

    public TextStyle(@AnyRes int fontResource, @Nullable String fontAssetsPath, int style2, @Px int size, @ColorInt int color2, @NotNull String hint, @ColorInt int hintColor, @NotNull Typeface defaultFont) {
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        Intrinsics.checkNotNullParameter((Object)defaultFont, (String)"defaultFont");
        this.fontResource = fontResource;
        this.fontAssetsPath = fontAssetsPath;
        this.style = style2;
        this.size = size;
        this.color = color2;
        this.hint = hint;
        this.hintColor = hintColor;
        this.defaultFont = defaultFont;
    }

    public /* synthetic */ TextStyle(int n, String string2, int n2, int n3, int n4, String string3, int n5, Typeface typeface, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            n = -1;
        }
        if ((n6 & 2) != 0) {
            string2 = null;
        }
        if ((n6 & 4) != 0) {
            n2 = 0;
        }
        if ((n6 & 8) != 0) {
            n3 = -1;
        }
        if ((n6 & 0x10) != 0) {
            n4 = Integer.MAX_VALUE;
        }
        if ((n6 & 0x20) != 0) {
            string3 = UNSET_HINT;
        }
        if ((n6 & 0x40) != 0) {
            n5 = Integer.MAX_VALUE;
        }
        if ((n6 & 0x80) != 0) {
            Typeface typeface2 = Typeface.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)typeface2, (String)"DEFAULT");
            typeface = typeface2;
        }
        this(n, string2, n2, n3, n4, string3, n5, typeface);
    }

    public final int getFontResource() {
        return this.fontResource;
    }

    @Nullable
    public final String getFontAssetsPath() {
        return this.fontAssetsPath;
    }

    public final int getStyle() {
        return this.style;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getColor() {
        return this.color;
    }

    @NotNull
    public final String getHint() {
        return this.hint;
    }

    public final int getHintColor() {
        return this.hintColor;
    }

    @NotNull
    public final Typeface getDefaultFont() {
        return this.defaultFont;
    }

    @Nullable
    public final Typeface getFont() {
        return ChatUI.getFonts().getFont(this);
    }

    public final void apply(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        ChatFonts chatFonts = ChatUI.getFonts();
        if (this.size != -1) {
            textView.setTextSize(0, (float)this.size);
        }
        if (this.color != Integer.MAX_VALUE) {
            textView.setTextColor(this.color);
        }
        if (!Intrinsics.areEqual((Object)this.hint, (Object)UNSET_HINT)) {
            textView.setHint((CharSequence)this.hint);
        }
        if (this.hintColor != Integer.MAX_VALUE) {
            textView.setHintTextColor(this.hintColor);
        }
        chatFonts.setFont(this, textView, this.defaultFont);
    }

    public final boolean hasFont() {
        return this.fontAssetsPath != null || this.fontResource != -1;
    }

    @Nullable
    public final Integer colorOrNull() {
        return this.color != Integer.MAX_VALUE ? Integer.valueOf(this.color) : null;
    }

    public final int component1() {
        return this.fontResource;
    }

    @Nullable
    public final String component2() {
        return this.fontAssetsPath;
    }

    public final int component3() {
        return this.style;
    }

    public final int component4() {
        return this.size;
    }

    public final int component5() {
        return this.color;
    }

    @NotNull
    public final String component6() {
        return this.hint;
    }

    public final int component7() {
        return this.hintColor;
    }

    @NotNull
    public final Typeface component8() {
        return this.defaultFont;
    }

    @NotNull
    public final TextStyle copy(@AnyRes int fontResource, @Nullable String fontAssetsPath, int style2, @Px int size, @ColorInt int color2, @NotNull String hint, @ColorInt int hintColor, @NotNull Typeface defaultFont) {
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        Intrinsics.checkNotNullParameter((Object)defaultFont, (String)"defaultFont");
        return new TextStyle(fontResource, fontAssetsPath, style2, size, color2, hint, hintColor, defaultFont);
    }

    public static /* synthetic */ TextStyle copy$default(TextStyle textStyle, int n, String string2, int n2, int n3, int n4, String string3, int n5, Typeface typeface, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = textStyle.fontResource;
        }
        if ((n6 & 2) != 0) {
            string2 = textStyle.fontAssetsPath;
        }
        if ((n6 & 4) != 0) {
            n2 = textStyle.style;
        }
        if ((n6 & 8) != 0) {
            n3 = textStyle.size;
        }
        if ((n6 & 0x10) != 0) {
            n4 = textStyle.color;
        }
        if ((n6 & 0x20) != 0) {
            string3 = textStyle.hint;
        }
        if ((n6 & 0x40) != 0) {
            n5 = textStyle.hintColor;
        }
        if ((n6 & 0x80) != 0) {
            typeface = textStyle.defaultFont;
        }
        return textStyle.copy(n, string2, n2, n3, n4, string3, n5, typeface);
    }

    @NotNull
    public String toString() {
        return "TextStyle(fontResource=" + this.fontResource + ", fontAssetsPath=" + this.fontAssetsPath + ", style=" + this.style + ", size=" + this.size + ", color=" + this.color + ", hint=" + this.hint + ", hintColor=" + this.hintColor + ", defaultFont=" + this.defaultFont + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.fontResource);
        result2 = result2 * 31 + (this.fontAssetsPath == null ? 0 : this.fontAssetsPath.hashCode());
        result2 = result2 * 31 + Integer.hashCode(this.style);
        result2 = result2 * 31 + Integer.hashCode(this.size);
        result2 = result2 * 31 + Integer.hashCode(this.color);
        result2 = result2 * 31 + this.hint.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.hintColor);
        result2 = result2 * 31 + this.defaultFont.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextStyle)) {
            return false;
        }
        TextStyle textStyle = (TextStyle)other;
        if (this.fontResource != textStyle.fontResource) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontAssetsPath, (Object)textStyle.fontAssetsPath)) {
            return false;
        }
        if (this.style != textStyle.style) {
            return false;
        }
        if (this.size != textStyle.size) {
            return false;
        }
        if (this.color != textStyle.color) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hint, (Object)textStyle.hint)) {
            return false;
        }
        if (this.hintColor != textStyle.hintColor) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.defaultFont, (Object)textStyle.defaultFont);
    }

    public TextStyle() {
        this(0, null, 0, 0, 0, null, 0, null, 255, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0005\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u00062\b\b\u0001\u0010\u0013\u001a\u00020\u0006J\u001a\u0010\u0014\u001a\u00020\u00002\b\b\u0001\u0010\u0015\u001a\u00020\u00062\b\b\u0001\u0010\u0016\u001a\u00020\u0006J\"\u0010\u0014\u001a\u00020\u00002\b\b\u0001\u0010\u0015\u001a\u00020\u00062\b\b\u0001\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\u00002\b\b\u0001\u0010\u0015\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u000b\u001a\u00020\u00002\b\b\u0001\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0018\u0010\f\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\nJ\u001a\u0010\r\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u00062\b\b\u0001\u0010\u0013\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u0006J\u001a\u0010\u000e\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u00062\b\b\u0001\u0010\u0013\u001a\u00020\u0006J\u0018\u0010\u000f\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/ui/font/TextStyle$Builder;", "", "array", "Landroid/content/res/TypedArray;", "(Landroid/content/res/TypedArray;)V", "color", "", "defaultFont", "Landroid/graphics/Typeface;", "fontAssetsPath", "", "fontResource", "hint", "hintColor", "size", "style", "build", "Lio/getstream/chat/android/ui/font/TextStyle;", "ref", "defValue", "font", "assetsPath", "resId", "stream-chat-android-ui-components_release"})
    public static final class Builder {
        @NotNull
        private final TypedArray array;
        private int fontResource;
        @Nullable
        private String fontAssetsPath;
        private int style;
        private int size;
        private int color;
        @NotNull
        private String hint;
        private int hintColor;
        @NotNull
        private Typeface defaultFont;

        public Builder(@NotNull TypedArray array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            this.array = array;
            this.fontResource = -1;
            this.size = -1;
            this.color = Integer.MAX_VALUE;
            this.hint = TextStyle.UNSET_HINT;
            this.hintColor = Integer.MAX_VALUE;
            Typeface typeface = Typeface.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)typeface, (String)"DEFAULT");
            this.defaultFont = typeface;
        }

        @NotNull
        public final Builder size(@StyleableRes int ref) {
            return this.size(ref, -1);
        }

        @NotNull
        public final Builder size(@StyleableRes int ref, @Px int defValue) {
            Builder builder;
            Builder $this$size_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$size_u24lambda_u240.size = $this$size_u24lambda_u240.array.getDimensionPixelSize(ref, defValue);
            return builder;
        }

        @NotNull
        public final Builder font(@StyleableRes int assetsPath, @StyleableRes int resId) {
            Builder builder;
            Builder $this$font_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$font_u24lambda_u241.fontAssetsPath = $this$font_u24lambda_u241.array.getString(assetsPath);
            $this$font_u24lambda_u241.fontResource = $this$font_u24lambda_u241.array.getResourceId(resId, -1);
            return builder;
        }

        @NotNull
        public final Builder fontAssetsPath(@StyleableRes int assetsPath, @Nullable String defValue) {
            Builder builder;
            Builder $this$fontAssetsPath_u24lambda_u242 = builder = this;
            boolean bl = false;
            String string2 = $this$fontAssetsPath_u24lambda_u242.array.getString(assetsPath);
            if (string2 == null) {
                string2 = defValue;
            }
            $this$fontAssetsPath_u24lambda_u242.fontAssetsPath = string2;
            return builder;
        }

        @NotNull
        public final Builder fontResource(@StyleableRes int resId, int defValue) {
            Builder builder;
            Builder $this$fontResource_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$fontResource_u24lambda_u243.fontResource = $this$fontResource_u24lambda_u243.array.getResourceId(resId, defValue);
            return builder;
        }

        @NotNull
        public final Builder font(@StyleableRes int assetsPath, @StyleableRes int resId, @NotNull Typeface defaultFont) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)defaultFont, (String)"defaultFont");
            Builder $this$font_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$font_u24lambda_u244.fontAssetsPath = $this$font_u24lambda_u244.array.getString(assetsPath);
            $this$font_u24lambda_u244.fontResource = $this$font_u24lambda_u244.array.getResourceId(resId, -1);
            $this$font_u24lambda_u244.defaultFont = defaultFont;
            return builder;
        }

        @NotNull
        public final Builder color(@StyleableRes int ref, @ColorInt int defValue) {
            Builder builder;
            Builder $this$color_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$color_u24lambda_u245.color = $this$color_u24lambda_u245.array.getColor(ref, defValue);
            return builder;
        }

        @NotNull
        public final Builder hintColor(@StyleableRes int ref, @ColorInt int defValue) {
            Builder builder;
            Builder $this$hintColor_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$hintColor_u24lambda_u246.hintColor = $this$hintColor_u24lambda_u246.array.getColor(ref, defValue);
            return builder;
        }

        @NotNull
        public final Builder hint(@StyleableRes int ref, @NotNull String defValue) {
            String string2;
            String string3;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)defValue, (String)"defValue");
            Builder $this$hint_u24lambda_u247 = builder = this;
            boolean bl = false;
            String string4 = string3 = $this$hint_u24lambda_u247.array.getString(ref);
            if (string4 == null) {
                string2 = defValue;
            } else {
                Intrinsics.checkNotNull((Object)string4);
                string2 = string3;
            }
            $this$hint_u24lambda_u247.hint = string2;
            return builder;
        }

        @NotNull
        public final Builder style(@StyleableRes int ref, int defValue) {
            Builder builder;
            Builder $this$style_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$style_u24lambda_u248.style = $this$style_u24lambda_u248.array.getInt(ref, defValue);
            return builder;
        }

        @NotNull
        public final TextStyle build() {
            return new TextStyle(this.fontResource, this.fontAssetsPath, this.style, this.size, this.color, this.hint, this.hintColor, this.defaultFont);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/getstream/chat/android/ui/font/TextStyle$Companion;", "", "()V", "UNSET_COLOR", "", "UNSET_FONT_RESOURCE", "UNSET_HINT", "", "UNSET_HINT_COLOR", "UNSET_SIZE", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

