/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.helper;

import android.content.Context;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import io.getstream.chat.android.client.utils.message.MessageUtils;
import io.getstream.chat.android.models.Channel;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.ui.common.extensions.internal.AnyKt;
import io.getstream.chat.android.ui.common.utils.extensions.ChannelKt;
import io.getstream.chat.android.ui.helper.MessagePreviewFormatter;
import io.getstream.chat.android.ui.utils.extensions.MessageKt;
import io.getstream.chat.android.ui.utils.extensions.StringKt;
import io.getstream.chat.android.ui.utils.extensions.UserKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/getstream/chat/android/ui/helper/DefaultMessagePreviewFormatter;", "Lio/getstream/chat/android/ui/helper/MessagePreviewFormatter;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "formatMessagePreview", "", "channel", "Lio/getstream/chat/android/models/Channel;", "message", "Lio/getstream/chat/android/models/Message;", "currentUser", "Lio/getstream/chat/android/models/User;", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nMessagePreviewFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessagePreviewFormatter.kt\nio/getstream/chat/android/ui/helper/DefaultMessagePreviewFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n819#2:111\n847#2,2:112\n*S KotlinDebug\n*F\n+ 1 MessagePreviewFormatter.kt\nio/getstream/chat/android/ui/helper/DefaultMessagePreviewFormatter\n*L\n105#1:111\n105#1:112,2\n*E\n"})
final class DefaultMessagePreviewFormatter
implements MessagePreviewFormatter {
    @NotNull
    private final Context context;

    public DefaultMessagePreviewFormatter(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CharSequence formatMessagePreview(@NotNull Channel channel2, @NotNull Message message, @Nullable User currentUser) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String displayedText = MessageKt.getTranslatedText(message, currentUser);
        if (MessageUtils.isSystem((Message)message)) {
            charSequence = (CharSequence)new SpannableStringBuilder((CharSequence)StringKt.italicize$default(((Object)StringsKt.trim((CharSequence)displayedText)).toString(), null, false, 3, null));
        } else {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            String sender = MessageKt.getSenderDisplayName(message, this.context, ChannelKt.isDirectMessaging((Channel)channel2));
            User user = currentUser;
            String currentUserMention = user != null ? UserKt.asMention(user, this.context) : null;
            String string2 = currentUserMention;
            SpannableString previewText = StringKt.bold(((Object)StringsKt.trim((CharSequence)displayedText)).toString(), string2 != null ? AnyKt.singletonList(string2) : null, true);
            SpannableString attachmentsText = MessageKt.getAttachmentsText(message);
            Object object = new CharSequence[]{sender, previewText, attachmentsText};
            object = CollectionsKt.listOf((Object[])object);
            boolean $i$f$filterNot = false;
            void var11_11 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                CharSequence it = (CharSequence)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence2 = it;
                if (charSequence2 == null || charSequence2.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            charSequence = (CharSequence)((Object)CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)((Appendable)new SpannableStringBuilder()), (CharSequence)": ", null, null, (int)0, null, null, (int)124, null));
        }
        return charSequence;
    }
}

