/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.helper;

import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.DrawableKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0006J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0013R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/ui/helper/SupportedReactions;", "", "context", "Landroid/content/Context;", "reactions", "", "", "Lio/getstream/chat/android/ui/helper/SupportedReactions$ReactionDrawable;", "(Landroid/content/Context;Ljava/util/Map;)V", "getReactions", "()Ljava/util/Map;", "types", "", "getTypes", "()Ljava/util/List;", "getReactionDrawable", "type", "isReactionTypeSupported", "", "isReactionTypeSupported$stream_chat_android_ui_components_release", "DefaultReactionDrawables", "DefaultReactionTypes", "ReactionDrawable", "stream-chat-android-ui-components_release"})
public final class SupportedReactions {
    @NotNull
    private final Map<String, ReactionDrawable> reactions;
    @NotNull
    private final List<String> types;

    public SupportedReactions(@NotNull Context context, @NotNull Map<String, ReactionDrawable> reactions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(reactions, (String)"reactions");
        this.reactions = reactions;
        this.types = CollectionsKt.toList((Iterable)this.reactions.keySet());
    }

    public /* synthetic */ SupportedReactions(Context context, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"love", (Object)DefaultReactionDrawables.INSTANCE.loveDrawable(context)), TuplesKt.to((Object)"like", (Object)DefaultReactionDrawables.INSTANCE.thumbsUpDrawable(context)), TuplesKt.to((Object)"sad", (Object)DefaultReactionDrawables.INSTANCE.thumbsDownDrawable(context)), TuplesKt.to((Object)"haha", (Object)DefaultReactionDrawables.INSTANCE.lolDrawable(context)), TuplesKt.to((Object)"wow", (Object)DefaultReactionDrawables.INSTANCE.wutDrawable(context))};
            map2 = MapsKt.mapOf((Pair[])pairArray);
        }
        this(context, map2);
    }

    @NotNull
    public final Map<String, ReactionDrawable> getReactions() {
        return this.reactions;
    }

    @NotNull
    public final List<String> getTypes() {
        return this.types;
    }

    public final boolean isReactionTypeSupported$stream_chat_android_ui_components_release(@NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return this.reactions.keySet().contains(type2);
    }

    @Nullable
    public final ReactionDrawable getReactionDrawable(@NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return this.reactions.get(type2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lio/getstream/chat/android/ui/helper/SupportedReactions$DefaultReactionDrawables;", "", "()V", "createTintedReactionDrawable", "Lio/getstream/chat/android/ui/helper/SupportedReactions$ReactionDrawable;", "context", "Landroid/content/Context;", "drawableResId", "", "lolDrawable", "loveDrawable", "thumbsDownDrawable", "thumbsUpDrawable", "wutDrawable", "stream-chat-android-ui-components_release"})
    private static final class DefaultReactionDrawables {
        @NotNull
        public static final DefaultReactionDrawables INSTANCE = new DefaultReactionDrawables();

        private DefaultReactionDrawables() {
        }

        @NotNull
        public final ReactionDrawable loveDrawable(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.createTintedReactionDrawable(context, R.drawable.stream_ui_ic_reaction_love);
        }

        @NotNull
        public final ReactionDrawable thumbsUpDrawable(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.createTintedReactionDrawable(context, R.drawable.stream_ui_ic_reaction_thumbs_up);
        }

        @NotNull
        public final ReactionDrawable thumbsDownDrawable(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.createTintedReactionDrawable(context, R.drawable.stream_ui_ic_reaction_thumbs_down);
        }

        @NotNull
        public final ReactionDrawable lolDrawable(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.createTintedReactionDrawable(context, R.drawable.stream_ui_ic_reaction_lol);
        }

        @NotNull
        public final ReactionDrawable wutDrawable(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.createTintedReactionDrawable(context, R.drawable.stream_ui_ic_reaction_wut);
        }

        private final ReactionDrawable createTintedReactionDrawable(Context context, @DrawableRes int drawableResId) {
            Drawable drawable2 = ContextKt.getDrawableCompat(context, drawableResId);
            Intrinsics.checkNotNull((Object)drawable2);
            Drawable drawable3 = DrawableKt.applyTint(drawable2, ContextKt.getColorCompat(context, R.color.stream_ui_grey));
            Drawable drawable4 = ContextKt.getDrawableCompat(context, drawableResId);
            Intrinsics.checkNotNull((Object)drawable4);
            return new ReactionDrawable(drawable3, DrawableKt.applyTint(drawable4, ContextKt.getColorCompat(context, R.color.stream_ui_accent_blue)));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/getstream/chat/android/ui/helper/SupportedReactions$DefaultReactionTypes;", "", "()V", "LOL", "", "LOVE", "THUMBS_DOWN", "THUMBS_UP", "WUT", "stream-chat-android-ui-components_release"})
    public static final class DefaultReactionTypes {
        @NotNull
        public static final DefaultReactionTypes INSTANCE = new DefaultReactionTypes();
        @NotNull
        public static final String LOVE = "love";
        @NotNull
        public static final String THUMBS_UP = "like";
        @NotNull
        public static final String THUMBS_DOWN = "sad";
        @NotNull
        public static final String LOL = "haha";
        @NotNull
        public static final String WUT = "wow";

        private DefaultReactionTypes() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/getstream/chat/android/ui/helper/SupportedReactions$ReactionDrawable;", "", "inactiveDrawable", "Landroid/graphics/drawable/Drawable;", "activeDrawable", "(Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;)V", "getDrawable", "isActive", "", "stream-chat-android-ui-components_release"})
    public static final class ReactionDrawable {
        @NotNull
        private final Drawable inactiveDrawable;
        @NotNull
        private final Drawable activeDrawable;

        public ReactionDrawable(@NotNull Drawable inactiveDrawable, @NotNull Drawable activeDrawable) {
            Intrinsics.checkNotNullParameter((Object)inactiveDrawable, (String)"inactiveDrawable");
            Intrinsics.checkNotNullParameter((Object)activeDrawable, (String)"activeDrawable");
            this.inactiveDrawable = inactiveDrawable;
            this.activeDrawable = activeDrawable;
        }

        @NotNull
        public final Drawable getDrawable(boolean isActive) {
            return isActive ? this.activeDrawable : this.inactiveDrawable;
        }
    }
}

