/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.navigation.destinations;

import android.content.Context;
import android.content.Intent;
import android.widget.Toast;
import io.getstream.chat.android.client.utils.attachment.AttachmentUtilsKt;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.ui.common.R;
import io.getstream.chat.android.ui.common.feature.documents.AttachmentDocumentActivity;
import io.getstream.chat.android.ui.feature.gallery.AttachmentActivity;
import io.getstream.chat.android.ui.feature.gallery.AttachmentMediaActivity;
import io.getstream.chat.android.ui.navigation.destinations.AttachmentDestination;
import io.getstream.chat.android.ui.navigation.destinations.ChatDestination;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import io.getstream.photoview.dialog.PhotoViewDialog;
import io.getstream.photoview.dialog.loader.ImageLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u001c\u0010\u001e\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001aH\u0002J\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\f\u0010\"\u001a\u00020\u0018*\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lio/getstream/chat/android/ui/navigation/destinations/AttachmentDestination;", "Lio/getstream/chat/android/ui/navigation/destinations/ChatDestination;", "message", "Lio/getstream/chat/android/models/Message;", "attachment", "Lio/getstream/chat/android/models/Attachment;", "context", "Landroid/content/Context;", "(Lio/getstream/chat/android/models/Message;Lio/getstream/chat/android/models/Attachment;Landroid/content/Context;)V", "getAttachment", "()Lio/getstream/chat/android/models/Attachment;", "setAttachment", "(Lio/getstream/chat/android/models/Attachment;)V", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "getMessage", "()Lio/getstream/chat/android/models/Message;", "setMessage", "(Lio/getstream/chat/android/models/Message;)V", "docMimeType", "", "mimeType", "", "loadFile", "", "navigate", "playableContent", "type", "showAttachment", "showImageViewer", "isGif", "Companion", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nAttachmentDestination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentDestination.kt\nio/getstream/chat/android/ui/navigation/destinations/AttachmentDestination\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n270#2,4:205\n270#2,4:209\n270#2,4:213\n766#3:217\n857#3,2:218\n1603#3,9:220\n1855#3:229\n1856#3:231\n1612#3:232\n1#4:230\n*S KotlinDebug\n*F\n+ 1 AttachmentDestination.kt\nio/getstream/chat/android/ui/navigation/destinations/AttachmentDestination\n*L\n89#1:205,4\n112#1:209,4\n142#1:213,4\n175#1:217\n175#1:218,2\n176#1:220,9\n176#1:229\n176#1:231\n176#1:232\n176#1:230\n*E\n"})
public class AttachmentDestination
extends ChatDestination {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private Message message;
    @NotNull
    private Attachment attachment;
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private static final String VIDEO_MIME_TYPE_PREFIX = "video";
    @NotNull
    private static final String MP4_MIME_TYPE = "mp4";
    @NotNull
    private static final String MPEG_MIME_TYPE = "audio/mpeg";
    @NotNull
    private static final String QUICKTIME_MIME_TYPE = "quicktime";
    @NotNull
    private static final String VIDEO_TYPE = "video";
    @NotNull
    private static final String AUDIO_TYPE = "audio";

    public AttachmentDestination(@NotNull Message message, @NotNull Attachment attachment, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.message = message;
        this.attachment = attachment;
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)this, (String)"Chat:AttachmentDestination");
    }

    @NotNull
    public final Message getMessage() {
        return this.message;
    }

    public final void setMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"<set-?>");
        this.message = message;
    }

    @NotNull
    public final Attachment getAttachment() {
        return this.attachment;
    }

    public final void setAttachment(@NotNull Attachment attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"<set-?>");
        this.attachment = attachment;
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @Override
    public void navigate() {
        this.showAttachment(this.message, this.attachment);
    }

    public final void showAttachment(@NotNull Message message, @NotNull Attachment attachment) {
        Intent intent;
        CharSequence charSequence;
        String type2;
        String url2;
        block24: {
            block23: {
                block22: {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
                    if (AttachmentUtilsKt.isFile((Attachment)attachment) || AttachmentUtilsKt.isVideo((Attachment)attachment) || AttachmentUtilsKt.isAudio((Attachment)attachment)) break block22;
                    String string2 = attachment.getMimeType();
                    boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"video", (boolean)false, (int)2, null) : false;
                    if (!bl) break block23;
                }
                this.loadFile(attachment);
                return;
            }
            url2 = null;
            type2 = null;
            type2 = attachment.getType();
            charSequence = attachment.getType();
            if (charSequence == null) break block24;
            int n = -1;
            switch (((String)charSequence).hashCode()) {
                case 100313435: {
                    if (((String)charSequence).equals("image")) {
                        n = 1;
                    }
                    break;
                }
                case -309474065: {
                    if (((String)charSequence).equals("product")) {
                        n = 2;
                    }
                    break;
                }
                case 98361695: {
                    if (((String)charSequence).equals("giphy")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    if (attachment.getTitleLink() != null || attachment.getOgUrl() != null || attachment.getAssetUrl() != null) {
                        String string3 = attachment.getTitleLink();
                        if (string3 == null && (string3 = attachment.getOgUrl()) == null) {
                            string3 = attachment.getAssetUrl();
                        }
                        url2 = string3;
                        type2 = "link";
                        break;
                    }
                    if (this.isGif(attachment)) {
                        url2 = attachment.getImageUrl();
                        type2 = "giphy";
                        break;
                    }
                    this.showImageViewer(message, attachment);
                    return;
                }
                case 3: {
                    url2 = attachment.getThumbUrl();
                    break;
                }
                case 2: {
                    url2 = attachment.getUrl();
                }
            }
        }
        if ((charSequence = (CharSequence)url2) == null || charSequence.length() == 0) {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string4 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string5 = "Wrong URL for attachment. Attachment: " + attachment;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string4, (String)string5, null, (int)8, null);
            }
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.stream_ui_message_list_attachment_invalid_url), (int)0).show();
            return;
        }
        Intent $this$showAttachment_u24lambda_u241 = intent = new Intent(this.getContext(), AttachmentActivity.class);
        boolean bl = false;
        $this$showAttachment_u24lambda_u241.putExtra("type", type2);
        $this$showAttachment_u24lambda_u241.putExtra("url", url2);
        Intent intent2 = intent;
        this.start(intent2);
    }

    private final void loadFile(Attachment attachment) {
        String title2;
        String mimeType2 = attachment.getMimeType();
        String url2 = attachment.getAssetUrl();
        String type2 = attachment.getType();
        String string2 = attachment.getTitle();
        if (string2 == null && (string2 = attachment.getName()) == null) {
            string2 = title2 = "";
        }
        if (mimeType2 == null && type2 == null) {
            Object[] this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string3 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string4 = "MimeType is null for url " + url2;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string4, null, (int)8, null);
            }
            this_$iv = new Object[]{attachment.getName()};
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.stream_ui_message_list_attachment_invalid_mime_type, this_$iv), (int)0).show();
            return;
        }
        if (this.playableContent(mimeType2, type2)) {
            Context context = this.getContext();
            String string5 = url2;
            if (string5 == null) {
                string5 = "";
            }
            Intent intent = AttachmentMediaActivity.Companion.createIntent(context, string5, title2, mimeType2, type2);
            this.start(intent);
        } else if (this.docMimeType(mimeType2)) {
            Intent $i$f$e;
            Intent $this$loadFile_u24lambda_u243 = $i$f$e = new Intent(this.getContext(), AttachmentDocumentActivity.class);
            boolean bl = false;
            $this$loadFile_u24lambda_u243.putExtra("url", url2);
            Intent intent = $i$f$e;
            this.start(intent);
        } else {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string6 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string7 = "Could not load attachment. Mimetype: " + mimeType2 + ". Type: " + type2;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string6, (String)string7, null, (int)8, null);
            }
            Object[] objectArray = new Object[]{attachment.getName()};
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.stream_ui_message_list_attachment_invalid_mime_type, objectArray), (int)0).show();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean playableContent(String mimeType2, String type2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        String string2 = mimeType2;
        if (string2 != null) {
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)AUDIO_TYPE, (boolean)false, (int)2, null)) {
                return true;
            }
            bl5 = false;
        } else {
            bl5 = false;
        }
        if (bl5) return true;
        String string3 = mimeType2;
        if (string3 != null) {
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"video", (boolean)false, (int)2, null)) {
                return true;
            }
            bl4 = false;
        } else {
            bl4 = false;
        }
        if (bl4) return true;
        String string4 = mimeType2;
        if (string4 != null) {
            if (StringsKt.contains$default((CharSequence)string4, (CharSequence)MP4_MIME_TYPE, (boolean)false, (int)2, null)) {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        String string5 = mimeType2;
        if (string5 != null) {
            if (StringsKt.contains$default((CharSequence)string5, (CharSequence)MPEG_MIME_TYPE, (boolean)false, (int)2, null)) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        String string6 = mimeType2;
        if (string6 != null) {
            if (StringsKt.contains$default((CharSequence)string6, (CharSequence)QUICKTIME_MIME_TYPE, (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (Intrinsics.areEqual((Object)type2, (Object)AUDIO_TYPE)) return true;
        if (!Intrinsics.areEqual((Object)type2, (Object)"video")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean docMimeType(String mimeType2) {
        if (Intrinsics.areEqual((Object)mimeType2, (Object)"application/msword")) return true;
        if (Intrinsics.areEqual((Object)mimeType2, (Object)"text/plain")) return true;
        if (Intrinsics.areEqual((Object)mimeType2, (Object)"application/pdf")) return true;
        if (Intrinsics.areEqual((Object)mimeType2, (Object)"text/html")) return true;
        String string2 = mimeType2;
        if (string2 == null) return false;
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"application/vnd", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void showImageViewer(@NotNull Message message, @NotNull Attachment attachment) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        Iterable iterable = message.getAttachments();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CharSequence charSequence;
            Attachment it = (Attachment)element$iv$iv;
            boolean bl = false;
            boolean bl2 = AttachmentUtilsKt.isImage((Attachment)it) && !((charSequence = (CharSequence)it.getImageUrl()) == null || charSequence.length() == 0);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Attachment p0 = (Attachment)element$iv$iv;
            boolean bl3 = false;
            if (p0.getImageUrl() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List imageUrls = (List)destination$iv$iv;
        if (imageUrls.isEmpty()) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Invalid image(s)!", (int)0).show();
            return;
        }
        int attachmentIndex = message.getAttachments().indexOf(attachment);
        PhotoViewDialog.Builder.show$default((PhotoViewDialog.Builder)new PhotoViewDialog.Builder(this.getContext(), imageUrls, (ImageLoader)showImageViewer.1.INSTANCE).withStartPosition((0 <= attachmentIndex ? attachmentIndex < imageUrls.size() : false) ? attachmentIndex : 0), (boolean)false, (int)1, null);
    }

    private final boolean isGif(Attachment $this$isGif) {
        String string2 = $this$isGif.getMimeType();
        return string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"gif", (boolean)false, (int)2, null) : false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/getstream/chat/android/ui/navigation/destinations/AttachmentDestination$Companion;", "", "()V", "AUDIO_TYPE", "", "MP4_MIME_TYPE", "MPEG_MIME_TYPE", "QUICKTIME_MIME_TYPE", "VIDEO_MIME_TYPE_PREFIX", "VIDEO_TYPE", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

