/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.utils;

import android.annotation.SuppressLint;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.widget.TextView;
import androidx.core.util.PatternsCompat;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.ui.utils.Linkify;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalStreamChatApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u00010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0011J(\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JM\u0010\u001c\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u0010(J9\u0010)\u001a\u0004\u0018\u00010\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\t2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0#2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u0010.J\u001e\u0010/\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0007\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/getstream/chat/android/ui/utils/Linkify;", "", "()V", "COMPARATOR", "Ljava/util/Comparator;", "Lio/getstream/chat/android/ui/utils/Linkify$LinkSpec;", "Lkotlin/Comparator;", "DEFAULT_SPAN_FACTORY", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "string", "Landroid/text/style/URLSpan;", "addLinkMovementMethod", "", "t", "Landroid/widget/TextView;", "addLinks", "", "text", "Landroid/text/Spannable;", "textView", "applyLink", "url", "start", "", "end", "gatherLinks", "links", "", "s", "pattern", "Ljava/util/regex/Pattern;", "schemes", "", "matchFilter", "Landroid/text/util/Linkify$MatchFilter;", "transformFilter", "Landroid/text/util/Linkify$TransformFilter;", "(Ljava/util/List;Landroid/text/Spannable;Ljava/util/regex/Pattern;[Ljava/lang/String;Landroid/text/util/Linkify$MatchFilter;Landroid/text/util/Linkify$TransformFilter;)V", "makeUrl", "prefixes", "matcher", "Ljava/util/regex/Matcher;", "filter", "(Ljava/lang/String;[Ljava/lang/String;Ljava/util/regex/Matcher;Landroid/text/util/Linkify$TransformFilter;)Ljava/lang/String;", "pruneOverlaps", "LinkSpec", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nLinkify.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Linkify.kt\nio/getstream/chat/android/ui/utils/Linkify\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,243:1\n1855#2,2:244\n13309#3,2:246\n*S KotlinDebug\n*F\n+ 1 Linkify.kt\nio/getstream/chat/android/ui/utils/Linkify\n*L\n109#1:244,2\n191#1:246,2\n*E\n"})
public final class Linkify {
    @NotNull
    public static final Linkify INSTANCE = new Linkify();
    @NotNull
    private static final Comparator<LinkSpec> COMPARATOR = Linkify::COMPARATOR$lambda$0;
    @NotNull
    private static final Function1<String, URLSpan> DEFAULT_SPAN_FACTORY = DEFAULT_SPAN_FACTORY.1.INSTANCE;

    private Linkify() {
    }

    public final void addLinks(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        CharSequence charSequence = textView.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getText(...)");
        CharSequence t = charSequence;
        if (t instanceof Spannable) {
            if (this.addLinks((Spannable)t)) {
                this.addLinkMovementMethod(textView);
            }
        } else {
            SpannableString s = SpannableString.valueOf((CharSequence)t);
            Intrinsics.checkNotNull((Object)s);
            if (this.addLinks((Spannable)s)) {
                this.addLinkMovementMethod(textView);
                textView.setText((CharSequence)s);
            }
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    private final boolean addLinks(Spannable text) {
        List links = new ArrayList();
        Pattern pattern = PatternsCompat.AUTOLINK_WEB_URL;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"AUTOLINK_WEB_URL");
        String[] stringArray = new String[]{"http://", "https://", "rtsp://"};
        this.gatherLinks(links, text, pattern, stringArray, android.text.util.Linkify.sUrlMatchFilter, null);
        Pattern pattern2 = PatternsCompat.AUTOLINK_EMAIL_ADDRESS;
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"AUTOLINK_EMAIL_ADDRESS");
        stringArray = new String[]{"mailto:"};
        this.gatherLinks(links, text, pattern2, stringArray, null, null);
        this.pruneOverlaps(links, text);
        if (links.isEmpty()) {
            return false;
        }
        Iterable $this$forEach$iv = links;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LinkSpec link = (LinkSpec)element$iv;
            boolean bl = false;
            if (link.getMarkwonAddedSpan() != null) continue;
            String string2 = link.getUrl();
            Intrinsics.checkNotNull((Object)string2);
            INSTANCE.applyLink(string2, link.getStart(), link.getEnd(), text);
        }
        return true;
    }

    private final void addLinkMovementMethod(TextView t) {
        MovementMethod m = t.getMovementMethod();
        if (!(m instanceof LinkMovementMethod) && t.getLinksClickable()) {
            t.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    private final void applyLink(String url2, int start, int end, Spannable text) {
        Function1<String, URLSpan> urlSpanFactory = DEFAULT_SPAN_FACTORY;
        URLSpan span = (URLSpan)urlSpanFactory.invoke((Object)url2);
        text.setSpan((Object)span, start, end, 33);
    }

    private final String makeUrl(String url2, String[] prefixes, Matcher matcher, Linkify.TransformFilter filter) {
        if (url2 == null) {
            return null;
        }
        Linkify.TransformFilter transformFilter = filter;
        String string2 = transformFilter != null ? transformFilter.transformUrl(matcher, url2) : null;
        if (string2 == null) {
            string2 = url2;
        }
        Object transformedUrl = string2;
        boolean hasPrefix = false;
        int n = prefixes.length;
        for (int i = 0; i < n; ++i) {
            if (!StringsKt.regionMatches((String)transformedUrl, (int)0, (String)prefixes[i], (int)0, (int)prefixes[i].length(), (boolean)true)) continue;
            hasPrefix = true;
            if (StringsKt.regionMatches((String)transformedUrl, (int)0, (String)prefixes[i], (int)0, (int)prefixes[i].length(), (boolean)false)) break;
            String string3 = prefixes[i];
            String string4 = ((String)transformedUrl).substring(prefixes[i].length());
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            transformedUrl = string3 + string4;
            break;
        }
        if (!hasPrefix && !(prefixes.length == 0)) {
            transformedUrl = prefixes[0] + (String)transformedUrl;
        }
        return transformedUrl;
    }

    private final void gatherLinks(List<LinkSpec> links, Spannable s, Pattern pattern, String[] schemes, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        Matcher m = pattern.matcher((CharSequence)s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            if (matchFilter != null && !matchFilter.acceptMatch((CharSequence)s, start, end)) continue;
            String string2 = m.group(0);
            Intrinsics.checkNotNull((Object)m);
            String url2 = this.makeUrl(string2, schemes, m, transformFilter);
            LinkSpec spec = new LinkSpec(null, url2, start, end, 1, null);
            links.add(spec);
        }
    }

    private final void pruneOverlaps(List<LinkSpec> links, Spannable text) {
        URLSpan span;
        URLSpan[] urlSpans;
        Object[] objectArray = text.getSpans(0, text.length(), URLSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(...)");
        URLSpan[] $this$forEach$iv = urlSpans = (URLSpan[])objectArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            URLSpan element$iv;
            span = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            LinkSpec spec = new LinkSpec(span, null, text.getSpanStart((Object)span), text.getSpanEnd((Object)span), 2, null);
            links.add(spec);
        }
        CollectionsKt.sortWith(links, COMPARATOR);
        int len = links.size();
        int i = 0;
        while (i < len - 1) {
            LinkSpec a = links.get(i);
            LinkSpec b = links.get(i + 1);
            int remove = -1;
            if (a.getStart() <= b.getStart() && a.getEnd() > b.getStart()) {
                if (b.getEnd() <= a.getEnd()) {
                    remove = i + 1;
                } else if (a.getEnd() - a.getStart() > b.getEnd() - b.getStart()) {
                    remove = i + 1;
                } else if (a.getEnd() - a.getStart() < b.getEnd() - b.getStart()) {
                    remove = i;
                }
                if (remove != -1) {
                    span = links.get(remove).getMarkwonAddedSpan();
                    if (span != null) {
                        text.removeSpan((Object)span);
                    }
                    links.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
    }

    private static final int COMPARATOR$lambda$0(LinkSpec a, LinkSpec b) {
        return a.getStart() < b.getStart() ? -1 : (a.getEnd() > b.getEnd() ? -1 : (a.getStart() > b.getStart() ? 1 : (a.getEnd() < b.getEnd() ? 1 : 0)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J5\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lio/getstream/chat/android/ui/utils/Linkify$LinkSpec;", "", "markwonAddedSpan", "Landroid/text/style/URLSpan;", "url", "", "start", "", "end", "(Landroid/text/style/URLSpan;Ljava/lang/String;II)V", "getEnd", "()I", "getMarkwonAddedSpan", "()Landroid/text/style/URLSpan;", "getStart", "getUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "stream-chat-android-ui-components_release"})
    private static final class LinkSpec {
        @Nullable
        private final URLSpan markwonAddedSpan;
        @Nullable
        private final String url;
        private final int start;
        private final int end;

        public LinkSpec(@Nullable URLSpan markwonAddedSpan, @Nullable String url2, int start, int end) {
            this.markwonAddedSpan = markwonAddedSpan;
            this.url = url2;
            this.start = start;
            this.end = end;
        }

        public /* synthetic */ LinkSpec(URLSpan uRLSpan, String string2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                uRLSpan = null;
            }
            if ((n3 & 2) != 0) {
                string2 = null;
            }
            this(uRLSpan, string2, n, n2);
        }

        @Nullable
        public final URLSpan getMarkwonAddedSpan() {
            return this.markwonAddedSpan;
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @Nullable
        public final URLSpan component1() {
            return this.markwonAddedSpan;
        }

        @Nullable
        public final String component2() {
            return this.url;
        }

        public final int component3() {
            return this.start;
        }

        public final int component4() {
            return this.end;
        }

        @NotNull
        public final LinkSpec copy(@Nullable URLSpan markwonAddedSpan, @Nullable String url2, int start, int end) {
            return new LinkSpec(markwonAddedSpan, url2, start, end);
        }

        public static /* synthetic */ LinkSpec copy$default(LinkSpec linkSpec, URLSpan uRLSpan, String string2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                uRLSpan = linkSpec.markwonAddedSpan;
            }
            if ((n3 & 2) != 0) {
                string2 = linkSpec.url;
            }
            if ((n3 & 4) != 0) {
                n = linkSpec.start;
            }
            if ((n3 & 8) != 0) {
                n2 = linkSpec.end;
            }
            return linkSpec.copy(uRLSpan, string2, n, n2);
        }

        @NotNull
        public String toString() {
            return "LinkSpec(markwonAddedSpan=" + this.markwonAddedSpan + ", url=" + this.url + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            int result2 = this.markwonAddedSpan == null ? 0 : this.markwonAddedSpan.hashCode();
            result2 = result2 * 31 + (this.url == null ? 0 : this.url.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.start);
            result2 = result2 * 31 + Integer.hashCode(this.end);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LinkSpec)) {
                return false;
            }
            LinkSpec linkSpec = (LinkSpec)other;
            if (!Intrinsics.areEqual((Object)this.markwonAddedSpan, (Object)linkSpec.markwonAddedSpan)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)linkSpec.url)) {
                return false;
            }
            if (this.start != linkSpec.start) {
                return false;
            }
            return this.end == linkSpec.end;
        }
    }
}

