/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Environment;
import android.view.View;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.google.android.material.snackbar.BaseTransientBottomBar;
import com.google.android.material.snackbar.Snackbar;
import com.permissionx.guolindev.PermissionX;
import com.permissionx.guolindev.request.ExplainScope;
import com.permissionx.guolindev.request.ForwardScope;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.ui.common.R;
import io.getstream.chat.android.ui.utils.PermissionChecker;
import io.getstream.chat.android.ui.utils.extensions.IntKt;
import io.getstream.chat.android.ui.utils.extensions.ViewKt;
import io.getstream.chat.android.uiutils.util.IntentUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalStreamChatApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bJ,\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bJ,\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bJ,\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bJR\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J<\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J,\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J \u0010\"\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006#"}, d2={"Lio/getstream/chat/android/ui/utils/PermissionChecker;", "", "()V", "checkAudioRecordPermissions", "", "view", "Landroid/view/View;", "onPermissionDenied", "Lkotlin/Function0;", "onPermissionGranted", "checkCameraPermissions", "checkFilePermissions", "checkMediaPermissions", "checkPermissions", "dialogTitle", "", "dialogMessage", "snackbarMessage", "permissions", "", "checkStoragePermissions", "checkWriteStoragePermissions", "isAllPermissionsGranted", "", "context", "Landroid/content/Context;", "isGrantedAudioRecordPermission", "isGrantedCameraPermissions", "isGrantedFilePermissions", "isGrantedMediaPermissions", "isNeededToRequestForCameraPermissions", "isPermissionContainedOnManifest", "permission", "showPermissionDeniedSnackbar", "showPermissionRationaleDialog", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nPermissionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionChecker.kt\nio/getstream/chat/android/ui/utils/PermissionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,307:1\n1726#2,3:308\n*S KotlinDebug\n*F\n+ 1 PermissionChecker.kt\nio/getstream/chat/android/ui/utils/PermissionChecker\n*L\n73#1:308,3\n*E\n"})
public final class PermissionChecker {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isGrantedMediaPermissions(@NotNull Context context) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 23) return true;
        if (Build.VERSION.SDK_INT >= 33) {
            Object[] objectArray = new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)"android.permission.READ_EXTERNAL_STORAGE");
        }
        if (!this.isAllPermissionsGranted(context, list)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isGrantedFilePermissions(@NotNull Context context) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 23) return true;
        if (Build.VERSION.SDK_INT >= 33) {
            Object[] objectArray = new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_AUDIO"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)"android.permission.READ_EXTERNAL_STORAGE");
        }
        if (!this.isAllPermissionsGranted(context, list)) return false;
        return true;
    }

    private final boolean isAllPermissionsGranted(Context context, List<String> permissions) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = permissions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String permission = (String)element$iv;
                    boolean bl2 = false;
                    if (ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isGrantedCameraPermissions(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT < 23 || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") == 0;
    }

    public final boolean isGrantedAudioRecordPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.RECORD_AUDIO") == 0;
    }

    public final boolean isNeededToRequestForCameraPermissions(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isPermissionContainedOnManifest(context, "android.permission.CAMERA") && !this.isGrantedCameraPermissions(context);
    }

    public final void checkMediaPermissions(@NotNull View view, @NotNull Function0<Unit> onPermissionDenied, @NotNull Function0<Unit> onPermissionGranted) {
        List list;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(onPermissionDenied, (String)"onPermissionDenied");
        Intrinsics.checkNotNullParameter(onPermissionGranted, (String)"onPermissionGranted");
        if (Build.VERSION.SDK_INT >= 33) {
            Object[] objectArray = new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)"android.permission.READ_EXTERNAL_STORAGE");
        }
        this.checkStoragePermissions(view, list, onPermissionDenied, onPermissionGranted);
    }

    public static /* synthetic */ void checkMediaPermissions$default(PermissionChecker permissionChecker, View view, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = checkMediaPermissions.1.INSTANCE;
        }
        permissionChecker.checkMediaPermissions(view, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    public final void checkFilePermissions(@NotNull View view, @NotNull Function0<Unit> onPermissionDenied, @NotNull Function0<Unit> onPermissionGranted) {
        List list;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(onPermissionDenied, (String)"onPermissionDenied");
        Intrinsics.checkNotNullParameter(onPermissionGranted, (String)"onPermissionGranted");
        if (Build.VERSION.SDK_INT >= 33) {
            Object[] objectArray = new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_AUDIO"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)"android.permission.READ_EXTERNAL_STORAGE");
        }
        this.checkStoragePermissions(view, list, onPermissionDenied, onPermissionGranted);
    }

    public static /* synthetic */ void checkFilePermissions$default(PermissionChecker permissionChecker, View view, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = checkFilePermissions.1.INSTANCE;
        }
        permissionChecker.checkFilePermissions(view, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    private final void checkStoragePermissions(View view, List<String> permissions, Function0<Unit> onPermissionDenied, Function0<Unit> onPermissionGranted) {
        String string2 = view.getContext().getString(R.string.stream_ui_message_composer_permission_storage_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = view.getContext().getString(R.string.stream_ui_message_composer_permission_storage_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        String string4 = view.getContext().getString(R.string.stream_ui_message_composer_permission_setting_message);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        this.checkPermissions(view, string2, string3, string4, permissions, onPermissionDenied, onPermissionGranted);
    }

    static /* synthetic */ void checkStoragePermissions$default(PermissionChecker permissionChecker, View view, List list, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = checkStoragePermissions.1.INSTANCE;
        }
        permissionChecker.checkStoragePermissions(view, list, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    public final void checkWriteStoragePermissions(@NotNull View view, @NotNull Function0<Unit> onPermissionDenied, @NotNull Function0<Unit> onPermissionGranted) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(onPermissionDenied, (String)"onPermissionDenied");
        Intrinsics.checkNotNullParameter(onPermissionGranted, (String)"onPermissionGranted");
        if (Build.VERSION.SDK_INT < 29 || Environment.isExternalStorageLegacy()) {
            String string2 = view.getContext().getString(R.string.stream_ui_message_composer_permission_storage_title);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            String string3 = view.getContext().getString(R.string.stream_ui_message_composer_permission_storage_message);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            String string4 = view.getContext().getString(R.string.stream_ui_message_composer_permission_setting_message);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            this.checkPermissions(view, string2, string3, string4, CollectionsKt.listOf((Object)"android.permission.WRITE_EXTERNAL_STORAGE"), onPermissionDenied, onPermissionGranted);
        } else {
            onPermissionGranted.invoke();
        }
    }

    public static /* synthetic */ void checkWriteStoragePermissions$default(PermissionChecker permissionChecker, View view, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = checkWriteStoragePermissions.1.INSTANCE;
        }
        permissionChecker.checkWriteStoragePermissions(view, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    public final void checkCameraPermissions(@NotNull View view, @NotNull Function0<Unit> onPermissionDenied, @NotNull Function0<Unit> onPermissionGranted) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(onPermissionDenied, (String)"onPermissionDenied");
        Intrinsics.checkNotNullParameter(onPermissionGranted, (String)"onPermissionGranted");
        String string2 = view.getContext().getString(R.string.stream_ui_message_composer_permission_camera_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = view.getContext().getString(R.string.stream_ui_message_composer_permission_camera_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        String string4 = view.getContext().getString(R.string.stream_ui_message_composer_permission_camera_message);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        this.checkPermissions(view, string2, string3, string4, CollectionsKt.listOf((Object)"android.permission.CAMERA"), onPermissionDenied, onPermissionGranted);
    }

    public static /* synthetic */ void checkCameraPermissions$default(PermissionChecker permissionChecker, View view, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = checkCameraPermissions.1.INSTANCE;
        }
        permissionChecker.checkCameraPermissions(view, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    public final void checkAudioRecordPermissions(@NotNull View view, @NotNull Function0<Unit> onPermissionDenied, @NotNull Function0<Unit> onPermissionGranted) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(onPermissionDenied, (String)"onPermissionDenied");
        Intrinsics.checkNotNullParameter(onPermissionGranted, (String)"onPermissionGranted");
        String string2 = view.getContext().getString(R.string.stream_ui_message_composer_permission_audio_record_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = view.getContext().getString(R.string.stream_ui_message_composer_permission_audio_record_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        String string4 = view.getContext().getString(R.string.stream_ui_message_composer_permission_audio_record_message);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        this.checkPermissions(view, string2, string3, string4, CollectionsKt.listOf((Object)"android.permission.RECORD_AUDIO"), onPermissionDenied, onPermissionGranted);
    }

    public static /* synthetic */ void checkAudioRecordPermissions$default(PermissionChecker permissionChecker, View view, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = checkAudioRecordPermissions.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function02 = checkAudioRecordPermissions.2.INSTANCE;
        }
        permissionChecker.checkAudioRecordPermissions(view, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    private final boolean isPermissionContainedOnManifest(Context context, String permission) {
        Intrinsics.checkNotNullExpressionValue((Object)context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions, (String)"requestedPermissions");
        return ArraysKt.contains((Object[])context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions, (Object)permission);
    }

    private final void checkPermissions(View view, String dialogTitle, String dialogMessage, String snackbarMessage, List<String> permissions, Function0<Unit> onPermissionDenied, Function0<Unit> onPermissionGranted) {
        FragmentActivity fragmentActivity = ViewKt.getActivity(view);
        if (fragmentActivity == null) {
            return;
        }
        FragmentActivity activity = fragmentActivity;
        PermissionX.init((FragmentActivity)activity).permissions(permissions).onExplainRequestReason((arg_0, arg_1) -> PermissionChecker.checkPermissions$lambda$1(this, view, dialogTitle, dialogMessage, arg_0, arg_1)).onForwardToSettings((arg_0, arg_1) -> PermissionChecker.checkPermissions$lambda$2(this, view, snackbarMessage, arg_0, arg_1)).request((arg_0, arg_1, arg_2) -> PermissionChecker.checkPermissions$lambda$3(onPermissionGranted, onPermissionDenied, arg_0, arg_1, arg_2));
    }

    private final void showPermissionRationaleDialog(Context context, String dialogTitle, String dialogMessage) {
        new AlertDialog.Builder(context).setTitle((CharSequence)dialogTitle).setMessage((CharSequence)dialogMessage).setPositiveButton(17039370, PermissionChecker::showPermissionRationaleDialog$lambda$4).show();
    }

    private final void showPermissionDeniedSnackbar(View view, String snackbarMessage) {
        Snackbar snackbar;
        Snackbar $this$showPermissionDeniedSnackbar_u24lambda_u246 = snackbar = Snackbar.make((View)view, (CharSequence)snackbarMessage, (int)0);
        boolean bl = false;
        $this$showPermissionDeniedSnackbar_u24lambda_u246.setAction(R.string.stream_ui_message_composer_permissions_setting_button, arg_0 -> PermissionChecker.showPermissionDeniedSnackbar$lambda$6$lambda$5($this$showPermissionDeniedSnackbar_u24lambda_u246, arg_0));
        $this$showPermissionDeniedSnackbar_u24lambda_u246.addCallback((BaseTransientBottomBar.BaseCallback)new BaseTransientBottomBar.BaseCallback<Snackbar>(){

            public void onShown(@Nullable Snackbar sb) {
                super.onShown((Object)sb);
                Snackbar snackbar = sb;
                Object object = snackbar != null ? snackbar.getView() : null;
                if (object != null) {
                    object.setElevation(IntKt.dpToPxPrecise(20));
                }
            }
        });
        $this$showPermissionDeniedSnackbar_u24lambda_u246.show();
    }

    private static final void checkPermissions$lambda$1(PermissionChecker this$0, View $view, String $dialogTitle, String $dialogMessage, ExplainScope explainScope, List list) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)$dialogTitle, (String)"$dialogTitle");
        Intrinsics.checkNotNullParameter((Object)$dialogMessage, (String)"$dialogMessage");
        Intrinsics.checkNotNullParameter((Object)explainScope, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<anonymous parameter 1>");
        Context context = $view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this$0.showPermissionRationaleDialog(context, $dialogTitle, $dialogMessage);
    }

    private static final void checkPermissions$lambda$2(PermissionChecker this$0, View $view, String $snackbarMessage, ForwardScope forwardScope, List list) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)$snackbarMessage, (String)"$snackbarMessage");
        Intrinsics.checkNotNullParameter((Object)forwardScope, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<anonymous parameter 1>");
        this$0.showPermissionDeniedSnackbar($view, $snackbarMessage);
    }

    private static final void checkPermissions$lambda$3(Function0 $onPermissionGranted, Function0 $onPermissionDenied, boolean allGranted, List list, List list2) {
        Intrinsics.checkNotNullParameter((Object)$onPermissionGranted, (String)"$onPermissionGranted");
        Intrinsics.checkNotNullParameter((Object)$onPermissionDenied, (String)"$onPermissionDenied");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<anonymous parameter 1>");
        Intrinsics.checkNotNullParameter((Object)list2, (String)"<anonymous parameter 2>");
        if (allGranted) {
            $onPermissionGranted.invoke();
        } else {
            $onPermissionDenied.invoke();
        }
    }

    private static final void showPermissionRationaleDialog$lambda$4(DialogInterface dialog, int n) {
        dialog.dismiss();
    }

    private static final void showPermissionDeniedSnackbar$lambda$6$lambda$5(Snackbar $this_apply, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Context context = $this_apply.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        IntentUtilsKt.openSystemSettings((Context)context);
    }
}

