/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.utils.extensions;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import androidx.annotation.ArrayRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Px;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentManager;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.ui.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\f\u0010\f\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\u0016\u0010\r\u001a\u00020\u000e*\u00020\u00022\b\b\u0001\u0010\u000f\u001a\u00020\u000eH\u0007\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00022\b\b\u0001\u0010\u000f\u001a\u00020\u000eH\u0007\u001a\u0016\u0010\u0012\u001a\u00020\u000e*\u00020\u00022\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0007\u001a\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00022\b\b\u0001\u0010\u0016\u001a\u00020\u000eH\u0007\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u0004\u0018\u00010\u0002H\u0000\u001a\u0016\u0010\u0019\u001a\u00020\u001a*\u00020\u00022\b\b\u0001\u0010\u0016\u001a\u00020\u000eH\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"isRtlLayout", "", "Landroid/content/Context;", "(Landroid/content/Context;)Z", "streamThemeInflater", "Landroid/view/LayoutInflater;", "getStreamThemeInflater", "(Landroid/content/Context;)Landroid/view/LayoutInflater;", "copyToClipboard", "", "text", "", "createStreamThemeWrapper", "getColorCompat", "", "color", "getColorStateListCompat", "Landroid/content/res/ColorStateList;", "getDimension", "dimen", "getDrawableCompat", "Landroid/graphics/drawable/Drawable;", "id", "getFragmentManager", "Landroidx/fragment/app/FragmentManager;", "getIntArray", "", "stream-chat-android-ui-components_release"})
public final class ContextKt {
    public static final boolean isRtlLayout(@NotNull Context $this$isRtlLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$isRtlLayout, (String)"<this>");
        return $this$isRtlLayout.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    @InternalStreamChatApi
    @Px
    public static final int getDimension(@NotNull Context $this$getDimension, @DimenRes int dimen2) {
        Intrinsics.checkNotNullParameter((Object)$this$getDimension, (String)"<this>");
        return $this$getDimension.getResources().getDimensionPixelSize(dimen2);
    }

    @NotNull
    public static final int[] getIntArray(@NotNull Context $this$getIntArray, @ArrayRes int id2) {
        Intrinsics.checkNotNullParameter((Object)$this$getIntArray, (String)"<this>");
        int[] nArray = $this$getIntArray.getResources().getIntArray(id2);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getIntArray(...)");
        return nArray;
    }

    @InternalStreamChatApi
    @ColorInt
    public static final int getColorCompat(@NotNull Context $this$getColorCompat, @ColorRes int color2) {
        Intrinsics.checkNotNullParameter((Object)$this$getColorCompat, (String)"<this>");
        return ContextCompat.getColor((Context)$this$getColorCompat, (int)color2);
    }

    @InternalStreamChatApi
    @Nullable
    public static final ColorStateList getColorStateListCompat(@NotNull Context $this$getColorStateListCompat, @ColorRes int color2) {
        Intrinsics.checkNotNullParameter((Object)$this$getColorStateListCompat, (String)"<this>");
        return ContextCompat.getColorStateList((Context)$this$getColorStateListCompat, (int)color2);
    }

    @InternalStreamChatApi
    @Nullable
    public static final Drawable getDrawableCompat(@NotNull Context $this$getDrawableCompat, @DrawableRes int id2) {
        Intrinsics.checkNotNullParameter((Object)$this$getDrawableCompat, (String)"<this>");
        return ContextCompat.getDrawable((Context)$this$getDrawableCompat, (int)id2);
    }

    @Nullable
    public static final FragmentManager getFragmentManager(@Nullable Context $this$getFragmentManager) {
        Context context = $this$getFragmentManager;
        return context instanceof AppCompatActivity ? ((AppCompatActivity)$this$getFragmentManager).getSupportFragmentManager() : (context instanceof ContextWrapper ? ContextKt.getFragmentManager(((ContextWrapper)$this$getFragmentManager).getBaseContext()) : null);
    }

    public static final void copyToClipboard(@NotNull Context $this$copyToClipboard, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$copyToClipboard, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = $this$copyToClipboard.getSystemService("clipboard");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
        ClipboardManager clipboard = (ClipboardManager)object;
        clipboard.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)text));
    }

    @NotNull
    public static final LayoutInflater getStreamThemeInflater(@NotNull Context $this$streamThemeInflater) {
        Intrinsics.checkNotNullParameter((Object)$this$streamThemeInflater, (String)"<this>");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)ContextKt.createStreamThemeWrapper($this$streamThemeInflater));
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"from(...)");
        return layoutInflater;
    }

    @NotNull
    public static final Context createStreamThemeWrapper(@NotNull Context $this$createStreamThemeWrapper) {
        Intrinsics.checkNotNullParameter((Object)$this$createStreamThemeWrapper, (String)"<this>");
        TypedValue typedValue = new TypedValue();
        return $this$createStreamThemeWrapper.getTheme().resolveAttribute(R.attr.streamUiValidTheme, typedValue, true) ? $this$createStreamThemeWrapper : ($this$createStreamThemeWrapper.getTheme().resolveAttribute(R.attr.streamUiTheme, typedValue, true) ? (Context)new ContextThemeWrapper($this$createStreamThemeWrapper, typedValue.resourceId) : (Context)new ContextThemeWrapper($this$createStreamThemeWrapper, R.style.StreamUiTheme));
    }
}

