/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.utils.extensions;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.FragmentActivity;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.ui.helper.ViewPadding;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001d\u0010\u0007\u001a\u00020\b*\u00020\u00022\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0014\u0010\f\u001a\u00020\b*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0016\u0010\u000f\u001a\u00020\b*\u00020\u00022\b\b\u0001\u0010\u0010\u001a\u00020\nH\u0000\u001a\u0016\u0010\u0011\u001a\u00020\b*\u00020\u00022\b\b\u0001\u0010\u0012\u001a\u00020\nH\u0007\" \u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"activity", "Landroidx/fragment/app/FragmentActivity;", "Landroid/view/View;", "getActivity$annotations", "(Landroid/view/View;)V", "getActivity", "(Landroid/view/View;)Landroidx/fragment/app/FragmentActivity;", "setBorderlessRipple", "", "color", "", "(Landroid/view/View;Ljava/lang/Integer;)V", "setPaddingCompat", "padding", "Lio/getstream/chat/android/ui/helper/ViewPadding;", "setPaddingStart", "start", "showToast", "resId", "stream-chat-android-ui-components_release"})
public final class ViewKt {
    public static final void setBorderlessRipple(@NotNull View $this$setBorderlessRipple, @ColorInt @Nullable Integer color2) {
        Drawable drawable2;
        Intrinsics.checkNotNullParameter((Object)$this$setBorderlessRipple, (String)"<this>");
        if (color2 != null) {
            ColorStateList colorStateList = ColorStateList.valueOf((int)color2);
            Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"valueOf(...)");
            ColorStateList rippleColor = colorStateList;
            drawable2 = (Drawable)new RippleDrawable(rippleColor, null, $this$setBorderlessRipple.getBackground());
        } else {
            drawable2 = null;
        }
        $this$setBorderlessRipple.setBackground(drawable2);
    }

    @Nullable
    public static final FragmentActivity getActivity(@NotNull View $this$activity) {
        Intrinsics.checkNotNullParameter((Object)$this$activity, (String)"<this>");
        Context context = $this$activity.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof FragmentActivity) {
                return (FragmentActivity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    @InternalStreamChatApi
    public static /* synthetic */ void getActivity$annotations(View view) {
    }

    @InternalStreamChatApi
    public static final void showToast(@NotNull View $this$showToast, @StringRes int resId) {
        Intrinsics.checkNotNullParameter((Object)$this$showToast, (String)"<this>");
        Toast.makeText((Context)$this$showToast.getContext(), (CharSequence)$this$showToast.getContext().getString(resId), (int)0).show();
    }

    public static final void setPaddingStart(@NotNull View $this$setPaddingStart, @Px int start) {
        Intrinsics.checkNotNullParameter((Object)$this$setPaddingStart, (String)"<this>");
        Context context = $this$setPaddingStart.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        boolean isRtl = ContextKt.isRtlLayout(context);
        if (isRtl) {
            $this$setPaddingStart.setPadding($this$setPaddingStart.getPaddingLeft(), $this$setPaddingStart.getPaddingTop(), start, $this$setPaddingStart.getPaddingBottom());
        } else {
            $this$setPaddingStart.setPadding(start, $this$setPaddingStart.getPaddingTop(), $this$setPaddingStart.getPaddingRight(), $this$setPaddingStart.getPaddingBottom());
        }
    }

    public static final void setPaddingCompat(@NotNull View $this$setPaddingCompat, @NotNull ViewPadding padding) {
        Intrinsics.checkNotNullParameter((Object)$this$setPaddingCompat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        ViewCompat.setPaddingRelative((View)$this$setPaddingCompat, (int)padding.getStart(), (int)padding.getTop(), (int)padding.getEnd(), (int)padding.getBottom());
    }
}

