/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.viewmodel.channels;

import androidx.lifecycle.FlowLiveDataConversions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.api.models.QueryChannelsRequest;
import io.getstream.chat.android.client.channel.ChannelClient;
import io.getstream.chat.android.client.errors.ChatErrorKt;
import io.getstream.chat.android.client.extensions.StringExtensionsKt;
import io.getstream.chat.android.models.Channel;
import io.getstream.chat.android.models.ChannelMute;
import io.getstream.chat.android.models.FilterObject;
import io.getstream.chat.android.models.Filters;
import io.getstream.chat.android.models.TypingEvent;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.models.querysort.QuerySortByField;
import io.getstream.chat.android.models.querysort.QuerySorter;
import io.getstream.chat.android.state.event.handler.chat.factory.ChatEventHandlerFactory;
import io.getstream.chat.android.state.extensions.ChatClientExtensions;
import io.getstream.chat.android.state.plugin.state.global.GlobalState;
import io.getstream.chat.android.state.plugin.state.querychannels.ChannelsStateData;
import io.getstream.chat.android.state.plugin.state.querychannels.QueryChannelsState;
import io.getstream.chat.android.state.utils.Event;
import io.getstream.chat.android.ui.utils.extensions.ChannelKt;
import io.getstream.chat.android.ui.utils.extensions.LiveDataKt;
import io.getstream.chat.android.ui.viewmodel.channels.ChannelListViewModel$buildDefaultFilter$;
import io.getstream.chat.android.uiutils.extension.FiltersKt;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import io.getstream.result.Error;
import io.getstream.result.call.Call;
import io.getstream.result.call.CallKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u000b\u0018\u0000 X2\u00020\u0001:\u0005WXYZ[B]\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u000305H\u0002J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0006J\u001e\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\u000e\u0010?\u001a\u0002072\u0006\u00108\u001a\u00020\u0006J\u0010\u0010@\u001a\u0002072\u0006\u0010A\u001a\u00020\u0003H\u0002J\u0010\u0010B\u001a\u0002072\u0006\u0010A\u001a\u00020\u0003H\u0002J\u000e\u0010C\u001a\u0002072\u0006\u00108\u001a\u00020\u0006J\u0006\u0010D\u001a\u000207J\u000e\u0010E\u001a\u0002072\u0006\u0010F\u001a\u00020GJ*\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00060=2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00060=2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\b\u0010J\u001a\u000207H\u0002J\u000e\u0010K\u001a\u0002072\u0006\u0010A\u001a\u00020\u0003J!\u0010L\u001a\u0002072\u0017\u0010M\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0N\u00a2\u0006\u0002\bOH\u0002JE\u0010P\u001a\u000e\u0012\u0004\u0012\u0002HR\u0012\u0004\u0012\u0002HS0Q\"\u0004\b\u0000\u0010R\"\u0004\b\u0001\u0010S*\u000e\u0012\u0004\u0012\u0002HR\u0012\u0004\u0012\u0002HS002\u0006\u0010T\u001a\u0002HR2\u0006\u0010U\u001a\u0002HSH\u0002\u00a2\u0006\u0002\u0010VR\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0019R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020,0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u000202000\u00178F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0019\u00a8\u0006\\"}, d2={"Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel;", "Landroidx/lifecycle/ViewModel;", "filter", "Lio/getstream/chat/android/models/FilterObject;", "sort", "Lio/getstream/chat/android/models/querysort/QuerySorter;", "Lio/getstream/chat/android/models/Channel;", "limit", "", "messageLimit", "memberLimit", "chatEventHandlerFactory", "Lio/getstream/chat/android/state/event/handler/chat/factory/ChatEventHandlerFactory;", "chatClient", "Lio/getstream/chat/android/client/ChatClient;", "globalState", "Lio/getstream/chat/android/state/plugin/state/global/GlobalState;", "(Lio/getstream/chat/android/models/FilterObject;Lio/getstream/chat/android/models/querysort/QuerySorter;IIILio/getstream/chat/android/state/event/handler/chat/factory/ChatEventHandlerFactory;Lio/getstream/chat/android/client/ChatClient;Lio/getstream/chat/android/state/plugin/state/global/GlobalState;)V", "_errorEvents", "Landroidx/lifecycle/MutableLiveData;", "Lio/getstream/chat/android/state/utils/Event;", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent;", "errorEvents", "Landroidx/lifecycle/LiveData;", "getErrorEvents", "()Landroidx/lifecycle/LiveData;", "filterLiveData", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "paginationState", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$PaginationState;", "getPaginationState", "paginationStateMerger", "Landroidx/lifecycle/MediatorLiveData;", "queryChannelsState", "Lkotlinx/coroutines/flow/StateFlow;", "Lio/getstream/chat/android/state/plugin/state/querychannels/QueryChannelsState;", "queryJob", "Lkotlinx/coroutines/Job;", "state", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$State;", "getState", "stateMerger", "typingEvents", "", "", "Lio/getstream/chat/android/models/TypingEvent;", "getTypingEvents", "buildDefaultFilter", "Lkotlinx/coroutines/flow/Flow;", "deleteChannel", "", "channel", "handleChannelStateNews", "channelState", "Lio/getstream/chat/android/state/plugin/state/querychannels/ChannelsStateData;", "channelMutes", "", "Lio/getstream/chat/android/models/ChannelMute;", "hideChannel", "init", "filterObject", "initData", "leaveChannel", "markAllRead", "onAction", "action", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$Action;", "parseMutedChannels", "channels", "requestMoreChannels", "setFilters", "setPaginationState", "reducer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "clone", "", "K", "V", "changeKey", "changeValue", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "Action", "Companion", "ErrorEvent", "PaginationState", "State", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nChannelListViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelListViewModel.kt\nio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel\n+ 2 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 3 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 4 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n+ 5 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,502:1\n53#2:503\n55#2:507\n50#3:504\n55#3:506\n107#4:505\n303#5,4:508\n1549#6:512\n1620#6,3:513\n1549#6:516\n1620#6,3:517\n*S KotlinDebug\n*F\n+ 1 ChannelListViewModel.kt\nio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel\n*L\n170#1:503\n170#1:507\n170#1:504\n170#1:506\n170#1:505\n371#1:508,4\n402#1:512\n402#1:513,3\n403#1:516\n403#1:517,3\n*E\n"})
public final class ChannelListViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FilterObject filter;
    @NotNull
    private final QuerySorter<Channel> sort;
    private final int limit;
    private final int messageLimit;
    private final int memberLimit;
    @NotNull
    private final ChatEventHandlerFactory chatEventHandlerFactory;
    @NotNull
    private final ChatClient chatClient;
    @NotNull
    private final GlobalState globalState;
    @Nullable
    private Job queryJob;
    @NotNull
    private final MediatorLiveData<State> stateMerger;
    @NotNull
    private final LiveData<State> state;
    @NotNull
    private final MediatorLiveData<PaginationState> paginationStateMerger;
    @NotNull
    private final LiveData<PaginationState> paginationState;
    @NotNull
    private final MutableLiveData<Event<ErrorEvent>> _errorEvents;
    @NotNull
    private final LiveData<Event<ErrorEvent>> errorEvents;
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final MutableLiveData<FilterObject> filterLiveData;
    @NotNull
    private StateFlow<? extends QueryChannelsState> queryChannelsState;
    @JvmField
    @NotNull
    public static final QuerySorter<Channel> DEFAULT_SORT = (QuerySorter)QuerySortByField.Companion.descByName("last_updated");
    @NotNull
    private static final State INITIAL_STATE = new State(true, CollectionsKt.emptyList());
    public static final int DEFAULT_CHANNEL_LIMIT = 30;
    public static final int DEFAULT_MESSAGE_LIMIT = 1;
    public static final int DEFAULT_MEMBER_LIMIT = 30;

    public ChannelListViewModel(@Nullable FilterObject filter, @NotNull QuerySorter<Channel> sort, int limit, int messageLimit, int memberLimit, @NotNull ChatEventHandlerFactory chatEventHandlerFactory, @NotNull ChatClient chatClient, @NotNull GlobalState globalState) {
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        Intrinsics.checkNotNullParameter((Object)chatEventHandlerFactory, (String)"chatEventHandlerFactory");
        Intrinsics.checkNotNullParameter((Object)chatClient, (String)"chatClient");
        Intrinsics.checkNotNullParameter((Object)globalState, (String)"globalState");
        this.filter = filter;
        this.sort = sort;
        this.limit = limit;
        this.messageLimit = messageLimit;
        this.memberLimit = memberLimit;
        this.chatEventHandlerFactory = chatEventHandlerFactory;
        this.chatClient = chatClient;
        this.globalState = globalState;
        this.stateMerger = new MediatorLiveData();
        this.state = Transformations.distinctUntilChanged((LiveData)((LiveData)this.stateMerger));
        this.paginationStateMerger = new MediatorLiveData();
        this.paginationState = Transformations.distinctUntilChanged((LiveData)((LiveData)this.paginationStateMerger));
        this._errorEvents = new MutableLiveData();
        this.errorEvents = (LiveData)this._errorEvents;
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"Chat:ChannelList-VM");
        this.filterLiveData = new MutableLiveData((Object)this.filter);
        this.queryChannelsState = (StateFlow)StateFlowKt.MutableStateFlow(null);
        if (this.filter == null) {
            BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ChannelListViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = FlowKt.first((Flow)ChannelListViewModel.access$buildDefaultFilter(this.this$0), (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            filter = (FilterObject)v0;
                            ChannelListViewModel.access$getFilterLiveData$p(this.this$0).setValue((Object)filter);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        Function1 function1 = (Function1)new Function1<FilterObject, Unit>(){

            public final void invoke(@Nullable FilterObject filter) {
                if (filter != null) {
                    this.initData(filter);
                }
            }
        };
        this.stateMerger.addSource((LiveData)this.filterLiveData, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    public /* synthetic */ ChannelListViewModel(FilterObject filterObject, QuerySorter querySorter, int n, int n2, int n3, ChatEventHandlerFactory chatEventHandlerFactory, ChatClient chatClient, GlobalState globalState, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            filterObject = null;
        }
        if ((n4 & 2) != 0) {
            querySorter = DEFAULT_SORT;
        }
        if ((n4 & 4) != 0) {
            n = 30;
        }
        if ((n4 & 8) != 0) {
            n2 = 1;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 30;
        }
        if ((n4 & 0x20) != 0) {
            chatEventHandlerFactory = new ChatEventHandlerFactory(null, 1, null);
        }
        if ((n4 & 0x40) != 0) {
            chatClient = ChatClient.Companion.instance();
        }
        if ((n4 & 0x80) != 0) {
            globalState = ChatClientExtensions.getGlobalState((ChatClient)chatClient);
        }
        this(filterObject, querySorter, n, n2, n3, chatEventHandlerFactory, chatClient, globalState);
    }

    @NotNull
    public final LiveData<State> getState() {
        return this.state;
    }

    @NotNull
    public final LiveData<Map<String, TypingEvent>> getTypingEvents() {
        return FlowLiveDataConversions.asLiveData$default((Flow)((Flow)this.globalState.getTypingChannels()), null, (long)0L, (int)3, null);
    }

    @NotNull
    public final LiveData<PaginationState> getPaginationState() {
        return this.paginationState;
    }

    @NotNull
    public final LiveData<Event<ErrorEvent>> getErrorEvents() {
        return this.errorEvents;
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Flow<FilterObject> buildDefaultFilter() {
        void $this$map$iv;
        Flow flow = (Flow)this.chatClient.getClientState().getUser();
        Filters filters = Filters.INSTANCE;
        boolean $i$f$map = false;
        void $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return FlowKt.filterNotNull((Flow)((Flow)new Flow<FilterObject>((Flow)$this$unsafeTransform$iv$iv, filters){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ Filters receiver$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
                this.receiver$inlined = filters;
            }

            @Nullable
            public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.receiver$inlined){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    final /* synthetic */ Filters receiver$inlined;
                    {
                        this.$this_unsafeFlow = $receiver;
                        this.receiver$inlined = filters;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 instanceof buildDefaultFilter$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var2_2){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ buildDefaultFilter$$inlined$map$1$2 this$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                var9_10 = $this$map_u24lambda_u245;
                                (Continuation)$continuation;
                                p0 = (User)value;
                                $i$a$-map-ChannelListViewModel$buildDefaultFilter$1 = false;
                                $continuation.label = 1;
                                v0 = var9_10.emit((Object)FiltersKt.defaultChannelListFilter((Filters)this.receiver$inlined, (User)p0), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl29
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl29:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }));
    }

    private final void initData(FilterObject filterObject) {
        this.stateMerger.setValue((Object)INITIAL_STATE);
        this.init(filterObject);
    }

    private final void init(FilterObject filterObject) {
        CompletableJob completableJob;
        QuerySorter<Channel> querySorter = this.sort;
        int n = this.limit;
        int n2 = this.messageLimit;
        int n3 = this.memberLimit;
        QueryChannelsRequest queryChannelsRequest = new QueryChannelsRequest(filterObject, 0, n, querySorter, n2, n3, 2, null);
        this.queryChannelsState = ChatClientExtensions.queryChannelsAsState((ChatClient)this.chatClient, (QueryChannelsRequest)queryChannelsRequest, (ChatEventHandlerFactory)this.chatEventHandlerFactory, (CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this));
        Job job = this.queryJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        CompletableJob it = completableJob = JobKt.Job((Job)JobKt.getJob((CoroutineContext)ViewModelKt.getViewModelScope((ViewModel)this).getCoroutineContext()));
        boolean bl = false;
        this.queryJob = (Job)it;
        CompletableJob queryJob = completableJob;
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)queryJob), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, queryJob, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ChannelListViewModel this$0;
            final /* synthetic */ CompletableJob $queryJob;
            {
                this.this$0 = $receiver;
                this.$queryJob = $queryJob;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)FlowKt.filterNotNull((Flow)((Flow)ChannelListViewModel.access$getQueryChannelsState$p(this.this$0))), (Function2)((Function2)new Function2<QueryChannelsState, Continuation<? super Unit>, Object>($this$launch, this.this$0, this.$queryJob, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ CoroutineScope $$this$launch;
                            final /* synthetic */ ChannelListViewModel this$0;
                            final /* synthetic */ CompletableJob $queryJob;
                            {
                                this.$$this$launch = $$this$launch;
                                this.this$0 = $receiver;
                                this.$queryJob = $queryJob;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        QueryChannelsState queryChannelsState = (QueryChannelsState)this.L$0;
                                        if (!CoroutineScopeKt.isActive((CoroutineScope)this.$$this$launch)) {
                                            return Unit.INSTANCE;
                                        }
                                        Function1 function1 = (Function1)new Function1<ChannelsStateData, Unit>(this.this$0){
                                            final /* synthetic */ ChannelListViewModel this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull ChannelsStateData channelsState) {
                                                Intrinsics.checkNotNullParameter((Object)channelsState, (String)"channelsState");
                                                ChannelListViewModel.access$getStateMerger$p(this.this$0).setValue((Object)ChannelListViewModel.access$handleChannelStateNews(this.this$0, channelsState, (List)ChannelListViewModel.access$getGlobalState$p(this.this$0).getChannelMutes().getValue()));
                                            }
                                        };
                                        LiveDataKt.addFlow(ChannelListViewModel.access$getStateMerger$p(this.this$0), (CoroutineContext)this.$queryJob, (Flow)queryChannelsState.getChannelsStateData(), (Observer)new /* invalid duplicate definition of identical inner class */);
                                        function1 = (Function1)new Function1<List<? extends ChannelMute>, Unit>(this.this$0){
                                            final /* synthetic */ ChannelListViewModel this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull List<ChannelMute> channelMutes) {
                                                Intrinsics.checkNotNullParameter(channelMutes, (String)"channelMutes");
                                                State state = (State)ChannelListViewModel.access$getStateMerger$p(this.this$0).getValue();
                                                Object object = state;
                                                boolean bl = object != null && (object = ((State)object).getChannels()) != null ? !((Collection)object).isEmpty() : false;
                                                if (bl) {
                                                    ChannelListViewModel.access$getStateMerger$p(this.this$0).setValue((Object)State.copy$default(state, false, ChannelListViewModel.access$parseMutedChannels(this.this$0, state.getChannels(), channelMutes), 1, null));
                                                } else {
                                                    State state2 = state;
                                                    ChannelListViewModel.access$getStateMerger$p(this.this$0).setValue(state2 != null ? State.copy$default(state2, false, null, 3, null) : null);
                                                }
                                            }
                                        };
                                        LiveDataKt.addFlow(ChannelListViewModel.access$getStateMerger$p(this.this$0), (CoroutineContext)this.$queryJob, (Flow)ChannelListViewModel.access$getGlobalState$p(this.this$0).getChannelMutes(), (Observer)new /* invalid duplicate definition of identical inner class */);
                                        function1 = (Function1)new Function1<Boolean, Unit>(this.this$0){
                                            final /* synthetic */ ChannelListViewModel this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(boolean loadingMore) {
                                                ChannelListViewModel.access$setPaginationState(this.this$0, (Function1)new Function1<PaginationState, PaginationState>(loadingMore){
                                                    final /* synthetic */ boolean $loadingMore;
                                                    {
                                                        this.$loadingMore = $loadingMore;
                                                        super(1);
                                                    }

                                                    @NotNull
                                                    public final PaginationState invoke(@NotNull PaginationState $this$setPaginationState) {
                                                        Intrinsics.checkNotNullParameter((Object)$this$setPaginationState, (String)"$this$setPaginationState");
                                                        return PaginationState.copy$default($this$setPaginationState, this.$loadingMore, false, 2, null);
                                                    }
                                                });
                                            }
                                        };
                                        LiveDataKt.addFlow(ChannelListViewModel.access$getPaginationStateMerger$p(this.this$0), (CoroutineContext)this.$queryJob, (Flow)queryChannelsState.getLoadingMore(), (Observer)new /* invalid duplicate definition of identical inner class */);
                                        function1 = (Function1)new Function1<Boolean, Unit>(this.this$0){
                                            final /* synthetic */ ChannelListViewModel this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(1);
                                            }

                                            public final void invoke(boolean endOfChannels) {
                                                ChannelListViewModel.access$setPaginationState(this.this$0, (Function1)new Function1<PaginationState, PaginationState>(endOfChannels){
                                                    final /* synthetic */ boolean $endOfChannels;
                                                    {
                                                        this.$endOfChannels = $endOfChannels;
                                                        super(1);
                                                    }

                                                    @NotNull
                                                    public final PaginationState invoke(@NotNull PaginationState $this$setPaginationState) {
                                                        Intrinsics.checkNotNullParameter((Object)$this$setPaginationState, (String)"$this$setPaginationState");
                                                        return PaginationState.copy$default($this$setPaginationState, false, this.$endOfChannels, 1, null);
                                                    }
                                                });
                                            }
                                        };
                                        LiveDataKt.addFlow(ChannelListViewModel.access$getPaginationStateMerger$p(this.this$0), (CoroutineContext)this.$queryJob, (Flow)queryChannelsState.getEndOfChannels(), (Observer)new /* invalid duplicate definition of identical inner class */);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull QueryChannelsState p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final State handleChannelStateNews(ChannelsStateData channelState, List<ChannelMute> channelMutes) {
        State state;
        ChannelsStateData channelsStateData = channelState;
        if (channelsStateData instanceof ChannelsStateData.NoQueryActive ? true : channelsStateData instanceof ChannelsStateData.Loading) {
            state = new State(true, CollectionsKt.emptyList());
        } else if (channelsStateData instanceof ChannelsStateData.OfflineNoResults) {
            state = new State(false, CollectionsKt.emptyList());
        } else if (channelsStateData instanceof ChannelsStateData.Result) {
            state = new State(false, this.parseMutedChannels(((ChannelsStateData.Result)channelState).getChannels(), channelMutes));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return state;
    }

    public final void onAction(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (action instanceof Action.ReachedEndOfList) {
            this.requestMoreChannels();
        }
    }

    public final void leaveChannel(@NotNull Channel channel2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
            User user = (User)this.chatClient.getClientState().getUser().getValue();
            if (user == null) break block0;
            User user2 = user;
            boolean bl = false;
            ChannelClient channelClient2 = this.chatClient.channel(channel2.getType(), channel2.getId());
            CallKt.enqueue$default((Call)ChannelClient.removeMembers$default((ChannelClient)channelClient2, (List)CollectionsKt.listOf((Object)user2.getId()), null, null, (int)6, null), null, (Function1)((Function1)new Function1<Error, Unit>(this, channel2){
                final /* synthetic */ ChannelListViewModel this$0;
                final /* synthetic */ Channel $channel;
                {
                    this.this$0 = $receiver;
                    this.$channel = $channel;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Error error) {
                    void this_$iv;
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    TaggedLogger taggedLogger = ChannelListViewModel.access$getLogger(this.this$0);
                    Channel channel2 = this.$channel;
                    boolean $i$f$e = false;
                    if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                        String string2 = this_$iv.getTag();
                        Priority priority = Priority.ERROR;
                        StreamLogger streamLogger = this_$iv.getDelegate();
                        boolean bl = false;
                        String string3 = "Could not leave channel with id: " + channel2.getId() + ". Error: " + error.getMessage() + ". Cause: " + ChatErrorKt.extractCause((Error)error);
                        StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                    }
                    ChannelListViewModel.access$get_errorEvents$p(this.this$0).postValue((Object)new Event((Object)new ErrorEvent.LeaveChannelError(error)));
                }
            }), (int)1, null);
        }
    }

    public final void deleteChannel(@NotNull Channel channel2) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        CallKt.enqueue$default((Call)this.chatClient.channel(channel2.getCid()).delete(), null, (Function1)((Function1)new Function1<Error, Unit>(this, channel2){
            final /* synthetic */ ChannelListViewModel this$0;
            final /* synthetic */ Channel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Error error) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                TaggedLogger taggedLogger = ChannelListViewModel.access$getLogger(this.this$0);
                Channel channel2 = this.$channel;
                boolean $i$f$e = false;
                if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                    String string2 = this_$iv.getTag();
                    Priority priority = Priority.ERROR;
                    StreamLogger streamLogger = this_$iv.getDelegate();
                    boolean bl = false;
                    String string3 = "Could not delete channel with id: " + channel2.getId() + ". Error: " + error.getMessage() + ". Cause: " + ChatErrorKt.extractCause((Error)error);
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                }
                ChannelListViewModel.access$get_errorEvents$p(this.this$0).postValue((Object)new Event((Object)new ErrorEvent.DeleteChannelError(error)));
            }
        }), (int)1, null);
    }

    public final void hideChannel(@NotNull Channel channel2) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        Pair pair = StringExtensionsKt.cidToTypeAndId((String)channel2.getCid());
        String channelType = (String)pair.component1();
        String channelId = (String)pair.component2();
        CallKt.enqueue$default((Call)this.chatClient.hideChannel(channelType, channelId, false), null, (Function1)((Function1)new Function1<Error, Unit>(this, channel2){
            final /* synthetic */ ChannelListViewModel this$0;
            final /* synthetic */ Channel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Error error) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                TaggedLogger taggedLogger = ChannelListViewModel.access$getLogger(this.this$0);
                Channel channel2 = this.$channel;
                boolean $i$f$e = false;
                if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                    String string2 = this_$iv.getTag();
                    Priority priority = Priority.ERROR;
                    StreamLogger streamLogger = this_$iv.getDelegate();
                    boolean bl = false;
                    String string3 = "Could not hide channel with id: " + channel2.getId() + ". Error: " + error.getMessage() + ". Cause: " + ChatErrorKt.extractCause((Error)error);
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                }
                ChannelListViewModel.access$get_errorEvents$p(this.this$0).postValue((Object)new Event((Object)new ErrorEvent.HideChannelError(error)));
            }
        }), (int)1, null);
    }

    public final void markAllRead() {
        CallKt.enqueue$default((Call)this.chatClient.markAllRead(), null, (Function1)((Function1)new Function1<Error, Unit>(this){
            final /* synthetic */ ChannelListViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Error streamError) {
                Intrinsics.checkNotNullParameter((Object)streamError, (String)"streamError");
                TaggedLogger this_$iv = ChannelListViewModel.access$getLogger(this.this$0);
                boolean $i$f$e = false;
                if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                    String string2 = this_$iv.getTag();
                    Priority priority = Priority.ERROR;
                    StreamLogger streamLogger = this_$iv.getDelegate();
                    boolean bl = false;
                    String string3 = "Could not mark all messages as read. Error: " + streamError.getMessage() + ". Cause: " + ChatErrorKt.extractCause((Error)streamError);
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                }
            }
        }), (int)1, null);
    }

    private final void requestMoreChannels() {
        block2: {
            FilterObject filterObject = (FilterObject)this.filterLiveData.getValue();
            if (filterObject == null) break block2;
            FilterObject it = filterObject;
            boolean bl = false;
            QueryChannelsState queryChannelsState = (QueryChannelsState)this.queryChannelsState.getValue();
            if (queryChannelsState == null) {
                return;
            }
            QueryChannelsState queryChannelsState2 = queryChannelsState;
            QueryChannelsRequest queryChannelsRequest = (QueryChannelsRequest)queryChannelsState2.getNextPageRequest().getValue();
            if (queryChannelsRequest != null) {
                QueryChannelsRequest it2 = queryChannelsRequest;
                boolean bl2 = false;
                BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, it2, null){
                    int label;
                    final /* synthetic */ ChannelListViewModel this$0;
                    final /* synthetic */ QueryChannelsRequest $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                CallKt.enqueue$default((Call)ChannelListViewModel.access$getChatClient$p(this.this$0).queryChannels(this.$it), null, (Function1)((Function1)new Function1<Error, Unit>(this.this$0){
                                    final /* synthetic */ ChannelListViewModel this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Error streamError) {
                                        Intrinsics.checkNotNullParameter((Object)streamError, (String)"streamError");
                                        TaggedLogger this_$iv = ChannelListViewModel.access$getLogger(this.this$0);
                                        boolean $i$f$e = false;
                                        if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                                            String string2 = this_$iv.getTag();
                                            Priority priority = Priority.ERROR;
                                            StreamLogger streamLogger = this_$iv.getDelegate();
                                            boolean bl = false;
                                            String string3 = "Could not load more channels. Error: " + streamError.getMessage() + ". Cause: " + ChatErrorKt.extractCause((Error)streamError);
                                            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                                        }
                                    }
                                }), (int)1, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    public final void setFilters(@NotNull FilterObject filterObject) {
        Intrinsics.checkNotNullParameter((Object)filterObject, (String)"filterObject");
        TaggedLogger this_$iv = this.getLogger();
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[setFilters] filterObject: " + filterObject;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.filterLiveData.setValue((Object)filterObject);
    }

    private final void setPaginationState(Function1<? super PaginationState, PaginationState> reducer) {
        PaginationState paginationState = (PaginationState)this.paginationStateMerger.getValue();
        if (paginationState == null) {
            paginationState = new PaginationState(false, false, 3, null);
        }
        this.paginationStateMerger.setValue(reducer.invoke((Object)paginationState));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Channel> parseMutedChannels(List<Channel> channels, List<ChannelMute> channelMutes) {
        Channel channelMute;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = channelMutes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChannelMute channelMute2 = (ChannelMute)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(channelMute.getChannel().getId());
        }
        Set mutedChannelsIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = channels;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void channel2;
            channelMute = (Channel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChannelKt.isMuted((Channel)channel2) != mutedChannelsIds.contains(channel2.getId()) ? Channel.copy$default((Channel)channel2, null, null, null, null, (int)0, (boolean)false, null, null, null, null, null, (int)0, null, null, null, null, null, null, (int)0, null, null, null, (int)0, null, null, null, null, (boolean)false, this.clone(channel2.getExtraData(), "mutedChannel", !ChannelKt.isMuted((Channel)channel2)), (int)0xFFFFFFF, null) : channel2);
        }
        return (List)destination$iv$iv;
    }

    private final <K, V> Map<K, V> clone(Map<K, ? extends V> $this$clone, K changeKey, V changeValue) {
        Map map2;
        Map<K, ? extends V> originalMap = $this$clone;
        Map $this$clone_u24lambda_u247 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$clone_u24lambda_u247.putAll(originalMap);
        $this$clone_u24lambda_u247.put(changeKey, changeValue);
        return map2;
    }

    public ChannelListViewModel() {
        this(null, null, 0, 0, 0, null, null, null, 255, null);
    }

    public static final /* synthetic */ StateFlow access$getQueryChannelsState$p(ChannelListViewModel $this) {
        return $this.queryChannelsState;
    }

    public static final /* synthetic */ MediatorLiveData access$getStateMerger$p(ChannelListViewModel $this) {
        return $this.stateMerger;
    }

    public static final /* synthetic */ State access$handleChannelStateNews(ChannelListViewModel $this, ChannelsStateData channelState, List channelMutes) {
        return $this.handleChannelStateNews(channelState, channelMutes);
    }

    public static final /* synthetic */ GlobalState access$getGlobalState$p(ChannelListViewModel $this) {
        return $this.globalState;
    }

    public static final /* synthetic */ List access$parseMutedChannels(ChannelListViewModel $this, List channels, List channelMutes) {
        return $this.parseMutedChannels(channels, channelMutes);
    }

    public static final /* synthetic */ MediatorLiveData access$getPaginationStateMerger$p(ChannelListViewModel $this) {
        return $this.paginationStateMerger;
    }

    public static final /* synthetic */ void access$setPaginationState(ChannelListViewModel $this, Function1 reducer) {
        $this.setPaginationState((Function1<? super PaginationState, PaginationState>)reducer);
    }

    public static final /* synthetic */ TaggedLogger access$getLogger(ChannelListViewModel $this) {
        return $this.getLogger();
    }

    public static final /* synthetic */ MutableLiveData access$get_errorEvents$p(ChannelListViewModel $this) {
        return $this._errorEvents;
    }

    public static final /* synthetic */ ChatClient access$getChatClient$p(ChannelListViewModel $this) {
        return $this.chatClient;
    }

    public static final /* synthetic */ Flow access$buildDefaultFilter(ChannelListViewModel $this) {
        return $this.buildDefaultFilter();
    }

    public static final /* synthetic */ MutableLiveData access$getFilterLiveData$p(ChannelListViewModel $this) {
        return $this.filterLiveData;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0001\u0004\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$Action;", "", "()V", "ReachedEndOfList", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$Action$ReachedEndOfList;", "stream-chat-android-ui-components_release"})
    public static abstract class Action {
        private Action() {
        }

        public /* synthetic */ Action(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$Action$ReachedEndOfList;", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$Action;", "()V", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class ReachedEndOfList
        extends Action {
            @NotNull
            public static final ReachedEndOfList INSTANCE = new ReachedEndOfList();

            private ReachedEndOfList() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "ReachedEndOfList";
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$Companion;", "", "()V", "DEFAULT_CHANNEL_LIMIT", "", "DEFAULT_MEMBER_LIMIT", "DEFAULT_MESSAGE_LIMIT", "DEFAULT_SORT", "Lio/getstream/chat/android/models/querysort/QuerySorter;", "Lio/getstream/chat/android/models/Channel;", "INITIAL_STATE", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$State;", "stream-chat-android-ui-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent;", "", "streamError", "Lio/getstream/result/Error;", "(Lio/getstream/result/Error;)V", "getStreamError", "()Lio/getstream/result/Error;", "DeleteChannelError", "HideChannelError", "LeaveChannelError", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent$DeleteChannelError;", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent$HideChannelError;", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent$LeaveChannelError;", "stream-chat-android-ui-components_release"})
    public static abstract class ErrorEvent {
        @NotNull
        private final Error streamError;

        private ErrorEvent(Error streamError) {
            this.streamError = streamError;
        }

        @NotNull
        public Error getStreamError() {
            return this.streamError;
        }

        public /* synthetic */ ErrorEvent(Error streamError, DefaultConstructorMarker $constructor_marker) {
            this(streamError);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent$DeleteChannelError;", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent;", "streamError", "Lio/getstream/result/Error;", "(Lio/getstream/result/Error;)V", "getStreamError", "()Lio/getstream/result/Error;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class DeleteChannelError
        extends ErrorEvent {
            @NotNull
            private final Error streamError;

            public DeleteChannelError(@NotNull Error streamError) {
                Intrinsics.checkNotNullParameter((Object)streamError, (String)"streamError");
                super(streamError, null);
                this.streamError = streamError;
            }

            @Override
            @NotNull
            public Error getStreamError() {
                return this.streamError;
            }

            @NotNull
            public final Error component1() {
                return this.streamError;
            }

            @NotNull
            public final DeleteChannelError copy(@NotNull Error streamError) {
                Intrinsics.checkNotNullParameter((Object)streamError, (String)"streamError");
                return new DeleteChannelError(streamError);
            }

            public static /* synthetic */ DeleteChannelError copy$default(DeleteChannelError deleteChannelError, Error error, int n, Object object) {
                if ((n & 1) != 0) {
                    error = deleteChannelError.streamError;
                }
                return deleteChannelError.copy(error);
            }

            @NotNull
            public String toString() {
                return "DeleteChannelError(streamError=" + this.streamError + ")";
            }

            public int hashCode() {
                return this.streamError.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DeleteChannelError)) {
                    return false;
                }
                DeleteChannelError deleteChannelError = (DeleteChannelError)other;
                return Intrinsics.areEqual((Object)this.streamError, (Object)deleteChannelError.streamError);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent$HideChannelError;", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent;", "streamError", "Lio/getstream/result/Error;", "(Lio/getstream/result/Error;)V", "getStreamError", "()Lio/getstream/result/Error;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class HideChannelError
        extends ErrorEvent {
            @NotNull
            private final Error streamError;

            public HideChannelError(@NotNull Error streamError) {
                Intrinsics.checkNotNullParameter((Object)streamError, (String)"streamError");
                super(streamError, null);
                this.streamError = streamError;
            }

            @Override
            @NotNull
            public Error getStreamError() {
                return this.streamError;
            }

            @NotNull
            public final Error component1() {
                return this.streamError;
            }

            @NotNull
            public final HideChannelError copy(@NotNull Error streamError) {
                Intrinsics.checkNotNullParameter((Object)streamError, (String)"streamError");
                return new HideChannelError(streamError);
            }

            public static /* synthetic */ HideChannelError copy$default(HideChannelError hideChannelError, Error error, int n, Object object) {
                if ((n & 1) != 0) {
                    error = hideChannelError.streamError;
                }
                return hideChannelError.copy(error);
            }

            @NotNull
            public String toString() {
                return "HideChannelError(streamError=" + this.streamError + ")";
            }

            public int hashCode() {
                return this.streamError.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof HideChannelError)) {
                    return false;
                }
                HideChannelError hideChannelError = (HideChannelError)other;
                return Intrinsics.areEqual((Object)this.streamError, (Object)hideChannelError.streamError);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent$LeaveChannelError;", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$ErrorEvent;", "streamError", "Lio/getstream/result/Error;", "(Lio/getstream/result/Error;)V", "getStreamError", "()Lio/getstream/result/Error;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class LeaveChannelError
        extends ErrorEvent {
            @NotNull
            private final Error streamError;

            public LeaveChannelError(@NotNull Error streamError) {
                Intrinsics.checkNotNullParameter((Object)streamError, (String)"streamError");
                super(streamError, null);
                this.streamError = streamError;
            }

            @Override
            @NotNull
            public Error getStreamError() {
                return this.streamError;
            }

            @NotNull
            public final Error component1() {
                return this.streamError;
            }

            @NotNull
            public final LeaveChannelError copy(@NotNull Error streamError) {
                Intrinsics.checkNotNullParameter((Object)streamError, (String)"streamError");
                return new LeaveChannelError(streamError);
            }

            public static /* synthetic */ LeaveChannelError copy$default(LeaveChannelError leaveChannelError, Error error, int n, Object object) {
                if ((n & 1) != 0) {
                    error = leaveChannelError.streamError;
                }
                return leaveChannelError.copy(error);
            }

            @NotNull
            public String toString() {
                return "LeaveChannelError(streamError=" + this.streamError + ")";
            }

            public int hashCode() {
                return this.streamError.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LeaveChannelError)) {
                    return false;
                }
                LeaveChannelError leaveChannelError = (LeaveChannelError)other;
                return Intrinsics.areEqual((Object)this.streamError, (Object)leaveChannelError.streamError);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$PaginationState;", "", "loadingMore", "", "endOfChannels", "(ZZ)V", "getEndOfChannels", "()Z", "getLoadingMore", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "stream-chat-android-ui-components_release"})
    public static final class PaginationState {
        private final boolean loadingMore;
        private final boolean endOfChannels;

        public PaginationState(boolean loadingMore, boolean endOfChannels) {
            this.loadingMore = loadingMore;
            this.endOfChannels = endOfChannels;
        }

        public /* synthetic */ PaginationState(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getLoadingMore() {
            return this.loadingMore;
        }

        public final boolean getEndOfChannels() {
            return this.endOfChannels;
        }

        public final boolean component1() {
            return this.loadingMore;
        }

        public final boolean component2() {
            return this.endOfChannels;
        }

        @NotNull
        public final PaginationState copy(boolean loadingMore, boolean endOfChannels) {
            return new PaginationState(loadingMore, endOfChannels);
        }

        public static /* synthetic */ PaginationState copy$default(PaginationState paginationState, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = paginationState.loadingMore;
            }
            if ((n & 2) != 0) {
                bl2 = paginationState.endOfChannels;
            }
            return paginationState.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "PaginationState(loadingMore=" + this.loadingMore + ", endOfChannels=" + this.endOfChannels + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.loadingMore);
            result2 = result2 * 31 + Boolean.hashCode(this.endOfChannels);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PaginationState)) {
                return false;
            }
            PaginationState paginationState = (PaginationState)other;
            if (this.loadingMore != paginationState.loadingMore) {
                return false;
            }
            return this.endOfChannels == paginationState.endOfChannels;
        }

        public PaginationState() {
            this(false, false, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel$State;", "", "isLoading", "", "channels", "", "Lio/getstream/chat/android/models/Channel;", "(ZLjava/util/List;)V", "getChannels", "()Ljava/util/List;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "stream-chat-android-ui-components_release"})
    public static final class State {
        private final boolean isLoading;
        @NotNull
        private final List<Channel> channels;

        public State(boolean isLoading, @NotNull List<Channel> channels) {
            Intrinsics.checkNotNullParameter(channels, (String)"channels");
            this.isLoading = isLoading;
            this.channels = channels;
        }

        public final boolean isLoading() {
            return this.isLoading;
        }

        @NotNull
        public final List<Channel> getChannels() {
            return this.channels;
        }

        public final boolean component1() {
            return this.isLoading;
        }

        @NotNull
        public final List<Channel> component2() {
            return this.channels;
        }

        @NotNull
        public final State copy(boolean isLoading, @NotNull List<Channel> channels) {
            Intrinsics.checkNotNullParameter(channels, (String)"channels");
            return new State(isLoading, channels);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bl = state.isLoading;
            }
            if ((n & 2) != 0) {
                list = state.channels;
            }
            return state.copy(bl, list);
        }

        @NotNull
        public String toString() {
            return "State(isLoading=" + this.isLoading + ", channels=" + this.channels + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isLoading);
            result2 = result2 * 31 + ((Object)this.channels).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.isLoading != state.isLoading) {
                return false;
            }
            return Intrinsics.areEqual(this.channels, state.channels);
        }
    }
}

