/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.viewmodel.channels;

import android.app.AlertDialog;
import android.content.DialogInterface;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.Transformations;
import io.getstream.chat.android.models.Channel;
import io.getstream.chat.android.models.TypingEvent;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.state.utils.EventObserver;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.feature.channels.list.ChannelListView;
import io.getstream.chat.android.ui.feature.channels.list.adapter.ChannelListItem;
import io.getstream.chat.android.ui.utils.extensions.LiveDataKt;
import io.getstream.chat.android.ui.viewmodel.channels.ChannelListViewModel;
import io.getstream.chat.android.ui.viewmodel.channels.ChannelListViewModelBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a!\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"bindView", "", "Lio/getstream/chat/android/ui/viewmodel/channels/ChannelListViewModel;", "view", "Lio/getstream/chat/android/ui/feature/channels/list/ChannelListView;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "bind", "stream-chat-android-ui-components_release"})
@JvmName(name="ChannelListViewModelBinding")
public final class ChannelListViewModelBinding {
    @JvmName(name="bind")
    public static final void bind(@NotNull ChannelListViewModel $this$bindView, @NotNull ChannelListView view, @NotNull LifecycleOwner lifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$bindView), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Function1 function1 = (Function1)new Function1<Pair<? extends List<? extends ChannelListItem>, ? extends Boolean>, Unit>(view){
            final /* synthetic */ ChannelListView $view;
            {
                this.$view = $view;
                super(1);
            }

            public final void invoke(Pair<? extends List<? extends ChannelListItem>, Boolean> pair) {
                List list = (List)pair.component1();
                boolean isLoading = (Boolean)pair.component2();
                if (isLoading && list.isEmpty()) {
                    this.$view.showLoadingView();
                } else if (!((Collection)list).isEmpty()) {
                    this.$view.hideLoadingView();
                    this.$view.setChannels(list);
                } else {
                    this.$view.hideLoadingView();
                    this.$view.setChannels(CollectionsKt.emptyList());
                }
            }
        };
        Transformations.distinctUntilChanged(LiveDataKt.combineWith(LiveDataKt.combineWith($this$bindView.getState(), $this$bindView.getPaginationState(), bindView.1.INSTANCE), $this$bindView.getTypingEvents(), (Function2)new Function2<Pair<? extends ChannelListViewModel.State, ? extends ChannelListViewModel.PaginationState>, Map<String, ? extends TypingEvent>, Pair<? extends List<? extends ChannelListItem>, ? extends Boolean>>(view){
            final /* synthetic */ ChannelListView $view;
            {
                this.$view = $view;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<List<ChannelListItem>, Boolean> invoke(@Nullable Pair<ChannelListViewModel.State, ChannelListViewModel.PaginationState> states, @Nullable Map<String, TypingEvent> typingEvents) {
                List list;
                Object object;
                ChannelListViewModel.PaginationState paginationState;
                Pair<ChannelListViewModel.State, ChannelListViewModel.PaginationState> pair = states;
                ChannelListViewModel.State state = pair != null ? (ChannelListViewModel.State)pair.getFirst() : null;
                Pair<ChannelListViewModel.State, ChannelListViewModel.PaginationState> pair2 = states;
                ChannelListViewModel.PaginationState paginationState2 = paginationState = pair2 != null ? (ChannelListViewModel.PaginationState)pair2.getSecond() : null;
                if (paginationState2 != null) {
                    ChannelListViewModel.PaginationState paginationState3 = paginationState2;
                    ChannelListView channelListView = this.$view;
                    ChannelListViewModel.PaginationState it = paginationState3;
                    boolean bl = false;
                    channelListView.setPaginationEnabled(!it.getEndOfChannels() && !it.getLoadingMore());
                }
                if ((object = state) != null && (object = ((ChannelListViewModel.State)object).getChannels()) != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Channel channel2 = (Channel)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Map<String, TypingEvent> map2 = typingEvents;
                        if (map2 == null || (map2 = (TypingEvent)map2.get(it.getCid())) == null || (map2 = map2.getUsers()) == null) {
                            map2 = CollectionsKt.emptyList();
                        }
                        collection.add(new ChannelListItem.ChannelItem((Channel)it, (List<User>)((Object)map2)));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List list2 = list;
                ChannelListViewModel.PaginationState paginationState4 = paginationState;
                boolean bl = paginationState4 != null ? paginationState4.getLoadingMore() : false;
                if (bl) {
                    list2 = CollectionsKt.plus((Collection)list2, (Object)ChannelListItem.LoadingMoreItem.INSTANCE);
                }
                ChannelListViewModel.State state2 = state;
                return TuplesKt.to((Object)list2, (Object)(state2 != null ? state2.isLoading() : false));
            }
        })).observe(lifecycleOwner, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        view.setOnEndReachedListener(() -> ChannelListViewModelBinding.bindView$lambda$0($this$bindView));
        view.setChannelDeleteClickListener(new ChannelListView.ChannelClickListener(view, $this$bindView){
            final /* synthetic */ ChannelListView $view;
            final /* synthetic */ ChannelListViewModel $this_bindView;
            {
                this.$view = $view;
                this.$this_bindView = $receiver;
            }

            public final void onClick(@NotNull Channel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                new AlertDialog.Builder(this.$view.getContext()).setTitle(R.string.stream_ui_channel_list_delete_confirmation_title).setMessage(R.string.stream_ui_channel_list_delete_confirmation_message).setPositiveButton(R.string.stream_ui_channel_list_delete_confirmation_positive_button, (arg_0, arg_1) -> bindView.5.onClick$lambda$0(this.$this_bindView, it, arg_0, arg_1)).setNegativeButton(R.string.stream_ui_channel_list_delete_confirmation_negative_button, bindView.5::onClick$lambda$1).show();
            }

            private static final void onClick$lambda$0(ChannelListViewModel $this_bindView, Channel $it, DialogInterface dialog, int n) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                dialog.dismiss();
                $this_bindView.deleteChannel($it);
            }

            private static final void onClick$lambda$1(DialogInterface dialog, int n) {
                dialog.dismiss();
            }
        });
        view.setChannelLeaveClickListener(new ChannelListView.ChannelClickListener($this$bindView){
            final /* synthetic */ ChannelListViewModel $this_bindView;
            {
                this.$this_bindView = $receiver;
            }

            public final void onClick(@NotNull Channel channel2) {
                Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
                this.$this_bindView.leaveChannel(channel2);
            }
        });
        $this$bindView.getErrorEvents().observe(lifecycleOwner, (Observer)new EventObserver((Function1)new Function1<ChannelListViewModel.ErrorEvent, Unit>(view){
            final /* synthetic */ ChannelListView $view;
            {
                this.$view = $view;
                super(1);
            }

            public final void invoke(@NotNull ChannelListViewModel.ErrorEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$view.showError(it);
            }
        }));
    }

    private static final void bindView$lambda$0(ChannelListViewModel $this_bindView) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        $this_bindView.onAction(ChannelListViewModel.Action.ReachedEndOfList.INSTANCE);
    }
}

