/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.viewmodel.messages;

import androidx.lifecycle.ViewModel;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.models.Command;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.ui.common.feature.messages.composer.MessageComposerController;
import io.getstream.chat.android.ui.common.state.messages.MessageAction;
import io.getstream.chat.android.ui.common.state.messages.MessageMode;
import io.getstream.chat.android.ui.common.state.messages.composer.MessageComposerState;
import io.getstream.chat.android.ui.common.state.messages.composer.ValidationError;
import io.getstream.result.Result;
import io.getstream.result.call.Call;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020(0\u000bJ\"\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u00020\u00122\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u00020(0\u000bH\u0007J\u0006\u00103\u001a\u00020.J\u0006\u00104\u001a\u00020.J\u0006\u00105\u001a\u00020.J\u0006\u00106\u001a\u00020.J\u0006\u00107\u001a\u00020.J\u0006\u00108\u001a\u00020.J\u0006\u00109\u001a\u00020.J\b\u0010:\u001a\u00020.H\u0014J\u0006\u0010;\u001a\u00020.J\u000e\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020\u0016J\u000e\u0010>\u001a\u00020.2\u0006\u0010?\u001a\u00020(J\u000e\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020BJ\u000e\u0010C\u001a\u00020.2\u0006\u0010D\u001a\u00020\fJ\u000e\u0010E\u001a\u00020.2\u0006\u0010F\u001a\u00020\u001aJ\"\u0010G\u001a\u00020.2\b\b\u0002\u00102\u001a\u0002012\u000e\b\u0002\u0010H\u001a\b\u0012\u0004\u0012\u0002010IH\u0007J\u0006\u0010J\u001a\u00020.J\u000e\u0010K\u001a\u00020.2\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010L\u001a\u00020.2\u0006\u0010M\u001a\u00020\u0012J\u000e\u0010N\u001a\u00020.2\u0006\u0010!\u001a\u00020\"J\u0006\u0010O\u001a\u00020.J\u0006\u0010P\u001a\u00020.J\u0006\u0010Q\u001a\u00020.J\u0006\u0010R\u001a\u00020.R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0019\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\tR\u001d\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120%0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010 R\u001d\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\tR\u001d\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\t\u00a8\u0006S"}, d2={"Lio/getstream/chat/android/ui/viewmodel/messages/MessageComposerViewModel;", "Landroidx/lifecycle/ViewModel;", "messageComposerController", "Lio/getstream/chat/android/ui/common/feature/messages/composer/MessageComposerController;", "(Lio/getstream/chat/android/ui/common/feature/messages/composer/MessageComposerController;)V", "alsoSendToChannel", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "getAlsoSendToChannel", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "commandSuggestions", "", "Lio/getstream/chat/android/models/Command;", "getCommandSuggestions", "cooldownTimer", "", "getCooldownTimer", "input", "", "getInput", "lastActiveAction", "Lkotlinx/coroutines/flow/Flow;", "Lio/getstream/chat/android/ui/common/state/messages/MessageAction;", "getLastActiveAction", "()Lkotlinx/coroutines/flow/Flow;", "mentionSuggestions", "Lio/getstream/chat/android/models/User;", "getMentionSuggestions", "messageComposerState", "Lkotlinx/coroutines/flow/StateFlow;", "Lio/getstream/chat/android/ui/common/state/messages/composer/MessageComposerState;", "getMessageComposerState", "()Lkotlinx/coroutines/flow/StateFlow;", "messageMode", "Lio/getstream/chat/android/ui/common/state/messages/MessageMode;", "getMessageMode", "ownCapabilities", "", "getOwnCapabilities", "selectedAttachments", "Lio/getstream/chat/android/models/Attachment;", "getSelectedAttachments", "validationErrors", "Lio/getstream/chat/android/ui/common/state/messages/composer/ValidationError;", "getValidationErrors", "addSelectedAttachments", "", "attachments", "buildNewMessage", "Lio/getstream/chat/android/models/Message;", "message", "cancelRecording", "clearData", "completeRecording", "dismissMessageActions", "dismissSuggestionsPopup", "leaveThread", "lockRecording", "onCleared", "pauseRecording", "performMessageAction", "messageAction", "removeSelectedAttachment", "attachment", "seekRecordingTo", "progress", "", "selectCommand", "command", "selectMention", "user", "sendMessage", "callback", "Lio/getstream/result/call/Call$Callback;", "sendRecording", "setAlsoSendToChannel", "setMessageInput", "value", "setMessageMode", "startRecording", "stopRecording", "toggleCommandsVisibility", "toggleRecordingPlayback", "stream-chat-android-ui-components_release"})
public final class MessageComposerViewModel
extends ViewModel {
    @NotNull
    private final MessageComposerController messageComposerController;
    @NotNull
    private final StateFlow<MessageComposerState> messageComposerState;
    @NotNull
    private final MutableStateFlow<String> input;
    @NotNull
    private final MutableStateFlow<Boolean> alsoSendToChannel;
    @NotNull
    private final MutableStateFlow<Integer> cooldownTimer;
    @NotNull
    private final MutableStateFlow<List<Attachment>> selectedAttachments;
    @NotNull
    private final MutableStateFlow<List<ValidationError>> validationErrors;
    @NotNull
    private final MutableStateFlow<List<User>> mentionSuggestions;
    @NotNull
    private final MutableStateFlow<List<Command>> commandSuggestions;
    @NotNull
    private final MutableStateFlow<MessageMode> messageMode;
    @NotNull
    private final Flow<MessageAction> lastActiveAction;
    @NotNull
    private final StateFlow<Set<String>> ownCapabilities;

    public MessageComposerViewModel(@NotNull MessageComposerController messageComposerController) {
        Intrinsics.checkNotNullParameter((Object)messageComposerController, (String)"messageComposerController");
        this.messageComposerController = messageComposerController;
        this.messageComposerState = (StateFlow)this.messageComposerController.getState();
        this.input = this.messageComposerController.getInput();
        this.alsoSendToChannel = this.messageComposerController.getAlsoSendToChannel();
        this.cooldownTimer = this.messageComposerController.getCooldownTimer();
        this.selectedAttachments = this.messageComposerController.getSelectedAttachments();
        this.validationErrors = this.messageComposerController.getValidationErrors();
        this.mentionSuggestions = this.messageComposerController.getMentionSuggestions();
        this.commandSuggestions = this.messageComposerController.getCommandSuggestions();
        this.messageMode = this.messageComposerController.getMessageMode();
        this.lastActiveAction = this.messageComposerController.getLastActiveAction();
        this.ownCapabilities = this.messageComposerController.getOwnCapabilities();
    }

    @NotNull
    public final StateFlow<MessageComposerState> getMessageComposerState() {
        return this.messageComposerState;
    }

    @NotNull
    public final MutableStateFlow<String> getInput() {
        return this.input;
    }

    @NotNull
    public final MutableStateFlow<Boolean> getAlsoSendToChannel() {
        return this.alsoSendToChannel;
    }

    @NotNull
    public final MutableStateFlow<Integer> getCooldownTimer() {
        return this.cooldownTimer;
    }

    @NotNull
    public final MutableStateFlow<List<Attachment>> getSelectedAttachments() {
        return this.selectedAttachments;
    }

    @NotNull
    public final MutableStateFlow<List<ValidationError>> getValidationErrors() {
        return this.validationErrors;
    }

    @NotNull
    public final MutableStateFlow<List<User>> getMentionSuggestions() {
        return this.mentionSuggestions;
    }

    @NotNull
    public final MutableStateFlow<List<Command>> getCommandSuggestions() {
        return this.commandSuggestions;
    }

    @NotNull
    public final MutableStateFlow<MessageMode> getMessageMode() {
        return this.messageMode;
    }

    @NotNull
    public final Flow<MessageAction> getLastActiveAction() {
        return this.lastActiveAction;
    }

    @NotNull
    public final StateFlow<Set<String>> getOwnCapabilities() {
        return this.ownCapabilities;
    }

    public final void setMessageInput(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.messageComposerController.setMessageInput(value);
    }

    public final void setAlsoSendToChannel(boolean alsoSendToChannel) {
        this.messageComposerController.setAlsoSendToChannel(alsoSendToChannel);
    }

    public final void setMessageMode(@NotNull MessageMode messageMode) {
        Intrinsics.checkNotNullParameter((Object)messageMode, (String)"messageMode");
        this.messageComposerController.setMessageMode(messageMode);
    }

    public final void performMessageAction(@NotNull MessageAction messageAction) {
        Intrinsics.checkNotNullParameter((Object)messageAction, (String)"messageAction");
        this.messageComposerController.performMessageAction(messageAction);
    }

    public final void dismissMessageActions() {
        this.messageComposerController.dismissMessageActions();
    }

    public final void addSelectedAttachments(@NotNull List<Attachment> attachments2) {
        Intrinsics.checkNotNullParameter(attachments2, (String)"attachments");
        this.messageComposerController.addSelectedAttachments(attachments2);
    }

    public final void removeSelectedAttachment(@NotNull Attachment attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        this.messageComposerController.removeSelectedAttachment(attachment);
    }

    @JvmOverloads
    public final void sendMessage(@NotNull Message message, @NotNull Call.Callback<Message> callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.messageComposerController.sendMessage(message, callback);
    }

    public static /* synthetic */ void sendMessage$default(MessageComposerViewModel messageComposerViewModel2, Message message, Call.Callback callback, int n, Object object) {
        if ((n & 1) != 0) {
            message = MessageComposerViewModel.buildNewMessage$default(messageComposerViewModel2, null, null, 3, null);
        }
        if ((n & 2) != 0) {
            callback = MessageComposerViewModel::sendMessage$lambda$0;
        }
        messageComposerViewModel2.sendMessage(message, (Call.Callback<Message>)callback);
    }

    @JvmOverloads
    @NotNull
    public final Message buildNewMessage(@NotNull String message, @NotNull List<Attachment> attachments2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attachments2, (String)"attachments");
        return this.messageComposerController.buildNewMessage(message, attachments2);
    }

    public static /* synthetic */ Message buildNewMessage$default(MessageComposerViewModel messageComposerViewModel2, String string2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = (String)messageComposerViewModel2.input.getValue();
        }
        if ((n & 2) != 0) {
            list = (List)messageComposerViewModel2.selectedAttachments.getValue();
        }
        return messageComposerViewModel2.buildNewMessage(string2, list);
    }

    public final void leaveThread() {
        this.messageComposerController.leaveThread();
    }

    public final void selectMention(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.messageComposerController.selectMention(user);
    }

    public final void selectCommand(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.messageComposerController.selectCommand(command);
    }

    public final void toggleCommandsVisibility() {
        this.messageComposerController.toggleCommandsVisibility();
    }

    public final void clearData() {
        this.messageComposerController.clearData();
    }

    public final void dismissSuggestionsPopup() {
        this.messageComposerController.dismissSuggestionsPopup();
    }

    public final void startRecording() {
        this.messageComposerController.startRecording();
    }

    public final void lockRecording() {
        this.messageComposerController.lockRecording();
    }

    public final void cancelRecording() {
        this.messageComposerController.cancelRecording();
    }

    public final void stopRecording() {
        this.messageComposerController.stopRecording();
    }

    public final void toggleRecordingPlayback() {
        this.messageComposerController.toggleRecordingPlayback();
    }

    public final void completeRecording() {
        this.messageComposerController.completeRecording();
    }

    public final void pauseRecording() {
        this.messageComposerController.pauseRecording();
    }

    public final void seekRecordingTo(float progress) {
        this.messageComposerController.seekRecordingTo(progress);
    }

    public final void sendRecording() {
        this.completeRecording();
        MessageComposerViewModel.sendMessage$default(this, MessageComposerViewModel.buildNewMessage$default(this, null, null, 3, null), null, 2, null);
    }

    protected void onCleared() {
        super.onCleared();
        this.messageComposerController.onCleared();
    }

    @JvmOverloads
    public final void sendMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MessageComposerViewModel.sendMessage$default(this, message, null, 2, null);
    }

    @JvmOverloads
    public final void sendMessage() {
        MessageComposerViewModel.sendMessage$default(this, null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final Message buildNewMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return MessageComposerViewModel.buildNewMessage$default(this, message, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Message buildNewMessage() {
        return MessageComposerViewModel.buildNewMessage$default(this, null, null, 3, null);
    }

    private static final void sendMessage$lambda$0(Result it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }
}

