/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.viewmodel.messages;

import android.view.View;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import io.getstream.chat.android.models.Channel;
import io.getstream.chat.android.models.Flag;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.state.utils.EventObserver;
import io.getstream.chat.android.ui.common.feature.messages.list.MessageListController;
import io.getstream.chat.android.ui.common.state.messages.list.DeletedMessageVisibility;
import io.getstream.chat.android.ui.common.state.messages.list.GiphyAction;
import io.getstream.chat.android.ui.feature.gallery.AttachmentGalleryResultItem;
import io.getstream.chat.android.ui.feature.gallery.AttachmentGalleryResultItemKt;
import io.getstream.chat.android.ui.feature.messages.list.MessageListView;
import io.getstream.chat.android.ui.utils.PermissionChecker;
import io.getstream.chat.android.ui.viewmodel.messages.MessageListViewModel;
import io.getstream.result.Result;
import io.getstream.result.call.Call;
import java.util.Set;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a!\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"bindView", "", "Lio/getstream/chat/android/ui/viewmodel/messages/MessageListViewModel;", "view", "Lio/getstream/chat/android/ui/feature/messages/list/MessageListView;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "bind", "stream-chat-android-ui-components_release"})
@JvmName(name="MessageListViewModelBinding")
public final class MessageListViewModelBinding {
    @JvmName(name="bind")
    public static final void bind(@NotNull MessageListViewModel $this$bindView, @NotNull MessageListView view, @NotNull LifecycleOwner lifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$bindView), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Function1 function1 = (Function1)new Function1<DeletedMessageVisibility, Unit>(view){
            final /* synthetic */ MessageListView $view;
            {
                this.$view = $view;
                super(1);
            }

            public final void invoke(DeletedMessageVisibility it) {
                Intrinsics.checkNotNull((Object)it);
                this.$view.setDeletedMessageVisibility(it);
            }
        };
        $this$bindView.getDeletedMessageVisibility().observe(lifecycleOwner, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        function1 = (Function1)new Function1<Channel, Unit>(view){
            final /* synthetic */ MessageListView $view;
            {
                this.$view = $view;
                super(1);
            }

            public final void invoke(Channel it) {
                Intrinsics.checkNotNull((Object)it);
                this.$view.init(it);
            }
        };
        $this$bindView.getChannel().observe(lifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        view.setEndRegionReachedHandler(() -> MessageListViewModelBinding.bindView$lambda$0($this$bindView));
        view.setBottomEndRegionReachedHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$1($this$bindView, arg_0));
        view.setLastMessageReadHandler(() -> MessageListViewModelBinding.bindView$lambda$2($this$bindView));
        view.setMessageDeleteHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$3($this$bindView, arg_0));
        view.setThreadStartHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$4($this$bindView, arg_0));
        view.setMessageFlagHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$5($this$bindView, view, arg_0));
        view.setMessagePinHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$6($this$bindView, arg_0));
        view.setMessageUnpinHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$7($this$bindView, arg_0));
        view.setMessageMarkAsUnreadHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$8($this$bindView, arg_0));
        view.setGiphySendHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$9($this$bindView, arg_0));
        view.setMessageRetryHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$10($this$bindView, arg_0));
        view.setMessageReactionHandler((arg_0, arg_1) -> MessageListViewModelBinding.bindView$lambda$11($this$bindView, arg_0, arg_1));
        view.setMessageReplyHandler((arg_0, arg_1) -> MessageListViewModelBinding.bindView$lambda$12($this$bindView, arg_0, arg_1));
        view.setAttachmentDownloadHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$13(view, $this$bindView, arg_0));
        view.setReplyMessageClickListener(arg_0 -> MessageListViewModelBinding.bindView$lambda$14($this$bindView, arg_0));
        view.setOnScrollToBottomHandler(() -> MessageListViewModelBinding.bindView$lambda$15($this$bindView, view));
        function1 = (Function1)new Function1<Set<? extends String>, Unit>(view){
            final /* synthetic */ MessageListView $view;
            {
                this.$view = $view;
                super(1);
            }

            public final void invoke(Set<String> it) {
                Intrinsics.checkNotNull(it);
                this.$view.setOwnCapabilities(it);
            }
        };
        $this$bindView.getOwnCapabilities().observe(lifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<MessageListViewModel.State, Unit>(view){
            final /* synthetic */ MessageListView $view;
            {
                this.$view = $view;
                super(1);
            }

            public final void invoke(MessageListViewModel.State state) {
                MessageListViewModel.State state2 = state;
                if (state2 instanceof MessageListViewModel.State.Loading) {
                    this.$view.hideEmptyStateView();
                    this.$view.showLoadingView();
                } else if (state2 instanceof MessageListViewModel.State.Result) {
                    if (((MessageListViewModel.State.Result)state).getMessageListItem().getItems().isEmpty()) {
                        this.$view.showEmptyStateView();
                    } else {
                        this.$view.hideEmptyStateView();
                    }
                    this.$view.displayNewMessages(((MessageListViewModel.State.Result)state).getMessageListItem());
                    this.$view.hideLoadingView();
                } else if (Intrinsics.areEqual((Object)state2, (Object)MessageListViewModel.State.NavigateUp.INSTANCE)) {
                    // empty if block
                }
            }
        };
        $this$bindView.getState().observe(lifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<Boolean, Unit>((Object)view){

            public final void invoke(boolean p0) {
                ((MessageListView)((Object)this.receiver)).setLoadingMore(p0);
            }
        };
        $this$bindView.getLoadMoreLiveData().observe(lifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<Message, Unit>((Object)view){

            public final void invoke(@NotNull Message p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((MessageListView)((Object)this.receiver)).scrollToMessage(p0);
            }
        };
        $this$bindView.getTargetMessage().observe(lifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<Boolean, Unit>((Object)view){

            public final void invoke(boolean p0) {
                ((MessageListView)((Object)this.receiver)).shouldRequestMessagesAtBottom(p0);
            }
        };
        $this$bindView.getInsideSearch().observe(lifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<Integer, Unit>((Object)view){

            public final void invoke(int p0) {
                ((MessageListView)((Object)this.receiver)).setUnreadCount$stream_chat_android_ui_components_release(p0);
            }
        };
        $this$bindView.getUnreadCount().observe(lifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<MessageListController.UnreadLabel, Unit>(view){
            final /* synthetic */ MessageListView $view;
            {
                this.$view = $view;
                super(1);
            }

            public final void invoke(MessageListController.UnreadLabel it) {
                boolean bl = it.getButtonVisibility();
                if (bl) {
                    this.$view.showUnreadLabelButton(it.getUnreadCount());
                } else if (!bl) {
                    this.$view.hideUnreadLabelButton();
                }
            }
        };
        $this$bindView.getUnreadLabel().observe(lifecycleOwner, new /* invalid duplicate definition of identical inner class */);
        view.setAttachmentReplyOptionClickHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$16($this$bindView, arg_0));
        view.setAttachmentShowInChatOptionClickHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$17($this$bindView, arg_0));
        view.setAttachmentDeleteOptionClickHandler(arg_0 -> MessageListViewModelBinding.bindView$lambda$18($this$bindView, arg_0));
        $this$bindView.getErrorEvents().observe(lifecycleOwner, (Observer)new EventObserver((Function1)new Function1<MessageListController.ErrorEvent, Unit>(view){
            final /* synthetic */ MessageListView $view;
            {
                this.$view = $view;
                super(1);
            }

            public final void invoke(@NotNull MessageListController.ErrorEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$view.showError(it);
            }
        }));
        view.setOnUnreadLabelClickListener(() -> MessageListViewModelBinding.bindView$lambda$19($this$bindView));
        view.setOnUnreadLabelReachedListener(() -> MessageListViewModelBinding.bindView$lambda$20($this$bindView));
    }

    private static final void bindView$lambda$0(MessageListViewModel $this_bindView) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        $this_bindView.onEvent(MessageListViewModel.Event.EndRegionReached.INSTANCE);
    }

    private static final void bindView$lambda$1(MessageListViewModel $this_bindView, String messageId2) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        $this_bindView.onEvent(new MessageListViewModel.Event.BottomEndRegionReached(messageId2));
    }

    private static final void bindView$lambda$2(MessageListViewModel $this_bindView) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        $this_bindView.onEvent(MessageListViewModel.Event.LastMessageRead.INSTANCE);
    }

    private static final void bindView$lambda$3(MessageListViewModel $this_bindView, Message it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_bindView.onEvent(new MessageListViewModel.Event.DeleteMessage(it, false));
    }

    private static final void bindView$lambda$4(MessageListViewModel $this_bindView, Message it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_bindView.onEvent(new MessageListViewModel.Event.ThreadModeEntered(it));
    }

    private static final void bindView$lambda$5(MessageListViewModel $this_bindView, MessageListView $view, Message it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)((Object)$view), (String)"$view");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_bindView.onEvent(new MessageListViewModel.Event.FlagMessage(it, null, MapsKt.emptyMap(), (Function1<? super Result<Flag>, Unit>)((Function1)new Function1<Result<? extends Flag>, Unit>((Object)$view){

            public final void invoke(@NotNull Result<Flag> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((MessageListView)((Object)this.receiver)).handleFlagMessageResult(p0);
            }
        })));
    }

    private static final void bindView$lambda$6(MessageListViewModel $this_bindView, Message it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_bindView.onEvent(new MessageListViewModel.Event.PinMessage(it));
    }

    private static final void bindView$lambda$7(MessageListViewModel $this_bindView, Message it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_bindView.onEvent(new MessageListViewModel.Event.UnpinMessage(it));
    }

    private static final void bindView$lambda$8(MessageListViewModel $this_bindView, Message it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_bindView.onEvent(new MessageListViewModel.Event.MarkAsUnreadMessage(it));
    }

    private static final void bindView$lambda$9(MessageListViewModel $this_bindView, GiphyAction giphyAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)giphyAction, (String)"giphyAction");
        $this_bindView.onEvent(new MessageListViewModel.Event.GiphyActionSelected(giphyAction));
    }

    private static final void bindView$lambda$10(MessageListViewModel $this_bindView, Message it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_bindView.onEvent(new MessageListViewModel.Event.RetryMessage(it));
    }

    private static final void bindView$lambda$11(MessageListViewModel $this_bindView, Message message, String reactionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)reactionType, (String)"reactionType");
        $this_bindView.onEvent(new MessageListViewModel.Event.MessageReaction(message, reactionType));
    }

    private static final void bindView$lambda$12(MessageListViewModel $this_bindView, String cid2, Message message) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)cid2, (String)"cid");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this_bindView.onEvent(new MessageListViewModel.Event.ReplyMessage(cid2, message));
    }

    private static final void bindView$lambda$13(MessageListView $view, MessageListViewModel $this_bindView, Function0 downloadAttachmentCall) {
        Intrinsics.checkNotNullParameter((Object)((Object)$view), (String)"$view");
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)downloadAttachmentCall, (String)"downloadAttachmentCall");
        PermissionChecker.checkWriteStoragePermissions$default(new PermissionChecker(), (View)$view, null, (Function0)new Function0<Unit>($this_bindView, (Function0<? extends Call<Unit>>)downloadAttachmentCall){
            final /* synthetic */ MessageListViewModel $this_bindView;
            final /* synthetic */ Function0<Call<Unit>> $downloadAttachmentCall;
            {
                this.$this_bindView = $receiver;
                this.$downloadAttachmentCall = $downloadAttachmentCall;
                super(0);
            }

            public final void invoke() {
                this.$this_bindView.onEvent(new MessageListViewModel.Event.DownloadAttachment(this.$downloadAttachmentCall));
            }
        }, 2, null);
    }

    private static final void bindView$lambda$14(MessageListViewModel $this_bindView, Message replyTo) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)replyTo, (String)"replyTo");
        $this_bindView.onEvent(new MessageListViewModel.Event.ShowMessage(replyTo.getId(), replyTo.getParentId()));
    }

    private static final void bindView$lambda$15(MessageListViewModel $this_bindView, MessageListView $view) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)((Object)$view), (String)"$view");
        MessageListViewModel.scrollToBottom$default($this_bindView, 0, (Function0)new Function0<Unit>($view){
            final /* synthetic */ MessageListView $view;
            {
                this.$view = $view;
                super(0);
            }

            public final void invoke() {
                this.$view.scrollToBottom();
            }
        }, 1, null);
    }

    private static final void bindView$lambda$16(MessageListViewModel $this_bindView, AttachmentGalleryResultItem result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        $this_bindView.onEvent(new MessageListViewModel.Event.ReplyAttachment(result2.getCid(), result2.getMessageId()));
    }

    private static final void bindView$lambda$17(MessageListViewModel $this_bindView, AttachmentGalleryResultItem result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        $this_bindView.onEvent(new MessageListViewModel.Event.ShowMessage(result2.getMessageId(), result2.getParentId()));
    }

    private static final void bindView$lambda$18(MessageListViewModel $this_bindView, AttachmentGalleryResultItem result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        $this_bindView.onEvent(new MessageListViewModel.Event.RemoveAttachment(result2.getMessageId(), AttachmentGalleryResultItemKt.toAttachment(result2)));
    }

    private static final void bindView$lambda$19(MessageListViewModel $this_bindView) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        $this_bindView.onEvent(new MessageListViewModel.Event.HideUnreadLabel(true));
    }

    private static final void bindView$lambda$20(MessageListViewModel $this_bindView) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_bindView), (String)"$this_bindView");
        $this_bindView.onEvent(new MessageListViewModel.Event.HideUnreadLabel(false));
    }
}

