/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.viewmodel.search;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import io.getstream.chat.android.models.FilterObject;
import io.getstream.chat.android.models.Filters;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.models.SearchMessagesResult;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.state.utils.Event;
import io.getstream.chat.android.ui.viewmodel.search.SearchViewModel;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import io.getstream.result.Error;
import io.getstream.result.Result;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0019\u001a\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020\u0006J\b\u0010!\u001a\u00020\u0006H\u0014J\b\u0010\"\u001a\u00020\u0006H\u0002J*\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0082@\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\f\u00a8\u0006,"}, d2={"Lio/getstream/chat/android/ui/viewmodel/search/SearchViewModel;", "Landroidx/lifecycle/ViewModel;", "()V", "_errorEvents", "Landroidx/lifecycle/MutableLiveData;", "Lio/getstream/chat/android/state/utils/Event;", "", "_state", "Lio/getstream/chat/android/ui/viewmodel/search/SearchViewModel$State;", "errorEvents", "Landroidx/lifecycle/LiveData;", "getErrorEvents", "()Landroidx/lifecycle/LiveData;", "job", "Lkotlinx/coroutines/Job;", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "state", "getState", "handleSearchMessageSuccess", "messages", "", "Lio/getstream/chat/android/models/Message;", "handleSearchMessagesError", "streamError", "Lio/getstream/result/Error;", "loadMore", "onCleared", "searchMessages", "Lio/getstream/result/Result;", "query", "", "offset", "", "(Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setQuery", "Companion", "State", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nSearchViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchViewModel.kt\nio/getstream/chat/android/ui/viewmodel/search/SearchViewModel\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 3 Result.kt\nio/getstream/result/Result\n+ 4 Result.kt\nio/getstream/result/ResultKt\n*L\n1#1,202:1\n303#2,4:203\n303#2,4:207\n303#2,4:211\n86#3:215\n152#4,3:216\n*S KotlinDebug\n*F\n+ 1 SearchViewModel.kt\nio/getstream/chat/android/ui/viewmodel/search/SearchViewModel\n*L\n137#1:203,4\n151#1:207,4\n167#1:211,4\n178#1:215\n178#1:216,3\n*E\n"})
public final class SearchViewModel
extends ViewModel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableLiveData<State> _state = new MutableLiveData((Object)new State(null, false, null, false, false, 31, null));
    @NotNull
    private final LiveData<State> state = (LiveData)this._state;
    @NotNull
    private final MutableLiveData<Event<Unit>> _errorEvents = new MutableLiveData();
    @NotNull
    private final LiveData<Event<Unit>> errorEvents = (LiveData)this._errorEvents;
    @NotNull
    private final CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()));
    @Nullable
    private Job job;
    @NotNull
    private final Lazy logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"Chat:SearchViewModel");
    private static final int QUERY_LIMIT = 30;

    @NotNull
    public final LiveData<State> getState() {
        return this.state;
    }

    @NotNull
    public final LiveData<Event<Unit>> getErrorEvents() {
        return this.errorEvents;
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    public final void setQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Job job = this.job;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        if (((CharSequence)query).length() == 0) {
            List list = CollectionsKt.emptyList();
            this._state.setValue((Object)new State(query, false, list, false, false));
        } else {
            List list = CollectionsKt.emptyList();
            this._state.setValue((Object)new State(query, true, list, true, false));
            this.searchMessages();
        }
    }

    public final void loadMore() {
        Job job = this.job;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        Object object = this._state.getValue();
        Intrinsics.checkNotNull((Object)object);
        State currentState = (State)object;
        if (currentState.getCanLoadMore() && !currentState.isLoading() && !currentState.isLoadingMore()) {
            this._state.setValue((Object)State.copy$default(currentState, null, false, null, false, true, 15, null));
            this.searchMessages();
        }
    }

    protected void onCleared() {
        super.onCleared();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
    }

    private final void searchMessages() {
        this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SearchViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = SearchViewModel.access$get_state$p(this.this$0).getValue();
                        Intrinsics.checkNotNull((Object)v0);
                        currentState = (State)v0;
                        this.label = 1;
                        v1 = SearchViewModel.access$searchMessages(this.this$0, currentState.getQuery(), currentState.getResults().size(), (Continuation)this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl16:
                        // 2 sources

                        if ((var4_5 = (result = (Result)v1)) instanceof Result.Success) {
                            SearchViewModel.access$handleSearchMessageSuccess(this.this$0, (List)((Result.Success)result).getValue());
                        } else if (var4_5 instanceof Result.Failure) {
                            SearchViewModel.access$handleSearchMessagesError(this.this$0, ((Result.Failure)result).getValue());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void handleSearchMessageSuccess(List<Message> messages) {
        TaggedLogger this_$iv = this.getLogger();
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "Found messages: " + messages.size();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        Object object = this._state.getValue();
        Intrinsics.checkNotNull((Object)object);
        State currentState = (State)object;
        List list = CollectionsKt.plus((Collection)currentState.getResults(), (Iterable)messages);
        boolean bl = messages.size() == 30;
        this._state.setValue((Object)State.copy$default(currentState, null, bl, list, false, false, 1, null));
    }

    private final void handleSearchMessagesError(Error streamError) {
        TaggedLogger this_$iv = this.getLogger();
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "Error searching messages: " + streamError.getMessage();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        Object object = this._state.getValue();
        Intrinsics.checkNotNull((Object)object);
        this._state.setValue((Object)State.copy$default((State)object, null, true, null, false, false, 5, null));
        this._errorEvents.setValue((Object)new Event((Object)Unit.INSTANCE));
    }

    /*
     * Unable to fully structure code
     */
    private final Object searchMessages(String var1_1, int var2_2, Continuation<? super Result<? extends List<Message>>> var3_3) {
        if (!(var3_3 instanceof searchMessages.2)) ** GOTO lbl-1000
        var19_4 = var3_3;
        if ((var19_4.label & -2147483648) != 0) {
            var19_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ SearchViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SearchViewModel.access$searchMessages(this.this$0, null, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this_$iv = this.getLogger();
                $i$f$d = false;
                if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                    var16_10 = this_$iv.getTag();
                    var15_11 = Priority.DEBUG;
                    var14_12 = this_$iv.getDelegate();
                    $i$a$-d-SearchViewModel$searchMessages$3 = false;
                    var17_15 = "Searching for \"" + (String)query + "\" with offset: " + (int)offset;
                    StreamLogger.DefaultImpls.log$default((StreamLogger)var14_12, (Priority)var15_11, (String)var16_10, (String)var17_15, null, (int)8, null);
                }
                v0 = ChatClient.Companion.instance().getClientState().getUser().getValue();
                if (v0 == null) {
                    $i$a$-d-SearchViewModel$searchMessages$3 = "Required value was null.";
                    throw new IllegalArgumentException($i$a$-d-SearchViewModel$searchMessages$3.toString());
                }
                currentUser = (User)v0;
                $continuation.label = 1;
                v1 = ChatClient.searchMessages$default((ChatClient)ChatClient.Companion.instance(), (FilterObject)Filters.in((String)"members", (List)CollectionsKt.listOf((Object)currentUser.getId())), (FilterObject)Filters.autocomplete((String)"text", (String)query), (Integer)Boxing.boxInt((int)offset), (Integer)Boxing.boxInt((int)30), null, null, (int)48, null).await((Continuation)$continuation);
                if (v1 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl35
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                this_$iv = (Result)v1;
                $i$f$map = false;
                $this$flatMap$iv$iv = this_$iv;
                $i$f$flatMap = false;
                var9_18 = $this$flatMap$iv$iv;
                if (var9_18 instanceof Result.Success) {
                    it$iv = ((Result.Success)$this$flatMap$iv$iv).getValue();
                    $i$a$-flatMap-Result$map$1$iv = false;
                    it = (SearchMessagesResult)it$iv;
                    $i$a$-map-SearchViewModel$searchMessages$4 = false;
                    var20_23 = it.getMessages();
                    v2 = (Result)new Result.Success((Object)var20_23);
                } else if (var9_18 instanceof Result.Failure) {
                    v2 = $this$flatMap$iv$iv;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ MutableLiveData access$get_state$p(SearchViewModel $this) {
        return $this._state;
    }

    public static final /* synthetic */ Object access$searchMessages(SearchViewModel $this, String query, int offset, Continuation $completion) {
        return $this.searchMessages(query, offset, (Continuation<? super Result<? extends List<Message>>>)$completion);
    }

    public static final /* synthetic */ void access$handleSearchMessageSuccess(SearchViewModel $this, List messages) {
        $this.handleSearchMessageSuccess(messages);
    }

    public static final /* synthetic */ void access$handleSearchMessagesError(SearchViewModel $this, Error streamError) {
        $this.handleSearchMessagesError(streamError);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/viewmodel/search/SearchViewModel$Companion;", "", "()V", "QUERY_LIMIT", "", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003JA\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\rR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lio/getstream/chat/android/ui/viewmodel/search/SearchViewModel$State;", "", "query", "", "canLoadMore", "", "results", "", "Lio/getstream/chat/android/models/Message;", "isLoading", "isLoadingMore", "(Ljava/lang/String;ZLjava/util/List;ZZ)V", "getCanLoadMore", "()Z", "getQuery", "()Ljava/lang/String;", "getResults", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "stream-chat-android-ui-components_release"})
    public static final class State {
        @NotNull
        private final String query;
        private final boolean canLoadMore;
        @NotNull
        private final List<Message> results;
        private final boolean isLoading;
        private final boolean isLoadingMore;

        public State(@NotNull String query, boolean canLoadMore, @NotNull List<Message> results, boolean isLoading, boolean isLoadingMore) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter(results, (String)"results");
            this.query = query;
            this.canLoadMore = canLoadMore;
            this.results = results;
            this.isLoading = isLoading;
            this.isLoadingMore = isLoadingMore;
        }

        public /* synthetic */ State(String string2, boolean bl, List list, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string2 = "";
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            if ((n & 0x10) != 0) {
                bl3 = false;
            }
            this(string2, bl, list, bl2, bl3);
        }

        @NotNull
        public final String getQuery() {
            return this.query;
        }

        public final boolean getCanLoadMore() {
            return this.canLoadMore;
        }

        @NotNull
        public final List<Message> getResults() {
            return this.results;
        }

        public final boolean isLoading() {
            return this.isLoading;
        }

        public final boolean isLoadingMore() {
            return this.isLoadingMore;
        }

        @NotNull
        public final String component1() {
            return this.query;
        }

        public final boolean component2() {
            return this.canLoadMore;
        }

        @NotNull
        public final List<Message> component3() {
            return this.results;
        }

        public final boolean component4() {
            return this.isLoading;
        }

        public final boolean component5() {
            return this.isLoadingMore;
        }

        @NotNull
        public final State copy(@NotNull String query, boolean canLoadMore, @NotNull List<Message> results, boolean isLoading, boolean isLoadingMore) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter(results, (String)"results");
            return new State(query, canLoadMore, results, isLoading, isLoadingMore);
        }

        public static /* synthetic */ State copy$default(State state, String string2, boolean bl, List list, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = state.query;
            }
            if ((n & 2) != 0) {
                bl = state.canLoadMore;
            }
            if ((n & 4) != 0) {
                list = state.results;
            }
            if ((n & 8) != 0) {
                bl2 = state.isLoading;
            }
            if ((n & 0x10) != 0) {
                bl3 = state.isLoadingMore;
            }
            return state.copy(string2, bl, list, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "State(query=" + this.query + ", canLoadMore=" + this.canLoadMore + ", results=" + this.results + ", isLoading=" + this.isLoading + ", isLoadingMore=" + this.isLoadingMore + ")";
        }

        public int hashCode() {
            int result2 = this.query.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.canLoadMore);
            result2 = result2 * 31 + ((Object)this.results).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isLoading);
            result2 = result2 * 31 + Boolean.hashCode(this.isLoadingMore);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual((Object)this.query, (Object)state.query)) {
                return false;
            }
            if (this.canLoadMore != state.canLoadMore) {
                return false;
            }
            if (!Intrinsics.areEqual(this.results, state.results)) {
                return false;
            }
            if (this.isLoading != state.isLoading) {
                return false;
            }
            return this.isLoadingMore == state.isLoadingMore;
        }

        public State() {
            this(null, false, null, false, false, 31, null);
        }
    }
}

