/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.widgets;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0006J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/getstream/chat/android/ui/widgets/EndlessScrollListener;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "loadMoreThreshold", "", "loadMoreListener", "Lkotlin/Function0;", "", "(ILkotlin/jvm/functions/Function0;)V", "paginationEnabled", "", "scrollStateReset", "checkScrollDown", "dy", "layoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "checkScrollUp", "disablePagination", "enablePagination", "handleScrollDown", "handleScrollUp", "onScrollStateChanged", "newState", "onScrolled", "dx", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nEndlessScrollListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndlessScrollListener.kt\nio/getstream/chat/android/ui/widgets/EndlessScrollListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class EndlessScrollListener
extends RecyclerView.OnScrollListener {
    private final int loadMoreThreshold;
    @NotNull
    private final Function0<Unit> loadMoreListener;
    private boolean paginationEnabled;
    private boolean scrollStateReset;

    public EndlessScrollListener(int loadMoreThreshold, @NotNull Function0<Unit> loadMoreListener) {
        Intrinsics.checkNotNullParameter(loadMoreListener, (String)"loadMoreListener");
        this.loadMoreThreshold = loadMoreThreshold;
        this.loadMoreListener = loadMoreListener;
        if (!(this.loadMoreThreshold >= 0)) {
            boolean bl = false;
            String string2 = "Load more threshold must not be negative";
            throw new IllegalArgumentException(string2.toString());
        }
        this.scrollStateReset = true;
    }

    public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        if (!this.paginationEnabled) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (!(layoutManager instanceof LinearLayoutManager)) {
            throw new IllegalStateException("EndlessScrollListener supports only LinearLayoutManager");
        }
        if (((LinearLayoutManager)layoutManager).getReverseLayout()) {
            this.checkScrollUp(dy, (LinearLayoutManager)layoutManager, recyclerView);
        } else {
            this.checkScrollDown(dy, (LinearLayoutManager)layoutManager, recyclerView);
        }
    }

    private final void checkScrollUp(int dy, LinearLayoutManager layoutManager, RecyclerView recyclerView) {
        if (dy >= 0) {
            return;
        }
        this.handleScrollUp(layoutManager, recyclerView);
    }

    private final void checkScrollDown(int dy, LinearLayoutManager layoutManager, RecyclerView recyclerView) {
        if (dy <= 0) {
            return;
        }
        this.handleScrollDown(layoutManager, recyclerView);
    }

    private final void handleScrollUp(LinearLayoutManager layoutManager, RecyclerView recyclerView) {
        int firstVisiblePosition = layoutManager.findFirstVisibleItemPosition();
        if (this.scrollStateReset && firstVisiblePosition <= this.loadMoreThreshold) {
            this.scrollStateReset = false;
            recyclerView.post(() -> EndlessScrollListener.handleScrollUp$lambda$1(this));
        }
    }

    private final void handleScrollDown(LinearLayoutManager layoutManager, RecyclerView recyclerView) {
        int lastVisibleItemPosition = layoutManager.findLastVisibleItemPosition();
        int itemCount = layoutManager.getItemCount();
        if (this.scrollStateReset && itemCount - this.loadMoreThreshold <= lastVisibleItemPosition) {
            this.scrollStateReset = false;
            recyclerView.post(() -> EndlessScrollListener.handleScrollDown$lambda$2(this));
        }
    }

    public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        switch (newState) {
            case 0: 
            case 1: {
                this.scrollStateReset = true;
            }
        }
    }

    public final void enablePagination() {
        this.paginationEnabled = true;
    }

    public final void disablePagination() {
        this.paginationEnabled = false;
    }

    private static final void handleScrollUp$lambda$1(EndlessScrollListener this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.paginationEnabled) {
            this$0.loadMoreListener.invoke();
        }
    }

    private static final void handleScrollDown$lambda$2(EndlessScrollListener this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.paginationEnabled) {
            this$0.loadMoreListener.invoke();
        }
    }
}

