/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.widgets.avatar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import com.google.android.material.imageview.ShapeableImageView;
import com.google.android.material.shape.AbsoluteCornerSize;
import com.google.android.material.shape.CornerSize;
import com.google.android.material.shape.RelativeCornerSize;
import com.google.android.material.shape.ShapeAppearanceModel;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.ui.ChatUI;
import io.getstream.chat.android.ui.common.images.resizing.StreamCdnImageResizing;
import io.getstream.chat.android.ui.common.images.resizing.StringExtensionsKt;
import io.getstream.chat.android.ui.common.utils.extensions.UserKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.widgets.avatar.AvatarImageView;
import io.getstream.chat.android.ui.widgets.avatar.AvatarShape;
import io.getstream.chat.android.ui.widgets.avatar.AvatarStyle;
import io.getstream.chat.android.ui.widgets.avatar.OnlineIndicatorPosition;
import io.getstream.chat.android.ui.widgets.avatar.UserAvatarRenderer;
import io.getstream.chat.android.ui.widgets.avatar.internal.AvatarPlaceholderDrawable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tH\u0014J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/getstream/chat/android/ui/widgets/avatar/UserAvatarView;", "Lio/getstream/chat/android/ui/widgets/avatar/AvatarImageView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "avatarStyle", "Lio/getstream/chat/android/ui/widgets/avatar/AvatarStyle;", "(Landroid/content/Context;Lio/getstream/chat/android/ui/widgets/avatar/AvatarStyle;)V", "avatarRenderer", "Lio/getstream/chat/android/ui/widgets/avatar/UserAvatarRenderer;", "borderPaint", "Landroid/graphics/Paint;", "online", "", "onlineIndicatorOutlinePaint", "onlineIndicatorPaint", "drawBorder", "", "canvas", "Landroid/graphics/Canvas;", "drawIndicator", "init", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setAvatarStyle", "setOnline", "setUser", "user", "Lio/getstream/chat/android/models/User;", "Companion", "stream-chat-android-ui-components_release"})
public final class UserAvatarView
extends AvatarImageView {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private AvatarStyle avatarStyle;
    @NotNull
    private final Paint onlineIndicatorOutlinePaint;
    @NotNull
    private final Paint onlineIndicatorPaint;
    @NotNull
    private final Paint borderPaint;
    private boolean online;
    @Nullable
    private UserAvatarRenderer avatarRenderer;
    private static final int AVATAR_SIZE_EXTRA = 1;

    public UserAvatarView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, (AttributeSet)null);
    }

    public UserAvatarView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    /*
     * WARNING - void declaration
     */
    public UserAvatarView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$borderPaint_u24lambda_u242;
        Paint $this$onlineIndicatorPaint_u24lambda_u241;
        Paint $this$onlineIndicatorOutlinePaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr);
        Paint paint2 = paint = new Paint();
        UserAvatarView userAvatarView = this;
        boolean bl = false;
        $i$a$-apply-UserAvatarView$onlineIndicatorOutlinePaint$1 = false;
        $this$onlineIndicatorOutlinePaint_u24lambda_u240.setStyle(Paint.Style.FILL);
        userAvatarView.onlineIndicatorOutlinePaint = paint;
        $this$onlineIndicatorOutlinePaint_u24lambda_u240 = paint = new Paint();
        userAvatarView = this;
        boolean bl2 = false;
        $i$a$-apply-UserAvatarView$onlineIndicatorPaint$1 = false;
        $this$onlineIndicatorPaint_u24lambda_u241.setStyle(Paint.Style.FILL);
        userAvatarView.onlineIndicatorPaint = paint;
        $this$onlineIndicatorPaint_u24lambda_u241 = paint = new Paint(1);
        userAvatarView = this;
        boolean bl3 = false;
        $i$a$-apply-UserAvatarView$borderPaint$1 = false;
        $this$borderPaint_u24lambda_u242.setStyle(Paint.Style.STROKE);
        userAvatarView.borderPaint = paint;
        this.init(context, attrs);
    }

    /*
     * WARNING - void declaration
     */
    public UserAvatarView(@NotNull Context context, @NotNull AvatarStyle avatarStyle) {
        void $this$borderPaint_u24lambda_u242;
        Paint $this$onlineIndicatorPaint_u24lambda_u241;
        Paint $this$onlineIndicatorOutlinePaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)avatarStyle, (String)"avatarStyle");
        super(ContextKt.createStreamThemeWrapper(context));
        Paint paint2 = paint = new Paint();
        UserAvatarView userAvatarView = this;
        boolean bl = false;
        $i$a$-apply-UserAvatarView$onlineIndicatorOutlinePaint$1 = false;
        $this$onlineIndicatorOutlinePaint_u24lambda_u240.setStyle(Paint.Style.FILL);
        userAvatarView.onlineIndicatorOutlinePaint = paint;
        $this$onlineIndicatorOutlinePaint_u24lambda_u240 = paint = new Paint();
        userAvatarView = this;
        boolean bl2 = false;
        $i$a$-apply-UserAvatarView$onlineIndicatorPaint$1 = false;
        $this$onlineIndicatorPaint_u24lambda_u241.setStyle(Paint.Style.FILL);
        userAvatarView.onlineIndicatorPaint = paint;
        $this$onlineIndicatorPaint_u24lambda_u241 = paint = new Paint(1);
        userAvatarView = this;
        boolean bl3 = false;
        $i$a$-apply-UserAvatarView$borderPaint$1 = false;
        $this$borderPaint_u24lambda_u242.setStyle(Paint.Style.STROKE);
        userAvatarView.borderPaint = paint;
        this.setAvatarStyle(avatarStyle);
    }

    @JvmOverloads
    public final void setUser(@NotNull User user, boolean online) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UserAvatarRenderer userAvatarRenderer = this.avatarRenderer;
        if (userAvatarRenderer != null) {
            AvatarStyle avatarStyle = this.avatarStyle;
            if (avatarStyle == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"avatarStyle");
                avatarStyle = null;
            }
            userAvatarRenderer.render(avatarStyle, user, this);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            String string2 = StringExtensionsKt.applyStreamCdnImageResizingIfEnabled((String)user.getImage(), (StreamCdnImageResizing)ChatUI.getStreamCdnImageResizing());
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            String string3 = UserKt.getInitials((User)user);
            AvatarStyle avatarStyle = this.avatarStyle;
            if (avatarStyle == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"avatarStyle");
                avatarStyle = null;
            }
            this.setAvatar(string2, (Object)new AvatarPlaceholderDrawable(context, string3, avatarStyle.getAvatarInitialsTextStyle()));
        }
        this.setOnline(online);
    }

    public static /* synthetic */ void setUser$default(UserAvatarView userAvatarView, User user, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = user.getOnline();
        }
        userAvatarView.setUser(user, bl);
    }

    public final void setOnline(boolean online) {
        this.online = online;
        this.invalidate();
    }

    private final void init(Context context, AttributeSet attrs) {
        this.setAvatarStyle(AvatarStyle.Companion.invoke(context, attrs));
        this.avatarRenderer = ChatUI.getUserAvatarRenderer();
    }

    private final void setAvatarStyle(AvatarStyle avatarStyle) {
        ShapeAppearanceModel shapeAppearanceModel;
        this.avatarStyle = avatarStyle;
        int padding = RangesKt.coerceAtLeast((int)(avatarStyle.getAvatarBorderWidth() - 1), (int)0);
        this.setPadding(padding, padding, padding, padding);
        this.onlineIndicatorOutlinePaint.setColor(avatarStyle.getOnlineIndicatorBorderColor());
        this.onlineIndicatorPaint.setColor(avatarStyle.getOnlineIndicatorColor());
        this.borderPaint.setColor(avatarStyle.getAvatarBorderColor());
        this.borderPaint.setStrokeWidth((float)avatarStyle.getAvatarBorderWidth());
        switch (WhenMappings.$EnumSwitchMapping$0[avatarStyle.getAvatarShape().ordinal()]) {
            case 1: {
                shapeAppearanceModel = new ShapeAppearanceModel().toBuilder().setAllCornerSizes((CornerSize)new RelativeCornerSize(0.5f)).build();
                break;
            }
            case 2: {
                shapeAppearanceModel = new ShapeAppearanceModel().toBuilder().setAllCornerSizes((CornerSize)new AbsoluteCornerSize(avatarStyle.getBorderRadius())).build();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.setShapeAppearanceModel(shapeAppearanceModel);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width = ShapeableImageView.resolveSize((int)0, (int)widthMeasureSpec);
        int avatarViewSize = width > (height = ShapeableImageView.resolveSize((int)0, (int)heightMeasureSpec)) ? height : width;
        this.setMeasuredDimension(avatarViewSize, avatarViewSize);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawBorder(canvas);
        this.drawIndicator(canvas);
    }

    private final void drawIndicator(Canvas canvas) {
        float f;
        float f2;
        block16: {
            block15: {
                if (!this.online) break block15;
                AvatarStyle avatarStyle = this.avatarStyle;
                if (avatarStyle == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"avatarStyle");
                    avatarStyle = null;
                }
                if (avatarStyle.getOnlineIndicatorEnabled()) break block16;
            }
            return;
        }
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        boolean isRtl = ContextKt.isRtlLayout(context);
        int width = this.getWidth();
        int height = this.getHeight();
        AvatarStyle avatarStyle = this.avatarStyle;
        if (avatarStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"avatarStyle");
            avatarStyle = null;
        }
        OnlineIndicatorPosition position = avatarStyle.getOnlineIndicatorPosition();
        switch (WhenMappings.$EnumSwitchMapping$1[position.ordinal()]) {
            case 1: 
            case 2: {
                if (isRtl) {
                    f2 = (float)width - (float)width / 8.0f;
                    break;
                }
                f2 = (float)width / 8.0f;
                break;
            }
            case 3: 
            case 4: {
                if (isRtl) {
                    f2 = (float)width / 8.0f;
                    break;
                }
                f2 = (float)width - (float)width / 8.0f;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        float cx = f2;
        switch (WhenMappings.$EnumSwitchMapping$1[position.ordinal()]) {
            case 1: 
            case 3: {
                f = (float)height / 8.0f;
                break;
            }
            case 2: 
            case 4: {
                f = (float)height - (float)height / 8.0f;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        float cy = f;
        canvas.drawCircle(cx, cy, (float)width / 8.0f, this.onlineIndicatorOutlinePaint);
        canvas.drawCircle(cx, cy, (float)width / 10.0f, this.onlineIndicatorPaint);
    }

    private final void drawBorder(Canvas canvas) {
        AvatarStyle avatarStyle = this.avatarStyle;
        if (avatarStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"avatarStyle");
            avatarStyle = null;
        }
        if (avatarStyle.getAvatarBorderWidth() == 0) {
            return;
        }
        AvatarStyle avatarStyle2 = this.avatarStyle;
        if (avatarStyle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"avatarStyle");
            avatarStyle2 = null;
        }
        float borderOffset = avatarStyle2.getAvatarBorderWidth() / 2;
        AvatarStyle avatarStyle3 = this.avatarStyle;
        if (avatarStyle3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"avatarStyle");
            avatarStyle3 = null;
        }
        if (WhenMappings.$EnumSwitchMapping$0[avatarStyle3.getAvatarShape().ordinal()] == 2) {
            float f = (float)this.getWidth() - borderOffset;
            float f2 = (float)this.getHeight() - borderOffset;
            AvatarStyle avatarStyle4 = this.avatarStyle;
            if (avatarStyle4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"avatarStyle");
                avatarStyle4 = null;
            }
            float f3 = avatarStyle4.getBorderRadius();
            AvatarStyle avatarStyle5 = this.avatarStyle;
            if (avatarStyle5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"avatarStyle");
                avatarStyle5 = null;
            }
            canvas.drawRoundRect(borderOffset, borderOffset, f, f2, f3, avatarStyle5.getBorderRadius(), this.borderPaint);
        } else {
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, (float)this.getWidth() / 2.0f - borderOffset, this.borderPaint);
        }
    }

    @JvmOverloads
    public final void setUser(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UserAvatarView.setUser$default(this, user, false, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/widgets/avatar/UserAvatarView$Companion;", "", "()V", "AVATAR_SIZE_EXTRA", "", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AvatarShape.values().length];
            try {
                nArray[AvatarShape.CIRCLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AvatarShape.ROUND_RECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OnlineIndicatorPosition.values().length];
            try {
                nArray[OnlineIndicatorPosition.TOP_START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OnlineIndicatorPosition.BOTTOM_START.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OnlineIndicatorPosition.TOP_END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OnlineIndicatorPosition.BOTTOM_END.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

