/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.widgets.avatar.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import androidx.annotation.Px;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.font.TextStyle;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.uiutils.util.ColorUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\b\b\u0001\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0012\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\n*\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0014\u0010\u0019\u001a\u00020\n*\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/getstream/chat/android/ui/widgets/avatar/internal/AvatarPlaceholderDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "initials", "", "initialsTextStyle", "Lio/getstream/chat/android/ui/font/TextStyle;", "(Landroid/content/Context;Ljava/lang/String;Lio/getstream/chat/android/ui/font/TextStyle;)V", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "", "initialsGradient", "Landroid/graphics/Shader;", "width", "height", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "drawGradient", "drawInitials", "Companion", "stream-chat-android-ui-components_release"})
public final class AvatarPlaceholderDrawable
extends Drawable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String initials;
    @NotNull
    private final TextStyle initialsTextStyle;
    private static final float GRADIENT_DARKER_COLOR_FACTOR = 1.3f;
    private static final float GRADIENT_LIGHTER_COLOR_FACTOR = 0.7f;

    public AvatarPlaceholderDrawable(@NotNull Context context, @NotNull String initials, @NotNull TextStyle initialsTextStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)initials, (String)"initials");
        Intrinsics.checkNotNullParameter((Object)initialsTextStyle, (String)"initialsTextStyle");
        this.context = context;
        this.initials = initials;
        this.initialsTextStyle = initialsTextStyle;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.drawGradient(canvas, this.initials);
        this.drawInitials(canvas, this.initials);
    }

    private final void drawGradient(Canvas $this$drawGradient, String initials) {
        Paint paint;
        Paint $this$drawGradient_u24lambda_u240 = paint = new Paint(1);
        boolean bl = false;
        $this$drawGradient_u24lambda_u240.setAntiAlias(true);
        $this$drawGradient_u24lambda_u240.setStyle(Paint.Style.FILL);
        $this$drawGradient_u24lambda_u240.setShader(this.initialsGradient(initials, $this$drawGradient.getWidth(), $this$drawGradient.getHeight()));
        Paint paint2 = paint;
        $this$drawGradient.drawRect(0.0f, 0.0f, (float)$this$drawGradient.getWidth(), (float)$this$drawGradient.getHeight(), paint2);
    }

    private final void drawInitials(Canvas $this$drawInitials, String initials) {
        Paint paint;
        Paint $this$drawInitials_u24lambda_u241 = paint = new Paint(1);
        boolean bl = false;
        $this$drawInitials_u24lambda_u241.setStyle(Paint.Style.FILL);
        Typeface typeface = this.initialsTextStyle.getFont();
        if (typeface == null) {
            typeface = Typeface.DEFAULT_BOLD;
        }
        $this$drawInitials_u24lambda_u241.setTypeface(typeface);
        $this$drawInitials_u24lambda_u241.setTextAlign(Paint.Align.CENTER);
        $this$drawInitials_u24lambda_u241.setColor(this.initialsTextStyle.getColor());
        $this$drawInitials_u24lambda_u241.setTextSize((float)this.initialsTextStyle.getSize());
        Paint textPaint = paint;
        $this$drawInitials.drawText(initials, (float)$this$drawInitials.getWidth() / 2.0f, (float)$this$drawInitials.getHeight() / 2.0f - (textPaint.ascent() + textPaint.descent()) / 2.0f, textPaint);
    }

    private final Shader initialsGradient(String initials, @Px int width, @Px int height) {
        int[] gradientBaseColors = ContextKt.getIntArray(this.context, R.array.stream_ui_avatar_gradient_colors);
        int baseColorIndex = Math.abs(initials.hashCode()) % gradientBaseColors.length;
        int baseColor = gradientBaseColors[baseColorIndex];
        return (Shader)new LinearGradient(0.0f, 0.0f, (float)width, (float)height, ColorUtilsKt.adjustColorBrightness((int)baseColor, (float)1.3f), ColorUtilsKt.adjustColorBrightness((int)baseColor, (float)0.7f), Shader.TileMode.CLAMP);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/widgets/avatar/internal/AvatarPlaceholderDrawable$Companion;", "", "()V", "GRADIENT_DARKER_COLOR_FACTOR", "", "GRADIENT_LIGHTER_COLOR_FACTOR", "stream-chat-android-ui-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

