/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.widgets.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.view.ViewGroupKt;
import androidx.recyclerview.widget.RecyclerView;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u0014H\u0002J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lio/getstream/chat/android/ui/widgets/internal/SimpleVerticalListDivider;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "bounds", "Landroid/graphics/Rect;", "drawOnLastItem", "", "getDrawOnLastItem", "()Z", "setDrawOnLastItem", "(Z)V", "drawable", "Landroid/graphics/drawable/Drawable;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "setDrawable", "(Landroid/graphics/drawable/Drawable;)V", "drawableHeight", "", "getDrawableHeight", "()Ljava/lang/Integer;", "setDrawableHeight", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "determineHeight", "getItemOffsets", "", "outRect", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "stream-chat-android-ui-components_release"})
public final class SimpleVerticalListDivider
extends RecyclerView.ItemDecoration {
    @NotNull
    private Drawable drawable;
    @Nullable
    private Integer drawableHeight;
    private boolean drawOnLastItem;
    @NotNull
    private final Rect bounds;

    public SimpleVerticalListDivider(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Drawable drawable2 = ContextKt.getDrawableCompat(context, R.drawable.stream_ui_divider);
        Intrinsics.checkNotNull((Object)drawable2);
        this.drawable = drawable2;
        this.bounds = new Rect();
    }

    @NotNull
    public final Drawable getDrawable() {
        return this.drawable;
    }

    public final void setDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"<set-?>");
        this.drawable = drawable2;
    }

    @Nullable
    public final Integer getDrawableHeight() {
        return this.drawableHeight;
    }

    public final void setDrawableHeight(@Nullable Integer n) {
        this.drawableHeight = n;
    }

    public final boolean getDrawOnLastItem() {
        return this.drawOnLastItem;
    }

    public final void setDrawOnLastItem(boolean bl) {
        this.drawOnLastItem = bl;
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        outRect.set(0, 0, 0, this.determineHeight());
    }

    public void onDraw(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        canvas.save();
        int left = parent.getClipToPadding() ? parent.getPaddingLeft() : 0;
        int right = parent.getClipToPadding() ? parent.getRight() - parent.getPaddingRight() : parent.getRight();
        IntRange drawRange = this.drawOnLastItem ? RangesKt.until((int)0, (int)SequencesKt.count((Sequence)ViewGroupKt.getChildren((ViewGroup)((ViewGroup)parent)))) : RangesKt.until((int)0, (int)(SequencesKt.count((Sequence)ViewGroupKt.getChildren((ViewGroup)((ViewGroup)parent))) - 1));
        int index = drawRange.getFirst();
        int n = drawRange.getLast();
        if (index <= n) {
            while (true) {
                View item = parent.getChildAt(index);
                boolean bl = false;
                parent.getDecoratedBoundsWithMargins(item, this.bounds);
                int bottom = this.bounds.bottom + MathKt.roundToInt((float)item.getTranslationY());
                int top = bottom - this.determineHeight();
                this.drawable.setBounds(left, top, right, bottom);
                this.drawable.draw(canvas);
                if (index == n) break;
                ++index;
            }
        }
        canvas.restore();
    }

    private final int determineHeight() {
        Integer n = this.drawableHeight;
        return n != null ? n.intValue() : this.drawable.getIntrinsicHeight();
    }
}

