/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.widgets.internal;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/getstream/chat/android/ui/widgets/internal/SnapToTopDataObserver;", "Landroidx/recyclerview/widget/RecyclerView$AdapterDataObserver;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "(Landroidx/recyclerview/widget/RecyclerView;)V", "layoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "getLayoutManager", "()Landroidx/recyclerview/widget/LinearLayoutManager;", "autoScrollToTopIfNecessary", "", "itemPosition", "", "onItemRangeInserted", "positionStart", "itemCount", "onItemRangeMoved", "fromPosition", "toPosition", "stream-chat-android-ui-components_release"})
public final class SnapToTopDataObserver
extends RecyclerView.AdapterDataObserver {
    @NotNull
    private final RecyclerView recyclerView;
    @NotNull
    private final LinearLayoutManager layoutManager;

    public SnapToTopDataObserver(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        this.recyclerView = recyclerView;
        RecyclerView.LayoutManager layoutManager = this.recyclerView.getLayoutManager();
        LinearLayoutManager linearLayoutManager = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
        if (linearLayoutManager == null) {
            throw new IllegalStateException("Auto scroll only works with LinearLayoutManager");
        }
        this.layoutManager = linearLayoutManager;
    }

    @NotNull
    public final LinearLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
        this.autoScrollToTopIfNecessary(Math.min(fromPosition, toPosition));
    }

    public void onItemRangeInserted(int positionStart, int itemCount) {
        this.autoScrollToTopIfNecessary(positionStart);
    }

    private final void autoScrollToTopIfNecessary(int itemPosition) {
        if (itemPosition != 0 || this.recyclerView.getScrollState() != 0 || this.recyclerView.canScrollVertically(-1)) {
            return;
        }
        if (this.layoutManager.findFirstVisibleItemPosition() == 0) {
            this.layoutManager.scrollToPosition(0);
        }
    }
}

