/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.widgets.typing;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.IntKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import io.getstream.chat.android.ui.widgets.typing.TypingIndicatorViewStyle;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0014\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/getstream/chat/android/ui/widgets/typing/TypingIndicatorView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "style", "Lio/getstream/chat/android/ui/widgets/typing/TypingIndicatorViewStyle;", "userTypingTextView", "Landroid/widget/TextView;", "init", "", "setTypingUsers", "users", "", "Lio/getstream/chat/android/models/User;", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nTypingIndicatorView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingIndicatorView.kt\nio/getstream/chat/android/ui/widgets/typing/TypingIndicatorView\n+ 2 View.kt\nandroidx/core/view/ViewKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n262#2,2:87\n262#2,2:90\n1#3:89\n*S KotlinDebug\n*F\n+ 1 TypingIndicatorView.kt\nio/getstream/chat/android/ui/widgets/typing/TypingIndicatorView\n*L\n58#1:87,2\n73#1:90,2\n*E\n"})
public final class TypingIndicatorView
extends LinearLayout {
    @NotNull
    private final TextView userTypingTextView;
    private TypingIndicatorViewStyle style;

    public TypingIndicatorView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context));
        this.userTypingTextView = new TextView(this.getContext());
        this.init(null);
    }

    public TypingIndicatorView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs);
        this.userTypingTextView = new TextView(this.getContext());
        this.init(attrs);
    }

    public TypingIndicatorView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr);
        this.userTypingTextView = new TextView(this.getContext());
        this.init(attrs);
    }

    /*
     * WARNING - void declaration
     */
    private final void init(AttributeSet attrs) {
        void $this$init_u24lambda_u241;
        View $this$init_u24lambda_u240;
        void $this$isVisible$iv;
        int horizontalPadding = IntKt.dpToPx(8);
        this.setPadding(horizontalPadding, 0, horizontalPadding, 0);
        this.setGravity(16);
        this.setOrientation(0);
        View view = (View)this;
        boolean value$iv22 = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.style = TypingIndicatorViewStyle.Companion.invoke(context, attrs);
        LayoutInflater layoutInflater = ViewGroupKt.getStreamThemeInflater((ViewGroup)this);
        TypingIndicatorViewStyle typingIndicatorViewStyle = this.style;
        if (typingIndicatorViewStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            typingIndicatorViewStyle = null;
        }
        layoutInflater.inflate(typingIndicatorViewStyle.getTypingIndicatorAnimationView(), (ViewGroup)this);
        View value$iv22 = view = this.userTypingTextView;
        TypingIndicatorView typingIndicatorView = this;
        boolean bl = false;
        TypingIndicatorViewStyle typingIndicatorViewStyle2 = this.style;
        if (typingIndicatorViewStyle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            typingIndicatorViewStyle2 = null;
        }
        TextStyleKt.setTextStyle((TextView)$this$init_u24lambda_u240, typingIndicatorViewStyle2.getTypingIndicatorUsersTextStyle());
        $this$init_u24lambda_u240 = view = new LinearLayout.LayoutParams(-2, -2);
        View view2 = view;
        boolean bl2 = false;
        $this$init_u24lambda_u241.setMarginStart(IntKt.dpToPx(8));
        Unit unit = Unit.INSTANCE;
        typingIndicatorView.addView(view2, (ViewGroup.LayoutParams)view);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTypingUsers(@NotNull List<User> users) {
        void $this$isVisible$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(users, (String)"users");
        View view = (View)this;
        if (users.isEmpty()) {
            bl = false;
        } else {
            Object[] objectArray = new Object[]{((User)CollectionsKt.first(users)).getName(), users.size() - 1};
            this.userTypingTextView.setText((CharSequence)this.getResources().getQuantityString(R.plurals.stream_ui_message_list_header_typing_users, users.size(), objectArray));
            bl = true;
        }
        boolean value$iv = bl;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
    }
}

