/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.widgets.typing.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.IntKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/getstream/chat/android/ui/widgets/typing/internal/TypingDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "dotDiameterPx", "", "dotRadiusPx", "dotSpacingPx", "intrinsicHeight", "", "intrinsicWidth", "paint", "Landroid/graphics/Paint;", "calculateAlpha", "dotIndex", "calculateCx", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "Companion", "stream-chat-android-ui-components_release"})
final class TypingDrawable
extends Drawable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paint paint;
    private final int intrinsicHeight;
    private final int intrinsicWidth;
    private final float dotSpacingPx;
    private final float dotDiameterPx;
    private final float dotRadiusPx;
    private static final int DOT_COUNT = 3;
    private static final int DOTS_ANIMATION_DURATION_MILLIS = 500;
    private static final int DELAY_DURATION_MILLIS = 300;
    private static final int FULL_ANIMATION_DURATION = 800;
    private static final int ANIMATION_OFFSET_MILLIS = 166;
    private static final int DOT_SPACING_DP = 3;
    private static final int DOT_SIZE_DP = 5;

    public TypingDrawable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.paint = new Paint();
        this.paint.setColor(ContextKt.getColorCompat(context, R.color.stream_ui_grey));
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        this.dotSpacingPx = IntKt.dpToPxPrecise(3);
        this.dotDiameterPx = IntKt.dpToPxPrecise(5);
        this.dotRadiusPx = this.dotDiameterPx / (float)2;
        this.intrinsicWidth = IntKt.dpToPx(24);
        this.intrinsicHeight = IntKt.dpToPx(5);
    }

    public int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    public int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        for (int dotIndex = 0; dotIndex < 3; ++dotIndex) {
            this.paint.setAlpha(this.calculateAlpha(dotIndex));
            canvas.drawCircle(this.calculateCx(dotIndex), this.dotRadiusPx, this.dotRadiusPx, this.paint);
        }
        this.invalidateSelf();
    }

    private final int calculateAlpha(int dotIndex) {
        int animationOffset = (3 - dotIndex) * 166;
        long timeInCycle = (System.currentTimeMillis() + (long)animationOffset) % (long)800;
        float coefficient = timeInCycle > 500L ? 0.0f : (float)Math.abs(Math.sin(Math.PI * (double)timeInCycle / (double)500.0f));
        return (int)((0.5f + 0.5f * coefficient) * (float)255);
    }

    private final float calculateCx(int dotIndex) {
        return (float)dotIndex * this.dotDiameterPx + (float)dotIndex * this.dotSpacingPx + this.dotRadiusPx;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/getstream/chat/android/ui/widgets/typing/internal/TypingDrawable$Companion;", "", "()V", "ANIMATION_OFFSET_MILLIS", "", "DELAY_DURATION_MILLIS", "DOTS_ANIMATION_DURATION_MILLIS", "DOT_COUNT", "DOT_SIZE_DP", "DOT_SPACING_DP", "FULL_ANIMATION_DURATION", "stream-chat-android-ui-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

