/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoEncoderFactory;
import org.webrtc.HardwareVideoEncoderWrapperFactory;
import org.webrtc.ResolutionAdjustment;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoEncoderFallback;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/webrtc/DefaultAlignedVideoEncoderFactory;", "Lorg/webrtc/VideoEncoderFactory;", "eglContext", "Lorg/webrtc/EglBase$Context;", "enableIntelVp8Encoder", "", "enableH264HighProfile", "resolutionAdjustment", "Lorg/webrtc/ResolutionAdjustment;", "(Lorg/webrtc/EglBase$Context;ZZLorg/webrtc/ResolutionAdjustment;)V", "hardwareVideoEncoderFactory", "softwareVideoEncoderFactory", "createEncoder", "Lorg/webrtc/VideoEncoder;", "info", "Lorg/webrtc/VideoCodecInfo;", "getSupportedCodecs", "", "()[Lorg/webrtc/VideoCodecInfo;", "stream-webrtc-android_release"})
@SourceDebugExtension(value={"SMAP\nDefaultAlignedVideoEncoderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAlignedVideoEncoderFactory.kt\norg/webrtc/DefaultAlignedVideoEncoderFactory\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,67:1\n37#2,2:68\n*S KotlinDebug\n*F\n+ 1 DefaultAlignedVideoEncoderFactory.kt\norg/webrtc/DefaultAlignedVideoEncoderFactory\n*L\n64#1:68,2\n*E\n"})
public final class DefaultAlignedVideoEncoderFactory
implements VideoEncoderFactory {
    @NotNull
    private final VideoEncoderFactory hardwareVideoEncoderFactory;
    @NotNull
    private final VideoEncoderFactory softwareVideoEncoderFactory;

    public DefaultAlignedVideoEncoderFactory(@Nullable EglBase.Context eglContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, @NotNull ResolutionAdjustment resolutionAdjustment) {
        Intrinsics.checkNotNullParameter((Object)((Object)resolutionAdjustment), (String)"resolutionAdjustment");
        this.softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();
        HardwareVideoEncoderFactory defaultFactory = new HardwareVideoEncoderFactory(eglContext, enableIntelVp8Encoder, enableH264HighProfile);
        this.hardwareVideoEncoderFactory = resolutionAdjustment == ResolutionAdjustment.NONE ? (VideoEncoderFactory)defaultFactory : (VideoEncoderFactory)new HardwareVideoEncoderWrapperFactory(defaultFactory, resolutionAdjustment.getValue());
    }

    public /* synthetic */ DefaultAlignedVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2, ResolutionAdjustment resolutionAdjustment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(context, bl, bl2, resolutionAdjustment);
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(@NotNull VideoCodecInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        VideoEncoder softwareEncoder = this.softwareVideoEncoderFactory.createEncoder(info);
        VideoEncoder hardwareEncoder = this.hardwareVideoEncoderFactory.createEncoder(info);
        if (hardwareEncoder != null && softwareEncoder != null) {
            return new VideoEncoderFallback(softwareEncoder, hardwareEncoder);
        }
        VideoEncoder videoEncoder = hardwareEncoder;
        if (videoEncoder == null) {
            videoEncoder = softwareEncoder;
        }
        return videoEncoder;
    }

    @Override
    @NotNull
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet supportedCodecInfos = new LinkedHashSet();
        VideoCodecInfo[] videoCodecInfoArray = this.softwareVideoEncoderFactory.getSupportedCodecs();
        Intrinsics.checkNotNullExpressionValue((Object)videoCodecInfoArray, (String)"getSupportedCodecs(...)");
        VideoCodecInfo[] videoCodecInfoArray2 = videoCodecInfoArray;
        supportedCodecInfos.addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(videoCodecInfoArray2, videoCodecInfoArray2.length)));
        VideoCodecInfo[] videoCodecInfoArray3 = this.hardwareVideoEncoderFactory.getSupportedCodecs();
        Intrinsics.checkNotNullExpressionValue((Object)videoCodecInfoArray3, (String)"getSupportedCodecs(...)");
        videoCodecInfoArray2 = videoCodecInfoArray3;
        supportedCodecInfos.addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(videoCodecInfoArray2, videoCodecInfoArray2.length)));
        Collection $this$toTypedArray$iv = supportedCodecInfos;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new VideoCodecInfo[0]);
    }
}

