/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoDecoderFactory;
import org.webrtc.Logging;
import org.webrtc.PlatformSoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoDecoderFallback;

public class DefaultBlacklistedVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "DefaultBlacklistedVideoDecoderFactory";
    private static final Predicate<VideoDecoder> defaultBlacklistedPredicate = decoder -> DefaultBlacklistedVideoDecoderFactory.isExynosVP9(decoder);
    private final VideoDecoderFactory hardwareVideoDecoderFactory;
    private final VideoDecoderFactory softwareVideoDecoderFactory;
    private final VideoDecoderFactory platformSoftwareVideoDecoderFactory;
    private final Predicate<VideoDecoder> isHardwareDecoderBlacklisted;

    public DefaultBlacklistedVideoDecoderFactory(@Nullable EglBase.Context eglContext) {
        this(eglContext, null);
    }

    public DefaultBlacklistedVideoDecoderFactory(@Nullable EglBase.Context eglContext, @Nullable Predicate<VideoDecoder> decoderBlacklistedPredicate) {
        this.hardwareVideoDecoderFactory = new HardwareVideoDecoderFactory(eglContext);
        this.softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();
        this.platformSoftwareVideoDecoderFactory = new PlatformSoftwareVideoDecoderFactory(eglContext);
        this.isHardwareDecoderBlacklisted = decoderBlacklistedPredicate == null ? defaultBlacklistedPredicate : decoderBlacklistedPredicate.or(defaultBlacklistedPredicate);
    }

    @Override
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        VideoDecoder softwareDecoder = this.softwareVideoDecoderFactory.createDecoder(codecType);
        VideoDecoder hardwareDecoder = this.hardwareVideoDecoderFactory.createDecoder(codecType);
        if (softwareDecoder == null) {
            softwareDecoder = this.platformSoftwareVideoDecoderFactory.createDecoder(codecType);
        }
        if (this.isHardwareDecoderBlacklisted.test(hardwareDecoder)) {
            Logging.d(TAG, "Hardware decoder is blacklisted: " + hardwareDecoder.getImplementationName());
            return softwareDecoder;
        }
        if (hardwareDecoder != null && softwareDecoder != null) {
            return new VideoDecoderFallback(softwareDecoder, hardwareDecoder);
        }
        return hardwareDecoder != null ? hardwareDecoder : softwareDecoder;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        HashSet<VideoCodecInfo> supportedCodecInfos = new HashSet<VideoCodecInfo>();
        supportedCodecInfos.addAll(Arrays.asList(this.softwareVideoDecoderFactory.getSupportedCodecs()));
        supportedCodecInfos.addAll(Arrays.asList(this.hardwareVideoDecoderFactory.getSupportedCodecs()));
        supportedCodecInfos.addAll(Arrays.asList(this.platformSoftwareVideoDecoderFactory.getSupportedCodecs()));
        return supportedCodecInfos.toArray(new VideoCodecInfo[0]);
    }

    private static boolean isExynosVP9(@Nullable VideoDecoder decoder) {
        if (decoder == null) {
            return false;
        }
        String name = decoder.getImplementationName().toLowerCase();
        return name.contains("exynos") && name.contains("vp9");
    }
}

