/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.Logging;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoFrame;

class HardwareVideoEncoderWrapper
implements VideoEncoder {
    private static final String TAG = "HardwareVideoEncoderWrapper";
    private final VideoEncoder internalEncoder;
    private final int alignment;
    private CropSizeCalculator calculator = new CropSizeCalculator(1, 0, 0);

    public HardwareVideoEncoderWrapper(VideoEncoder internalEncoder, int alignment) {
        this.internalEncoder = internalEncoder;
        this.alignment = alignment;
    }

    private VideoCodecStatus retryWithoutCropping(int width, int height, Runnable retryFunc) {
        Logging.v(TAG, "retrying without resolution adjustment");
        this.calculator = new CropSizeCalculator(1, width, height);
        retryFunc.run();
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings originalSettings, VideoEncoder.Callback callback) {
        this.calculator = new CropSizeCalculator(this.alignment, originalSettings.width, originalSettings.height);
        if (!this.calculator.isCropRequired()) {
            return this.internalEncoder.initEncode(originalSettings, callback);
        }
        VideoEncoder.Settings croppedSettings = new VideoEncoder.Settings(originalSettings.numberOfCores, this.calculator.getCroppedWidth(), this.calculator.getCroppedHeight(), originalSettings.startBitrate, originalSettings.maxFramerate, originalSettings.numberOfSimulcastStreams, originalSettings.automaticResizeOn, originalSettings.capabilities);
        try {
            VideoCodecStatus result = this.internalEncoder.initEncode(croppedSettings, callback);
            if (result == VideoCodecStatus.FALLBACK_SOFTWARE) {
                Logging.e(TAG, "internalEncoder.initEncode() returned FALLBACK_SOFTWARE: croppedSettings " + croppedSettings);
                return this.retryWithoutCropping(originalSettings.width, originalSettings.height, () -> this.internalEncoder.initEncode(originalSettings, callback));
            }
            return result;
        }
        catch (Exception e) {
            Logging.e(TAG, "internalEncoder.initEncode() failed", e);
            return this.retryWithoutCropping(originalSettings.width, originalSettings.height, () -> this.internalEncoder.initEncode(originalSettings, callback));
        }
    }

    @Override
    public VideoCodecStatus release() {
        return this.internalEncoder.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus encode(VideoFrame frame, VideoEncoder.EncodeInfo encodeInfo) {
        if (this.calculator.hasFrameSizeChanged(frame.getBuffer().getWidth(), frame.getBuffer().getHeight())) {
            this.calculator = new CropSizeCalculator(this.alignment, frame.getBuffer().getWidth(), frame.getBuffer().getHeight());
        }
        if (!this.calculator.isCropRequired()) {
            return this.internalEncoder.encode(frame, encodeInfo);
        }
        int croppedWidth = this.calculator.getCroppedWidth();
        int croppedHeight = this.calculator.getCroppedHeight();
        VideoFrame.Buffer croppedBuffer = frame.getBuffer().cropAndScale(this.calculator.cropX / 2, this.calculator.cropY / 2, croppedWidth, croppedHeight, croppedWidth, croppedHeight);
        VideoFrame croppedFrame = new VideoFrame(croppedBuffer, frame.getRotation(), frame.getTimestampNs());
        try {
            VideoCodecStatus result = this.internalEncoder.encode(croppedFrame, encodeInfo);
            if (result == VideoCodecStatus.FALLBACK_SOFTWARE) {
                Logging.e(TAG, "internalEncoder.encode() returned FALLBACK_SOFTWARE");
                VideoCodecStatus videoCodecStatus = this.retryWithoutCropping(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), () -> this.internalEncoder.encode(frame, encodeInfo));
                return videoCodecStatus;
            }
            VideoCodecStatus videoCodecStatus = result;
            return videoCodecStatus;
        }
        catch (Exception e) {
            Logging.e(TAG, "internalEncoder.encode() failed", e);
            VideoCodecStatus videoCodecStatus = this.retryWithoutCropping(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), () -> this.internalEncoder.encode(frame, encodeInfo));
            return videoCodecStatus;
        }
        finally {
            croppedBuffer.release();
        }
    }

    @Override
    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation allocation, int frameRate) {
        return this.internalEncoder.setRateAllocation(allocation, frameRate);
    }

    @Override
    public VideoEncoder.ScalingSettings getScalingSettings() {
        return this.internalEncoder.getScalingSettings();
    }

    @Override
    public String getImplementationName() {
        return this.internalEncoder.getImplementationName();
    }

    @Override
    public long createNative(long webrtcEnvRef) {
        return this.internalEncoder.createNative(webrtcEnvRef);
    }

    @Override
    public boolean isHardwareEncoder() {
        return this.internalEncoder.isHardwareEncoder();
    }

    @Override
    public VideoCodecStatus setRates(VideoEncoder.RateControlParameters rcParameters) {
        return this.internalEncoder.setRates(rcParameters);
    }

    @Override
    public VideoEncoder.ResolutionBitrateLimits[] getResolutionBitrateLimits() {
        return this.internalEncoder.getResolutionBitrateLimits();
    }

    @Override
    public VideoEncoder.EncoderInfo getEncoderInfo() {
        return this.internalEncoder.getEncoderInfo();
    }

    private static class CropSizeCalculator {
        private static final String TAG = "CropSizeCalculator";
        private final int alignment;
        private final int originalWidth;
        private final int originalHeight;
        private final int cropX;
        private final int cropY;

        public CropSizeCalculator(int alignment, int originalWidth, int originalHeight) {
            this.alignment = alignment;
            this.originalWidth = originalWidth;
            this.originalHeight = originalHeight;
            this.cropX = originalWidth % alignment;
            this.cropY = originalHeight % alignment;
            if (originalWidth != 0 && originalHeight != 0) {
                Logging.v(TAG, "init(): alignment=" + alignment + " size=" + originalWidth + "x" + originalHeight + " => " + this.getCroppedWidth() + "x" + this.getCroppedHeight());
            }
        }

        public int getCroppedWidth() {
            return this.originalWidth - this.cropX;
        }

        public int getCroppedHeight() {
            return this.originalHeight - this.cropY;
        }

        public boolean isCropRequired() {
            return this.cropX != 0 || this.cropY != 0;
        }

        public boolean hasFrameSizeChanged(int nextWidth, int nextHeight) {
            if (this.originalWidth == nextWidth && this.originalHeight == nextHeight) {
                return false;
            }
            Logging.v(TAG, "frame size has changed: " + this.originalWidth + "x" + this.originalHeight + " => " + nextWidth + "x" + nextHeight);
            return true;
        }
    }
}

